/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.StatementException;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.TemporaryTable;
import com.mckoi.database.TransactionException;
import com.mckoi.database.interpret.SQLQueryExecutor;
import com.mckoi.database.interpret.SearchExpression;
import com.mckoi.database.interpret.Statement;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.sql.ParseException;
import java.sql.SQLException;

public class Show
extends Statement {
    static final int TABLES = 1;
    static final int STATUS = 2;
    static final int DESCRIBE_TABLE = 3;
    static final int CONNECTIONS = 4;
    static final int PRODUCT = 5;
    static final int CONNECTION_INFO = 6;
    String table_name;
    String show_type;
    Expression[] args;
    SearchExpression where_clause = new SearchExpression();

    TemporaryTable createEmptyTable(Database d, String name, String[] cols) throws DatabaseException {
        DataTableColumnDef[] fields = new DataTableColumnDef[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            fields[i] = DataTableColumnDef.createStringColumn(cols[i]);
        }
        TemporaryTable temp_table = new TemporaryTable(d, name, fields);
        temp_table.setupAllSelectableSchemes();
        return temp_table;
    }

    public void prepare() throws DatabaseException {
        this.show_type = (String)this.cmd.getObject("show");
        this.show_type = this.show_type.toLowerCase();
        this.table_name = (String)this.cmd.getObject("table_name");
        this.args = (Expression[])this.cmd.getObject("args");
        this.where_clause = (SearchExpression)this.cmd.getObject("where_clause");
    }

    /*
     * WARNING - void declaration
     */
    public Table evaluate() throws DatabaseException {
        void var4_19;
        block20: {
            DatabaseQueryContext context = new DatabaseQueryContext(this.database);
            Database d = this.database.getDatabase();
            SQLQueryExecutor executor = new SQLQueryExecutor();
            try {
                TemporaryTable show_table;
                int[] order_set = null;
                if (this.show_type.equals("schema")) {
                    SQLQuery query = new SQLQuery("  SELECT \"name\" AS \"schema_name\",          \"type\",          \"other\" AS \"notes\"     FROM SYS_JDBC.ThisUserSchemaInfo ORDER BY \"schema_name\"");
                    return executor.execute(this.database, query);
                }
                if (this.show_type.equals("tables")) {
                    String current_schema = this.database.getCurrentSchema();
                    SQLQuery query = new SQLQuery("  SELECT \"Tables.TABLE_NAME\" AS \"table_name\",          I_PRIVILEGE_STRING(\"agg_priv_bit\") AS \"user_privs\",          \"Tables.TABLE_TYPE\" as \"table_type\"     FROM SYS_JDBC.Tables,          ( SELECT AGGOR(\"priv_bit\") agg_priv_bit,                   \"object\", \"param\"              FROM SYS_JDBC.ThisUserSimpleGrant             WHERE \"object\" = 1          GROUP BY \"param\" )   WHERE \"Tables.TABLE_SCHEM\" = ?      AND CONCAT(\"Tables.TABLE_SCHEM\", '.', \"Tables.TABLE_NAME\") = \"param\" ORDER BY \"Tables.TABLE_NAME\"");
                    query.addVar(current_schema);
                    return executor.execute(this.database, query);
                }
                if (this.show_type.equals("status")) {
                    SQLQuery query = new SQLQuery("  SELECT \"stat_name\" AS \"name\",          \"value\"     FROM SYS_INFO.sUSRDatabaseStatistics ");
                    return executor.execute(this.database, query);
                }
                if (this.show_type.equals("describe_table")) {
                    TableName tname = this.resolveTableName(this.table_name, this.database);
                    if (!this.database.tableExists(tname)) {
                        throw new StatementException("Unable to find table '" + this.table_name + "'");
                    }
                    SQLQuery query = new SQLQuery("  SELECT \"column\" AS \"name\",          i_sql_type(\"type_desc\", \"size\", \"scale\") AS \"type\",          \"not_null\",          \"index_str\" AS \"index\",          \"default\"     FROM SYS_JDBC.ThisUserTableColumns    WHERE \"schema\" = ?      AND \"table\" = ? ORDER BY \"seq_no\" ");
                    query.addVar(tname.getSchema());
                    query.addVar(tname.getName());
                    return executor.execute(this.database, query);
                }
                if (this.show_type.equals("connections")) {
                    SQLQuery query = new SQLQuery("SELECT * FROM SYS_INFO.sUSRCurrentConnections");
                    return executor.execute(this.database, query);
                }
                if (this.show_type.equals("product")) {
                    SQLQuery query = new SQLQuery("SELECT \"name\", \"version\" FROM   ( SELECT \"value\" AS \"name\" FROM SYS_INFO.sUSRProductInfo      WHERE \"var\" = 'name' ),   ( SELECT \"value\" AS \"version\" FROM SYS_INFO.sUSRProductInfo      WHERE \"var\" = 'version' ) ");
                    return executor.execute(this.database, query);
                }
                if (this.show_type.equals("connection_info")) {
                    SQLQuery query = new SQLQuery("SELECT * FROM SYS_INFO.sUSRConnectionInfo");
                    return executor.execute(this.database, query);
                }
                if (this.show_type.equals("jdbc_procedures")) {
                    show_table = this.createEmptyTable(d, "JDBCProcedures", new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "R1", "R2", "R3", "REMARKS", "PROCEDURE_TYPE"});
                    break block20;
                }
                if (this.show_type.equals("jdbc_procedure_columns")) {
                    show_table = this.createEmptyTable(d, "JDBCProcedureColumns", new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"});
                    break block20;
                }
                if (this.show_type.equals("jdbc_catalogs")) {
                    show_table = this.createEmptyTable(d, "JDBCCatalogs", new String[]{"TABLE_CAT"});
                    break block20;
                }
                if (this.show_type.equals("jdbc_table_types")) {
                    DataTableColumnDef[] fields = new DataTableColumnDef[]{DataTableColumnDef.createStringColumn("TABLE_TYPE")};
                    TemporaryTable temp_table = new TemporaryTable(d, "JDBCTableTypes", fields);
                    String[] supported_types = new String[]{"TABLE", "VIEW", "SYSTEM TABLE", "TRIGGER", "FUNCTION", "SEQUENCE"};
                    for (int i = 0; i < supported_types.length; ++i) {
                        temp_table.newRow();
                        temp_table.setRowObject(TObject.stringVal(supported_types[i]), "JDBCTableTypes.TABLE_TYPE");
                    }
                    temp_table.setupAllSelectableSchemes();
                    show_table = temp_table;
                    order_set = new int[]{0};
                    break block20;
                }
                if (this.show_type.equals("jdbc_best_row_identifier")) {
                    show_table = this.createEmptyTable(d, "JDBCBestRowIdentifier", new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"});
                    break block20;
                }
                if (this.show_type.equals("jdbc_version_columns")) {
                    show_table = this.createEmptyTable(d, "JDBCVersionColumn", new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"});
                    break block20;
                }
                if (this.show_type.equals("jdbc_index_info")) {
                    show_table = this.createEmptyTable(d, "JDBCIndexInfo", new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"});
                    break block20;
                }
                throw new StatementException("Unknown SHOW identifier: " + this.show_type);
            }
            catch (SQLException e) {
                throw new DatabaseException("SQL Error: " + e.getMessage());
            }
            catch (ParseException e) {
                throw new DatabaseException("Parse Error: " + e.getMessage());
            }
            catch (TransactionException e) {
                throw new DatabaseException("Transaction Error: " + e.getMessage());
            }
        }
        return var4_19;
    }
}

