/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Table;
import com.mckoi.database.interpret.Statement;

public class Set
extends Statement {
    String type;
    String var_name;
    Expression exp;
    String value;

    public void prepare() throws DatabaseException {
        this.type = (String)this.cmd.getObject("type");
        this.var_name = (String)this.cmd.getObject("var_name");
        this.exp = (Expression)this.cmd.getObject("exp");
        this.value = (String)this.cmd.getObject("value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        String com = this.type.toLowerCase();
        if (com.equals("varset")) {
            this.database.setVar(this.var_name, this.exp);
            return FunctionTable.resultTable(context, 0);
        } else if (com.equals("isolationset")) {
            this.value = this.value.toLowerCase();
            this.database.setTransactionIsolation(this.value);
            return FunctionTable.resultTable(context, 0);
        } else if (com.equals("autocommit")) {
            this.value = this.value.toLowerCase();
            if (this.value.equals("on") || this.value.equals("1")) {
                this.database.setAutoCommit(true);
                return FunctionTable.resultTable(context, 0);
            } else {
                if (!this.value.equals("off") && !this.value.equals("0")) throw new DatabaseException("Unrecognised value for SET AUTO COMMIT");
                this.database.setAutoCommit(false);
            }
            return FunctionTable.resultTable(context, 0);
        } else {
            if (!com.equals("schema")) throw new DatabaseException("Unrecognised set command.");
            this.database.setDefaultSchema(this.value);
        }
        return FunctionTable.resultTable(context, 0);
    }
}

