/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Privileges;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Statement;

public class Sequence
extends Statement {
    String type;
    TableName seq_name;
    Expression increment;
    Expression min_value;
    Expression max_value;
    Expression start_value;
    Expression cache_value;
    boolean cycle;

    public void prepare() throws DatabaseException {
        this.type = (String)this.cmd.getObject("type");
        String sname = (String)this.cmd.getObject("seq_name");
        String schema_name = this.database.getCurrentSchema();
        this.seq_name = TableName.resolve(schema_name, sname);
        this.seq_name = this.database.tryResolveCase(this.seq_name);
        if (this.type.equals("create")) {
            this.increment = (Expression)this.cmd.getObject("increment");
            this.min_value = (Expression)this.cmd.getObject("min_value");
            this.max_value = (Expression)this.cmd.getObject("max_value");
            this.start_value = (Expression)this.cmd.getObject("start");
            this.cache_value = (Expression)this.cmd.getObject("cache");
            this.cycle = this.cmd.getObject("cycle") != null;
        }
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        boolean ignore_case = this.database.isInCaseInsensitiveMode();
        SchemaDef schema = this.database.resolveSchemaCase(this.seq_name.getSchema(), ignore_case);
        if (schema == null) {
            throw new DatabaseException("Schema '" + this.seq_name.getSchema() + "' doesn't exist.");
        }
        this.seq_name = new TableName(schema.getName(), this.seq_name.getName());
        if (this.type.equals("create")) {
            if (!this.database.getDatabase().canUserCreateSequenceObject(context, this.user, this.seq_name)) {
                throw new UserAccessException("User not permitted to create sequence: " + this.seq_name);
            }
            if (this.database.tableExists(this.seq_name)) {
                throw new DatabaseException("Database object with name '" + this.seq_name + "' already exists.");
            }
            long v_start_value = 0L;
            if (this.start_value != null) {
                v_start_value = this.start_value.evaluate(null, null, context).toBigNumber().longValue();
            }
            long v_increment_by = 1L;
            if (this.increment != null) {
                v_increment_by = this.increment.evaluate(null, null, context).toBigNumber().longValue();
            }
            long v_min_value = 0L;
            if (this.min_value != null) {
                v_min_value = this.min_value.evaluate(null, null, context).toBigNumber().longValue();
            }
            long v_max_value = Long.MAX_VALUE;
            if (this.max_value != null) {
                v_max_value = this.max_value.evaluate(null, null, context).toBigNumber().longValue();
            }
            long v_cache = 16L;
            if (this.cache_value != null && (v_cache = this.cache_value.evaluate(null, null, context).toBigNumber().longValue()) <= 0L) {
                throw new DatabaseException("Cache size can not be <= 0");
            }
            if (v_min_value >= v_max_value) {
                throw new DatabaseException("Min value can not be >= the max value.");
            }
            if (v_start_value < v_min_value || v_start_value >= v_max_value) {
                throw new DatabaseException("Start value is outside the min/max sequence bounds.");
            }
            this.database.createSequenceGenerator(this.seq_name, v_start_value, v_increment_by, v_min_value, v_max_value, v_cache, this.cycle);
            this.database.getGrantManager().addGrant(Privileges.PROCEDURE_ALL_PRIVS, 1, this.seq_name.toString(), this.user.getUserName(), true, "@SYSTEM");
        } else if (this.type.equals("drop")) {
            if (!this.database.getDatabase().canUserDropSequenceObject(context, this.user, this.seq_name)) {
                throw new UserAccessException("User not permitted to drop sequence: " + this.seq_name);
            }
            this.database.dropSequenceGenerator(this.seq_name);
            this.database.getGrantManager().revokeAllGrantsOnObject(1, this.seq_name.toString());
        } else {
            throw new RuntimeException("Unknown type: " + this.type);
        }
        return FunctionTable.resultTable(context, 0);
    }
}

