/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.CorrelatedVariable;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.JoiningSet;
import com.mckoi.database.Operator;
import com.mckoi.database.QueryContext;
import com.mckoi.database.QueryPlan;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.StatementException;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TableName;
import com.mckoi.database.TableQueryDef;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.ByColumn;
import com.mckoi.database.interpret.FromClause;
import com.mckoi.database.interpret.FromTableDef;
import com.mckoi.database.interpret.FromTableDirectSource;
import com.mckoi.database.interpret.FromTableInterface;
import com.mckoi.database.interpret.FromTableSubQuerySource;
import com.mckoi.database.interpret.SearchExpression;
import com.mckoi.database.interpret.SelectColumn;
import com.mckoi.database.interpret.TableExpressionFromSet;
import com.mckoi.database.interpret.TableSelectExpression;
import com.mckoi.util.BigNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Planner {
    private static TableName GROUP_BY_FUNCTION_TABLE = new TableName("FUNCTIONTABLE");

    private static void prepareSearchExpression(final DatabaseConnection db, final TableExpressionFromSet from_set, SearchExpression expression) throws DatabaseException {
        expression.prepare(new ExpressionPreparer(){

            public boolean canPrepare(Object element) {
                return element instanceof TableSelectExpression;
            }

            public Object prepare(Object element) throws DatabaseException {
                TableSelectExpression sq_expr = (TableSelectExpression)element;
                TableExpressionFromSet sq_from_set = Planner.generateFromSet(sq_expr, db);
                sq_from_set.setParent(from_set);
                QueryPlanNode sq_plan = Planner.formQueryPlan(db, sq_expr, sq_from_set, null);
                return new TObject(TType.QUERY_PLAN_TYPE, new QueryPlan.CachePointNode(sq_plan));
            }
        });
        expression.prepare(from_set.expressionQualifier());
    }

    private static Expression filterHavingClause(Expression having_expr, ArrayList aggregate_list, QueryContext context) {
        if (having_expr.size() > 1) {
            Operator op = (Operator)having_expr.last();
            Expression[] exps = having_expr.split();
            Expression new_left = Planner.filterHavingClause(exps[0], aggregate_list, context);
            Expression new_right = Planner.filterHavingClause(exps[1], aggregate_list, context);
            Expression expr = new Expression(new_left, op, new_right);
            return expr;
        }
        if (having_expr.hasAggregateFunction(context)) {
            aggregate_list.add(having_expr);
            Variable v = Variable.resolve("FUNCTIONTABLE.HAVINGAG_" + aggregate_list.size());
            return new Expression(v);
        }
        return having_expr;
    }

    static TableExpressionFromSet generateFromSet(TableSelectExpression select_expression, DatabaseConnection db) {
        FromClause from_clause = select_expression.from_clause;
        from_clause.getJoinSet().prepare(db);
        TableExpressionFromSet from_set = new TableExpressionFromSet(db);
        Iterator tables = from_clause.allTables().iterator();
        while (tables.hasNext()) {
            FromTableDef ftdef = (FromTableDef)tables.next();
            String unique_key = ftdef.getUniqueKey();
            String alias = ftdef.getAlias();
            if (ftdef.isSubQueryTable()) {
                TableSelectExpression sub_query = ftdef.getTableSelectExpression();
                TableExpressionFromSet sub_query_from_set = Planner.generateFromSet(sub_query, db);
                TableName alias_table_name = null;
                if (alias != null) {
                    alias_table_name = new TableName(alias);
                }
                FromTableSubQuerySource source = new FromTableSubQuerySource(db, unique_key, sub_query, sub_query_from_set, alias_table_name);
                from_set.addTable(source);
                continue;
            }
            String name = ftdef.getName();
            TableName table_name = db.resolveTableName(name);
            if (!db.tableExists(table_name)) {
                throw new StatementException("Table '" + table_name + "' was not found.");
            }
            TableName given_name = null;
            if (alias != null) {
                given_name = new TableName(alias);
            }
            TableQueryDef table_query_def = db.getTableQueryDef(table_name, given_name);
            FromTableDirectSource source = new FromTableDirectSource(db, table_query_def, unique_key, given_name, table_name);
            from_set.addTable(source);
        }
        ArrayList columns = select_expression.columns;
        for (int i = 0; i < columns.size(); ++i) {
            boolean alias_match_v;
            SelectColumn col = (SelectColumn)columns.get(i);
            if (col.glob_name != null) {
                if (col.glob_name.equals("*")) {
                    from_set.exposeAllColumns();
                    continue;
                }
                String tname = col.glob_name.substring(0, col.glob_name.indexOf(".*"));
                TableName tn = TableName.resolve(tname);
                from_set.exposeAllColumnsFromSource(tn);
                continue;
            }
            String alias = col.alias;
            Variable v = col.expression.getVariable();
            boolean bl = alias_match_v = v != null && alias != null && from_set.stringCompare(v.getName(), alias);
            if (alias != null && !alias_match_v) {
                from_set.addFunctionRef(alias, col.expression);
                from_set.exposeVariable(new Variable(alias));
                continue;
            }
            if (v != null) {
                Variable resolved = from_set.resolveReference(v);
                if (resolved == null) {
                    from_set.exposeVariable(v);
                    continue;
                }
                from_set.exposeVariable(resolved);
                continue;
            }
            String fun_name = col.expression.text().toString();
            from_set.addFunctionRef(fun_name, col.expression);
            from_set.exposeVariable(new Variable(fun_name));
        }
        return from_set;
    }

    public static QueryPlanNode formQueryPlan(DatabaseConnection db, TableSelectExpression expression, TableExpressionFromSet from_set, ArrayList order_by) throws DatabaseException {
        int i;
        int i2;
        DatabaseQueryContext context = new DatabaseQueryContext(db);
        QuerySelectColumnSet column_set = new QuerySelectColumnSet(from_set);
        ArrayList columns = expression.columns;
        boolean do_subset_column = columns.size() != 0;
        for (int i3 = 0; i3 < columns.size(); ++i3) {
            SelectColumn col = (SelectColumn)columns.get(i3);
            if (col.glob_name != null) {
                if (col.glob_name.equals("*")) {
                    column_set.selectAllColumnsFromAllSources();
                    continue;
                }
                String tname = col.glob_name.substring(0, col.glob_name.indexOf(".*"));
                TableName tn = TableName.resolve(tname);
                column_set.selectAllColumnsFromSource(tn);
                continue;
            }
            column_set.selectSingleColumn(col);
        }
        column_set.prepare(context);
        if (order_by != null) {
            ArrayList prepared_col_set = column_set.s_col_list;
            for (int i4 = 0; i4 < order_by.size(); ++i4) {
                int col_ref;
                BigNumber bnum;
                Object last_elem;
                ByColumn col = (ByColumn)order_by.get(i4);
                Expression exp = col.exp;
                if (exp.size() != 1 || !((last_elem = exp.last()) instanceof TObject) || (bnum = ((TObject)last_elem).toBigNumber()).getScale() != 0 || (col_ref = bnum.intValue() - 1) < 0 || col_ref >= prepared_col_set.size()) continue;
                SelectColumn scol = (SelectColumn)prepared_col_set.get(col_ref);
                col.exp = new Expression(scol.expression);
            }
        }
        QueryTableSetPlanner table_planner = new QueryTableSetPlanner();
        for (int i5 = 0; i5 < from_set.setCount(); ++i5) {
            FromTableInterface table = from_set.getTable(i5);
            if (table instanceof FromTableSubQuerySource) {
                TableExpressionFromSet sq_from_set;
                FromTableSubQuerySource sq_table = (FromTableSubQuerySource)table;
                TableSelectExpression sq_expr = sq_table.getTableExpression();
                QueryPlanNode sq_plan = Planner.formQueryPlan(db, sq_expr, sq_from_set = sq_table.getFromSet(), null);
                if (!(sq_plan instanceof QueryPlan.SubsetNode)) {
                    throw new RuntimeException("Top plan is not a SubsetNode!");
                }
                QueryPlan.SubsetNode subset_node = (QueryPlan.SubsetNode)sq_plan;
                subset_node.setGivenName(sq_table.getAliasedName());
                table_planner.addTableSource(sq_plan, sq_table);
                continue;
            }
            if (table instanceof FromTableDirectSource) {
                FromTableDirectSource ds_table = (FromTableDirectSource)table;
                TableName given_name = ds_table.getGivenTableName();
                TableName root_name = ds_table.getRootTableName();
                String aliased_name = null;
                if (!root_name.equals(given_name)) {
                    aliased_name = given_name.getName();
                }
                QueryPlanNode ds_plan = ds_table.createFetchQueryPlanNode();
                table_planner.addTableSource(ds_plan, ds_table);
                continue;
            }
            throw new RuntimeException("Unknown table source instance: " + table.getClass());
        }
        SearchExpression where_clause = expression.where_clause;
        SearchExpression having_clause = expression.having_clause;
        JoiningSet join_set = expression.from_clause.getJoinSet();
        boolean all_inner_joins = true;
        for (i2 = 0; i2 < join_set.getTableCount() - 1; ++i2) {
            int type = join_set.getJoinType(i2);
            if (type == 1) continue;
            all_inner_joins = false;
        }
        for (i2 = 0; i2 < join_set.getTableCount() - 1; ++i2) {
            int type = join_set.getJoinType(i2);
            Expression on_expression = join_set.getOnExpression(i2);
            if (all_inner_joins) {
                if (on_expression == null) continue;
                where_clause.appendExpression(on_expression);
                continue;
            }
            if (type == 1 && on_expression == null) continue;
            if (on_expression == null) {
                throw new RuntimeException("No ON expression in join.");
            }
            on_expression.prepare(from_set.expressionQualifier());
            table_planner.setJoinInfoBetweenSources(i2, type, on_expression);
        }
        Planner.prepareSearchExpression(db, from_set, where_clause);
        Planner.prepareSearchExpression(db, from_set, having_clause);
        ArrayList extra_aggregate_functions = new ArrayList();
        Expression new_having_clause = null;
        if (having_clause.getFromExpression() != null) {
            new_having_clause = Planner.filterHavingClause(having_clause.getFromExpression(), extra_aggregate_functions, context);
            having_clause.setFromExpression(new_having_clause);
        }
        ArrayList<Expression> group_by_functions = new ArrayList<Expression>();
        ArrayList group_list_in = expression.group_by;
        int gsz = group_list_in.size();
        Variable[] group_by_list = new Variable[gsz];
        for (int i6 = 0; i6 < gsz; ++i6) {
            ByColumn by_column = (ByColumn)group_list_in.get(i6);
            Expression exp = by_column.exp;
            exp.prepare(from_set.expressionQualifier());
            Variable v = exp.getVariable();
            Expression group_by_expression = v == null ? exp : from_set.dereferenceAssignment(v);
            if (group_by_expression != null) {
                if (group_by_expression.hasAggregateFunction(context)) {
                    throw new StatementException("Aggregate expression '" + group_by_expression.text().toString() + "' is not allowed in GROUP BY clause.");
                }
                int group_by_fun_num = group_by_functions.size();
                group_by_functions.add(group_by_expression);
                v = new Variable(GROUP_BY_FUNCTION_TABLE, "#GROUPBY-" + group_by_fun_num);
            }
            group_by_list[i6] = v;
        }
        Variable groupmax_column = expression.group_max;
        if (groupmax_column != null) {
            Variable v = from_set.resolveReference(groupmax_column);
            if (v == null) {
                throw new StatementException("Could find GROUP MAX reference '" + groupmax_column + "'");
            }
            groupmax_column = v;
        }
        if (from_set.setCount() == 0) {
            if (column_set.aggregate_count > 0) {
                throw new StatementException("Invalid use of aggregate function in select with no FROM clause");
            }
            ArrayList s_col_list = column_set.s_col_list;
            int sz = s_col_list.size();
            String[] col_names = new String[sz];
            Expression[] exp_list = new Expression[sz];
            Variable[] subset_vars = new Variable[sz];
            Variable[] aliases = new Variable[sz];
            for (int i7 = 0; i7 < sz; ++i7) {
                SelectColumn scol = (SelectColumn)s_col_list.get(i7);
                exp_list[i7] = scol.expression;
                col_names[i7] = scol.internal_name.getName();
                subset_vars[i7] = new Variable(scol.internal_name);
                aliases[i7] = new Variable(scol.resolved_name);
            }
            return new QueryPlan.SubsetNode(new QueryPlan.CreateFunctionsNode(new QueryPlan.SingleRowTableNode(), exp_list, col_names), subset_vars, aliases);
        }
        QueryPlanNode node = table_planner.planSearchExpression(expression.where_clause);
        ArrayList functions_list = column_set.function_col_list;
        int fsz = functions_list.size();
        ArrayList<Object> complete_fun_list = new ArrayList<Object>();
        for (i = 0; i < fsz; ++i) {
            SelectColumn scol = (SelectColumn)functions_list.get(i);
            complete_fun_list.add(scol.expression);
            complete_fun_list.add(scol.internal_name.getName());
        }
        for (i = 0; i < extra_aggregate_functions.size(); ++i) {
            complete_fun_list.add(extra_aggregate_functions.get(i));
            complete_fun_list.add("HAVINGAG_" + (i + 1));
        }
        int fsz2 = complete_fun_list.size() / 2;
        Expression[] def_fun_list = new Expression[fsz2];
        String[] def_fun_names = new String[fsz2];
        for (int i8 = 0; i8 < fsz2; ++i8) {
            def_fun_list[i8] = (Expression)complete_fun_list.get(i8 * 2);
            def_fun_names[i8] = (String)complete_fun_list.get(i8 * 2 + 1);
        }
        if (column_set.aggregate_count > 0 || gsz > 0) {
            if (gsz == 0) {
                node = new QueryPlan.GroupNode(node, groupmax_column, def_fun_list, def_fun_names);
            } else {
                int gfsz = group_by_functions.size();
                if (gfsz > 0) {
                    Expression[] group_fun_list = new Expression[gfsz];
                    String[] group_fun_name = new String[gfsz];
                    for (int i9 = 0; i9 < gfsz; ++i9) {
                        group_fun_list[i9] = (Expression)group_by_functions.get(i9);
                        group_fun_name[i9] = "#GROUPBY-" + i9;
                    }
                    node = new QueryPlan.CreateFunctionsNode(node, group_fun_list, group_fun_name);
                }
                node = new QueryPlan.GroupNode(node, group_by_list, groupmax_column, def_fun_list, def_fun_names);
            }
        } else if (fsz > 0) {
            node = new QueryPlan.CreateFunctionsNode(node, def_fun_list, def_fun_names);
        }
        ArrayList s_col_list = column_set.s_col_list;
        int sz = s_col_list.size();
        if (expression.having_clause.getFromExpression() != null) {
            Expression having_expr = having_clause.getFromExpression();
            Planner.substituteAliasedVariables(having_expr, s_col_list);
            PlanTableSource source = table_planner.getSingleTableSource();
            source.updatePlan(node);
            node = table_planner.planSearchExpression(having_clause);
        }
        QueryPlanNode right_composite = null;
        if (expression.next_composite != null) {
            TableSelectExpression composite_expr = expression.next_composite;
            TableExpressionFromSet composite_from_set = Planner.generateFromSet(composite_expr, db);
            right_composite = Planner.formQueryPlan(db, composite_expr, composite_from_set, null);
        }
        Variable[] aliases = null;
        if (do_subset_column) {
            Variable[] subset_vars = new Variable[sz];
            aliases = new Variable[sz];
            for (int i10 = 0; i10 < sz; ++i10) {
                SelectColumn scol = (SelectColumn)s_col_list.get(i10);
                subset_vars[i10] = new Variable(scol.internal_name);
                aliases[i10] = new Variable(scol.resolved_name);
            }
            if (expression.distinct) {
                node = new QueryPlan.DistinctNode(node, subset_vars);
            }
            if (right_composite == null && order_by != null) {
                node = Planner.planForOrderBy(node, order_by, from_set, s_col_list);
            }
            node = new QueryPlan.SubsetNode(node, subset_vars, aliases);
        } else if (right_composite == null && order_by != null) {
            node = Planner.planForOrderBy(node, order_by, from_set, s_col_list);
        }
        if (right_composite != null) {
            node = new QueryPlan.CompositeNode(node, right_composite, expression.composite_function, expression.is_composite_all);
            if (order_by != null) {
                node = Planner.planForOrderBy(node, order_by, from_set, s_col_list);
            }
            if (!(node instanceof QueryPlan.SubsetNode) && aliases != null) {
                node = new QueryPlan.SubsetNode(node, aliases, aliases);
            }
        }
        return node;
    }

    public static QueryPlanNode planForOrderBy(QueryPlanNode plan, ArrayList order_by, TableExpressionFromSet from_set, ArrayList s_col_list) throws DatabaseException {
        TableName FUNCTION_TABLE = new TableName("FUNCTIONTABLE");
        if (order_by.size() > 0) {
            int sz = order_by.size();
            Variable[] order_list = new Variable[sz];
            boolean[] ascending_list = new boolean[sz];
            ArrayList<Expression> function_orders = new ArrayList<Expression>();
            for (int i = 0; i < sz; ++i) {
                ByColumn column = (ByColumn)order_by.get(i);
                Expression exp = column.exp;
                ascending_list[i] = column.ascending;
                Variable v = exp.getVariable();
                if (v != null) {
                    Variable new_v = from_set.resolveReference(v);
                    if (new_v == null) {
                        throw new StatementException("Can not resolve ORDER BY variable: " + v);
                    }
                    Planner.substituteAliasedVariable(new_v, s_col_list);
                    order_list[i] = new_v;
                    continue;
                }
                exp.prepare(from_set.expressionQualifier());
                Planner.substituteAliasedVariables(exp, s_col_list);
                order_list[i] = new Variable(FUNCTION_TABLE, "#ORDER-" + function_orders.size());
                function_orders.add(exp);
            }
            int fsz = function_orders.size();
            if (fsz > 0) {
                Expression[] funs = new Expression[fsz];
                String[] fnames = new String[fsz];
                for (int n = 0; n < fsz; ++n) {
                    funs[n] = (Expression)function_orders.get(n);
                    fnames[n] = "#ORDER-" + n;
                }
                if (plan instanceof QueryPlan.SubsetNode) {
                    QueryPlan.SubsetNode top_subset_node = (QueryPlan.SubsetNode)plan;
                    Variable[] mapped_names = top_subset_node.getNewColumnNames();
                    plan = new QueryPlan.CreateFunctionsNode(plan, funs, fnames);
                    plan = new QueryPlan.SortNode(plan, order_list, ascending_list);
                    plan = new QueryPlan.SubsetNode(plan, mapped_names, mapped_names);
                } else {
                    plan = new QueryPlan.CreateFunctionsNode(plan, funs, fnames);
                    plan = new QueryPlan.SortNode(plan, order_list, ascending_list);
                }
            } else {
                plan = new QueryPlan.SortNode(plan, order_list, ascending_list);
            }
        }
        return plan;
    }

    private static void substituteAliasedVariables(Expression expression, ArrayList s_col_list) {
        List all_vars = expression.allVariables();
        for (int i = 0; i < all_vars.size(); ++i) {
            Variable v = (Variable)all_vars.get(i);
            Planner.substituteAliasedVariable(v, s_col_list);
        }
    }

    private static void substituteAliasedVariable(Variable v, ArrayList s_col_list) {
        if (s_col_list != null) {
            int sz = s_col_list.size();
            for (int n = 0; n < sz; ++n) {
                SelectColumn scol = (SelectColumn)s_col_list.get(n);
                if (!v.equals(scol.resolved_name)) continue;
                v.set(scol.internal_name);
            }
        }
    }

    static abstract class ExpressionPlan
    implements Comparable {
        private float optimizable_value;

        ExpressionPlan() {
        }

        public void setOptimizableValue(float v) {
            this.optimizable_value = v;
        }

        public float getOptimizableValue() {
            return this.optimizable_value;
        }

        public abstract void addToPlanTree();

        public int compareTo(Object ob) {
            ExpressionPlan dest_plan = (ExpressionPlan)ob;
            float dest_val = dest_plan.optimizable_value;
            if (this.optimizable_value > dest_val) {
                return 1;
            }
            if (this.optimizable_value < dest_val) {
                return -1;
            }
            return 0;
        }
    }

    private static class PlanTableSource {
        private QueryPlanNode plan;
        private final Variable[] var_list;
        private final String[] unique_names;
        private boolean is_updated;
        PlanTableSource left_plan;
        PlanTableSource right_plan;
        int left_join_type;
        int right_join_type;
        Expression left_on_expr;
        Expression right_on_expr;

        public PlanTableSource(QueryPlanNode plan, Variable[] var_list, String[] table_unique_names) {
            this.plan = plan;
            this.var_list = var_list;
            this.unique_names = table_unique_names;
            this.left_join_type = -1;
            this.right_join_type = -1;
            this.is_updated = false;
        }

        void setLeftJoinInfo(PlanTableSource left_plan, int join_type, Expression on_expr) {
            this.left_plan = left_plan;
            this.left_join_type = join_type;
            this.left_on_expr = on_expr;
        }

        void setRightJoinInfo(PlanTableSource right_plan, int join_type, Expression on_expr) {
            this.right_plan = right_plan;
            this.right_join_type = join_type;
            this.right_on_expr = on_expr;
        }

        void setJoinInfoMergedBetween(PlanTableSource left, PlanTableSource right) {
            if (left.right_plan != right) {
                if (left.right_plan != null) {
                    this.setRightJoinInfo(left.right_plan, left.right_join_type, left.right_on_expr);
                    this.right_plan.left_plan = this;
                }
                if (right.left_plan != null) {
                    this.setLeftJoinInfo(right.left_plan, right.left_join_type, right.left_on_expr);
                    this.left_plan.right_plan = this;
                }
            }
            if (left.left_plan != right) {
                if (this.left_plan == null && left.left_plan != null) {
                    this.setLeftJoinInfo(left.left_plan, left.left_join_type, left.left_on_expr);
                    this.left_plan.right_plan = this;
                }
                if (this.right_plan == null && right.right_plan != null) {
                    this.setRightJoinInfo(right.right_plan, right.right_join_type, right.right_on_expr);
                    this.right_plan.left_plan = this;
                }
            }
        }

        public boolean containsVariable(Variable v) {
            for (int i = 0; i < this.var_list.length; ++i) {
                if (!this.var_list[i].equals(v)) continue;
                return true;
            }
            return false;
        }

        public boolean containsUniqueKey(String name) {
            for (int i = 0; i < this.unique_names.length; ++i) {
                if (!this.unique_names[i].equals(name)) continue;
                return true;
            }
            return false;
        }

        public void setUpdated() {
            this.is_updated = true;
        }

        public void updatePlan(QueryPlanNode node) {
            this.plan = node;
            this.setUpdated();
        }

        public QueryPlanNode getPlan() {
            return this.plan;
        }

        public boolean isUpdated() {
            return this.is_updated;
        }

        public PlanTableSource copy() {
            return new PlanTableSource(this.plan, this.var_list, this.unique_names);
        }
    }

    private static class QueryTableSetPlanner {
        private ArrayList table_list = new ArrayList();
        private boolean has_join_occurred = false;

        private void addPlanTableSource(PlanTableSource source) {
            this.table_list.add(source);
            this.has_join_occurred = true;
        }

        public boolean hasJoinOccured() {
            return this.has_join_occurred;
        }

        public void addTableSource(QueryPlanNode plan, FromTableInterface from_def) {
            Variable[] all_cols = from_def.allColumns();
            String[] unique_names = new String[]{from_def.getUniqueName()};
            this.addPlanTableSource(new PlanTableSource(plan, all_cols, unique_names));
        }

        private int indexOfPlanTableSource(PlanTableSource source) {
            int sz = this.table_list.size();
            for (int i = 0; i < sz; ++i) {
                if (this.table_list.get(i) != source) continue;
                return i;
            }
            return -1;
        }

        public void setJoinInfoBetweenSources(int between_index, int join_type, Expression on_expr) {
            PlanTableSource plan_left = (PlanTableSource)this.table_list.get(between_index);
            PlanTableSource plan_right = (PlanTableSource)this.table_list.get(between_index + 1);
            plan_left.setRightJoinInfo(plan_right, join_type, on_expr);
            plan_right.setLeftJoinInfo(plan_left, join_type, on_expr);
        }

        public static PlanTableSource concatTableSources(PlanTableSource left, PlanTableSource right, QueryPlanNode plan) {
            int n;
            int n2;
            Variable[] new_var_list = new Variable[left.var_list.length + right.var_list.length];
            int i = 0;
            for (n2 = 0; n2 < left.var_list.length; ++n2) {
                new_var_list[i] = left.var_list[n2];
                ++i;
            }
            for (n2 = 0; n2 < right.var_list.length; ++n2) {
                new_var_list[i] = right.var_list[n2];
                ++i;
            }
            String[] new_unique_list = new String[left.unique_names.length + right.unique_names.length];
            i = 0;
            for (n = 0; n < left.unique_names.length; ++n) {
                new_unique_list[i] = left.unique_names[n];
                ++i;
            }
            for (n = 0; n < right.unique_names.length; ++n) {
                new_unique_list[i] = right.unique_names[n];
                ++i;
            }
            return new PlanTableSource(plan, new_var_list, new_unique_list);
        }

        public PlanTableSource mergeTables(PlanTableSource left, PlanTableSource right, QueryPlanNode merge_plan) {
            this.table_list.remove(left);
            this.table_list.remove(right);
            PlanTableSource c_plan = QueryTableSetPlanner.concatTableSources(left, right, merge_plan);
            c_plan.setJoinInfoMergedBetween(left, right);
            c_plan.setUpdated();
            this.addPlanTableSource(c_plan);
            return c_plan;
        }

        public PlanTableSource findTableSource(Variable ref) {
            int sz = this.table_list.size();
            if (sz == 1) {
                return (PlanTableSource)this.table_list.get(0);
            }
            for (int i = 0; i < sz; ++i) {
                PlanTableSource source = (PlanTableSource)this.table_list.get(i);
                if (!source.containsVariable(ref)) continue;
                return source;
            }
            throw new RuntimeException("Unable to find table with variable reference: " + ref);
        }

        public PlanTableSource findCommonTableSource(List var_list) {
            if (var_list.size() == 0) {
                return null;
            }
            PlanTableSource plan = this.findTableSource((Variable)var_list.get(0));
            int sz = var_list.size();
            for (int i = 1; i < sz; ++i) {
                PlanTableSource p2 = this.findTableSource((Variable)var_list.get(i));
                if (plan == p2) continue;
                return null;
            }
            return plan;
        }

        public PlanTableSource findTableSourceWithUniqueKey(String key) {
            int sz = this.table_list.size();
            for (int i = 0; i < sz; ++i) {
                PlanTableSource source = (PlanTableSource)this.table_list.get(i);
                if (!source.containsUniqueKey(key)) continue;
                return source;
            }
            throw new RuntimeException("Unable to find table with unique key: " + key);
        }

        private PlanTableSource getSingleTableSource() {
            if (this.table_list.size() != 1) {
                throw new RuntimeException("Not a single table source.");
            }
            return (PlanTableSource)this.table_list.get(0);
        }

        private void setCachePoints() {
            int sz = this.table_list.size();
            for (int i = 0; i < sz; ++i) {
                PlanTableSource plan = (PlanTableSource)this.table_list.get(i);
                if (plan.getPlan() instanceof QueryPlan.CachePointNode) continue;
                plan.plan = new QueryPlan.CachePointNode(plan.getPlan());
            }
        }

        private PlanTableSource joinAllPlansWithVariables(List all_vars) {
            ArrayList<PlanTableSource> touched_plans = new ArrayList<PlanTableSource>();
            int sz = all_vars.size();
            for (int i = 0; i < sz; ++i) {
                Variable v = (Variable)all_vars.get(i);
                PlanTableSource plan = this.findTableSource(v);
                if (touched_plans.contains(plan)) continue;
                touched_plans.add(plan);
            }
            return this.joinAllPlansToSingleSource(touched_plans);
        }

        private int canPlansBeNaturallyJoined(PlanTableSource plan1, PlanTableSource plan2) {
            if (plan1.left_plan == plan2 || plan1.right_plan == plan2) {
                return 0;
            }
            if (plan1.left_plan != null && plan2.left_plan != null) {
                return 2;
            }
            if (plan1.right_plan != null && plan2.right_plan != null) {
                return 1;
            }
            if (plan1.left_plan == null && plan2.right_plan == null || plan1.right_plan == null && plan2.left_plan == null) {
                return 0;
            }
            return 2;
        }

        private PlanTableSource joinAllPlansToSingleSource(List all_plans) {
            if (all_plans.size() == 0) {
                return null;
            }
            if (all_plans.size() == 1) {
                return (PlanTableSource)all_plans.get(0);
            }
            ArrayList working_plan_list = new ArrayList(all_plans.size());
            for (int i = 0; i < all_plans.size(); ++i) {
                working_plan_list.add(all_plans.get(i));
            }
            while (working_plan_list.size() > 1) {
                PlanTableSource new_plan;
                PlanTableSource right_plan;
                PlanTableSource left_plan = (PlanTableSource)working_plan_list.get(0);
                int status = this.canPlansBeNaturallyJoined(left_plan, right_plan = (PlanTableSource)working_plan_list.get(1));
                if (status == 0) {
                    new_plan = this.naturallyJoinPlans(left_plan, right_plan);
                    working_plan_list.remove(left_plan);
                    working_plan_list.remove(right_plan);
                    working_plan_list.add(0, new_plan);
                    continue;
                }
                if (status == 1) {
                    new_plan = this.naturallyJoinPlans(left_plan, left_plan.right_plan);
                    working_plan_list.remove(left_plan);
                    working_plan_list.remove(left_plan.right_plan);
                    working_plan_list.add(0, new_plan);
                    continue;
                }
                if (status == 2) {
                    new_plan = this.naturallyJoinPlans(left_plan, left_plan.left_plan);
                    working_plan_list.remove(left_plan);
                    working_plan_list.remove(left_plan.left_plan);
                    working_plan_list.add(0, new_plan);
                    continue;
                }
                throw new RuntimeException("Unknown status: " + status);
            }
            return (PlanTableSource)working_plan_list.get(0);
        }

        /*
         * WARNING - void declaration
         */
        private PlanTableSource naturallyJoinPlans(PlanTableSource plan1, PlanTableSource plan2) {
            void var7_8;
            void var4_4;
            void var6_6;
            boolean outer_join;
            void var5_5;
            void var3_3;
            PlanTableSource right_plan;
            PlanTableSource left_plan;
            Expression on_expr;
            int join_type;
            if (plan1.right_plan == plan2) {
                join_type = plan1.right_join_type;
                on_expr = plan1.right_on_expr;
                left_plan = plan1;
                right_plan = plan2;
            } else if (plan1.left_plan == plan2) {
                join_type = plan1.left_join_type;
                on_expr = plan1.left_on_expr;
                left_plan = plan2;
                right_plan = plan1;
            } else {
                if (plan1.left_plan != null && plan2.left_plan != null || plan1.right_plan != null && plan2.right_plan != null) {
                    throw new RuntimeException("Assertion failed - plans can not be naturally join because the left/right join plans clash.");
                }
                QueryPlan.NaturalJoinNode node = new QueryPlan.NaturalJoinNode(plan1.getPlan(), plan2.getPlan());
                return this.mergeTables(plan1, plan2, node);
            }
            if (var3_3 == 2) {
                var5_5.updatePlan(new QueryPlan.MarkerNode(var5_5.getPlan(), "OUTER_JOIN"));
                outer_join = true;
            } else if (var3_3 == 3) {
                var6_6.updatePlan(new QueryPlan.MarkerNode(var6_6.getPlan(), "OUTER_JOIN"));
                outer_join = true;
            } else if (var3_3 == true) {
                outer_join = false;
            } else {
                throw new RuntimeException("Join type (" + (int)var3_3 + ") is not supported.");
            }
            QueryTableSetPlanner planner = new QueryTableSetPlanner();
            planner.addPlanTableSource(var5_5.copy());
            planner.addPlanTableSource(var6_6.copy());
            QueryPlanNode node = planner.logicalEvaluate((Expression)var4_4);
            if (var7_8 != false) {
                node = new QueryPlan.LeftOuterJoinNode(node, "OUTER_JOIN");
            }
            return this.mergeTables(plan1, plan2, node);
        }

        private void planAllOuterJoins() {
            int sz = this.table_list.size();
            if (sz <= 1) {
                return;
            }
            ArrayList working_plan_list = new ArrayList(sz);
            for (int i = 0; i < sz; ++i) {
                working_plan_list.add(this.table_list.get(i));
            }
            PlanTableSource plan1 = (PlanTableSource)working_plan_list.get(0);
            for (int i = 1; i < sz; ++i) {
                PlanTableSource plan2 = (PlanTableSource)working_plan_list.get(i);
                plan1 = plan1.right_plan == plan2 ? this.naturallyJoinPlans(plan1, plan2) : plan2;
            }
        }

        private PlanTableSource naturalJoinAll() {
            int sz = this.table_list.size();
            if (sz == 1) {
                return (PlanTableSource)this.table_list.get(0);
            }
            return this.joinAllPlansToSingleSource(this.table_list);
        }

        private void addSingleVarPlanTo(ArrayList list, PlanTableSource table, Variable variable, Variable single_var, Expression[] exp_parts, Operator op) {
            Expression exp = new Expression(exp_parts[0], op, exp_parts[1]);
            int sz = list.size();
            for (int i = 0; i < sz; ++i) {
                SingleVarPlan plan = (SingleVarPlan)list.get(i);
                if (plan.table_source != table || variable != null && !plan.variable.equals(variable)) continue;
                plan.variable = variable;
                plan.expression = new Expression(plan.expression, Operator.get("and"), exp);
                return;
            }
            SingleVarPlan plan = new SingleVarPlan();
            plan.table_source = table;
            plan.variable = variable;
            plan.single_var = single_var;
            plan.expression = exp;
            list.add(plan);
        }

        void evaluateConstants(ArrayList constant_vars, ArrayList evaluate_order) {
            for (int i = 0; i < constant_vars.size(); ++i) {
                Expression expr = (Expression)constant_vars.get(i);
                ConstantExpressionPlan exp_plan = new ConstantExpressionPlan(expr);
                exp_plan.setOptimizableValue(0.0f);
                evaluate_order.add(exp_plan);
            }
        }

        void evaluateSingles(ArrayList single_vars, ArrayList evaluate_order) {
            ExpressionPlan exp_plan;
            SingleVarPlan var_plan;
            int i;
            ArrayList simple_plan_list = new ArrayList();
            ArrayList complex_plan_list = new ArrayList();
            for (int i2 = 0; i2 < single_vars.size(); ++i2) {
                Variable single_var;
                Expression andexp = (Expression)single_vars.get(i2);
                Operator op = (Operator)andexp.last();
                Expression[] exps = andexp.split();
                if (op.isSubQuery()) {
                    ExpressionPlan exp_plan2;
                    single_var = exps[0].getVariable();
                    if (single_var != null) {
                        exp_plan2 = new SimpleSelectExpressionPlan(single_var, op, exps[1]);
                        exp_plan2.setOptimizableValue(0.2f);
                        evaluate_order.add(exp_plan2);
                        continue;
                    }
                    single_var = (Variable)exps[0].allVariables().get(0);
                    exp_plan2 = new ComplexSingleExpressionPlan(single_var, andexp);
                    exp_plan2.setOptimizableValue(0.8f);
                    evaluate_order.add(exp_plan2);
                    continue;
                }
                List all_vars = exps[0].allVariables();
                if (all_vars.size() == 0) {
                    Expression temp_exp = exps[0];
                    exps[0] = exps[1];
                    exps[1] = temp_exp;
                    op = op.reverse();
                    single_var = (Variable)exps[0].allVariables().get(0);
                } else {
                    single_var = (Variable)all_vars.get(0);
                }
                PlanTableSource table_source = this.findTableSource(single_var);
                Variable v = exps[0].getVariable();
                if (v != null) {
                    this.addSingleVarPlanTo(simple_plan_list, table_source, v, single_var, exps, op);
                    continue;
                }
                this.addSingleVarPlanTo(complex_plan_list, table_source, null, single_var, exps, op);
            }
            int sz = simple_plan_list.size();
            for (i = 0; i < sz; ++i) {
                var_plan = (SingleVarPlan)simple_plan_list.get(i);
                exp_plan = new SimpleSingleExpressionPlan(var_plan.single_var, var_plan.expression);
                exp_plan.setOptimizableValue(0.2f);
                evaluate_order.add(exp_plan);
            }
            sz = complex_plan_list.size();
            for (i = 0; i < sz; ++i) {
                var_plan = (SingleVarPlan)complex_plan_list.get(i);
                exp_plan = new ComplexSingleExpressionPlan(var_plan.single_var, var_plan.expression);
                exp_plan.setOptimizableValue(0.8f);
                evaluate_order.add(exp_plan);
            }
        }

        void evaluatePatterns(ArrayList pattern_exprs, ArrayList evaluate_order) {
            for (int i = 0; i < pattern_exprs.size(); ++i) {
                ExpressionPlan expr_plan;
                Expression expr = (Expression)pattern_exprs.get(i);
                Expression[] exps = expr.split();
                Variable lhs_v = exps[0].getVariable();
                if (expr.isConstant()) {
                    expr_plan = new ConstantExpressionPlan(expr);
                    expr_plan.setOptimizableValue(0.0f);
                    evaluate_order.add(expr_plan);
                    continue;
                }
                if (lhs_v != null && exps[1].isConstant()) {
                    expr_plan = new SimplePatternExpressionPlan(lhs_v, expr);
                    expr_plan.setOptimizableValue(0.25f);
                    evaluate_order.add(expr_plan);
                    continue;
                }
                expr_plan = new ExhaustiveSelectExpressionPlan(expr);
                expr_plan.setOptimizableValue(0.82f);
                evaluate_order.add(expr_plan);
            }
        }

        void evaluateSubQueries(ArrayList expressions, ArrayList evaluate_order) {
            for (int i = 0; i < expressions.size(); ++i) {
                ArrayList cv;
                Expression[] exps;
                Expression andexp = (Expression)expressions.get(i);
                Variable left_var = null;
                QueryPlanNode right_plan = null;
                Operator op = (Operator)andexp.last();
                boolean is_exhaustive = op.isSubQuery() ? ((left_var = (exps = andexp.split())[0].getVariable()) != null ? ((right_plan = exps[1].getQueryPlanNode()) != null ? (cv = right_plan.discoverCorrelatedVariables(1, new ArrayList())).size() != 0 : true) : true) : true;
                if (is_exhaustive) {
                    List all_vars = andexp.allVariables();
                    ArrayList all_correlated = andexp.discoverCorrelatedVariables(0, new ArrayList());
                    int sz = all_correlated.size();
                    if (all_vars.size() == 0 && sz == 0) {
                        ConstantExpressionPlan expr_plan = new ConstantExpressionPlan(andexp);
                        expr_plan.setOptimizableValue(0.0f);
                        evaluate_order.add(expr_plan);
                        continue;
                    }
                    for (int n = 0; n < sz; ++n) {
                        CorrelatedVariable cv2 = (CorrelatedVariable)all_correlated.get(n);
                        all_vars.add(cv2.getVariable());
                    }
                    ExhaustiveSubQueryExpressionPlan exp_plan = new ExhaustiveSubQueryExpressionPlan(all_vars, andexp);
                    exp_plan.setOptimizableValue(0.85f);
                    evaluate_order.add(exp_plan);
                    continue;
                }
                SimpleSubQueryExpressionPlan exp_plan = new SimpleSubQueryExpressionPlan(andexp);
                exp_plan.setOptimizableValue(0.3f);
                evaluate_order.add(exp_plan);
            }
        }

        void evaluateMultiples(ArrayList multi_vars, ArrayList evaluate_order) {
            for (int i = 0; i < multi_vars.size(); ++i) {
                ExpressionPlan exp_plan;
                Expression expr = (Expression)multi_vars.get(i);
                Expression[] exps = expr.split();
                Variable lhs_v = exps[0].getVariable();
                Variable rhs_v = exps[1].getVariable();
                if (lhs_v == null && rhs_v == null) {
                    exp_plan = new ExhaustiveJoinExpressionPlan(expr);
                    exp_plan.setOptimizableValue(0.68f);
                    evaluate_order.add(exp_plan);
                    continue;
                }
                if (lhs_v != null && rhs_v != null) {
                    exp_plan = new StandardJoinExpressionPlan(expr);
                    exp_plan.setOptimizableValue(0.6f);
                    evaluate_order.add(exp_plan);
                    continue;
                }
                exp_plan = new StandardJoinExpressionPlan(expr);
                exp_plan.setOptimizableValue(0.64f);
                evaluate_order.add(exp_plan);
            }
        }

        void evaluateSubLogic(ArrayList sublogic_exprs, ArrayList evaluate_order) {
            block0: for (int i = 0; i < sublogic_exprs.size(); ++i) {
                Expression expr = (Expression)sublogic_exprs.get(i);
                ArrayList or_exprs = expr.breakByOperator(new ArrayList(), "or");
                PlanTableSource common = null;
                for (int n = 0; n < or_exprs.size(); ++n) {
                    Expression or_expr = (Expression)or_exprs.get(n);
                    List vars = or_expr.allVariables();
                    if (vars.size() <= 0) continue;
                    PlanTableSource ts = this.findCommonTableSource(vars);
                    boolean or_after_joins = false;
                    if (ts == null) {
                        or_after_joins = true;
                    } else if (common == null) {
                        common = ts;
                    } else if (common != ts) {
                        or_after_joins = true;
                    }
                    if (!or_after_joins) continue;
                    SubLogicExpressionPlan exp_plan = new SubLogicExpressionPlan(expr);
                    exp_plan.setOptimizableValue(0.7f);
                    evaluate_order.add(exp_plan);
                    continue block0;
                }
                SubLogicExpressionPlan exp_plan = new SubLogicExpressionPlan(expr);
                exp_plan.setOptimizableValue(0.58f);
                evaluate_order.add(exp_plan);
            }
        }

        void planForExpressionList(List and_list) {
            ArrayList<Expression> sub_logic_expressions = new ArrayList<Expression>();
            ArrayList<Expression> sub_query_expressions = new ArrayList<Expression>();
            ArrayList<Expression> constants = new ArrayList<Expression>();
            ArrayList<Expression> pattern_expressions = new ArrayList<Expression>();
            ArrayList<Expression> single_vars = new ArrayList<Expression>();
            ArrayList<Expression> multi_vars = new ArrayList<Expression>();
            for (int i = 0; i < and_list.size(); ++i) {
                Operator op;
                Object el = and_list.get(i);
                Expression andexp = (Expression)el;
                Object lob = andexp.last();
                if (!(lob instanceof Operator) || ((Operator)lob).isMathematical()) {
                    Operator EQUAL_OP = Operator.get("=");
                    andexp.addElement(TObject.booleanVal(true));
                    andexp.addOperator(EQUAL_OP);
                    op = EQUAL_OP;
                } else {
                    op = (Operator)lob;
                }
                if (op.isLogical()) {
                    sub_logic_expressions.add(andexp);
                    continue;
                }
                if (andexp.hasSubQuery()) {
                    sub_query_expressions.add(andexp);
                    continue;
                }
                if (op.isPattern()) {
                    pattern_expressions.add(andexp);
                    continue;
                }
                List vars = andexp.allVariables();
                if (vars.size() == 0) {
                    constants.add(andexp);
                    continue;
                }
                if (vars.size() == 1) {
                    single_vars.add(andexp);
                    continue;
                }
                if (vars.size() > 1) {
                    multi_vars.add(andexp);
                    continue;
                }
                throw new Error("Hmm, vars list size is negative!");
            }
            ArrayList evaluate_order = new ArrayList();
            this.evaluateConstants(constants, evaluate_order);
            this.evaluateSingles(single_vars, evaluate_order);
            this.evaluatePatterns(pattern_expressions, evaluate_order);
            this.evaluateSubQueries(sub_query_expressions, evaluate_order);
            this.evaluateMultiples(multi_vars, evaluate_order);
            this.evaluateSubLogic(sub_logic_expressions, evaluate_order);
            Collections.sort(evaluate_order);
            for (int i = 0; i < evaluate_order.size(); ++i) {
                ExpressionPlan plan = (ExpressionPlan)evaluate_order.get(i);
                plan.addToPlanTree();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void planForExpression(Expression exp) {
            if (exp == null) {
                return;
            }
            Object ob = exp.last();
            if (ob instanceof Operator && ((Operator)ob).isLogical()) {
                Operator last_op = (Operator)ob;
                if (last_op.is("or")) {
                    Expression[] exps = exp.split();
                    this.setCachePoints();
                    QueryTableSetPlanner left_planner = this.copy();
                    QueryTableSetPlanner right_planner = this.copy();
                    left_planner.planForExpression(exps[0]);
                    right_planner.planForExpression(exps[1]);
                    int left_sz = left_planner.table_list.size();
                    int right_sz = right_planner.table_list.size();
                    if (left_sz != right_sz || left_planner.hasJoinOccured() || right_planner.hasJoinOccured()) {
                        left_planner.naturalJoinAll();
                        right_planner.naturalJoinAll();
                    }
                    ArrayList left_table_list = left_planner.table_list;
                    ArrayList right_table_list = right_planner.table_list;
                    int sz = left_table_list.size();
                    ArrayList<PlanTableSource> left_join_list = new ArrayList<PlanTableSource>();
                    ArrayList<PlanTableSource> right_join_list = new ArrayList<PlanTableSource>();
                    for (int i = 0; i < sz; ++i) {
                        PlanTableSource left_plan = (PlanTableSource)left_table_list.get(i);
                        PlanTableSource right_plan = (PlanTableSource)right_table_list.get(i);
                        if (!left_plan.isUpdated() && !right_plan.isUpdated()) continue;
                        left_join_list.add(left_plan);
                        right_join_list.add(right_plan);
                    }
                    left_planner.joinAllPlansToSingleSource(left_join_list);
                    right_planner.joinAllPlansToSingleSource(right_join_list);
                    left_table_list = left_planner.table_list;
                    right_table_list = right_planner.table_list;
                    sz = left_table_list.size();
                    ArrayList<PlanTableSource> new_table_list = new ArrayList<PlanTableSource>(sz);
                    for (int i = 0; i < sz; ++i) {
                        PlanTableSource new_plan;
                        PlanTableSource left_plan = (PlanTableSource)left_table_list.get(i);
                        PlanTableSource right_plan = (PlanTableSource)right_table_list.get(i);
                        if (left_plan.isUpdated() || right_plan.isUpdated()) {
                            QueryPlan.LogicalUnionNode node = new QueryPlan.LogicalUnionNode(left_plan.getPlan(), right_plan.getPlan());
                            left_plan.updatePlan(node);
                            new_plan = left_plan;
                        } else {
                            new_plan = left_plan;
                        }
                        new_table_list.add(new_plan);
                    }
                    this.table_list = new_table_list;
                    return;
                } else {
                    if (!last_op.is("and")) throw new RuntimeException("Unknown logical operator: " + ob);
                    ArrayList and_list = new ArrayList();
                    and_list = this.createAndList(and_list, exp);
                    this.planForExpressionList(and_list);
                }
                return;
            } else {
                ArrayList<Expression> exp_list = new ArrayList<Expression>(1);
                exp_list.add(exp);
                this.planForExpressionList(exp_list);
            }
        }

        QueryPlanNode logicalEvaluate(Expression exp) {
            if (exp == null) {
                this.naturalJoinAll();
                return this.getSingleTableSource().getPlan();
            }
            this.planForExpression(exp);
            this.naturalJoinAll();
            return this.getSingleTableSource().getPlan();
        }

        private ArrayList createAndList(ArrayList list, Expression exp) {
            return exp.breakByOperator(list, "and");
        }

        QueryPlanNode planSearchExpression(SearchExpression search_expression) {
            this.planAllOuterJoins();
            QueryPlanNode node = this.logicalEvaluate(search_expression.getFromExpression());
            return node;
        }

        private QueryTableSetPlanner copy() {
            int i;
            QueryTableSetPlanner copy = new QueryTableSetPlanner();
            int sz = this.table_list.size();
            for (i = 0; i < sz; ++i) {
                copy.table_list.add(((PlanTableSource)this.table_list.get(i)).copy());
            }
            for (i = 0; i < sz; ++i) {
                int n;
                PlanTableSource src = (PlanTableSource)this.table_list.get(i);
                PlanTableSource mod = (PlanTableSource)copy.table_list.get(i);
                if (src.left_plan != null) {
                    n = this.indexOfPlanTableSource(src.left_plan);
                    mod.setLeftJoinInfo((PlanTableSource)copy.table_list.get(n), src.left_join_type, src.left_on_expr);
                }
                if (src.right_plan == null) continue;
                n = this.indexOfPlanTableSource(src.right_plan);
                mod.setRightJoinInfo((PlanTableSource)copy.table_list.get(n), src.right_join_type, src.right_on_expr);
            }
            return copy;
        }

        void printDebugInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append("PLANNER:\n");
            for (int i = 0; i < this.table_list.size(); ++i) {
                buf.append("TABLE " + i + "\n");
                ((PlanTableSource)this.table_list.get(i)).getPlan().debugString(2, buf);
                buf.append("\n");
            }
            System.out.println(buf);
        }

        private class SubLogicExpressionPlan
        extends ExpressionPlan {
            private Expression expression;

            public SubLogicExpressionPlan(Expression e) {
                this.expression = e;
            }

            public void addToPlanTree() {
                QueryTableSetPlanner.this.planForExpression(this.expression);
            }
        }

        private class StandardJoinExpressionPlan
        extends ExpressionPlan {
            private Expression expression;

            public StandardJoinExpressionPlan(Expression e) {
                this.expression = e;
            }

            public void addToPlanTree() {
                PlanTableSource rhs_plan;
                Expression[] exps = this.expression.split();
                Variable lhs_v = exps[0].getVariable();
                Variable rhs_v = exps[1].getVariable();
                List lhs_vars = exps[0].allVariables();
                List rhs_vars = exps[1].allVariables();
                Operator op = (Operator)this.expression.last();
                PlanTableSource lhs_plan = QueryTableSetPlanner.this.joinAllPlansWithVariables(lhs_vars);
                if (lhs_plan != (rhs_plan = QueryTableSetPlanner.this.joinAllPlansWithVariables(rhs_vars)) && (lhs_v != null || rhs_v != null)) {
                    if (lhs_v == null && rhs_v != null) {
                        QueryPlan.JoinNode join_node = new QueryPlan.JoinNode(rhs_plan.getPlan(), lhs_plan.getPlan(), rhs_v, op.reverse(), exps[0]);
                        QueryTableSetPlanner.this.mergeTables(rhs_plan, lhs_plan, join_node);
                    } else {
                        QueryPlan.JoinNode join_node = new QueryPlan.JoinNode(lhs_plan.getPlan(), rhs_plan.getPlan(), lhs_v, op, exps[1]);
                        QueryTableSetPlanner.this.mergeTables(lhs_plan, rhs_plan, join_node);
                    }
                    return;
                }
                List all_vars = this.expression.allVariables();
                PlanTableSource all_plan = QueryTableSetPlanner.this.joinAllPlansWithVariables(all_vars);
                all_plan.updatePlan(new QueryPlan.ExhaustiveSelectNode(all_plan.getPlan(), this.expression));
            }
        }

        private class ExhaustiveJoinExpressionPlan
        extends ExpressionPlan {
            private Expression expression;

            public ExhaustiveJoinExpressionPlan(Expression e) {
                this.expression = e;
            }

            public void addToPlanTree() {
                List all_vars = this.expression.allVariables();
                PlanTableSource all_plan = QueryTableSetPlanner.this.joinAllPlansWithVariables(all_vars);
                all_plan.updatePlan(new QueryPlan.ExhaustiveSelectNode(all_plan.getPlan(), this.expression));
            }
        }

        private class SimpleSubQueryExpressionPlan
        extends ExpressionPlan {
            private Expression expression;

            public SimpleSubQueryExpressionPlan(Expression e) {
                this.expression = e;
            }

            public void addToPlanTree() {
                Operator op = (Operator)this.expression.last();
                Expression[] exps = this.expression.split();
                Variable left_var = exps[0].getVariable();
                QueryPlanNode right_plan = exps[1].getQueryPlanNode();
                PlanTableSource table_source = QueryTableSetPlanner.this.findTableSource(left_var);
                QueryPlanNode left_plan = table_source.getPlan();
                table_source.updatePlan(new QueryPlan.NonCorrelatedAnyAllNode(left_plan, right_plan, new Variable[]{left_var}, op));
            }
        }

        private class ExhaustiveSubQueryExpressionPlan
        extends ExpressionPlan {
            private List all_vars;
            private Expression expression;

            public ExhaustiveSubQueryExpressionPlan(List vars, Expression e) {
                this.all_vars = vars;
                this.expression = e;
            }

            public void addToPlanTree() {
                PlanTableSource table_source = QueryTableSetPlanner.this.joinAllPlansWithVariables(this.all_vars);
                table_source.updatePlan(new QueryPlan.ExhaustiveSelectNode(table_source.getPlan(), this.expression));
            }
        }

        private class ExhaustiveSelectExpressionPlan
        extends ExpressionPlan {
            private Expression expression;

            public ExhaustiveSelectExpressionPlan(Expression e) {
                this.expression = e;
            }

            public void addToPlanTree() {
                List all_vars = this.expression.allVariables();
                PlanTableSource table_source = QueryTableSetPlanner.this.joinAllPlansWithVariables(all_vars);
                table_source.updatePlan(new QueryPlan.ExhaustiveSelectNode(table_source.getPlan(), this.expression));
            }
        }

        private class SimplePatternExpressionPlan
        extends ExpressionPlan {
            private Variable single_var;
            private Expression expression;

            public SimplePatternExpressionPlan(Variable v, Expression e) {
                this.single_var = v;
                this.expression = e;
            }

            public void addToPlanTree() {
                PlanTableSource table_source = QueryTableSetPlanner.this.findTableSource(this.single_var);
                table_source.updatePlan(new QueryPlan.SimplePatternSelectNode(table_source.getPlan(), this.expression));
            }
        }

        private class ComplexSingleExpressionPlan
        extends ExpressionPlan {
            private Variable single_var;
            private Expression expression;

            public ComplexSingleExpressionPlan(Variable v, Expression e) {
                this.single_var = v;
                this.expression = e;
            }

            public void addToPlanTree() {
                PlanTableSource table_source = QueryTableSetPlanner.this.findTableSource(this.single_var);
                table_source.updatePlan(new QueryPlan.ExhaustiveSelectNode(table_source.getPlan(), this.expression));
            }
        }

        private class SimpleSingleExpressionPlan
        extends ExpressionPlan {
            private Variable single_var;
            private Expression expression;

            public SimpleSingleExpressionPlan(Variable v, Expression e) {
                this.single_var = v;
                this.expression = e;
            }

            public void addToPlanTree() {
                PlanTableSource table_source = QueryTableSetPlanner.this.findTableSource(this.single_var);
                table_source.updatePlan(new QueryPlan.RangeSelectNode(table_source.getPlan(), this.expression));
            }
        }

        private class SimpleSelectExpressionPlan
        extends ExpressionPlan {
            private Variable single_var;
            private Operator op;
            private Expression expression;

            public SimpleSelectExpressionPlan(Variable v, Operator op, Expression e) {
                this.single_var = v;
                this.op = op;
                this.expression = e;
            }

            public void addToPlanTree() {
                PlanTableSource table_source = QueryTableSetPlanner.this.findTableSource(this.single_var);
                table_source.updatePlan(new QueryPlan.SimpleSelectNode(table_source.getPlan(), this.single_var, this.op, this.expression));
            }
        }

        private class ConstantExpressionPlan
        extends ExpressionPlan {
            private Expression expression;

            public ConstantExpressionPlan(Expression e) {
                this.expression = e;
            }

            public void addToPlanTree() {
                for (int n = 0; n < QueryTableSetPlanner.this.table_list.size(); ++n) {
                    PlanTableSource plan = (PlanTableSource)QueryTableSetPlanner.this.table_list.get(n);
                    plan.updatePlan(new QueryPlan.ConstantSelectNode(plan.getPlan(), this.expression));
                }
            }
        }

        private static class SingleVarPlan {
            PlanTableSource table_source;
            Variable single_var;
            Variable variable;
            Expression expression;

            private SingleVarPlan() {
            }
        }
    }

    private static class QuerySelectColumnSet {
        private static TableName FUNCTION_TABLE_NAME = new TableName("FUNCTIONTABLE");
        private TableExpressionFromSet from_set;
        ArrayList s_col_list;
        ArrayList function_col_list;
        private int running_fun_number = 0;
        int aggregate_count = 0;
        int constant_count = 0;

        public QuerySelectColumnSet(TableExpressionFromSet from_set) {
            this.from_set = from_set;
            this.s_col_list = new ArrayList();
            this.function_col_list = new ArrayList();
        }

        void selectSingleColumn(SelectColumn col) {
            this.s_col_list.add(col);
        }

        void addAllFromTable(FromTableInterface table) {
            Variable[] vars = table.allColumns();
            int s_col_list_max = this.s_col_list.size();
            for (int i = 0; i < vars.length; ++i) {
                Variable v = vars[i];
                SelectColumn ncol = new SelectColumn();
                Expression e = new Expression(v);
                e.text().append(v.toString());
                ncol.alias = null;
                ncol.expression = e;
                ncol.resolved_name = v;
                ncol.internal_name = v;
                this.selectSingleColumn(ncol);
            }
        }

        void selectAllColumnsFromSource(TableName table_name) {
            FromTableInterface table = this.from_set.findTable(table_name.getSchema(), table_name.getName());
            if (table == null) {
                throw new StatementException(table_name.toString() + ".* is not a valid reference.");
            }
            this.addAllFromTable(table);
        }

        void selectAllColumnsFromAllSources() {
            for (int p = 0; p < this.from_set.setCount(); ++p) {
                FromTableInterface table = this.from_set.getTable(p);
                this.addAllFromTable(table);
            }
        }

        Variable addHiddenFunction(String fun_alias, Expression function, QueryContext context) {
            SelectColumn scol = new SelectColumn();
            scol.resolved_name = new Variable(fun_alias);
            scol.alias = fun_alias;
            scol.expression = function;
            scol.internal_name = new Variable(FUNCTION_TABLE_NAME, fun_alias);
            if (function.hasAggregateFunction(context)) {
                ++this.aggregate_count;
            } else if (function.isConstant()) {
                ++this.constant_count;
            }
            this.function_col_list.add(scol);
            return scol.internal_name;
        }

        private void prepareSelectColumn(SelectColumn col, QueryContext context) throws DatabaseException {
            List exp_elements = col.expression.allElements();
            for (int n = 0; n < exp_elements.size(); ++n) {
                if (!(exp_elements.get(n) instanceof TableSelectExpression)) continue;
                throw new StatementException("Sub-query not allowed in column list.");
            }
            col.expression.prepare(this.from_set.expressionQualifier());
            Variable v = col.expression.getVariable();
            if (v == null) {
                ++this.running_fun_number;
                String agg_str = Integer.toString(this.running_fun_number);
                if (col.expression.hasAggregateFunction(context)) {
                    ++this.aggregate_count;
                    agg_str = agg_str + "_A";
                } else if (col.expression.isConstant()) {
                    ++this.constant_count;
                }
                this.function_col_list.add(col);
                col.internal_name = new Variable(FUNCTION_TABLE_NAME, agg_str);
                if (col.alias == null) {
                    col.alias = new String(col.expression.text());
                }
                col.resolved_name = new Variable(col.alias);
            } else {
                col.internal_name = v;
                col.resolved_name = col.alias == null ? v : new Variable(col.alias);
            }
        }

        void prepare(QueryContext context) throws DatabaseException {
            for (int i = 0; i < this.s_col_list.size(); ++i) {
                SelectColumn column = (SelectColumn)this.s_col_list.get(i);
                this.prepareSelectColumn(column, context);
            }
        }
    }
}

