/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Privileges;
import com.mckoi.database.ProcedureManager;
import com.mckoi.database.ProcedureName;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Statement;
import java.lang.reflect.Method;
import java.util.List;

public class Function
extends Statement {
    private String type;
    private TableName fun_name;

    public void prepare() throws DatabaseException {
        this.type = (String)this.cmd.getObject("type");
        String function_name = (String)this.cmd.getObject("function_name");
        String schema_name = this.database.getCurrentSchema();
        this.fun_name = TableName.resolve(schema_name, function_name);
        this.fun_name = this.database.tryResolveCase(this.fun_name);
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        boolean ignore_case = this.database.isInCaseInsensitiveMode();
        SchemaDef schema = this.database.resolveSchemaCase(this.fun_name.getSchema(), ignore_case);
        if (schema == null) {
            throw new DatabaseException("Schema '" + this.fun_name.getSchema() + "' doesn't exist.");
        }
        this.fun_name = new TableName(schema.getName(), this.fun_name.getName());
        if (this.type.equals("create")) {
            if (!this.database.getDatabase().canUserCreateProcedureObject(context, this.user, this.fun_name)) {
                throw new UserAccessException("User not permitted to create function: " + this.fun_name);
            }
            if (this.database.tableExists(this.fun_name)) {
                throw new DatabaseException("Database object with name '" + this.fun_name + "' already exists.");
            }
            List arg_names = (List)this.cmd.getObject("arg_names");
            List arg_types = (List)this.cmd.getObject("arg_types");
            TObject loc_name = (TObject)this.cmd.getObject("location_name");
            TType return_type = (TType)this.cmd.getObject("return_type");
            TType[] arg_type_array = arg_types.toArray(new TType[arg_types.size()]);
            String java_specification = loc_name.getObject().toString();
            Method proc_method = ProcedureManager.javaProcedureMethod(java_specification, arg_type_array);
            if (proc_method == null) {
                throw new DatabaseException("Unable to find invokation method for Java stored procedure name: " + java_specification);
            }
            ProcedureName proc_name = new ProcedureName(this.fun_name);
            int sz = arg_types.size();
            TType[] arg_list = new TType[sz];
            for (int i = 0; i < sz; ++i) {
                arg_list[i] = (TType)arg_types.get(i);
            }
            ProcedureManager manager = this.database.getProcedureManager();
            manager.defineJavaProcedure(proc_name, java_specification, return_type, arg_list, this.user.getUserName());
            this.database.getGrantManager().addGrant(Privileges.PROCEDURE_ALL_PRIVS, 1, proc_name.toString(), this.user.getUserName(), true, "@SYSTEM");
        } else if (this.type.equals("drop")) {
            if (!this.database.getDatabase().canUserDropProcedureObject(context, this.user, this.fun_name)) {
                throw new UserAccessException("User not permitted to drop function: " + this.fun_name);
            }
            ProcedureName proc_name = new ProcedureName(this.fun_name);
            ProcedureManager manager = this.database.getProcedureManager();
            manager.deleteProcedure(proc_name);
            this.database.getGrantManager().revokeAllGrantsOnObject(1, proc_name.toString());
        } else {
            throw new RuntimeException("Unknown type: " + this.type);
        }
        return FunctionTable.resultTable(context, 0);
    }
}

