/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.TableName;
import com.mckoi.database.TableQueryDef;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.FromTableInterface;

public class FromTableDirectSource
implements FromTableInterface {
    private TableQueryDef table_query;
    private DataTableDef data_table_def;
    private String unique_name;
    private TableName table_name;
    private TableName root_name;
    private boolean case_insensitive = false;

    public FromTableDirectSource(DatabaseConnection connection, TableQueryDef table_query, String unique_name, TableName given_name, TableName root_name) {
        this.unique_name = unique_name;
        this.data_table_def = table_query.getDataTableDef();
        this.root_name = root_name;
        this.table_name = given_name != null ? given_name : root_name;
        this.case_insensitive = connection.isInCaseInsensitiveMode();
        this.table_query = table_query;
    }

    public TableName getGivenTableName() {
        return this.table_name;
    }

    public TableName getRootTableName() {
        return this.root_name;
    }

    public QueryPlanNode createFetchQueryPlanNode() {
        return this.table_query.getQueryPlanNode();
    }

    public void setCaseInsensitive(boolean status) {
        this.case_insensitive = status;
    }

    private boolean stringCompare(String str1, String str2) {
        if (!this.case_insensitive) {
            return str1.equals(str2);
        }
        return str1.equalsIgnoreCase(str2);
    }

    public String getUniqueName() {
        return this.unique_name;
    }

    public boolean matchesReference(String catalog, String schema, String table) {
        if (schema != null && !this.stringCompare(schema, this.table_name.getSchema())) {
            return false;
        }
        return table == null || this.stringCompare(table, this.table_name.getName());
    }

    public int resolveColumnCount(String catalog, String schema, String table, String column) {
        if (schema != null && !this.stringCompare(schema, this.table_name.getSchema())) {
            return 0;
        }
        if (table != null && !this.stringCompare(table, this.table_name.getName())) {
            return 0;
        }
        if (column != null) {
            if (!this.case_insensitive) {
                int i = this.data_table_def.fastFindColumnName(column);
                return i == -1 ? 0 : 1;
            }
            int resolve_count = 0;
            int col_count = this.data_table_def.columnCount();
            for (int i = 0; i < col_count; ++i) {
                if (!this.data_table_def.columnAt(i).getName().equalsIgnoreCase(column)) continue;
                ++resolve_count;
            }
            return resolve_count;
        }
        return this.data_table_def.columnCount();
    }

    public Variable resolveColumn(String catalog, String schema, String table, String column) {
        if (schema != null && !this.stringCompare(schema, this.table_name.getSchema())) {
            throw new Error("Incorrect schema.");
        }
        if (table != null && !this.stringCompare(table, this.table_name.getName())) {
            throw new Error("Incorrect table.");
        }
        if (column != null) {
            if (!this.case_insensitive) {
                int i = this.data_table_def.fastFindColumnName(column);
                if (i == -1) {
                    throw new Error("Could not resolve '" + column + "'");
                }
                return new Variable(this.table_name, column);
            }
            int col_count = this.data_table_def.columnCount();
            for (int i = 0; i < col_count; ++i) {
                String col_name = this.data_table_def.columnAt(i).getName();
                if (!col_name.equalsIgnoreCase(column)) continue;
                return new Variable(this.table_name, col_name);
            }
            throw new Error("Could not resolve '" + column + "'");
        }
        return new Variable(this.table_name, this.data_table_def.columnAt(0).getName());
    }

    public Variable[] allColumns() {
        int col_count = this.data_table_def.columnCount();
        Variable[] vars = new Variable[col_count];
        for (int i = 0; i < col_count; ++i) {
            vars[i] = new Variable(this.table_name, this.data_table_def.columnAt(i).getName());
        }
        return vars;
    }
}

