/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DataTable;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.TriggerEvent;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Planner;
import com.mckoi.database.interpret.SearchExpression;
import com.mckoi.database.interpret.Select;
import com.mckoi.database.interpret.Statement;
import com.mckoi.database.interpret.TableExpressionFromSet;
import com.mckoi.database.interpret.TableSelectExpression;
import java.util.ArrayList;

public class Delete
extends Statement {
    String table_name;
    SearchExpression where_condition;
    int limit = -1;
    private DataTable update_table;
    private TableName tname;
    private ArrayList relationally_linked_tables;
    private QueryPlanNode plan;

    public void prepare() throws DatabaseException {
        this.table_name = (String)this.cmd.getObject("table_name");
        this.where_condition = (SearchExpression)this.cmd.getObject("where_clause");
        this.limit = this.cmd.getInt("limit");
        this.tname = this.resolveTableName(this.table_name, this.database);
        if (!this.database.tableExists(this.tname)) {
            throw new DatabaseException("Table '" + this.tname + "' does not exist.");
        }
        this.update_table = this.database.getTable(this.tname);
        TableSelectExpression select_expression = new TableSelectExpression();
        select_expression.from_clause.addTable(this.table_name);
        select_expression.where_clause = this.where_condition;
        TableExpressionFromSet from_set = Planner.generateFromSet(select_expression, this.database);
        this.plan = Planner.formQueryPlan(this.database, select_expression, from_set, null);
        TableName[] linked_tables = this.database.queryTablesRelationallyLinkedTo(this.tname);
        this.relationally_linked_tables = new ArrayList(linked_tables.length);
        for (int i = 0; i < linked_tables.length; ++i) {
            this.relationally_linked_tables.add(this.database.getTable(linked_tables[i]));
        }
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        if (!this.database.getDatabase().canUserDeleteFromTableObject(context, this.user, this.tname)) {
            throw new UserAccessException("User not permitted to delete from table: " + this.table_name);
        }
        Select.checkUserSelectPermissions(context, this.user, this.plan);
        Table delete_set = this.plan.evaluate(context);
        int delete_count = this.update_table.delete(delete_set, this.limit);
        if (delete_count > 0) {
            this.database.notifyTriggerEvent(new TriggerEvent(2, this.tname.toString(), delete_count));
        }
        return FunctionTable.resultTable(context, delete_count);
    }
}

