/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.Statement;

public class Compact
extends Statement {
    String table_name;

    public void prepare() throws DatabaseException {
        this.table_name = (String)this.cmd.getObject("table_name");
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        TableName tname = this.resolveTableName(this.table_name, this.database);
        if (!this.database.tableExists(tname)) {
            throw new DatabaseException("Table '" + tname + "' does not exist.");
        }
        if (!this.database.getDatabase().canUserCompactTableObject(context, this.user, tname)) {
            throw new UserAccessException("User not permitted to compact table: " + this.table_name);
        }
        this.database.compactTable(tname);
        return FunctionTable.resultTable(context, 0);
    }
}

