/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseConstraintViolationException;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.StatementTree;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.interpret.AlterTableAction;
import com.mckoi.database.interpret.ColumnChecker;
import com.mckoi.database.interpret.ColumnDef;
import com.mckoi.database.interpret.ConstraintDef;
import com.mckoi.database.interpret.CreateTable;
import com.mckoi.database.interpret.Statement;
import java.util.ArrayList;

public class AlterTable
extends Statement {
    StatementTree create_statement;
    String table_name;
    private ArrayList actions;
    private TableName tname;
    CreateTable create_stmt;

    public void addAction(AlterTableAction action) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        this.actions.add(action);
    }

    public boolean checkColumnNamesMatch(DatabaseConnection db, String col1, String col2) {
        if (db.isInCaseInsensitiveMode()) {
            return col1.equalsIgnoreCase(col2);
        }
        return col1.equals(col2);
    }

    private void checkColumnConstraint(String col_name, String[] cols, TableName table, String constraint_name) {
        for (int i = 0; i < cols.length; ++i) {
            if (!col_name.equals(cols[i])) continue;
            throw new DatabaseConstraintViolationException(27, "Constraint violation (" + constraint_name + ") dropping column " + col_name + " because of " + "referential constraint in " + table);
        }
    }

    public void prepare() throws DatabaseException {
        this.table_name = (String)this.cmd.getObject("table_name");
        this.addAction((AlterTableAction)this.cmd.getObject("alter_action"));
        this.create_statement = (StatementTree)this.cmd.getObject("create_statement");
        if (this.create_statement != null) {
            this.create_stmt = new CreateTable();
            this.create_stmt.init(this.database, this.create_statement, null);
            this.create_stmt.prepare();
            this.table_name = this.create_stmt.table_name;
        }
        this.tname = this.resolveTableName(this.table_name, this.database);
        if (this.tname.getName().indexOf(46) != -1) {
            throw new DatabaseException("Table name can not contain '.' character.");
        }
    }

    public Table evaluate() throws DatabaseException {
        AlterTableAction action;
        int i;
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        String schema_name = this.database.getCurrentSchema();
        if (!this.database.getDatabase().canUserAlterTableObject(context, this.user, this.tname)) {
            throw new UserAccessException("User not permitted to alter table: " + this.table_name);
        }
        if (this.create_statement != null) {
            DataTableDef table_def = this.create_stmt.createDataTableDef();
            TableName tname = table_def.getTableName();
            if (this.database.tableExists(tname)) {
                this.database.dropAllConstraintsForTable(tname);
                this.database.updateTable(table_def);
            } else {
                this.database.createTable(table_def);
            }
            this.create_stmt.setupAllConstraints();
            return FunctionTable.resultTable(context, 0);
        }
        DataTableDef table_def = this.database.getTable(this.tname).getDataTableDef();
        String table_name = table_def.getName();
        DataTableDef new_table = table_def.noColumnCopy();
        ColumnChecker checker = ColumnChecker.standardColumnChecker(this.database, this.tname);
        boolean table_altered = false;
        for (int n = 0; n < table_def.columnCount(); ++n) {
            DataTableColumnDef column = new DataTableColumnDef(table_def.columnAt(n));
            String col_name = column.getName();
            boolean mark_dropped = false;
            for (int i2 = 0; i2 < this.actions.size(); ++i2) {
                int p;
                AlterTableAction action2 = (AlterTableAction)this.actions.get(i2);
                if (action2.getAction().equals("ALTERSET") && this.checkColumnNamesMatch(this.database, (String)action2.getElement(0), col_name)) {
                    Expression exp = (Expression)action2.getElement(1);
                    checker.checkExpression(exp);
                    column.setDefaultExpression(exp);
                    table_altered = true;
                    continue;
                }
                if (action2.getAction().equals("DROPDEFAULT") && this.checkColumnNamesMatch(this.database, (String)action2.getElement(0), col_name)) {
                    column.setDefaultExpression(null);
                    table_altered = true;
                    continue;
                }
                if (!action2.getAction().equals("DROP") || !this.checkColumnNamesMatch(this.database, (String)action2.getElement(0), col_name)) continue;
                Transaction.ColumnGroupReference[] refs = this.database.queryTableImportedForeignKeyReferences(this.tname);
                for (p = 0; p < refs.length; ++p) {
                    this.checkColumnConstraint(col_name, refs[p].ref_columns, refs[p].ref_table_name, refs[p].name);
                }
                refs = this.database.queryTableForeignKeyReferences(this.tname);
                for (p = 0; p < refs.length; ++p) {
                    this.checkColumnConstraint(col_name, refs[p].key_columns, refs[p].key_table_name, refs[p].name);
                }
                Transaction.ColumnGroup primary_key = this.database.queryTablePrimaryKeyGroup(this.tname);
                if (primary_key != null) {
                    this.checkColumnConstraint(col_name, primary_key.columns, this.tname, primary_key.name);
                }
                Transaction.ColumnGroup[] uniques = this.database.queryTableUniqueGroups(this.tname);
                for (int p2 = 0; p2 < uniques.length; ++p2) {
                    this.checkColumnConstraint(col_name, uniques[p2].columns, this.tname, uniques[p2].name);
                }
                mark_dropped = true;
                table_altered = true;
            }
            if (mark_dropped) continue;
            new_table.addColumn(column);
        }
        for (i = 0; i < this.actions.size(); ++i) {
            action = (AlterTableAction)this.actions.get(i);
            if (!action.getAction().equals("ADD")) continue;
            ColumnDef cdef = (ColumnDef)action.getElement(0);
            if (cdef.isUnique() || cdef.isPrimaryKey()) {
                throw new DatabaseException("Can not use UNIQUE or PRIMARY KEY column constraint when altering a column.  Use ADD CONSTRAINT instead.");
            }
            DataTableColumnDef col = CreateTable.convertColumnDef(cdef);
            checker.checkExpression(col.getDefaultExpression(this.database.getSystem()));
            String col_name = col.getName();
            col.setName(ColumnChecker.stripTableName(table_name, col_name));
            new_table.addColumn(col);
            table_altered = true;
        }
        for (i = 0; i < this.actions.size(); ++i) {
            boolean constraint_dropped;
            action = (AlterTableAction)this.actions.get(i);
            if (action.getAction().equals("DROP_CONSTRAINT")) {
                String constraint_name = (String)action.getElement(0);
                int drop_count = this.database.dropNamedConstraint(this.tname, constraint_name);
                if (drop_count != 0) continue;
                throw new DatabaseException("Named constraint to drop on table " + this.tname + " was not found: " + constraint_name);
            }
            if (!action.getAction().equals("DROP_CONSTRAINT_PRIMARY_KEY") || (constraint_dropped = this.database.dropPrimaryKeyConstraintForTable(this.tname, null))) continue;
            throw new DatabaseException("No primary key to delete on table " + this.tname);
        }
        for (i = 0; i < this.actions.size(); ++i) {
            action = (AlterTableAction)this.actions.get(i);
            if (!action.getAction().equals("ADD_CONSTRAINT")) continue;
            ConstraintDef constraint = (ConstraintDef)action.getElement(0);
            boolean foreign_constraint = constraint.type == 3;
            TableName ref_tname = null;
            if (foreign_constraint) {
                ref_tname = this.resolveTableName(constraint.reference_table_name, this.database);
                if (this.database.isInCaseInsensitiveMode()) {
                    ref_tname = this.database.tryResolveCase(ref_tname);
                }
                constraint.reference_table_name = ref_tname.toString();
            }
            ColumnChecker.stripColumnList(table_name, constraint.column_list);
            ColumnChecker.stripColumnList(constraint.reference_table_name, constraint.column_list2);
            checker.checkExpression(constraint.check_expression);
            checker.checkColumnList(constraint.column_list);
            if (foreign_constraint && constraint.column_list2 != null) {
                ColumnChecker referenced_checker = ColumnChecker.standardColumnChecker(this.database, ref_tname);
                referenced_checker.checkColumnList(constraint.column_list2);
            }
            CreateTable.addSchemaConstraint(this.database, this.tname, constraint);
        }
        if (table_altered) {
            if (new_table.columnCount() == 0) {
                throw new DatabaseException("Can not ALTER table to have 0 columns.");
            }
            this.database.updateTable(new_table);
        } else {
            this.database.checkAllConstraints(this.tname);
        }
        return FunctionTable.resultTable(context, 0);
    }
}

