/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.StreamableObject;
import com.mckoi.database.global.StringObject;
import com.mckoi.util.BigNumber;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

public class ObjectTransfer {
    public static int size(Object ob) throws IOException {
        if (ob == null) {
            return 9;
        }
        if (ob instanceof StringObject) {
            return ob.toString().length() * 2 + 9;
        }
        if (ob instanceof BigNumber) {
            return 24;
        }
        if (ob instanceof Date) {
            return 17;
        }
        if (ob instanceof Boolean) {
            return 11;
        }
        if (ob instanceof ByteLongObject) {
            return ((ByteLongObject)ob).length() + 9;
        }
        if (ob instanceof StreamableObject) {
            return 14;
        }
        throw new IOException("Unrecognised type: " + ob.getClass());
    }

    public static int exactSize(Object ob) throws IOException {
        if (ob == null) {
            return 1;
        }
        if (ob instanceof StringObject) {
            return ob.toString().length() * 2 + 1 + 4;
        }
        if (ob instanceof BigNumber) {
            BigNumber n = (BigNumber)ob;
            if (n.canBeRepresentedAsInt()) {
                return 5;
            }
            if (n.canBeRepresentedAsLong()) {
                return 9;
            }
            byte[] buf = n.toByteArray();
            return buf.length + 1 + 1 + 4 + 4;
        }
        if (ob instanceof Date) {
            return 9;
        }
        if (ob instanceof Boolean) {
            return 2;
        }
        if (ob instanceof ByteLongObject) {
            return ((ByteLongObject)ob).length() + 1 + 8;
        }
        if (ob instanceof StreamableObject) {
            return 6;
        }
        throw new IOException("Unrecognised type: " + ob.getClass());
    }

    public static void writeTo(DataOutput out, Object ob) throws IOException {
        if (ob == null) {
            out.writeByte(1);
        } else if (ob instanceof StringObject) {
            String str = ob.toString();
            out.writeByte(18);
            out.writeInt(str.length());
            out.writeChars(str);
        } else if (ob instanceof BigNumber) {
            BigNumber n = (BigNumber)ob;
            if (n.canBeRepresentedAsInt()) {
                out.writeByte(24);
                out.writeInt(n.intValue());
            } else if (n.canBeRepresentedAsLong()) {
                out.writeByte(8);
                out.writeLong(n.longValue());
            } else {
                out.writeByte(7);
                out.writeByte(n.getState());
                out.writeInt(n.getScale());
                byte[] buf = n.toByteArray();
                out.writeInt(buf.length);
                out.write(buf);
            }
        } else if (ob instanceof Date) {
            Date d = (Date)ob;
            out.writeByte(9);
            out.writeLong(d.getTime());
        } else if (ob instanceof Boolean) {
            Boolean b = (Boolean)ob;
            out.writeByte(12);
            out.writeBoolean(b);
        } else if (ob instanceof ByteLongObject) {
            ByteLongObject barr = (ByteLongObject)ob;
            out.writeByte(15);
            byte[] arr = barr.getByteArray();
            out.writeLong(arr.length);
            out.write(arr);
        } else if (ob instanceof StreamableObject) {
            StreamableObject ob_head = (StreamableObject)ob;
            out.writeByte(16);
            out.writeByte(ob_head.getType());
            out.writeLong(ob_head.getSize());
            out.writeLong(ob_head.getIdentifier());
        } else {
            throw new IOException("Unrecognised type: " + ob.getClass());
        }
    }

    public static Object readFrom(DataInputStream in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return null;
            }
            case 3: {
                String str = in.readUTF();
                return StringObject.fromString(str);
            }
            case 6: {
                int scale = in.readInt();
                int blen = in.readInt();
                byte[] buf = new byte[blen];
                in.readFully(buf);
                return BigNumber.fromData(buf, scale, (byte)0);
            }
            case 7: {
                byte state = in.readByte();
                int scale = in.readInt();
                int blen = in.readInt();
                byte[] buf = new byte[blen];
                in.readFully(buf);
                return BigNumber.fromData(buf, scale, state);
            }
            case 8: {
                long val = in.readLong();
                return BigNumber.fromLong(val);
            }
            case 9: {
                long time = in.readLong();
                return new Date(time);
            }
            case 12: {
                return new Boolean(in.readBoolean());
            }
            case 15: {
                long size = in.readLong();
                byte[] arr = new byte[(int)size];
                in.readFully(arr, 0, (int)size);
                return new ByteLongObject(arr);
            }
            case 16: {
                byte h_type = in.readByte();
                long h_size = in.readLong();
                long h_id = in.readLong();
                return new StreamableObject(h_type, h_size, h_id);
            }
            case 18: {
                int len;
                StringBuffer buf = new StringBuffer(len);
                for (len = in.readInt(); len > 0; --len) {
                    buf.append(in.readChar());
                }
                return StringObject.fromString(new String(buf));
            }
            case 24: {
                long val = in.readInt();
                return BigNumber.fromLong(val);
            }
        }
        throw new IOException("Unrecognised type: " + type);
    }
}

