/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.BlobAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class ByteLongObject
implements Serializable,
BlobAccessor {
    static final long serialVersionUID = -6843780673892019530L;
    private byte[] data;

    public ByteLongObject(byte[] from, int offset, int length) {
        this.data = new byte[length];
        System.arraycopy(from, offset, this.data, 0, length);
    }

    public ByteLongObject(byte[] from) {
        this(from, 0, from.length);
    }

    public ByteLongObject(InputStream in, int length) throws IOException {
        int read;
        this.data = new byte[length];
        for (int i = 0; i < length; i += read) {
            read = in.read(this.data, i, length - i);
            if (read != -1) continue;
            throw new IOException("Premature end of stream.");
        }
    }

    public int length() {
        return this.data.length;
    }

    public byte getByte(int n) {
        return this.data[n];
    }

    public byte[] getByteArray() {
        return this.data;
    }

    public InputStream getInputStream() {
        return new BLOBInputStream();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.data == null) {
            buf.append("[ BLOB (NULL) ]");
        } else {
            buf.append("[ BLOB size=");
            buf.append(this.data.length);
            buf.append(" ]");
        }
        return new String(buf);
    }

    private class BLOBInputStream
    extends InputStream {
        private int index = 0;

        public int read() throws IOException {
            if (this.index >= ByteLongObject.this.length()) {
                return -1;
            }
            int b = ByteLongObject.this.getByte(this.index) & 0xFF;
            ++this.index;
            return b;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int size = ByteLongObject.this.length();
            int to_read = Math.min(len, size - this.index);
            if (to_read <= 0) {
                return -1;
            }
            System.arraycopy(ByteLongObject.this.data, this.index, buf, off, to_read);
            this.index += to_read;
            return to_read;
        }
    }
}

