/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.control;

import com.mckoi.database.Database;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseSystem;
import com.mckoi.database.control.DBConfig;
import com.mckoi.database.control.DBSystem;

public final class DBController {
    private static final DBController VM_DB_CONTROLLER = new DBController();
    static /* synthetic */ Class class$com$mckoi$database$control$DBController;

    DBController() {
    }

    public boolean databaseExists(DBConfig config) {
        Database database = DBController.createDatabase(config);
        boolean b = database.exists();
        database.getSystem().dispose();
        return b;
    }

    public DBSystem createDatabase(DBConfig config, String admin_user, String admin_pass) {
        Database database = DBController.createDatabase(config);
        DatabaseSystem system = database.getSystem();
        try {
            database.create(admin_user, admin_pass);
            database.init();
        }
        catch (DatabaseException e) {
            system.Debug().write(40, this, "Database create failed");
            system.Debug().writeException(e);
            throw new RuntimeException(e.getMessage());
        }
        return new DBSystem(this, config, database);
    }

    public DBSystem startDatabase(DBConfig config) {
        Database database = DBController.createDatabase(config);
        DatabaseSystem system = database.getSystem();
        try {
            database.init();
        }
        catch (DatabaseException e) {
            system.Debug().write(40, this, "Database init failed");
            system.Debug().writeException(e);
            throw new RuntimeException(e.getMessage());
        }
        return new DBSystem(this, config, database);
    }

    private static Database createDatabase(DBConfig config) {
        DatabaseSystem system = new DatabaseSystem();
        system.init(config);
        Database database = new Database(system, "DefaultDatabase");
        system.Debug().write(10000, class$com$mckoi$database$control$DBController == null ? (class$com$mckoi$database$control$DBController = DBController.class$("com.mckoi.database.control.DBController")) : class$com$mckoi$database$control$DBController, "Starting Database Server");
        return database;
    }

    public static DBController getDefault() {
        return VM_DB_CONTROLLER;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

