/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.User;
import com.mckoi.database.WorkerThread;
import com.mckoi.debug.DebugLogger;
import java.util.LinkedList;

final class WorkerPool {
    private TransactionSystem system;
    private int MAXIMUM_WORKER_THREADS = 4;
    private LinkedList available_worker_threads;
    private int worker_thread_count;
    private LinkedList run_queue;
    private boolean is_executing_commands;

    WorkerPool(TransactionSystem system, int max_worker_threads) {
        this.system = system;
        this.MAXIMUM_WORKER_THREADS = max_worker_threads;
        this.is_executing_commands = false;
        this.run_queue = new LinkedList();
        this.available_worker_threads = new LinkedList();
        this.worker_thread_count = 0;
    }

    public final DebugLogger Debug() {
        return this.system.Debug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyWorkerReady(WorkerThread worker_thread) {
        LinkedList linkedList = this.available_worker_threads;
        synchronized (linkedList) {
            this.available_worker_threads.add(worker_thread);
            int q_len = this.run_queue.size();
            if (q_len > 0) {
                RunCommand command = (RunCommand)this.run_queue.remove(0);
                this.execute(command.user, command.database, command.runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerThread getFirstWaitingThread() {
        LinkedList linkedList = this.available_worker_threads;
        synchronized (linkedList) {
            int size = this.available_worker_threads.size();
            if (size > 0) {
                WorkerThread wt = (WorkerThread)this.available_worker_threads.remove(0);
                return wt;
            }
            if (this.worker_thread_count < this.MAXIMUM_WORKER_THREADS) {
                ++this.worker_thread_count;
                WorkerThread wt = new WorkerThread(this);
                wt.start();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(User user, DatabaseConnection database, Runnable runner) {
        LinkedList linkedList = this.available_worker_threads;
        synchronized (linkedList) {
            WorkerThread worker;
            if (this.is_executing_commands && (worker = this.getFirstWaitingThread()) != null) {
                worker.execute(user, database, runner);
                return;
            }
            RunCommand command = new RunCommand(user, database, runner);
            this.run_queue.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsExecutingCommands(boolean status) {
        LinkedList linkedList = this.available_worker_threads;
        synchronized (linkedList) {
            if (status) {
                this.is_executing_commands = true;
                for (int i = this.run_queue.size() - 1; i >= 0; --i) {
                    RunCommand command = (RunCommand)this.run_queue.remove(i);
                    this.execute(command.user, command.database, command.runnable);
                }
            } else {
                this.is_executing_commands = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilAllWorkersQuiet() {
        if (Thread.currentThread() instanceof WorkerThread) {
            throw new Error("Can't call this method from a WorkerThread!");
        }
        LinkedList linkedList = this.available_worker_threads;
        synchronized (linkedList) {
            while (this.worker_thread_count != this.available_worker_threads.size()) {
                try {
                    this.available_worker_threads.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        LinkedList linkedList = this.available_worker_threads;
        synchronized (linkedList) {
            while (this.available_worker_threads.size() > 0) {
                WorkerThread wt = (WorkerThread)this.available_worker_threads.remove(0);
                --this.worker_thread_count;
                wt.shutdown();
            }
        }
    }

    private static final class RunCommand {
        User user;
        DatabaseConnection database;
        Runnable runnable;

        public RunCommand(User user, DatabaseConnection database, Runnable runnable) {
            this.user = user;
            this.database = database;
            this.runnable = runnable;
        }
    }
}

