/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.global.BlobAccessor;
import com.mckoi.database.global.ByteLongObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ViewDef {
    private DataTableDef view_def;
    private QueryPlanNode view_query_node;

    public ViewDef(DataTableDef view_def, QueryPlanNode query_node) {
        this.view_def = view_def;
        this.view_query_node = query_node;
    }

    public DataTableDef getDataTableDef() {
        return this.view_def;
    }

    public QueryPlanNode getQueryPlanNode() {
        try {
            return (QueryPlanNode)this.view_query_node.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone error: " + e.getMessage());
        }
    }

    ByteLongObject serializeToBlob() {
        try {
            ByteArrayOutputStream byte_out = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byte_out);
            out.writeInt(1);
            this.getDataTableDef().write(out);
            out.writeObject(this.getQueryPlanNode());
            out.flush();
            return new ByteLongObject(byte_out.toByteArray());
        }
        catch (IOException e) {
            throw new Error("IO Error: " + e.getMessage());
        }
    }

    static final ViewDef deserializeFromBlob(BlobAccessor blob) {
        InputStream blob_in = blob.getInputStream();
        try {
            ObjectInputStream in = new ObjectInputStream(blob_in);
            int version = in.readInt();
            if (version == 1) {
                DataTableDef view_def = DataTableDef.read(in);
                view_def.setImmutable();
                QueryPlanNode view_plan = (QueryPlanNode)in.readObject();
                return new ViewDef(view_def, view_plan);
            }
            throw new IOException("Newer ViewDef version serialization: " + version);
        }
        catch (IOException e) {
            throw new Error("IO Error: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new Error("Class not found: " + e.getMessage());
        }
    }
}

