/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.FixedSizeDataStore;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.ByteArrayUtil;
import com.mckoi.util.UserTerminal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class VariableSizeDataStore {
    private static final boolean COMPRESSED_WRITE_ENABLED = true;
    private static final int INDEX_SECTOR_SIZE = 12;
    private final DebugLogger debug;
    private FixedSizeDataStore allocation_store;
    private FixedSizeDataStore data_store;
    private byte[] index_key;
    private Deflater deflater;
    private Inflater inflater;
    private byte[] compress_buffer;
    private OutputStream sector_output_stream = null;

    public VariableSizeDataStore(File name, int sector_size, DebugLogger logger) {
        this.debug = logger;
        this.index_key = new byte[12];
        String path = name.getPath();
        this.allocation_store = new FixedSizeDataStore(new File(path + ".axi"), 12, this.debug);
        this.data_store = new FixedSizeDataStore(new File(path + ".dss"), sector_size, this.debug);
    }

    public VariableSizeDataStore(File name, DebugLogger logger) {
        this(name, -1, logger);
    }

    public void synch() throws IOException {
        this.allocation_store.synch();
        this.data_store.synch();
    }

    public void hardSynch() throws IOException {
        this.allocation_store.hardSynch();
        this.data_store.hardSynch();
    }

    public boolean locked() {
        return this.allocation_store.locked();
    }

    public void lock() {
        this.allocation_store.lock();
        this.data_store.lock();
    }

    public void unlock() {
        this.data_store.unlock();
        this.allocation_store.unlock();
    }

    public boolean recordDeleted(int record_index) throws IOException {
        return this.allocation_store.isSectorDeleted(record_index);
    }

    public int usedRecordCount() {
        return this.allocation_store.getSectorUseCount();
    }

    public int rawRecordCount() throws IOException {
        return this.allocation_store.rawSectorCount();
    }

    public boolean exists() throws IOException {
        return this.allocation_store.exists() && this.data_store.exists();
    }

    public boolean isReadOnly() {
        return this.data_store.isReadOnly();
    }

    public boolean open(boolean read_only) throws IOException {
        boolean r1 = this.allocation_store.open(read_only);
        boolean r2 = this.data_store.open(read_only);
        return r1 | r2;
    }

    public void close() throws IOException {
        this.allocation_store.close();
        this.data_store.close();
    }

    public void delete() {
        this.allocation_store.delete();
        this.data_store.delete();
    }

    public void fix(UserTerminal terminal) throws IOException {
        terminal.println("+ Fixing variable data store.");
        this.allocation_store.fix(terminal);
        this.data_store.fix(terminal);
        terminal.println("- Repairing references.");
        int sector_count = this.allocation_store.rawSectorCount();
        int data_sector_count = this.data_store.rawSectorCount();
        terminal.println("- Sector count: " + sector_count);
        int bad_record_count = 0;
        int deleted_record_count = 0;
        for (int i = 0; i < sector_count; ++i) {
            if (!this.allocation_store.isSectorDeleted(i)) {
                this.allocation_store.getSector(i, this.index_key);
                int sector_head = ByteArrayUtil.getInt(this.index_key, 0);
                int length = ByteArrayUtil.getInt(this.index_key, 4);
                if (sector_head < 0 || sector_head >= data_sector_count || length <= 0) {
                    ++bad_record_count;
                    this.allocation_store.deleteAcross(i);
                    ++deleted_record_count;
                    continue;
                }
                int[] chain_span = this.data_store.getSectorChain(sector_head, length);
                continue;
            }
            ++deleted_record_count;
        }
        terminal.println("- Fixed " + bad_record_count + " bad chains.");
    }

    public void copyTo(File path) throws IOException {
        this.allocation_store.copyTo(path);
        this.data_store.copyTo(path);
    }

    public int writeRecordType(int record_index, int type_key) throws IOException {
        int cur_type_key;
        this.allocation_store.getSector(record_index, this.index_key);
        int old_type_key = cur_type_key = ByteArrayUtil.getInt(this.index_key, 8);
        type_key = type_key & 0xFFFFFFF0 | cur_type_key & 0xF;
        ByteArrayUtil.setInt(type_key, this.index_key, 8);
        this.allocation_store.overwriteSector(record_index, this.index_key);
        return old_type_key;
    }

    public int readRecordType(int record_index) throws IOException {
        this.allocation_store.getSector(record_index, this.index_key);
        int cur_type_key = ByteArrayUtil.getInt(this.index_key, 8);
        return cur_type_key;
    }

    public int write(byte[] buf, int offset, int length) throws IOException {
        int real_length;
        int v;
        int sector_size = this.data_store.getSectorSize();
        boolean use_compressed_form = false;
        int compress_size = -1;
        if (length > sector_size) {
            int orig_span = this.data_store.calculateSectorSpan(length);
            if (this.deflater == null) {
                this.deflater = new Deflater();
            }
            this.deflater.setInput(buf, offset, length);
            this.deflater.finish();
            if (this.compress_buffer == null || this.compress_buffer.length < length + 4) {
                this.compress_buffer = new byte[length + 4];
            }
            compress_size = this.deflater.deflate(this.compress_buffer) + 4;
            this.deflater.reset();
            int new_span = this.data_store.calculateSectorSpan(compress_size);
            if (new_span < orig_span) {
                ByteArrayUtil.setInt(length, this.compress_buffer, compress_size - 4);
                use_compressed_form = true;
            }
        }
        int type_key = 0;
        if (use_compressed_form) {
            v = this.data_store.writeAcross(this.compress_buffer, 0, compress_size);
            real_length = compress_size;
            type_key |= 1;
        } else {
            v = this.data_store.writeAcross(buf, offset, length);
            real_length = length;
        }
        ByteArrayUtil.setInt(v, this.index_key, 0);
        ByteArrayUtil.setInt(real_length, this.index_key, 4);
        ByteArrayUtil.setInt(type_key, this.index_key, 8);
        return this.allocation_store.addSector(this.index_key);
    }

    public int read(int record, byte[] buf, int offset, int length) throws IOException {
        this.allocation_store.getSector(record, this.index_key);
        int chain_head = ByteArrayUtil.getInt(this.index_key, 0);
        int data_length = ByteArrayUtil.getInt(this.index_key, 4);
        int type_key = ByteArrayUtil.getInt(this.index_key, 8);
        if ((type_key & 1) != 0) {
            int inflate_count;
            if (this.compress_buffer == null || this.compress_buffer.length < data_length) {
                this.compress_buffer = new byte[data_length];
            }
            this.data_store.readAcross(chain_head, this.compress_buffer, 0, data_length);
            if (this.inflater == null) {
                this.inflater = new Inflater();
            }
            this.inflater.reset();
            this.inflater.setInput(this.compress_buffer, 0, data_length);
            try {
                inflate_count = this.inflater.inflate(buf, offset, length);
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                this.debug.writeException(e);
                throw new Error(e.getMessage());
            }
            return inflate_count;
        }
        int read_amount = Math.min(length, data_length);
        this.data_store.readAcross(chain_head, buf, offset, read_amount);
        return read_amount;
    }

    public byte[] readRecord(int record) throws IOException {
        this.allocation_store.getSector(record, this.index_key);
        int chain_head = ByteArrayUtil.getInt(this.index_key, 0);
        int data_length = ByteArrayUtil.getInt(this.index_key, 4);
        int type_key = ByteArrayUtil.getInt(this.index_key, 8);
        if ((type_key & 1) != 0) {
            int inflate_count;
            if (this.compress_buffer == null || this.compress_buffer.length < data_length) {
                this.compress_buffer = new byte[data_length];
            }
            this.data_store.readAcross(chain_head, this.compress_buffer, 0, data_length);
            if (this.inflater == null) {
                this.inflater = new Inflater();
            }
            int uncompressed_size = ByteArrayUtil.getInt(this.compress_buffer, data_length - 4);
            byte[] buf = new byte[uncompressed_size];
            this.inflater.reset();
            this.inflater.setInput(this.compress_buffer, 0, data_length - 4);
            try {
                inflate_count = this.inflater.inflate(buf);
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                this.debug.writeException(e);
                throw new Error(e.getMessage());
            }
            if (inflate_count != buf.length) {
                throw new Error("Inflate size != buf.length (" + inflate_count + " != " + buf.length + ")");
            }
            return buf;
        }
        byte[] buf = new byte[data_length];
        this.data_store.readAcross(chain_head, buf, 0, data_length);
        return buf;
    }

    public int delete(int record) throws IOException {
        this.allocation_store.getSector(record, this.index_key);
        int chain_head = ByteArrayUtil.getInt(this.index_key, 0);
        this.allocation_store.deleteSector(record);
        this.data_store.deleteAcross(chain_head);
        return record;
    }

    public OutputStream getRecordOutputStream() throws IOException {
        if (this.sector_output_stream == null) {
            this.sector_output_stream = this.data_store.getSectorOutputStream();
            return this.sector_output_stream;
        }
        throw new Error("More than one record output stream opened.");
    }

    public int completeRecordStreamWrite() throws IOException {
        if (this.sector_output_stream != null) {
            int v = this.data_store.getSectorOfLastOutputStream();
            int real_length = this.data_store.getLengthOfLastOutputStream();
            int type_key = 0;
            ByteArrayUtil.setInt(v, this.index_key, 0);
            ByteArrayUtil.setInt(real_length, this.index_key, 4);
            ByteArrayUtil.setInt(type_key, this.index_key, 8);
            this.sector_output_stream = null;
            this.data_store.wipeLastOutputStream();
            return this.allocation_store.addSector(this.index_key);
        }
        throw new Error("Output stream not available.");
    }

    public InputStream getRecordInputStream(int record) throws IOException {
        this.allocation_store.getSector(record, this.index_key);
        int chain_head = ByteArrayUtil.getInt(this.index_key, 0);
        return this.data_store.getSectorInputStream(chain_head);
    }

    public int sectorSize() throws IOException {
        return this.data_store.getSectorSize();
    }

    public int recordSize(int record) throws IOException {
        this.allocation_store.getSector(record, this.index_key);
        return ByteArrayUtil.getInt(this.index_key, 4);
    }

    public boolean isCompressed(int record) throws IOException {
        this.allocation_store.getSector(record, this.index_key);
        return (ByteArrayUtil.getInt(this.index_key, 8) & 1) != 0;
    }

    public int recordSectorCount(int record) throws IOException {
        return this.data_store.calculateSectorSpan(this.recordSize(record));
    }

    public long totalStoreSize() {
        return this.data_store.totalSize();
    }

    public void writeReservedBuffer(byte[] info, int offset, int length, int res_offset) throws IOException {
        this.allocation_store.writeReservedBuffer(info, offset, length, res_offset);
    }

    public void writeReservedBuffer(byte[] info, int offset, int length) throws IOException {
        this.allocation_store.writeReservedBuffer(info, offset, length);
    }

    public void readReservedBuffer(byte[] info, int offset, int length) throws IOException {
        this.allocation_store.readReservedBuffer(info, offset, length);
    }

    public static boolean exists(File path, String name) throws IOException {
        File af = new File(path, name + ".axi");
        File df = new File(path, name + ".dss");
        return af.exists() & df.exists();
    }

    public static boolean delete(File path, String name) throws IOException {
        File af = new File(path, name + ".axi");
        File df = new File(path, name + ".dss");
        return af.delete() & df.delete();
    }

    public static boolean rename(File path_source, String name_source, File path_dest, String name_dest) throws IOException {
        File afs = new File(path_source, name_source + ".axi");
        File dfs = new File(path_source, name_source + ".dss");
        File afd = new File(path_dest, name_dest + ".axi");
        File dfd = new File(path_dest, name_dest + ".dss");
        return afs.renameTo(afd) & dfs.renameTo(dfd);
    }

    public int writeString(String str) throws IOException {
        byte[] bts = str.getBytes();
        return this.write(bts, 0, bts.length);
    }

    public String readString(int record) throws IOException {
        byte[] buffer = new byte[65536];
        int read_in = this.read(record, buffer, 0, 65536);
        return new String(buffer, 0, read_in);
    }
}

