/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TableName;
import java.io.Serializable;

public final class Variable
implements Serializable,
Cloneable {
    static final long serialVersionUID = -8772800465139383297L;
    private static final TableName UNKNOWN_TABLE_NAME = new TableName("##UNKNOWN_TABLE_NAME##");
    private TableName table_name;
    private String column_name;

    public Variable(TableName table_name, String column_name) {
        if (table_name == null || column_name == null) {
            throw new NullPointerException();
        }
        this.table_name = table_name;
        this.column_name = column_name;
    }

    public Variable(String column_name) {
        this(UNKNOWN_TABLE_NAME, column_name);
    }

    public Variable(Variable v) {
        this.table_name = v.table_name;
        this.column_name = v.column_name;
    }

    public TableName getTableName() {
        if (!this.table_name.equals(UNKNOWN_TABLE_NAME)) {
            return this.table_name;
        }
        return null;
    }

    public String getName() {
        return this.column_name;
    }

    public static Variable resolve(String name) {
        int div = name.lastIndexOf(".");
        if (div != -1) {
            String column_name = name.substring(div + 1);
            TableName table_name = TableName.resolve(name.substring(0, div));
            return new Variable(table_name, column_name);
        }
        return new Variable(name);
    }

    public static Variable resolve(TableName tname, String name) {
        Variable v = Variable.resolve(name);
        if (v.getTableName() == null) {
            return new Variable(tname, v.getName());
        }
        if (v.getTableName().getSchema() == null) {
            return new Variable(new TableName(tname.getSchema(), v.getTableName().getName()), v.getName());
        }
        return v;
    }

    public Variable resolveTableName(TableName tablen) {
        if (this.table_name.equals(UNKNOWN_TABLE_NAME)) {
            return new Variable(tablen, this.getName());
        }
        return new Variable(this.table_name.resolveSchema(tablen.getSchema()), this.getName());
    }

    public Variable set(Variable from) {
        this.table_name = from.table_name;
        this.column_name = from.column_name;
        return this;
    }

    public void setColumnName(String column_name) {
        if (column_name == null) {
            throw new NullPointerException();
        }
        this.column_name = column_name;
    }

    public void setTableName(TableName tname) {
        if (this.table_name == null) {
            throw new NullPointerException();
        }
        this.table_name = tname;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        if (this.getTableName() != null) {
            return this.getTableName() + "." + this.getName();
        }
        return this.getName();
    }

    public String toTechString() {
        TableName tn = this.getTableName();
        if (tn != null) {
            return tn.getSchema() + "^" + tn.getName() + "^" + this.getName();
        }
        return this.getName();
    }

    public boolean equals(Object ob) {
        Variable cn = (Variable)ob;
        return cn.table_name.equals(this.table_name) && cn.column_name.equals(this.column_name);
    }

    public int compareTo(Object ob) {
        Variable cn = (Variable)ob;
        int v = this.table_name.compareTo(cn.table_name);
        if (v == 0) {
            return this.column_name.compareTo(cn.column_name);
        }
        return v;
    }

    public int hashCode() {
        return this.table_name.hashCode() + this.column_name.hashCode();
    }
}

