/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CellInputStream;
import com.mckoi.database.ConvertUtils;
import com.mckoi.database.DataCellSerialization;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.IndexSet;
import com.mckoi.database.IndexStore;
import com.mckoi.database.MasterTableDataSource;
import com.mckoi.database.MultiVersionTableIndices;
import com.mckoi.database.OpenTransactionList;
import com.mckoi.database.RIDList;
import com.mckoi.database.RowData;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.StoreSystem;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.VariableSizeDataStore;
import com.mckoi.util.ByteArrayUtil;
import com.mckoi.util.IntegerListInterface;
import com.mckoi.util.UserTerminal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public final class V1MasterTableDataSource
extends MasterTableDataSource {
    private String file_name;
    private VariableSizeDataStore data_store;
    private IndexStore index_store;
    private final DataCellSerialization data_cell_serializer = new DataCellSerialization();
    private CellInputStream cell_in = new CellInputStream(null);
    private short s_run_total_hits = 0;
    private short s_run_file_hits = 0;
    private int OPT_last_row = -1;
    private int OPT_last_col = -1;
    private int OPT_last_skip_offset = -1;

    public V1MasterTableDataSource(TransactionSystem system, StoreSystem store_system, OpenTransactionList open_transactions) {
        super(system, store_system, open_transactions, null);
    }

    String getFileName() {
        return this.file_name;
    }

    File getPath() {
        return this.getSystem().getDatabasePath();
    }

    synchronized void create(int table_id, DataTableDef table_def, int data_sector_size, int index_sector_size) throws IOException {
        this.setupDataTableDef(table_def);
        this.file_name = V1MasterTableDataSource.makeTableFileName(this.getSystem(), table_id, this.getTableName());
        this.data_store = new VariableSizeDataStore(new File(this.getPath(), this.file_name), data_sector_size, this.Debug());
        this.data_store.open(false);
        this.index_store = new IndexStore(new File(this.getPath(), this.file_name + ".iid"), this.Debug());
        this.index_store.create(index_sector_size);
        this.index_store.init();
        this.index_store.addIndexLists(table_def.columnCount() + 1, (byte)1);
        this.index_store.flush();
        this.saveDataTableDef(table_def);
        byte[] reserved_buffer = new byte[64];
        ByteArrayUtil.setInt(table_id, reserved_buffer, 0);
        this.data_store.writeReservedBuffer(reserved_buffer, 0, 64);
        this.table_id = table_id;
        this.loadInternal();
    }

    synchronized boolean exists(String file_name) throws IOException {
        VariableSizeDataStore data_store = new VariableSizeDataStore(new File(this.getPath(), file_name), this.Debug());
        return data_store.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void open(String file_name) throws IOException {
        this.data_store = new VariableSizeDataStore(new File(this.getPath(), file_name), this.Debug());
        boolean need_check = this.data_store.open(this.isReadOnly());
        byte[] reserved_buffer = new byte[64];
        this.data_store.readReservedBuffer(reserved_buffer, 0, 64);
        this.table_id = ByteArrayUtil.getInt(reserved_buffer, 0);
        this.file_name = file_name;
        this.table_def = this.loadDataTableDef();
        this.column_count = this.table_def.columnCount();
        this.table_indices = new MultiVersionTableIndices(this.getSystem(), this.table_def.getTableName(), this.table_def.columnCount());
        this.column_rid_list = new RIDList[this.table_def.columnCount()];
        this.index_store = new IndexStore(new File(this.getPath(), file_name + ".iid"), this.Debug());
        if (!this.index_store.exists()) {
            if (this.isReadOnly()) throw new IOException("Can not create .iid index file in read-only mode.");
            File original_ijf = new File(this.getPath(), file_name + ".ijf");
            if (!original_ijf.exists()) throw new IOException("The index file for '" + file_name + "' does not exist.");
            String str = "Converting index file for: " + file_name;
            System.out.println(str);
            this.Debug().write(10, this, str);
            ArrayList transaction_journals = ConvertUtils.convertIndexFiles1(original_ijf, this.index_store, this.table_def, this.Debug());
            if (transaction_journals.size() > 0) {
                this.Debug().write(40, this, "There are uncommitted changes that were not converted because the pre 0.92 database was not closed cleanly.");
            }
            need_check = true;
        } else {
            this.index_store.open(this.isReadOnly());
            this.index_store.init();
        }
        this.loadInternal();
        this.setupDataIndexSetDef();
        if (!need_check) return;
        this.doOpeningScan();
    }

    synchronized void dirtyOpen(String file_name) throws IOException {
        this.data_store = new VariableSizeDataStore(new File(this.getPath(), file_name), this.Debug());
        this.data_store.open(false);
        byte[] reserved_buffer = new byte[64];
        this.data_store.readReservedBuffer(reserved_buffer, 0, 64);
        this.table_id = ByteArrayUtil.getInt(reserved_buffer, 0);
        this.file_name = file_name;
        this.table_def = this.loadDataTableDef();
    }

    synchronized void close() throws IOException {
        if (this.table_indices != null) {
            this.mergeJournalChanges(Integer.MAX_VALUE);
            if (!this.isReadOnly()) {
                this.index_store.flush();
            }
        }
        this.index_store.close();
        this.data_store.close();
        this.table_id = -1;
        this.table_def = null;
        this.table_indices = null;
        this.column_rid_list = null;
        this.is_closed = true;
    }

    synchronized int rawRecordSize(int row_number) throws IOException {
        int size = 2;
        InputStream in = this.data_store.getRecordInputStream(++row_number);
        this.cell_in.setParentStream(in);
        this.cell_in.skip(2L);
        for (int i = 0; i < this.column_count; ++i) {
            int len = this.data_cell_serializer.skipSerialization(this.cell_in);
            if (len <= 0) {
                throw new Error("Corrupt data - cell size is <= 0");
            }
            this.cell_in.skip(len);
            size += 4 + len;
        }
        this.cell_in.close();
        return size;
    }

    synchronized int rawDataSectorSize() throws IOException {
        return this.data_store.sectorSize();
    }

    private synchronized void rebuildAllIndices(File path, String file_name) throws IOException {
        File temporary_name = new File(path, file_name + ".id2");
        File actual_name = new File(path, file_name + ".iid");
        IndexStore temp_store = new IndexStore(temporary_name, this.Debug());
        temp_store.create(this.index_store.getBlockSize());
        temp_store.init();
        temp_store.addIndexLists(this.column_count + 1, (byte)1);
        IndexSet index_set = temp_store.getSnapshotIndexSet();
        IntegerListInterface master_index = index_set.getIndex(0);
        TableDataSource table = this.minimalTableDataSource(master_index);
        SelectableScheme[] cols = new SelectableScheme[this.column_count];
        for (int i = 0; i < this.column_count; ++i) {
            cols[i] = this.createSelectableSchemeForColumn(index_set, table, i);
        }
        int row_count = this.rawRowCount();
        for (int i = 0; i < row_count; ++i) {
            int type;
            if (this.recordDeleted(i) || (type = this.recordTypeInfo(i)) != 2) continue;
            master_index.uniqueInsertSort(i);
            for (int n = 0; n < this.column_count; ++n) {
                cols[n].insert(i);
            }
        }
        temp_store.commitIndexSet(index_set);
        index_set.dispose();
        temp_store.flush();
        this.index_store.close();
        this.index_store.delete();
        temp_store.close();
        boolean b = temporary_name.renameTo(actual_name);
        if (!b) {
            throw new IOException("Unable to rename " + temporary_name + " to " + actual_name);
        }
        temp_store = null;
        this.index_store = new IndexStore(actual_name, this.Debug());
        this.index_store.open(false);
        this.index_store.init();
    }

    synchronized void copyTo(File path) throws IOException {
        this.data_store.copyTo(path);
        this.index_store.copyTo(path);
    }

    public synchronized void checkAndRepair(String file_name, UserTerminal terminal) throws IOException {
        this.data_store = new VariableSizeDataStore(new File(this.getPath(), file_name), this.Debug());
        boolean need_check = this.data_store.open(this.isReadOnly());
        this.data_store.fix(terminal);
        byte[] reserved_buffer = new byte[64];
        this.data_store.readReservedBuffer(reserved_buffer, 0, 64);
        this.table_id = ByteArrayUtil.getInt(reserved_buffer, 0);
        this.file_name = file_name;
        this.table_def = this.loadDataTableDef();
        this.table_indices = new MultiVersionTableIndices(this.getSystem(), this.table_def.getTableName(), this.table_def.columnCount());
        this.column_rid_list = new RIDList[this.table_def.columnCount()];
        this.index_store = new IndexStore(new File(this.getPath(), file_name + ".iid"), this.Debug());
        need_check = this.index_store.open(this.isReadOnly());
        boolean index_store_stable = this.index_store.fix(terminal);
        this.loadInternal();
        this.mergeJournalChanges(Integer.MAX_VALUE);
        terminal.println("+ Rebuilding all index information for table!");
        this.rebuildAllIndices(this.getPath(), file_name);
        this.doOpeningScan();
    }

    public synchronized void checkForCleanup() {
    }

    String getSourceIdent() {
        return this.getFileName();
    }

    synchronized void synchAll() throws IOException {
        this.index_store.flush();
        if (!this.getSystem().dontSynchFileSystem()) {
            this.data_store.hardSynch();
        }
        if (!this.getSystem().dontSynchFileSystem()) {
            this.index_store.hardSynch();
        }
    }

    synchronized int writeRecordType(int row_index, int row_state) throws IOException {
        return this.data_store.writeRecordType(row_index + 1, row_state);
    }

    synchronized int readRecordType(int row_index) throws IOException {
        return this.data_store.readRecordType(row_index + 1);
    }

    synchronized boolean recordDeleted(int row_index) throws IOException {
        return this.data_store.recordDeleted(row_index + 1);
    }

    synchronized int rawRowCount() throws IOException {
        return this.data_store.rawRecordCount() - 1;
    }

    synchronized void internalDeleteRow(int row_index) throws IOException {
        this.data_store.delete(row_index + 1);
    }

    IndexSet createIndexSet() {
        return this.index_store.getSnapshotIndexSet();
    }

    synchronized void commitIndexSet(IndexSet index_set) {
        this.index_store.commitIndexSet(index_set);
        index_set.dispose();
    }

    synchronized DataTableDef loadDataTableDef() throws IOException {
        byte[] d = new byte[65536];
        int read = this.data_store.read(0, d, 0, 65536);
        if (read == 65536) {
            throw new IOException("Buffer overflow when reading table definition, > 64k");
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(d, 0, read);
        DataInputStream din = new DataInputStream(bin);
        int mn = din.readInt();
        if (mn != 48827) {
            throw new IOException("Couldn't find magic number for table definition data.");
        }
        DataTableDef def = DataTableDef.read(din);
        return def;
    }

    synchronized void saveDataTableDef(DataTableDef def) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(48827);
        def.write(dout);
        byte[] d = bout.toByteArray();
        int rindex = this.data_store.write(d, 0, d.length);
        if (rindex != 0) {
            throw new IOException("Couldn't write table fields to record 0.");
        }
    }

    synchronized int internalAddRow(RowData data) throws IOException {
        OutputStream out = this.data_store.getRecordOutputStream();
        DataOutputStream temp_out = new DataOutputStream(out);
        temp_out.writeShort(0);
        int row_cells = data.getColumnCount();
        for (int i = 0; i < row_cells; ++i) {
            TObject cell = data.getCellData(i);
            this.data_cell_serializer.setToSerialize(cell);
            this.data_cell_serializer.writeSerialization(temp_out);
        }
        temp_out.close();
        int record_index = this.data_store.completeRecordStreamWrite();
        if (this.DATA_CELL_CACHING) {
            for (int i = 0; i < row_cells; ++i) {
                this.cache.put(this.table_id, record_index, i, data.getCellData(i));
            }
        }
        int row_number = record_index - 1;
        for (int i = 0; i < this.column_count; ++i) {
            RIDList rid_list = this.column_rid_list[i];
            if (rid_list == null) continue;
            rid_list.insertRID(data.getCellData(i), row_number);
        }
        return row_number;
    }

    synchronized TObject internalGetCellContents(int column, int row) {
        TObject cell;
        if (this.s_run_total_hits >= 1600) {
            this.getSystem().stats().add(this.s_run_total_hits, this.total_hits_key);
            this.getSystem().stats().add(this.s_run_file_hits, this.file_hits_key);
            this.s_run_total_hits = 0;
            this.s_run_file_hits = 0;
        }
        this.s_run_total_hits = (short)(this.s_run_total_hits + 1);
        if (this.DATA_CELL_CACHING && (cell = this.cache.get(this.table_id, ++row, column)) != null) {
            return cell;
        }
        this.s_run_file_hits = (short)(this.s_run_file_hits + 1);
        try {
            int start_col;
            InputStream in = this.data_store.getRecordInputStream(row);
            this.cell_in.setParentStream(in);
            if (this.OPT_last_row == row && column >= this.OPT_last_col) {
                this.cell_in.skip(this.OPT_last_skip_offset);
                start_col = this.OPT_last_col;
            } else {
                this.cell_in.skip(2L);
                this.OPT_last_row = row;
                this.OPT_last_skip_offset = 2;
                this.OPT_last_col = 0;
                start_col = 0;
            }
            for (int i = start_col; i < column; ++i) {
                int len = this.data_cell_serializer.skipSerialization(this.cell_in);
                if (len <= 0) {
                    throw new Error("Corrupt data - cell size is <= 0");
                }
                this.cell_in.skip(len);
                ++this.OPT_last_col;
                this.OPT_last_skip_offset += len + 4;
            }
            Object ob = this.data_cell_serializer.readSerialization(this.cell_in);
            TType ttype = this.getDataTableDef().columnAt(column).getTType();
            cell = new TObject(ttype, ob);
            this.cell_in.close();
            if (this.DATA_CELL_CACHING) {
                this.cache.put(this.table_id, row, column, cell);
            }
            return cell;
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new Error("IOError getting cell at (" + column + ", " + row + ").");
        }
    }

    synchronized long currentUniqueID() {
        return this.index_store.currentUniqueID();
    }

    synchronized long nextUniqueID() {
        return this.index_store.nextUniqueID();
    }

    synchronized void setUniqueID(long value) {
        this.index_store.setUniqueID(value);
    }

    synchronized void dispose(boolean pending_close) throws IOException {
        this.close();
    }

    synchronized boolean drop() throws IOException {
        if (!this.is_closed) {
            this.close();
        }
        this.Debug().write(10000, this, "Dropping: " + this.getFileName());
        this.data_store.delete();
        this.index_store.delete();
        return true;
    }

    void shutdownHookCleanup() {
    }

    public String toString() {
        return "[V1MasterTableDataSource: " + this.file_name + "]";
    }
}

