/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.StoreSystem;
import com.mckoi.store.HeapStore;
import com.mckoi.store.Store;
import java.io.IOException;
import java.util.HashMap;

class V1HeapStoreSystem
implements StoreSystem {
    private HashMap name_store_map = new HashMap();
    private HashMap store_name_map = new HashMap();

    V1HeapStoreSystem() {
    }

    public boolean storeExists(String name) {
        return this.name_store_map.get(name) != null;
    }

    public Store createStore(String name) {
        if (!this.storeExists(name)) {
            HeapStore store = new HeapStore();
            this.name_store_map.put(name, store);
            this.store_name_map.put(store, name);
            return store;
        }
        throw new RuntimeException("Store exists: " + name);
    }

    public Store openStore(String name) {
        HeapStore store = (HeapStore)this.name_store_map.get(name);
        if (store == null) {
            throw new RuntimeException("Store does not exist: " + name);
        }
        return store;
    }

    public boolean closeStore(Store store) {
        if (this.store_name_map.get(store) == null) {
            throw new RuntimeException("Store does not exist.");
        }
        return true;
    }

    public boolean deleteStore(Store store) {
        String name = (String)this.store_name_map.remove(store);
        this.name_store_map.remove(name);
        return true;
    }

    public void setCheckPoint() {
    }

    public void lock(String lock_name) throws IOException {
    }

    public void unlock(String lock_name) throws IOException {
    }
}

