/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.StoreSystem;
import com.mckoi.database.TransactionSystem;
import com.mckoi.store.JournalledFileStore;
import com.mckoi.store.LoggingBufferManager;
import com.mckoi.store.Store;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class V1FileStoreSystem
implements StoreSystem {
    private static final String FLOCK_EXT = ".lock";
    private TransactionSystem system;
    private File path;
    private boolean read_only;
    private FileOutputStream lock_file;

    public V1FileStoreSystem(TransactionSystem system, File path, boolean read_only) {
        this.system = system;
        this.path = path;
        this.read_only = read_only;
        if (!read_only && !path.exists()) {
            path.mkdirs();
        }
    }

    private JournalledFileStore createFileStore(String file_name) throws IOException {
        LoggingBufferManager buffer_manager = this.system.getBufferManager();
        return new JournalledFileStore(file_name, buffer_manager, this.read_only);
    }

    public boolean storeExists(String name) {
        try {
            JournalledFileStore store = this.createFileStore(name);
            return store.exists();
        }
        catch (IOException e) {
            this.system.Debug().writeException(e);
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
    }

    public Store createStore(String name) {
        LoggingBufferManager buffer_manager = this.system.getBufferManager();
        if (this.read_only) {
            throw new RuntimeException("Can not create store because system is read-only.");
        }
        try {
            buffer_manager.lockForWrite();
            JournalledFileStore store = this.createFileStore(name);
            if (!store.exists()) {
                store.open();
                JournalledFileStore journalledFileStore = store;
                return journalledFileStore;
            }
            try {
                throw new RuntimeException("Can not create - store with name " + name + " already exists.");
            }
            catch (IOException e) {
                this.system.Debug().writeException(e);
                throw new RuntimeException("IO Error: " + e.getMessage());
            }
            catch (InterruptedException e) {
                throw new Error("Interrupted: " + e.getMessage());
            }
        }
        finally {
            buffer_manager.unlockForWrite();
        }
    }

    public Store openStore(String name) {
        LoggingBufferManager buffer_manager = this.system.getBufferManager();
        try {
            buffer_manager.lockForWrite();
            JournalledFileStore store = this.createFileStore(name);
            if (store.exists()) {
                store.open();
                JournalledFileStore journalledFileStore = store;
                return journalledFileStore;
            }
            try {
                throw new RuntimeException("Can not open - store with name " + name + " does not exist.");
            }
            catch (IOException e) {
                this.system.Debug().writeException(e);
                throw new RuntimeException("IO Error: " + e.getMessage());
            }
            catch (InterruptedException e) {
                throw new Error("Interrupted: " + e.getMessage());
            }
        }
        finally {
            buffer_manager.unlockForWrite();
        }
    }

    public boolean closeStore(Store store) {
        LoggingBufferManager buffer_manager = this.system.getBufferManager();
        try {
            buffer_manager.lockForWrite();
            ((JournalledFileStore)store).close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.system.Debug().writeException(e);
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted: " + e.getMessage());
        }
        finally {
            buffer_manager.unlockForWrite();
        }
    }

    public boolean deleteStore(Store store) {
        LoggingBufferManager buffer_manager = this.system.getBufferManager();
        try {
            buffer_manager.lockForWrite();
            boolean bl = ((JournalledFileStore)store).delete();
            return bl;
        }
        catch (IOException e) {
            this.system.Debug().writeException(e);
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted: " + e.getMessage());
        }
        finally {
            buffer_manager.unlockForWrite();
        }
    }

    public void setCheckPoint() {
        try {
            LoggingBufferManager buffer_manager = this.system.getBufferManager();
            buffer_manager.setCheckPoint(false);
        }
        catch (IOException e) {
            this.system.Debug().writeException(e);
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
        catch (InterruptedException e) {
            this.system.Debug().writeException(e);
            throw new RuntimeException("Interrupted Error: " + e.getMessage());
        }
    }

    public void lock(String name) throws IOException {
        File flock_fn = new File(this.path, name + FLOCK_EXT);
        if (flock_fn.exists()) {
            this.system.Debug().write(20, this, "File lock file exists: " + flock_fn);
            boolean deleted = false;
            deleted = flock_fn.delete();
            if (!deleted) {
                System.err.println("\nI couldn't delete the file lock for Database '" + name + "'.\n" + "This most likely means the database is open and being used by\n" + "another process.\n" + "The lock file is: " + flock_fn + "\n\n");
                throw new IOException("Couldn't delete conglomerate file lock.");
            }
        }
        flock_fn.createNewFile();
        flock_fn.deleteOnExit();
        this.lock_file = new FileOutputStream(flock_fn);
    }

    public void unlock(String name) throws IOException {
        if (this.lock_file != null) {
            this.lock_file.close();
        }
        File flock_fn = new File(this.path, name + FLOCK_EXT);
        flock_fn.delete();
    }
}

