/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Database;
import com.mckoi.database.UserManager;

public final class User {
    private String user_name;
    private Database database;
    private String connection_string;
    private long time_connected;
    private long last_command_time;

    User(String user_name, Database database, String connection_string, long time_connected) {
        this.user_name = user_name;
        this.database = database;
        this.connection_string = connection_string;
        this.time_connected = time_connected;
        this.last_command_time = time_connected;
    }

    public String getUserName() {
        return this.user_name;
    }

    public String getConnectionString() {
        return this.connection_string;
    }

    public long getTimeConnected() {
        return this.time_connected;
    }

    public long getLastCommandTime() {
        return this.last_command_time;
    }

    public Database getDatabase() {
        return this.database;
    }

    public final void refreshLastCommandTime() {
        this.last_command_time = System.currentTimeMillis();
    }

    public void logout() {
        UserManager user_manager = this.database.getUserManager();
        if (user_manager != null) {
            user_manager.userLoggedOut(this);
        }
    }
}

