/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataCellCache;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseDispatcher;
import com.mckoi.database.Expression;
import com.mckoi.database.Function;
import com.mckoi.database.FunctionDef;
import com.mckoi.database.FunctionFactory;
import com.mckoi.database.FunctionInfo;
import com.mckoi.database.FunctionLookup;
import com.mckoi.database.InternalFunctionFactory;
import com.mckoi.database.RegexLibrary;
import com.mckoi.database.StoreSystem;
import com.mckoi.database.Transaction;
import com.mckoi.database.V1FileStoreSystem;
import com.mckoi.database.V1HeapStoreSystem;
import com.mckoi.database.control.DBConfig;
import com.mckoi.debug.DebugLogger;
import com.mckoi.debug.DefaultDebugLogger;
import com.mckoi.store.LoggingBufferManager;
import com.mckoi.util.LogWriter;
import com.mckoi.util.Stats;
import com.mckoi.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class TransactionSystem {
    private final Stats stats = new Stats();
    private final DefaultDebugLogger logger = new DefaultDebugLogger();
    private DBConfig config = null;
    private File db_path;
    private boolean lookup_comparison_list_enabled = false;
    private boolean read_only_access = false;
    private boolean table_lock_check = false;
    private boolean soft_index_storage = false;
    private boolean always_reindex_dirty_tables = false;
    private boolean dont_synch_filesystem = false;
    private boolean ignore_case_for_identifiers = false;
    private boolean transaction_error_on_dirty_select = true;
    private DataCellCache data_cell_cache = null;
    private ArrayList function_factory_list;
    private DSFunctionLookup function_lookup;
    private RegexLibrary regex_library;
    private File log_directory;
    private LoggingBufferManager buffer_manager;
    private StoreSystem store_system;
    private ArrayList table_listeners;
    private DatabaseDispatcher dispatcher;

    public TransactionSystem() {
        Properties p = System.getProperties();
        this.stats.set(0, "Runtime.java.version: " + p.getProperty("java.version"));
        this.stats.set(0, "Runtime.java.vendor: " + p.getProperty("java.vendor"));
        this.stats.set(0, "Runtime.java.vm.name: " + p.getProperty("java.vm.name"));
        this.stats.set(0, "Runtime.os.name: " + p.getProperty("os.name"));
        this.stats.set(0, "Runtime.os.arch: " + p.getProperty("os.arch"));
        this.stats.set(0, "Runtime.os.version: " + p.getProperty("os.version"));
        this.table_listeners = new ArrayList();
    }

    private static File parseFileString(File root_path, String root_info, String path_string) {
        File res;
        File path = new File(path_string);
        if (path.isAbsolute()) {
            res = path;
        } else {
            if (root_info != null && root_info.equals("jvm")) {
                return path;
            }
            res = new File(root_path, path_string);
        }
        return res;
    }

    private void setupLog(DBConfig config) {
        int debug_level;
        String log_path_string = config.getValue("log_path");
        String root_path_var = config.getValue("root_path");
        String read_only_access = config.getValue("read_only");
        String debug_logs = config.getValue("debug_logs");
        boolean read_only_bool = false;
        if (read_only_access != null) {
            read_only_bool = read_only_access.equalsIgnoreCase("enabled");
        }
        boolean debug_logs_bool = true;
        if (debug_logs != null) {
            debug_logs_bool = debug_logs.equalsIgnoreCase("enabled");
        }
        if (debug_logs_bool && !read_only_bool && log_path_string != null && !log_path_string.equals("")) {
            LogWriter f_writer;
            File log_path = TransactionSystem.parseFileString(config.currentPath(), root_path_var, log_path_string);
            if (!log_path.exists()) {
                log_path.mkdirs();
            }
            this.setLogDirectory(log_path);
            String dlog_file_name = "";
            try {
                dlog_file_name = config.getValue("debug_log_file");
                File debug_log_file = new File(log_path.getCanonicalPath(), dlog_file_name);
                f_writer = new LogWriter(debug_log_file, 524288L, 12);
                f_writer.write("**** Debug log started: " + new Date(System.currentTimeMillis()) + " ****\n");
                f_writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to open debug file '" + dlog_file_name + "' in path '" + log_path + "'");
            }
            this.setDebugOutput(f_writer);
        }
        if (!debug_logs_bool) {
            this.setDebugOutput(new PrintWriter(new Writer(){

                public void write(int c) throws IOException {
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                }

                public void write(String str, int off, int len) throws IOException {
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            }));
        }
        if ((debug_level = Integer.parseInt(config.getValue("debug_level"))) == -1) {
            this.setDebugLevel(255);
        } else {
            this.setDebugLevel(debug_level);
        }
    }

    public final String getConfigString(String property, String default_val) {
        String v = this.config.getValue(property);
        if (v == null) {
            return default_val;
        }
        return v.trim();
    }

    public final int getConfigInt(String property, int default_val) {
        String v = this.config.getValue(property);
        if (v == null) {
            return default_val;
        }
        return Integer.parseInt(v);
    }

    public final boolean getConfigBoolean(String property, boolean default_val) {
        String v = this.config.getValue(property);
        if (v == null) {
            return default_val;
        }
        return v.trim().equalsIgnoreCase("enabled");
    }

    private static String regexStringToClass(String lib) {
        if (lib.equals("java.util.regexp")) {
            return "com.mckoi.database.regexbridge.JavaRegex";
        }
        if (lib.equals("org.apache.regexp")) {
            return "com.mckoi.database.regexbridge.ApacheRegex";
        }
        if (lib.equals("gnu.regexp")) {
            return "com.mckoi.database.regexbridge.GNURegex";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void init(DBConfig config) {
        this.function_factory_list = new ArrayList();
        this.function_lookup = new DSFunctionLookup();
        if (config != null) {
            String regex_bridge;
            String lib_used;
            boolean regex_api_exists;
            void var3_7;
            boolean is_file_store_mode;
            this.config = config;
            this.read_only_access = this.getConfigBoolean("read_only", false);
            this.setupLog(config);
            String storage_system = this.getConfigString("storage_system", "v1file");
            if (storage_system.equalsIgnoreCase("v1file")) {
                this.Debug().write(10000, this, "Storage System: v1 file storage mode.");
                String database_path = this.getConfigString("database_path", "./data");
                String root_path_var = this.getConfigString("root_path", "jvm");
                this.db_path = TransactionSystem.parseFileString(config.currentPath(), root_path_var, database_path);
                this.store_system = new V1FileStoreSystem(this, this.db_path, this.read_only_access);
                is_file_store_mode = true;
            } else if (storage_system.equalsIgnoreCase("v1javaheap")) {
                this.Debug().write(10000, this, "Storage System: v1 Java heap storage mode.");
                this.store_system = new V1HeapStoreSystem();
                is_file_store_mode = false;
            } else {
                String error_msg = "Unknown storage_system property: " + storage_system;
                this.Debug().write(40, this, error_msg);
                throw new RuntimeException(error_msg);
            }
            this.addFunctionFactory(new InternalFunctionFactory());
            int max_cache_size = 0;
            int max_cache_entry_size = 0;
            max_cache_size = this.getConfigInt("data_cache_size", 0);
            max_cache_entry_size = this.getConfigInt("max_cache_entry_size", 0);
            if (max_cache_size >= 4096 && max_cache_entry_size >= 16 && max_cache_entry_size < max_cache_size / 2) {
                this.Debug().write(10000, this, "Internal Data Cache size:          " + max_cache_size);
                this.Debug().write(10000, this, "Internal Data Cache max cell size: " + max_cache_entry_size);
                int hash_size = DataCellCache.closestPrime(max_cache_size / 55);
                this.data_cell_cache = new DataCellCache(this, max_cache_size, max_cache_entry_size, hash_size);
            } else {
                this.Debug().write(10000, this, "Internal Data Cache disabled.");
            }
            this.lookup_comparison_list_enabled = false;
            this.Debug().write(10000, this, "lookup_comparison_list = " + this.lookup_comparison_list_enabled);
            this.Debug().write(10000, this, "read_only = " + this.read_only_access);
            if (this.read_only_access) {
                this.stats.set(1, "DatabaseSystem.read_only");
            }
            this.transaction_error_on_dirty_select = this.getConfigBoolean("transaction_error_on_dirty_select", true);
            this.Debug().write(10000, this, "transaction_error_on_dirty_select = " + this.transaction_error_on_dirty_select);
            this.ignore_case_for_identifiers = this.getConfigBoolean("ignore_case_for_identifiers", false);
            this.Debug().write(10000, this, "ignore_case_for_identifiers = " + this.ignore_case_for_identifiers);
            if (var3_7 != false) {
                boolean nio_interface_available;
                try {
                    Class.forName("java.nio.channels.FileChannel");
                    nio_interface_available = true;
                    this.Debug().write(10000, this, "Java NIO API is available.");
                }
                catch (ClassNotFoundException e) {
                    nio_interface_available = false;
                    this.Debug().write(10000, this, "Java NIO API is not available.");
                }
                String os_name = System.getProperties().getProperty("os.name");
                boolean nio_bugged_os = os_name.equalsIgnoreCase("Windows 95") || os_name.equalsIgnoreCase("Windows 98");
                int io_safety_level = this.getConfigInt("io_safety_level", 10);
                if (io_safety_level < 1 || io_safety_level > 10) {
                    this.Debug().write(10000, this, "Invalid io_safety_level value.  Setting to the most safe level.");
                    io_safety_level = 10;
                }
                this.Debug().write(10000, this, "io_safety_level = " + io_safety_level);
                boolean enable_logging = true;
                if (io_safety_level <= 2) {
                    this.Debug().write(10000, this, "Disabling journaling and file sync.");
                    enable_logging = false;
                }
                boolean use_nio_if_available = this.getConfigBoolean("use_nio_if_available", false);
                boolean force_use_nio = this.getConfigBoolean("force_use_nio", false);
                boolean disable_nio = true;
                this.Debug().write(10000, this, "Using stardard IO API for heap buffered file access.");
                int page_size = this.getConfigInt("buffered_io_page_size", 8192);
                int max_pages = this.getConfigInt("buffered_io_max_pages", 256);
                String api_to_use = "Java IO";
                this.Debug().write(10000, this, "[Buffer Manager] Using IO API: " + api_to_use);
                this.Debug().write(10000, this, "[Buffer Manager] Page Size: " + page_size);
                this.Debug().write(10000, this, "[Buffer Manager] Max pages: " + max_pages);
                File journal_path = this.db_path;
                long max_slice_size = 0x40000000L;
                String first_file_ext = "koi";
                this.buffer_manager = new LoggingBufferManager(this.db_path, journal_path, this.read_only_access, max_pages, page_size, "koi", 0x40000000L, this.Debug(), enable_logging);
                try {
                    this.buffer_manager.start();
                }
                catch (IOException e) {
                    this.Debug().write(40, this, "Error starting buffer manager");
                    this.Debug().writeException(40, e);
                    throw new Error("IO Error: " + e.getMessage());
                }
            }
            try {
                Class.forName("java.util.regex.Pattern");
                regex_api_exists = true;
            }
            catch (ClassNotFoundException e) {
                regex_api_exists = false;
                this.Debug().write(10000, this, "Java regex API not available.");
            }
            String force_lib = this.getConfigString("force_regex_library", null);
            if (force_lib != null) {
                lib_used = force_lib;
                regex_bridge = TransactionSystem.regexStringToClass(force_lib);
            } else {
                String lib;
                lib_used = lib = this.getConfigString("regex_library", null);
                regex_bridge = regex_api_exists ? "com.mckoi.database.regexbridge.JavaRegex" : (lib != null ? TransactionSystem.regexStringToClass(lib) : null);
            }
            if (regex_bridge != null) {
                try {
                    Class<?> c = Class.forName(regex_bridge);
                    this.regex_library = (RegexLibrary)c.newInstance();
                    this.Debug().write(10000, this, "Using regex bridge: " + lib_used);
                }
                catch (Throwable e) {
                    this.Debug().write(40, this, "Unable to load regex bridge: " + regex_bridge);
                    this.Debug().writeException(20, e);
                }
            } else {
                if (lib_used != null) {
                    this.Debug().write(40, this, "Regex library not known: " + lib_used);
                }
                this.Debug().write(10000, this, "Regex features disabled.");
            }
            try {
                String function_factories = this.getConfigString("function_factories", null);
                if (function_factories != null) {
                    List factories = StringUtil.explode(function_factories, ";");
                    for (int i = 0; i < factories.size(); ++i) {
                        String factory_class = factories.get(i).toString();
                        Class<?> c = Class.forName(factory_class);
                        FunctionFactory fun_factory = (FunctionFactory)c.newInstance();
                        this.addFunctionFactory(fun_factory);
                        this.Debug().write(10000, this, "Successfully added function factory: " + factory_class);
                    }
                } else {
                    this.Debug().write(10000, this, "No 'function_factories' config property found.");
                }
            }
            catch (Throwable e) {
                this.Debug().write(40, this, "Error parsing 'function_factories' configuration property.");
                this.Debug().writeException(e);
            }
            this.flushCachedFunctionLookup();
        }
    }

    public void setupRowCache(int max_cache_size, int max_cache_entry_size) {
        this.data_cell_cache = new DataCellCache(this, max_cache_size, max_cache_entry_size);
    }

    public boolean readOnlyAccess() {
        return this.read_only_access;
    }

    public File getDatabasePath() {
        return this.db_path;
    }

    public boolean tableLockingEnabled() {
        return this.table_lock_check;
    }

    public boolean lookupComparisonListEnabled() {
        return this.lookup_comparison_list_enabled;
    }

    public boolean softIndexStorage() {
        return this.soft_index_storage;
    }

    public boolean alwaysReindexDirtyTables() {
        return this.always_reindex_dirty_tables;
    }

    public boolean dontSynchFileSystem() {
        return this.dont_synch_filesystem;
    }

    public boolean transactionErrorOnDirtySelect() {
        return this.transaction_error_on_dirty_select;
    }

    public boolean ignoreIdentifierCase() {
        return this.ignore_case_for_identifiers;
    }

    public LoggingBufferManager getBufferManager() {
        return this.buffer_manager;
    }

    public RegexLibrary getRegexLibrary() {
        if (this.regex_library != null) {
            return this.regex_library;
        }
        throw new Error("No regular expression library found in classpath and/or in configuration file.");
    }

    public final StoreSystem storeSystem() {
        return this.store_system;
    }

    public final void setDebugOutput(Writer writer) {
        this.logger.setOutput(writer);
    }

    public final void setDebugLevel(int level) {
        this.logger.setDebugLevel(level);
    }

    public final DebugLogger Debug() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunctionFactory(FunctionFactory factory) {
        ArrayList arrayList = this.function_factory_list;
        synchronized (arrayList) {
            this.function_factory_list.add(factory);
        }
        factory.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCachedFunctionLookup() {
        FunctionFactory[] factories;
        ArrayList arrayList = this.function_factory_list;
        synchronized (arrayList) {
            factories = this.function_factory_list.toArray(new FunctionFactory[this.function_factory_list.size()]);
        }
        this.function_lookup.flushContents(factories);
    }

    public FunctionLookup getFunctionLookup() {
        return this.function_lookup;
    }

    public Transaction.CheckExpression prepareTransactionCheckConstraint(DataTableDef table_def, Transaction.CheckExpression check) {
        Expression exp = check.expression;
        table_def.resolveColumns(this.ignoreIdentifierCase(), exp);
        return check;
    }

    public final Stats stats() {
        return this.stats;
    }

    public final void setLogDirectory(File log_path) {
        this.log_directory = log_path;
    }

    public final File getLogDirectory() {
        return this.log_directory;
    }

    DataCellCache getDataCellCache() {
        return this.data_cell_cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseDispatcher getDispatcher() {
        TransactionSystem transactionSystem = this;
        synchronized (transactionSystem) {
            if (this.dispatcher == null) {
                this.dispatcher = new DatabaseDispatcher(this);
            }
            return this.dispatcher;
        }
    }

    Object createEvent(Runnable runnable) {
        return this.getDispatcher().createEvent(runnable);
    }

    void postEvent(int time_to_wait, Object event) {
        this.getDispatcher().postEvent(time_to_wait, event);
    }

    public void dispose() {
        if (this.buffer_manager != null) {
            try {
                this.store_system.setCheckPoint();
                this.buffer_manager.stop();
            }
            catch (IOException e) {
                System.out.println("Error stopping buffer manager.");
                e.printStackTrace();
            }
        }
        this.buffer_manager = null;
        this.regex_library = null;
        this.data_cell_cache = null;
        this.config = null;
        this.log_directory = null;
        this.function_factory_list = null;
        this.store_system = null;
        if (this.dispatcher != null) {
            this.dispatcher.finish();
        }
        this.dispatcher = null;
    }

    private static class DSFunctionLookup
    implements FunctionLookup {
        private FunctionFactory[] factories;

        private DSFunctionLookup() {
        }

        public synchronized Function generateFunction(FunctionDef function_def) {
            for (int i = 0; i < this.factories.length; ++i) {
                Function f = this.factories[i].generateFunction(function_def);
                if (f == null) continue;
                return f;
            }
            return null;
        }

        public synchronized boolean isAggregate(FunctionDef function_def) {
            for (int i = 0; i < this.factories.length; ++i) {
                FunctionInfo f_info = this.factories[i].getFunctionInfo(function_def.getName());
                if (f_info == null) continue;
                return f_info.getType() == 2;
            }
            return false;
        }

        public synchronized void flushContents(FunctionFactory[] factories) {
            this.factories = factories;
        }
    }
}

