/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DataTableListener;
import com.mckoi.database.Database;
import com.mckoi.database.DefaultDataTable;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SimpleRowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import java.util.ArrayList;

public final class TemporaryTable
extends DefaultDataTable {
    private DataTableDef table_def;
    private ArrayList table_storage;

    public TemporaryTable(Database database, String name, DataTableColumnDef[] fields) {
        super(database);
        this.table_storage = new ArrayList();
        this.table_def = new DataTableDef();
        this.table_def.setTableName(new TableName(null, name));
        for (int i = 0; i < fields.length; ++i) {
            this.table_def.addVirtualColumn(new DataTableColumnDef(fields[i]));
        }
        this.table_def.setImmutable();
    }

    public TemporaryTable(String name, Table based_on) {
        super(based_on.getDatabase());
        this.table_def = new DataTableDef(based_on.getDataTableDef());
        this.table_def.setTableName(new TableName(null, name));
        this.table_def.setImmutable();
    }

    public TemporaryTable(DefaultDataTable based_on) {
        super(based_on.getDatabase());
        this.table_def = new DataTableDef(based_on.getDataTableDef());
        this.table_def.setImmutable();
    }

    private Variable resolveToVariable(String col_name) {
        Variable partial = Variable.resolve(col_name);
        return partial;
    }

    public void newRow() {
        this.table_storage.add(new TObject[this.getColumnCount()]);
        ++this.row_count;
    }

    public void setRowCell(TObject cell, int column, int row) {
        TObject[] cells = (TObject[])this.table_storage.get(row);
        cells[column] = cell;
    }

    public void setRowCell(TObject cell, String col_name) {
        Variable v = this.resolveToVariable(col_name);
        this.setRowCell(cell, this.findFieldName(v), this.row_count - 1);
    }

    public void setRowObject(TObject ob, int col_index, int row) {
        this.setRowCell(ob, col_index, row);
    }

    public void setRowObject(TObject ob, String col_name) {
        Variable v = this.resolveToVariable(col_name);
        this.setRowObject(ob, this.findFieldName(v));
    }

    public void setRowObject(TObject ob, int col_index) {
        this.setRowObject(ob, col_index, this.row_count - 1);
    }

    public void setCellFrom(Table table, int src_col, int src_row, String to_col) {
        Variable v = this.resolveToVariable(to_col);
        TObject cell = table.getCellContents(src_col, src_row);
        this.setRowCell(cell, this.findFieldName(v), this.row_count - 1);
    }

    public void copyFrom(Table table, int row) {
        int i;
        this.newRow();
        Variable[] vars = new Variable[table.getColumnCount()];
        for (i = 0; i < vars.length; ++i) {
            vars[i] = table.getResolvedVariable(i);
        }
        for (i = 0; i < this.getColumnCount(); ++i) {
            Variable v = this.getResolvedVariable(i);
            String col_name = v.getName();
            try {
                int tcol_index = -1;
                for (int n = 0; n < vars.length || tcol_index == -1; ++n) {
                    if (!vars[n].getName().equals(col_name)) continue;
                    tcol_index = n;
                }
                this.setRowCell(table.getCellContents(tcol_index, row), i, this.row_count - 1);
                continue;
            }
            catch (Exception e) {
                this.Debug().writeException(e);
                throw new Error(e.getMessage());
            }
        }
    }

    public void setupAllSelectableSchemes() {
        this.blankSelectableSchemes(1);
        for (int row_number = 0; row_number < this.row_count; ++row_number) {
            this.addRowToColumnSchemes(row_number);
        }
    }

    public DataTableDef getDataTableDef() {
        return this.table_def;
    }

    public TObject getCellContents(int column, int row) {
        TObject[] cells = (TObject[])this.table_storage.get(row);
        TObject cell = cells[column];
        if (cell == null) {
            throw new Error("NULL cell!  (" + column + ", " + row + ")");
        }
        return cell;
    }

    public RowEnumeration rowEnumeration() {
        return new SimpleRowEnumeration(this.row_count);
    }

    void addDataTableListener(DataTableListener listener) {
    }

    void removeDataTableListener(DataTableListener listener) {
    }

    public void lockRoot(int lock_key) {
    }

    public void unlockRoot(int lock_key) {
    }

    public boolean hasRootsLocked() {
        return true;
    }

    static final TemporaryTable singleColumnTable(Database database, String col_name, Class c) {
        TType ttype = TType.fromClass(c);
        DataTableColumnDef col_def = new DataTableColumnDef();
        col_def.setName(col_name);
        col_def.setFromTType(ttype);
        TemporaryTable table = new TemporaryTable(database, "single", new DataTableColumnDef[]{col_def});
        return table;
    }
}

