/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlobStore;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConstraintViolationException;
import com.mckoi.database.Expression;
import com.mckoi.database.IndexSet;
import com.mckoi.database.MasterTableDataSource;
import com.mckoi.database.MasterTableJournal;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.OpenTransactionList;
import com.mckoi.database.RawDiagnosticTable;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.SequenceManager;
import com.mckoi.database.SimpleTransaction;
import com.mckoi.database.StateStore;
import com.mckoi.database.StoreSystem;
import com.mckoi.database.SystemQueryContext;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TableCommitModificationEvent;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.TransactionException;
import com.mckoi.database.TransactionJournal;
import com.mckoi.database.TransactionModificationListener;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.V1MasterTableDataSource;
import com.mckoi.database.V2MasterTableDataSource;
import com.mckoi.database.Variable;
import com.mckoi.database.VariableResolver;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.global.Ref;
import com.mckoi.debug.DebugLogger;
import com.mckoi.store.Area;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.BigNumber;
import com.mckoi.util.IntegerVector;
import com.mckoi.util.UserTerminal;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableDataConglomerate {
    public static final String STATE_POST = "_sf";
    public static final String SYSTEM_SCHEMA = "SYS_INFO";
    public static final TableName SCHEMA_INFO_TABLE = new TableName("SYS_INFO", "sUSRSchemaInfo");
    public static final TableName PERSISTENT_VAR_TABLE = new TableName("SYS_INFO", "sUSRDatabaseVars");
    public static final TableName FOREIGN_COLS_TABLE = new TableName("SYS_INFO", "sUSRForeignColumns");
    public static final TableName UNIQUE_COLS_TABLE = new TableName("SYS_INFO", "sUSRUniqueColumns");
    public static final TableName PRIMARY_COLS_TABLE = new TableName("SYS_INFO", "sUSRPrimaryColumns");
    public static final TableName CHECK_INFO_TABLE = new TableName("SYS_INFO", "sUSRCheckInfo");
    public static final TableName UNIQUE_INFO_TABLE = new TableName("SYS_INFO", "sUSRUniqueInfo");
    public static final TableName FOREIGN_INFO_TABLE = new TableName("SYS_INFO", "sUSRFKeyInfo");
    public static final TableName PRIMARY_INFO_TABLE = new TableName("SYS_INFO", "sUSRPKeyInfo");
    public static final TableName SYS_SEQUENCE_INFO = new TableName("SYS_INFO", "sUSRSequenceInfo");
    public static final TableName SYS_SEQUENCE = new TableName("SYS_INFO", "sUSRSequence");
    private final TransactionSystem system;
    private final StoreSystem store_system;
    private String name;
    private Store act_state_store;
    private StateStore state_store;
    private long commit_id;
    private ArrayList table_list;
    private Store act_blob_store;
    private BlobStore blob_store;
    private SequenceManager sequence_manager;
    private OpenTransactionList open_transactions;
    private ArrayList namespace_journal_list;
    private final HashMap modification_listeners;
    final Object commit_lock = new Object();
    static /* synthetic */ Class class$com$mckoi$database$TableDataConglomerate;

    public TableDataConglomerate(TransactionSystem system, StoreSystem store_system) {
        this.system = system;
        this.store_system = store_system;
        this.open_transactions = new OpenTransactionList(system);
        this.modification_listeners = new HashMap();
        this.namespace_journal_list = new ArrayList();
        this.sequence_manager = new SequenceManager(this);
    }

    public final TransactionSystem getSystem() {
        return this.system;
    }

    public final StoreSystem storeSystem() {
        return this.store_system;
    }

    final SequenceManager getSequenceManager() {
        return this.sequence_manager;
    }

    final BlobStore getBlobStore() {
        return this.blob_store;
    }

    public final DebugLogger Debug() {
        return this.getSystem().Debug();
    }

    String getName() {
        return this.name;
    }

    private void markAsCommittedDropped(int table_id) {
        MasterTableDataSource master_table = this.getMasterTable(table_id);
        this.state_store.addDeleteResource(new StateStore.StateResource(table_id, TableDataConglomerate.createEncodedTableFile(master_table)));
    }

    private MasterTableDataSource loadMasterTable(int table_id, String table_str, int table_type) throws IOException {
        V2MasterTableDataSource master;
        if (table_type == 1) {
            V1MasterTableDataSource master2 = new V1MasterTableDataSource(this.getSystem(), this.storeSystem(), this.open_transactions);
            if (master2.exists(table_str)) {
                return master2;
            }
        } else if (table_type == 2 && (master = new V2MasterTableDataSource(this.getSystem(), this.storeSystem(), this.open_transactions, this.blob_store)).exists(table_str)) {
            return master;
        }
        this.Debug().write(40, this, "Couldn't find table source - resource name: " + table_str + " table_id: " + table_id);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String createEncodedTableFile(MasterTableDataSource table) {
        void var1_1;
        int type;
        if (table instanceof V1MasterTableDataSource) {
            type = 49;
        } else if (table instanceof V2MasterTableDataSource) {
            type = 50;
        } else {
            throw new RuntimeException("Unrecognised MasterTableDataSource class.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(':');
        buf.append((char)var1_1);
        buf.append(table.getSourceIdent());
        return new String(buf);
    }

    private void readVisibleTables() throws IOException {
        StateStore.StateResource[] tables = this.state_store.getVisibleList();
        for (int i = 0; i < tables.length; ++i) {
            MasterTableDataSource master;
            StateStore.StateResource resource = tables[i];
            int master_table_id = (int)resource.table_id;
            String file_name = resource.name;
            int table_type = 1;
            if (file_name.startsWith(":")) {
                if (file_name.charAt(1) == '1') {
                    table_type = 1;
                } else if (file_name.charAt(1) == '2') {
                    table_type = 2;
                } else {
                    throw new RuntimeException("Table type is not known.");
                }
                file_name = file_name.substring(2);
            }
            if ((master = this.loadMasterTable(master_table_id, file_name, table_type)) == null) {
                throw new Error("Table file for " + file_name + " was not found.");
            }
            if (master instanceof V1MasterTableDataSource) {
                V1MasterTableDataSource v1_master = (V1MasterTableDataSource)master;
                v1_master.open(file_name);
            } else if (master instanceof V2MasterTableDataSource) {
                V2MasterTableDataSource v2_master = (V2MasterTableDataSource)master;
                v2_master.open(file_name);
            } else {
                throw new Error("Unknown master table type: " + master.getClass());
            }
            this.table_list.add(master);
        }
    }

    public void checkVisibleTables(UserTerminal terminal) throws IOException {
        StateStore.StateResource[] tables = this.state_store.getVisibleList();
        for (int i = 0; i < tables.length; ++i) {
            MasterTableDataSource master;
            StateStore.StateResource resource = tables[i];
            int master_table_id = (int)resource.table_id;
            String file_name = resource.name;
            int table_type = 1;
            if (file_name.startsWith(":")) {
                if (file_name.charAt(1) == '1') {
                    table_type = 1;
                } else if (file_name.charAt(1) == '2') {
                    table_type = 2;
                } else {
                    throw new RuntimeException("Table type is not known.");
                }
                file_name = file_name.substring(2);
            }
            if ((master = this.loadMasterTable(master_table_id, file_name, table_type)) instanceof V1MasterTableDataSource) {
                V1MasterTableDataSource v1_master = (V1MasterTableDataSource)master;
                v1_master.checkAndRepair(file_name, terminal);
            } else if (master instanceof V2MasterTableDataSource) {
                V2MasterTableDataSource v2_master = (V2MasterTableDataSource)master;
                v2_master.checkAndRepair(file_name, terminal);
            } else {
                throw new Error("Unknown master table type: " + master.getClass());
            }
            this.table_list.add(master);
            this.store_system.setCheckPoint();
        }
    }

    private void readDroppedTables() throws IOException {
        StateStore.StateResource[] tables = this.state_store.getDeleteList();
        for (int i = 0; i < tables.length; ++i) {
            MasterTableDataSource master;
            StateStore.StateResource resource = tables[i];
            int master_table_id = (int)resource.table_id;
            String file_name = resource.name;
            int table_type = 1;
            if (file_name.startsWith(":")) {
                if (file_name.charAt(1) == '1') {
                    table_type = 1;
                } else if (file_name.charAt(1) == '2') {
                    table_type = 2;
                } else {
                    throw new RuntimeException("Table type is not known.");
                }
                file_name = file_name.substring(2);
            }
            if ((master = this.loadMasterTable(master_table_id, file_name, table_type)) == null) {
                this.state_store.removeDeleteResource(resource.name);
                continue;
            }
            if (master instanceof V1MasterTableDataSource) {
                V1MasterTableDataSource v1_master = (V1MasterTableDataSource)master;
                v1_master.open(file_name);
            } else if (master instanceof V2MasterTableDataSource) {
                V2MasterTableDataSource v2_master = (V2MasterTableDataSource)master;
                v2_master.open(file_name);
            } else {
                throw new Error("Unknown master table type: " + master.getClass());
            }
            this.table_list.add(master);
        }
        this.state_store.commit();
    }

    void updateSystemTableSchema() {
        Transaction transaction = this.createTransaction();
        DataTableDef table = new DataTableDef();
        table.setTableName(SYS_SEQUENCE_INFO);
        table.addColumn(DataTableColumnDef.createNumericColumn("id"));
        table.addColumn(DataTableColumnDef.createStringColumn("schema"));
        table.addColumn(DataTableColumnDef.createStringColumn("name"));
        table.addColumn(DataTableColumnDef.createNumericColumn("type"));
        transaction.alterCreateTable(table, 187, 128);
        table = new DataTableDef();
        table.setTableName(SYS_SEQUENCE);
        table.addColumn(DataTableColumnDef.createNumericColumn("seq_id"));
        table.addColumn(DataTableColumnDef.createNumericColumn("last_value"));
        table.addColumn(DataTableColumnDef.createNumericColumn("increment"));
        table.addColumn(DataTableColumnDef.createNumericColumn("minvalue"));
        table.addColumn(DataTableColumnDef.createNumericColumn("maxvalue"));
        table.addColumn(DataTableColumnDef.createNumericColumn("start"));
        table.addColumn(DataTableColumnDef.createNumericColumn("cache"));
        table.addColumn(DataTableColumnDef.createBooleanColumn("cycle"));
        transaction.alterCreateTable(table, 187, 128);
        table = new DataTableDef();
        table.setTableName(PRIMARY_INFO_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("id"));
        table.addColumn(DataTableColumnDef.createStringColumn("name"));
        table.addColumn(DataTableColumnDef.createStringColumn("schema"));
        table.addColumn(DataTableColumnDef.createStringColumn("table"));
        table.addColumn(DataTableColumnDef.createNumericColumn("deferred"));
        transaction.alterCreateTable(table, 187, 128);
        table = new DataTableDef();
        table.setTableName(FOREIGN_INFO_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("id"));
        table.addColumn(DataTableColumnDef.createStringColumn("name"));
        table.addColumn(DataTableColumnDef.createStringColumn("schema"));
        table.addColumn(DataTableColumnDef.createStringColumn("table"));
        table.addColumn(DataTableColumnDef.createStringColumn("ref_schema"));
        table.addColumn(DataTableColumnDef.createStringColumn("ref_table"));
        table.addColumn(DataTableColumnDef.createStringColumn("update_rule"));
        table.addColumn(DataTableColumnDef.createStringColumn("delete_rule"));
        table.addColumn(DataTableColumnDef.createNumericColumn("deferred"));
        transaction.alterCreateTable(table, 187, 128);
        table = new DataTableDef();
        table.setTableName(UNIQUE_INFO_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("id"));
        table.addColumn(DataTableColumnDef.createStringColumn("name"));
        table.addColumn(DataTableColumnDef.createStringColumn("schema"));
        table.addColumn(DataTableColumnDef.createStringColumn("table"));
        table.addColumn(DataTableColumnDef.createNumericColumn("deferred"));
        transaction.alterCreateTable(table, 187, 128);
        table = new DataTableDef();
        table.setTableName(CHECK_INFO_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("id"));
        table.addColumn(DataTableColumnDef.createStringColumn("name"));
        table.addColumn(DataTableColumnDef.createStringColumn("schema"));
        table.addColumn(DataTableColumnDef.createStringColumn("table"));
        table.addColumn(DataTableColumnDef.createStringColumn("expression"));
        table.addColumn(DataTableColumnDef.createNumericColumn("deferred"));
        table.addColumn(DataTableColumnDef.createBinaryColumn("serialized_expression"));
        transaction.alterCreateTable(table, 187, 128);
        table = new DataTableDef();
        table.setTableName(PRIMARY_COLS_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("pk_id"));
        table.addColumn(DataTableColumnDef.createStringColumn("column"));
        table.addColumn(DataTableColumnDef.createNumericColumn("seq_no"));
        transaction.alterCreateTable(table, 91, 128);
        table = new DataTableDef();
        table.setTableName(UNIQUE_COLS_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("un_id"));
        table.addColumn(DataTableColumnDef.createStringColumn("column"));
        table.addColumn(DataTableColumnDef.createNumericColumn("seq_no"));
        transaction.alterCreateTable(table, 91, 128);
        table = new DataTableDef();
        table.setTableName(FOREIGN_COLS_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("fk_id"));
        table.addColumn(DataTableColumnDef.createStringColumn("fcolumn"));
        table.addColumn(DataTableColumnDef.createStringColumn("pcolumn"));
        table.addColumn(DataTableColumnDef.createNumericColumn("seq_no"));
        transaction.alterCreateTable(table, 91, 128);
        table = new DataTableDef();
        table.setTableName(SCHEMA_INFO_TABLE);
        table.addColumn(DataTableColumnDef.createNumericColumn("id"));
        table.addColumn(DataTableColumnDef.createStringColumn("name"));
        table.addColumn(DataTableColumnDef.createStringColumn("type"));
        table.addColumn(DataTableColumnDef.createStringColumn("other"));
        transaction.alterCreateTable(table, 91, 128);
        table = new DataTableDef();
        table.setTableName(PERSISTENT_VAR_TABLE);
        table.addColumn(DataTableColumnDef.createStringColumn("variable"));
        table.addColumn(DataTableColumnDef.createStringColumn("value"));
        transaction.alterCreateTable(table, 91, 128);
        try {
            transaction.closeAndCommit();
        }
        catch (TransactionException e) {
            this.Debug().writeException(e);
            throw new Error("Transaction Exception creating conglomerate.");
        }
    }

    void resetTableID(TableName tname) {
        TObject ob;
        BigNumber b_num;
        Transaction transaction = this.createTransaction();
        MutableTableDataSource table = transaction.getTable(tname);
        DataTableDef table_def = table.getDataTableDef();
        int col_index = table_def.findColumnName("id");
        if (col_index == -1) {
            throw new Error("Column name 'id' not found.");
        }
        SelectableScheme scheme = table.getColumnScheme(col_index);
        IntegerVector ivec = scheme.selectLast();
        if (ivec.size() > 0 && (b_num = (ob = table.getCellContents(col_index, ivec.intAt(0))).toBigNumber()) != null) {
            transaction.setUniqueID(tname, b_num.longValue() + 1L);
        }
        try {
            transaction.closeAndCommit();
        }
        catch (TransactionException e) {
            this.Debug().writeException(e);
            throw new Error("Transaction Exception creating conglomerate.");
        }
    }

    void resetAllSystemTableID() {
        this.resetTableID(PRIMARY_INFO_TABLE);
        this.resetTableID(FOREIGN_INFO_TABLE);
        this.resetTableID(UNIQUE_INFO_TABLE);
        this.resetTableID(CHECK_INFO_TABLE);
        this.resetTableID(SCHEMA_INFO_TABLE);
    }

    private void initializeSystemTableSchema() {
        Transaction transaction = this.createTransaction();
        transaction.createSchema(SYSTEM_SCHEMA, "SYSTEM");
        String[] id_col = new String[]{"id"};
        transaction.addPrimaryKeyConstraint(PRIMARY_INFO_TABLE, id_col, (short)6, "SYSTEM_PK_PK");
        transaction.addPrimaryKeyConstraint(FOREIGN_INFO_TABLE, id_col, (short)6, "SYSTEM_FK_PK");
        transaction.addPrimaryKeyConstraint(UNIQUE_INFO_TABLE, id_col, (short)6, "SYSTEM_UNIQUE_PK");
        transaction.addPrimaryKeyConstraint(CHECK_INFO_TABLE, id_col, (short)6, "SYSTEM_CHECK_PK");
        transaction.addPrimaryKeyConstraint(SCHEMA_INFO_TABLE, id_col, (short)6, "SYSTEM_SCHEMA_PK");
        String[] fk_col = new String[1];
        String[] fk_ref_col = new String[]{"id"};
        fk_col[0] = "pk_id";
        transaction.addForeignKeyConstraint(PRIMARY_COLS_TABLE, fk_col, PRIMARY_INFO_TABLE, fk_ref_col, "NO ACTION", "NO ACTION", (short)6, "SYSTEM_PK_FK");
        fk_col[0] = "fk_id";
        transaction.addForeignKeyConstraint(FOREIGN_COLS_TABLE, fk_col, FOREIGN_INFO_TABLE, fk_ref_col, "NO ACTION", "NO ACTION", (short)6, "SYSTEM_FK_FK");
        fk_col[0] = "un_id";
        transaction.addForeignKeyConstraint(UNIQUE_COLS_TABLE, fk_col, UNIQUE_INFO_TABLE, fk_ref_col, "NO ACTION", "NO ACTION", (short)6, "SYSTEM_UNIQUE_FK");
        String[] columns = new String[]{"schema", "table"};
        transaction.addUniqueConstraint(PRIMARY_INFO_TABLE, columns, (short)6, "SYSTEM_PKEY_ST_UNIQUE");
        columns = new String[]{"name"};
        transaction.addUniqueConstraint(SCHEMA_INFO_TABLE, columns, (short)6, "SYSTEM_SCHEMA_UNIQUE");
        columns = new String[]{"name", "schema"};
        transaction.addUniqueConstraint(PRIMARY_INFO_TABLE, columns, (short)6, "SYSTEM_PKEY_UNIQUE");
        transaction.addUniqueConstraint(FOREIGN_INFO_TABLE, columns, (short)6, "SYSTEM_FKEY_UNIQUE");
        transaction.addUniqueConstraint(UNIQUE_INFO_TABLE, columns, (short)6, "SYSTEM_UNIQUE_UNIQUE");
        transaction.addUniqueConstraint(CHECK_INFO_TABLE, columns, (short)6, "SYSTEM_CHECK_UNIQUE");
        columns = new String[]{"variable"};
        transaction.addUniqueConstraint(PERSISTENT_VAR_TABLE, columns, (short)6, "SYSTEM_DATABASEVARS_UNIQUE");
        transaction.setPersistentVar("database.version", "1.4");
        try {
            transaction.closeAndCommit();
        }
        catch (TransactionException e) {
            this.Debug().writeException(e);
            throw new Error("Transaction Exception initializing conglomerate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeBlobStore() throws IOException {
        boolean blob_store_exists = this.storeSystem().storeExists("BlobStore");
        if (!blob_store_exists && this.isReadOnly()) {
            return;
        }
        this.act_blob_store = blob_store_exists ? this.storeSystem().openStore("BlobStore") : this.storeSystem().createStore("BlobStore");
        try {
            this.act_blob_store.lockForWrite();
            this.blob_store = new BlobStore(this.act_blob_store);
            MutableArea fixed_area = this.act_blob_store.getMutableArea(-1L);
            if (!blob_store_exists) {
                long header_p = this.blob_store.create();
                fixed_area.putLong(header_p);
                fixed_area.checkOut();
            } else {
                long header_p = fixed_area.getLong();
                this.blob_store.init(header_p);
            }
        }
        finally {
            this.act_blob_store.unlockForWrite();
        }
    }

    private boolean isReadOnly() {
        return this.system.readOnlyAccess();
    }

    private File getPath() {
        return this.system.getDatabasePath();
    }

    private int nextUniqueTableID() throws IOException {
        return this.state_store.nextTableID();
    }

    private void setupInternal() {
        this.commit_id = 0L;
        this.table_list = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void minimalCreate(String name) throws IOException {
        this.name = name;
        if (this.exists(name)) {
            throw new IOException("Conglomerate already exists: " + name);
        }
        if (!this.isReadOnly()) {
            this.storeSystem().lock(name);
        }
        this.act_state_store = this.storeSystem().createStore(name + STATE_POST);
        try {
            this.act_state_store.lockForWrite();
            this.state_store = new StateStore(this.act_state_store);
            long head_p = this.state_store.create();
            MutableArea fixed_area = this.act_state_store.getMutableArea(-1L);
            fixed_area.putLong(head_p);
            fixed_area.checkOut();
        }
        finally {
            this.act_state_store.unlockForWrite();
        }
        this.setupInternal();
        this.initializeBlobStore();
        this.updateSystemTableSchema();
    }

    public void create(String name) throws IOException {
        this.minimalCreate(name);
        this.initializeSystemTableSchema();
        this.state_store.commit();
    }

    public void open(String name) throws IOException {
        this.name = name;
        if (!this.exists(name)) {
            throw new IOException("Conglomerate doesn't exists: " + name);
        }
        if (!this.isReadOnly()) {
            this.storeSystem().lock(name);
        }
        this.act_state_store = this.storeSystem().openStore(name + STATE_POST);
        this.state_store = new StateStore(this.act_state_store);
        Area fixed_area = this.act_state_store.getArea(-1L);
        long head_p = fixed_area.getLong();
        this.state_store.init(head_p);
        this.setupInternal();
        this.initializeBlobStore();
        this.readVisibleTables();
        this.readDroppedTables();
        this.cleanUpConglomerate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.commit_lock;
        synchronized (object) {
            this.cleanUpConglomerate();
            this.store_system.setCheckPoint();
            int size = this.table_list.size();
            for (int i = 0; i < size; ++i) {
                MasterTableDataSource master = (MasterTableDataSource)this.table_list.get(i);
                master.dispose(false);
            }
            this.state_store.commit();
            this.storeSystem().closeStore(this.act_state_store);
            this.table_list = null;
        }
        this.storeSystem().unlock(this.name);
        if (this.blob_store != null) {
            this.storeSystem().closeStore(this.act_blob_store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        Object object = this.commit_lock;
        synchronized (object) {
            this.cleanUpConglomerate();
            int size = this.table_list.size();
            for (int i = 0; i < size; ++i) {
                MasterTableDataSource master = (MasterTableDataSource)this.table_list.get(i);
                master.drop();
            }
            this.state_store.commit();
            this.storeSystem().closeStore(this.act_state_store);
            this.storeSystem().deleteStore(this.act_state_store);
            if (this.blob_store != null) {
                this.storeSystem().closeStore(this.act_blob_store);
                this.storeSystem().deleteStore(this.act_blob_store);
            }
            this.table_list = null;
        }
        this.storeSystem().unlock(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.commit_lock;
        synchronized (object) {
            return this.table_list == null;
        }
    }

    public boolean exists(String name) throws IOException {
        return this.storeSystem().storeExists(name + STATE_POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void liveCopyTo(TableDataConglomerate dest_conglomerate) throws IOException {
        StoreSystem dest_store_system = dest_conglomerate.storeSystem();
        dest_conglomerate.blob_store.copyFrom(dest_store_system, this.blob_store);
        Transaction transaction = this.createTransaction();
        try {
            transaction.liveCopyAllDataTo(dest_conglomerate);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                transaction.closeAndCommit();
            }
            catch (TransactionException e) {
                throw new RuntimeException("Transaction Error: " + e.getMessage());
            }
            throw throwable;
        }
        try {
            transaction.closeAndCommit();
        }
        catch (TransactionException e) {
            throw new RuntimeException("Transaction Error: " + e.getMessage());
        }
        this.getSystem().stats().increment("TableDataConglomerate.liveCopies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawDiagnosticTable getDiagnosticTable(String table_file_name) {
        Object object = this.commit_lock;
        synchronized (object) {
            for (int i = 0; i < this.table_list.size(); ++i) {
                MasterTableDataSource master = (MasterTableDataSource)this.table_list.get(i);
                if (!master.getSourceIdent().equals(table_file_name)) continue;
                return master.getRawDiagnosticTable();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllTableFileNames() {
        Object object = this.commit_lock;
        synchronized (object) {
            String[] list = new String[this.table_list.size()];
            for (int i = 0; i < this.table_list.size(); ++i) {
                MasterTableDataSource master = (MasterTableDataSource)this.table_list.get(i);
                list[i] = master.getSourceIdent();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionModificationListener(TableName table_name, TransactionModificationListener listener) {
        HashMap hashMap = this.modification_listeners;
        synchronized (hashMap) {
            ArrayList<TransactionModificationListener> list = (ArrayList<TransactionModificationListener>)this.modification_listeners.get(table_name);
            if (list == null) {
                list = new ArrayList<TransactionModificationListener>();
                this.modification_listeners.put(table_name, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionModificationListener(TableName table_name, TransactionModificationListener listener) {
        HashMap hashMap = this.modification_listeners;
        synchronized (hashMap) {
            ArrayList list = (ArrayList)this.modification_listeners.get(table_name);
            if (list != null) {
                int sz = list.size();
                for (int i = sz - 1; i >= 0; --i) {
                    if (list.get(i) != listener) continue;
                    list.remove(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction createTransaction() {
        ArrayList<MasterTableDataSource> this_committed_tables = new ArrayList<MasterTableDataSource>();
        Object object = this.commit_lock;
        synchronized (object) {
            long this_commit_id = this.commit_id;
            StateStore.StateResource[] committed_table_list = this.state_store.getVisibleList();
            for (int i = 0; i < committed_table_list.length; ++i) {
                this_committed_tables.add(this.getMasterTable((int)committed_table_list[i].table_id));
            }
            int sz = this_committed_tables.size();
            ArrayList<IndexSet> index_info = new ArrayList<IndexSet>(sz);
            for (int i = 0; i < sz; ++i) {
                MasterTableDataSource mtable = (MasterTableDataSource)this_committed_tables.get(i);
                index_info.add(mtable.createIndexSet());
            }
            Transaction t = new Transaction(this, this_commit_id, this_committed_tables, index_info);
            this.open_transactions.addTransaction(t);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTransaction(Transaction transaction) {
        boolean last_transaction = false;
        Object object = this.commit_lock;
        synchronized (object) {
            this.open_transactions.removeTransaction(transaction);
            ++this.commit_id;
            last_transaction = this.open_transactions.count() == 0;
        }
        if (last_transaction) {
            try {
                this.cleanUpConglomerate();
            }
            catch (IOException e) {
                this.Debug().write(40, this, "Error cleaning up conglomerate");
                this.Debug().writeException(40, e);
            }
        }
    }

    private boolean closeAndDropTable(String table_file_name) throws IOException {
        for (int i = 0; i < this.table_list.size(); ++i) {
            MasterTableDataSource t = (MasterTableDataSource)this.table_list.get(i);
            String enc_fn = table_file_name.substring(2);
            if (!t.getSourceIdent().equals(enc_fn)) continue;
            if (t.isRootLocked()) {
                return false;
            }
            boolean b = t.drop();
            if (b) {
                this.table_list.remove(i);
            }
            return b;
        }
        return false;
    }

    private void closeTable(String table_file_name, boolean pending_drop) throws IOException {
        for (int i = 0; i < this.table_list.size(); ++i) {
            MasterTableDataSource t = (MasterTableDataSource)this.table_list.get(i);
            String enc_fn = table_file_name.substring(2);
            if (!t.getSourceIdent().equals(enc_fn)) continue;
            if (t.isRootLocked()) {
                return;
            }
            t.dispose(pending_drop);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpConglomerate() throws IOException {
        Object object = this.commit_lock;
        synchronized (object) {
            StateStore.StateResource[] delete_list;
            if (this.isClosed()) {
                return;
            }
            if (this.open_transactions.count() == 0 && (delete_list = this.state_store.getDeleteList()).length > 0) {
                String fn;
                int i;
                int drop_count = 0;
                for (i = delete_list.length - 1; i >= 0; --i) {
                    fn = delete_list[i].name;
                    this.closeTable(fn, true);
                }
                for (i = delete_list.length - 1; i >= 0; --i) {
                    fn = delete_list[i].name;
                    boolean dropped = this.closeAndDropTable(fn);
                    if (!dropped) continue;
                    this.state_store.removeDeleteResource(fn);
                    ++drop_count;
                }
                if (drop_count > 0) {
                    this.state_store.commit();
                }
            }
        }
    }

    static String stringColumnList(String[] list) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.length - 1; ++i) {
            buf.append(list[i]);
        }
        buf.append(list[list.length - 1]);
        return new String(buf);
    }

    static String deferredString(short deferred) {
        switch (deferred) {
            case 6: {
                return "Immediate";
            }
            case 5: {
                return "Deferred";
            }
        }
        throw new Error("Unknown deferred string.");
    }

    static int[] findColumnIndices(DataTableDef table_def, String[] cols) {
        int[] col_indexes = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            col_indexes[i] = table_def.findColumnName(cols[i]);
        }
        return col_indexes;
    }

    private static boolean isUniqueColumns(TableDataSource table, int rindex, String[] cols, boolean nulls_are_allowed) {
        int i;
        DataTableDef table_def = table.getDataTableDef();
        IntegerVector identical_rows = null;
        int[] col_indexes = TableDataConglomerate.findColumnIndices(table_def, cols);
        for (i = 0; i < col_indexes.length; ++i) {
            TObject cell = table.getCellContents(col_indexes[i], rindex);
            if (!cell.isNull()) continue;
            return nulls_are_allowed;
        }
        for (i = 0; i < col_indexes.length; ++i) {
            int col_index = col_indexes[i];
            TObject cell = table.getCellContents(col_index, rindex);
            if (identical_rows != null && identical_rows.size() <= 0) continue;
            SelectableScheme ss = table.getColumnScheme(col_index);
            IntegerVector ivec = ss.selectEqual(cell);
            if (identical_rows == null) {
                identical_rows = ivec;
                continue;
            }
            ivec.quickSort();
            for (int row_index = identical_rows.size() - 1; row_index >= 0; --row_index) {
                int val = identical_rows.intAt(row_index);
                int found_index = ivec.sortedIndexOf(val);
                if (found_index < ivec.size() && ivec.intAt(found_index) == val) continue;
                identical_rows.removeIntAt(row_index);
            }
        }
        if (identical_rows != null) {
            int sz = identical_rows.size();
            if (sz == 1) {
                return true;
            }
            if (sz > 1) {
                return false;
            }
            if (sz == 0) {
                throw new Error("Assertion failed: We must be able to find the row we are testing uniqueness against!");
            }
        }
        return true;
    }

    static IntegerVector findKeys(TableDataSource t2, int[] col2_indexes, TObject[] key_value) {
        int key_size = key_value.length;
        SelectableScheme ss = t2.getColumnScheme(col2_indexes[0]);
        IntegerVector list = ss.selectEqual(key_value[0]);
        if (key_size > 1) {
            int sz = list.size();
            block0: for (int i = sz - 1; i >= 0; --i) {
                int r_index = list.intAt(i);
                for (int c = 1; c < key_size; ++c) {
                    TObject c_value = key_value[c];
                    int col_index = col2_indexes[c];
                    if (c_value.compareTo(t2.getCellContents(col_index, r_index)) == 0) continue;
                    list.removeIntAt(i);
                    continue block0;
                }
            }
        }
        return list;
    }

    private static int rowCountOfReferenceTable(SimpleTransaction transaction, int row_index, TableName table1, String[] cols1, TableName table2, String[] cols2, boolean check_source_table_key) {
        IntegerVector keys;
        int key_count;
        TableDataSource t1 = transaction.getTableDataSource(table1);
        TableDataSource t2 = transaction.getTableDataSource(table2);
        DataTableDef dtd1 = t1.getDataTableDef();
        DataTableDef dtd2 = t2.getDataTableDef();
        int[] col1_indexes = TableDataConglomerate.findColumnIndices(dtd1, cols1);
        int[] col2_indexes = TableDataConglomerate.findColumnIndices(dtd2, cols2);
        int key_size = col1_indexes.length;
        TObject[] key_value = new TObject[key_size];
        int null_count = 0;
        for (int n = 0; n < key_size; ++n) {
            key_value[n] = t1.getCellContents(col1_indexes[n], row_index);
            if (!key_value[n].isNull()) continue;
            ++null_count;
        }
        if (null_count > 0) {
            return -1;
        }
        if (check_source_table_key && (key_count = (keys = TableDataConglomerate.findKeys(t1, col1_indexes, key_value)).size()) > 0) {
            return 0;
        }
        return TableDataConglomerate.findKeys(t2, col2_indexes, key_value).size();
    }

    static void checkFieldConstraintViolations(SimpleTransaction transaction, TableDataSource table, int[] row_indices) {
        if (row_indices == null || row_indices.length == 0) {
            return;
        }
        DataTableDef table_def = table.getDataTableDef();
        TableName table_name = table_def.getTableName();
        int len = table_def.columnCount();
        for (int i = 0; i < len; ++i) {
            DataTableColumnDef column_def = table_def.columnAt(i);
            for (int rn = 0; rn < row_indices.length; ++rn) {
                ByteLongObject serialized_jobject;
                Object ob;
                String class_constraint;
                TObject cell = table.getCellContents(i, row_indices[rn]);
                if (column_def.isNotNull() && cell.isNull()) {
                    throw new DatabaseConstraintViolationException(24, "You tried to add 'null' cell to column '" + table_def.columnAt(i).getName() + "' which is declared as 'not_null'");
                }
                if (cell.isNull() || column_def.getSQLType() != 2000 || (class_constraint = column_def.getClassConstraint()).equals("java.lang.Object") || (ob = ObjectTranslator.deserialize(serialized_jobject = (ByteLongObject)cell.getObject())).getClass().isAssignableFrom(column_def.getClassConstraintAsClass())) continue;
                throw new DatabaseConstraintViolationException(25, "The Java object being inserted is not derived from the class constraint defined for the column (" + class_constraint + ")");
            }
        }
    }

    static void checkAddConstraintViolations(SimpleTransaction transaction, TableDataSource table, int[] row_indices, short deferred) {
        String cur_schema = table.getDataTableDef().getSchema();
        SystemQueryContext context = new SystemQueryContext(transaction, cur_schema);
        if (row_indices == null || row_indices.length == 0) {
            return;
        }
        DataTableDef table_def = table.getDataTableDef();
        TableName table_name = table_def.getTableName();
        Transaction.ColumnGroup primary_key = Transaction.queryTablePrimaryKeyGroup(transaction, table_name);
        if (primary_key != null && (deferred == 5 || primary_key.deferred == 6)) {
            for (int rn = 0; rn < row_indices.length; ++rn) {
                if (TableDataConglomerate.isUniqueColumns(table, row_indices[rn], primary_key.columns, false)) continue;
                throw new DatabaseConstraintViolationException(20, TableDataConglomerate.deferredString(deferred) + " primary Key constraint violation (" + primary_key.name + ") Columns = ( " + TableDataConglomerate.stringColumnList(primary_key.columns) + " ) Table = ( " + table_name.toString() + " )");
            }
        }
        Transaction.ColumnGroup[] unique_constraints = Transaction.queryTableUniqueGroups(transaction, table_name);
        for (int i = 0; i < unique_constraints.length; ++i) {
            Transaction.ColumnGroup unique = unique_constraints[i];
            if (deferred != 5 && unique.deferred != 6) continue;
            for (int rn = 0; rn < row_indices.length; ++rn) {
                if (TableDataConglomerate.isUniqueColumns(table, row_indices[rn], unique.columns, true)) continue;
                throw new DatabaseConstraintViolationException(21, TableDataConglomerate.deferredString(deferred) + " unique constraint violation (" + unique.name + ") Columns = ( " + TableDataConglomerate.stringColumnList(unique.columns) + " ) Table = ( " + table_name.toString() + " )");
            }
        }
        Transaction.ColumnGroupReference[] foreign_constraints = Transaction.queryTableForeignKeyReferences(transaction, table_name);
        for (int i = 0; i < foreign_constraints.length; ++i) {
            Transaction.ColumnGroupReference ref = foreign_constraints[i];
            if (deferred != 5 && ref.deferred != 6) continue;
            for (int rn = 0; rn < row_indices.length; ++rn) {
                int row_count = TableDataConglomerate.rowCountOfReferenceTable(transaction, row_indices[rn], ref.key_table_name, ref.key_columns, ref.ref_table_name, ref.ref_columns, false);
                if (row_count == -1) {
                    // empty if block
                }
                if (row_count != 0) continue;
                throw new DatabaseConstraintViolationException(23, TableDataConglomerate.deferredString(deferred) + " foreign key constraint violation (" + ref.name + ") Columns = " + ref.key_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(ref.key_columns) + " ) -> " + ref.ref_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(ref.ref_columns) + " )");
            }
        }
        Transaction.CheckExpression[] check_constraints = Transaction.queryTableCheckExpressions(transaction, table_name);
        TransactionSystem system = transaction.getSystem();
        for (int i = 0; i < check_constraints.length; ++i) {
            Transaction.CheckExpression check = check_constraints[i];
            if (deferred != 5 && check.deferred != 6) continue;
            check = system.prepareTransactionCheckConstraint(table_def, check);
            Expression exp = check.expression;
            for (int rn = 0; rn < row_indices.length; ++rn) {
                TableRowVariableResolver resolver = new TableRowVariableResolver(table, row_indices[rn]);
                TObject ob = exp.evaluate(null, resolver, context);
                Boolean b = ob.toBoolean();
                if (b != null) {
                    if (!b.equals(Boolean.FALSE)) continue;
                    throw new DatabaseConstraintViolationException(22, TableDataConglomerate.deferredString(deferred) + " check constraint violation (" + check.name + ") - '" + exp.text() + "' evaluated to false for inserted/updated row.");
                }
                transaction.Debug().write(40, class$com$mckoi$database$TableDataConglomerate == null ? TableDataConglomerate.class$("com.mckoi.database.TableDataConglomerate") : class$com$mckoi$database$TableDataConglomerate, TableDataConglomerate.deferredString(deferred) + " check constraint violation (" + check.name + ") - '" + exp.text() + "' returned a non boolean or NULL result.");
            }
        }
    }

    static void checkAddConstraintViolations(SimpleTransaction transaction, TableDataSource table, int row_index, short deferred) {
        TableDataConglomerate.checkAddConstraintViolations(transaction, table, new int[]{row_index}, deferred);
    }

    static void checkRemoveConstraintViolations(SimpleTransaction transaction, TableDataSource table, int[] row_indices, short deferred) {
        if (row_indices == null || row_indices.length == 0) {
            return;
        }
        DataTableDef table_def = table.getDataTableDef();
        TableName table_name = table_def.getTableName();
        Transaction.ColumnGroupReference[] foreign_constraints = Transaction.queryTableImportedForeignKeyReferences(transaction, table_name);
        for (int i = 0; i < foreign_constraints.length; ++i) {
            Transaction.ColumnGroupReference ref = foreign_constraints[i];
            if (deferred != 5 && ref.deferred != 6) continue;
            for (int rn = 0; rn < row_indices.length; ++rn) {
                int row_count = TableDataConglomerate.rowCountOfReferenceTable(transaction, row_indices[rn], ref.ref_table_name, ref.ref_columns, ref.key_table_name, ref.key_columns, true);
                if (row_count <= 0) continue;
                throw new DatabaseConstraintViolationException(23, TableDataConglomerate.deferredString(deferred) + " foreign key constraint violation " + "on delete (" + ref.name + ") Columns = " + ref.key_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(ref.key_columns) + " ) -> " + ref.ref_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(ref.ref_columns) + " )");
            }
        }
    }

    static void checkRemoveConstraintViolations(SimpleTransaction transaction, TableDataSource table, int row_index, short deferred) {
        TableDataConglomerate.checkRemoveConstraintViolations(transaction, table, new int[]{row_index}, deferred);
    }

    static void checkAllAddConstraintViolations(SimpleTransaction transaction, TableDataSource table, short deferred) {
        int[] rows = new int[table.getRowCount()];
        RowEnumeration row_enum = table.rowEnumeration();
        int p = 0;
        while (row_enum.hasMoreRows()) {
            rows[p] = row_enum.nextRowIndex();
            ++p;
        }
        TableDataConglomerate.checkAddConstraintViolations(transaction, table, rows, (short)5);
    }

    Ref createNewLargeObject(byte type, long size) {
        try {
            if (this.isReadOnly()) {
                throw new RuntimeException("A new large object can not be allocated with a read-only conglomerate");
            }
            Ref ref = this.blob_store.allocateLargeObject(type, size);
            return ref;
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new RuntimeException("IO Error when creating blob: " + e.getMessage());
        }
    }

    void flushBlobStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fix(String name, UserTerminal terminal) {
        this.name = name;
        try {
            String state_fn = name + STATE_POST;
            boolean state_exists = false;
            try {
                state_exists = this.exists(name);
            }
            catch (IOException e) {
                terminal.println("IO Error when checking if state store exists: " + e.getMessage());
                e.printStackTrace();
            }
            if (!state_exists) {
                terminal.println("Couldn't find store: " + state_fn);
                return;
            }
            terminal.println("+ Found state store: " + state_fn);
            try {
                this.act_state_store = this.storeSystem().openStore(name + STATE_POST);
                this.state_store = new StateStore(this.act_state_store);
                Area fixed_area = this.act_state_store.getArea(-1L);
                long head_p = fixed_area.getLong();
                this.state_store.init(head_p);
                terminal.println("+ Initialized the state store: " + state_fn);
            }
            catch (IOException e) {
                terminal.println("Couldn't initialize the state file: " + state_fn + " Reason: " + e.getMessage());
                try {
                    this.close();
                }
                catch (IOException e2) {
                    terminal.println("Unable to close conglomerate after fix.");
                }
                return;
            }
            try {
                this.initializeBlobStore();
            }
            catch (IOException e) {
                terminal.println("Error intializing BlobStore: " + e.getMessage());
                e.printStackTrace();
                try {
                    this.close();
                }
                catch (IOException e3) {
                    terminal.println("Unable to close conglomerate after fix.");
                }
                return;
            }
            this.setupInternal();
            try {
                int i;
                this.checkVisibleTables(terminal);
                terminal.println("+ RESETTING ALL SYSTEM TABLE UNIQUE ID VALUES.");
                this.resetAllSystemTableID();
                StringBuffer buf = new StringBuffer();
                StateStore.StateResource[] committed_tables = this.state_store.getVisibleList();
                StateStore.StateResource[] committed_dropped = this.state_store.getDeleteList();
                for (i = 0; i < committed_tables.length; ++i) {
                    terminal.println("+ COMMITTED TABLE: " + committed_tables[i].name);
                }
                for (i = 0; i < committed_dropped.length; ++i) {
                    terminal.println("+ COMMIT DROPPED TABLE: " + committed_dropped[i].name);
                }
                return;
            }
            catch (IOException e) {
                terminal.println("IOException: " + e.getMessage());
                e.printStackTrace();
                try {
                    this.close();
                }
                catch (IOException e4) {
                    terminal.println("Unable to close conglomerate after fix.");
                }
            }
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                terminal.println("Unable to close conglomerate after fix.");
            }
        }
    }

    private static boolean commitTableListContains(List list, MasterTableDataSource master) {
        int sz = list.size();
        for (int i = 0; i < sz; ++i) {
            CommitTableInfo info = (CommitTableInfo)list.get(i);
            if (!info.master.equals(master)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void processCommit(Transaction transaction, ArrayList visible_tables, ArrayList selected_from_tables, ArrayList touched_tables, TransactionJournal journal) throws TransactionException {
        ArrayList<MasterTableJournal> journal_list = new ArrayList<MasterTableJournal>();
        for (int i = 0; i < touched_tables.size(); ++i) {
            MasterTableJournal table_journal = ((MutableTableDataSource)touched_tables.get(i)).getJournal();
            if (table_journal.entries() <= 0) continue;
            journal_list.add(table_journal);
        }
        MasterTableJournal[] changed_tables = journal_list.toArray(new MasterTableJournal[journal_list.size()]);
        IntegerVector created_tables = journal.getTablesCreated();
        IntegerVector dropped_tables = journal.getTablesDropped();
        IntegerVector constraint_altered_tables = journal.getTablesConstraintAltered();
        if (changed_tables.length == 0 && created_tables.size() == 0 && dropped_tables.size() == 0 && constraint_altered_tables.size() == 0) {
            this.closeTransaction(transaction);
            return;
        }
        boolean entries_committed = false;
        ArrayList<MasterTableDataSource> changed_tables_list = new ArrayList<MasterTableDataSource>();
        Object object = this.commit_lock;
        synchronized (object) {
            block57: {
                int i;
                int i2;
                int i3;
                int i4;
                ArrayList database_objects_created = transaction.getAllNamesCreated();
                ArrayList database_objects_dropped = transaction.getAllNamesDropped();
                Transaction check_transaction = null;
                long tran_commit_id = transaction.getCommitID();
                if (transaction.transactionErrorOnDirtySelect()) {
                    for (int i5 = 0; i5 < selected_from_tables.size(); ++i5) {
                        MasterTableDataSource selected_table = (MasterTableDataSource)selected_from_tables.get(i5);
                        MasterTableJournal[] journals_since = selected_table.findAllJournalsSince(tran_commit_id);
                        if (journals_since.length <= 0) continue;
                        throw new TransactionException(4, "Concurrent Serializable Transaction Conflict(4): Select from table that has committed changes: " + selected_table.getName());
                    }
                }
                ArrayList all_dropped_obs = new ArrayList();
                ArrayList all_created_obs = new ArrayList();
                int nsj_sz = this.namespace_journal_list.size();
                for (int i6 = 0; i6 < nsj_sz; ++i6) {
                    NameSpaceJournal ns_journal = (NameSpaceJournal)this.namespace_journal_list.get(i6);
                    if (ns_journal.commit_id < tran_commit_id) continue;
                    all_dropped_obs.addAll(ns_journal.dropped_names);
                    all_created_obs.addAll(ns_journal.created_names);
                }
                int ado_sz = all_dropped_obs.size();
                boolean conflict5 = false;
                Object conflict_name = null;
                String conflict_desc = "";
                for (int n = 0; n < ado_sz; ++n) {
                    if (!database_objects_dropped.contains(all_dropped_obs.get(n))) continue;
                    conflict5 = true;
                    conflict_name = all_dropped_obs.get(n);
                    conflict_desc = "Drop Clash";
                }
                int aco_sz = all_created_obs.size();
                for (int n = 0; n < aco_sz; ++n) {
                    if (!database_objects_created.contains(all_created_obs.get(n))) continue;
                    conflict5 = true;
                    conflict_name = all_created_obs.get(n);
                    conflict_desc = "Create Clash";
                }
                if (conflict5) {
                    throw new TransactionException(5, "Concurrent Serializable Transaction Conflict(5): Namespace conflict: " + conflict_name.toString() + " " + conflict_desc);
                }
                for (i4 = 0; i4 < changed_tables.length; ++i4) {
                    MasterTableJournal change_journal = changed_tables[i4];
                    int table_id = change_journal.getTableID();
                    MasterTableDataSource master = this.getMasterTable(table_id);
                    boolean committed_resource = this.state_store.containsVisibleResource(table_id);
                    if (!created_tables.contains(table_id) && !committed_resource) {
                        throw new TransactionException(3, "Concurrent Serializable Transaction Conflict(2): Table altered/dropped: " + master.getName());
                    }
                    MasterTableJournal[] journals_since = master.findAllJournalsSince(tran_commit_id);
                    for (int n = 0; n < journals_since.length; ++n) {
                        change_journal.testCommitClash(master.getDataTableDef(), journals_since[n]);
                    }
                }
                for (i4 = 0; i4 < dropped_tables.size(); ++i4) {
                    int table_id = dropped_tables.intAt(i4);
                    MasterTableDataSource master = this.getMasterTable(table_id);
                    if (master.findAllJournalsSince(tran_commit_id).length <= 0) continue;
                    throw new TransactionException(2, "Concurrent Serializable Transaction Conflict(3): Dropped table has modifications: " + master.getName());
                }
                int created_tables_count = created_tables.size();
                int changed_tables_count = changed_tables.length;
                ArrayList<CommitTableInfo> normalized_changed_tables = new ArrayList<CommitTableInfo>(8);
                for (i3 = 0; i3 < changed_tables_count; ++i3) {
                    MasterTableJournal table_journal = changed_tables[i3];
                    int table_id = table_journal.getTableID();
                    if (dropped_tables.contains(table_id)) continue;
                    MasterTableDataSource master_table = this.getMasterTable(table_id);
                    CommitTableInfo table_info = new CommitTableInfo();
                    table_info.master = master_table;
                    table_info.journal = table_journal;
                    table_info.changes_since_commit = master_table.findAllJournalsSince(tran_commit_id);
                    normalized_changed_tables.add(table_info);
                }
                for (i3 = 0; i3 < created_tables_count; ++i3) {
                    MasterTableDataSource master_table;
                    int table_id = created_tables.intAt(i3);
                    if (dropped_tables.contains(table_id) || TableDataConglomerate.commitTableListContains(normalized_changed_tables, master_table = this.getMasterTable(table_id))) continue;
                    CommitTableInfo table_info = new CommitTableInfo();
                    table_info.master = master_table;
                    normalized_changed_tables.add(table_info);
                }
                int norm_changed_tables_count = normalized_changed_tables.size();
                int dropped_tables_count = dropped_tables.size();
                ArrayList<MasterTableDataSource> normalized_dropped_tables = new ArrayList<MasterTableDataSource>(8);
                for (i2 = 0; i2 < dropped_tables_count; ++i2) {
                    int table_id = dropped_tables.intAt(i2);
                    if (created_tables.contains(table_id)) continue;
                    MasterTableDataSource master_table = this.getMasterTable(table_id);
                    normalized_dropped_tables.add(master_table);
                }
                check_transaction = this.createTransaction();
                for (i2 = 0; i2 < normalized_dropped_tables.size(); ++i2) {
                    MasterTableDataSource master_table = (MasterTableDataSource)normalized_dropped_tables.get(i2);
                    check_transaction.removeVisibleTable(master_table);
                }
                TableDataSource[] changed_table_source = new TableDataSource[norm_changed_tables_count];
                for (i = 0; i < norm_changed_tables_count; ++i) {
                    MutableTableDataSource mtable;
                    CommitTableInfo table_info = (CommitTableInfo)normalized_changed_tables.get(i);
                    MasterTableDataSource master = table_info.master;
                    MasterTableJournal[] all_table_changes = table_info.changes_since_commit;
                    if (all_table_changes == null || all_table_changes.length == 0) {
                        mtable = transaction.getTable(master.getTableName());
                        table_info.index_set = transaction.getIndexSetForTable(master);
                        mtable.flushIndexChanges();
                        check_transaction.updateVisibleTable(table_info.master, table_info.index_set);
                    } else {
                        mtable = master.createTableDataSourceAtCommit(check_transaction, table_info.journal);
                        table_info.index_set = check_transaction.getIndexSetForTable(master);
                        mtable.flushIndexChanges();
                        mtable.dispose();
                    }
                    changed_table_source[i] = check_transaction.getTable(master.getTableName());
                }
                check_transaction.setReadOnly();
                for (i = 0; i < constraint_altered_tables.size(); ++i) {
                    int table_id = constraint_altered_tables.intAt(i);
                    for (int n = 0; n < norm_changed_tables_count; ++n) {
                        CommitTableInfo table_info = (CommitTableInfo)normalized_changed_tables.get(n);
                        if (table_info.master.getTableID() != table_id) continue;
                        TableDataConglomerate.checkAllAddConstraintViolations(check_transaction, changed_table_source[n], (short)5);
                    }
                }
                for (i = 0; i < norm_changed_tables_count; ++i) {
                    CommitTableInfo table_info = (CommitTableInfo)normalized_changed_tables.get(i);
                    MasterTableJournal change_journal = table_info.journal;
                    if (change_journal == null) continue;
                    int[] normalized_removed_rows = change_journal.normalizedRemovedRows();
                    TableDataConglomerate.checkRemoveConstraintViolations((SimpleTransaction)check_transaction, changed_table_source[i], normalized_removed_rows, (short)5);
                    int[] normalized_added_rows = change_journal.normalizedAddedRows();
                    TableDataConglomerate.checkAddConstraintViolations((SimpleTransaction)check_transaction, changed_table_source[i], normalized_added_rows, (short)5);
                    table_info.norm_added_rows = normalized_added_rows;
                    table_info.norm_removed_rows = normalized_removed_rows;
                }
                for (i = 0; i < norm_changed_tables_count; ++i) {
                    TransactionModificationListener[] listeners;
                    CommitTableInfo table_info = (CommitTableInfo)normalized_changed_tables.get(i);
                    MasterTableJournal change_journal = table_info.journal;
                    if (change_journal == null) continue;
                    TableName table_name = table_info.master.getTableName();
                    HashMap hashMap = this.modification_listeners;
                    synchronized (hashMap) {
                        ArrayList list = (ArrayList)this.modification_listeners.get(table_name);
                        if (list == null || list.size() == 0) {
                            continue;
                        }
                        listeners = list.toArray(new TransactionModificationListener[list.size()]);
                    }
                    TableCommitModificationEvent event = new TableCommitModificationEvent(check_transaction, table_name, table_info.norm_added_rows, table_info.norm_removed_rows);
                    for (int n = 0; n < listeners.length; ++n) {
                        listeners[n].tableCommitChange(event);
                    }
                }
                entries_committed = true;
                for (i = 0; i < norm_changed_tables_count; ++i) {
                    CommitTableInfo table_info = (CommitTableInfo)normalized_changed_tables.get(i);
                    MasterTableJournal change_journal = table_info.journal;
                    if (change_journal == null) continue;
                    MasterTableDataSource master = table_info.master;
                    master.commitTransactionChange(this.commit_id, change_journal, table_info.index_set);
                    changed_tables_list.add(master);
                }
                if (created_tables.size() > 0 || dropped_tables.size() > 0) {
                    this.commitToTables(created_tables, dropped_tables);
                }
                if (database_objects_created.size() > 0 || database_objects_dropped.size() > 0) {
                    NameSpaceJournal namespace_journal = new NameSpaceJournal(tran_commit_id, database_objects_created, database_objects_dropped);
                    this.namespace_journal_list.add(namespace_journal);
                }
                Object var43_79 = null;
                try {
                    if (!entries_committed) {
                        for (int i7 = 0; i7 < changed_tables.length; ++i7) {
                            MasterTableJournal change_journal = changed_tables[i7];
                            int table_id = change_journal.getTableID();
                            MasterTableDataSource master = this.getMasterTable(table_id);
                            master.rollbackTransactionChange(change_journal);
                        }
                        if (this.Debug().isInterestedIn(10)) {
                            this.Debug().write(10, this, "Rolled back transaction changes in a commit.");
                        }
                    }
                    Object var49_89 = null;
                }
                catch (Throwable throwable) {
                    Object var49_90 = null;
                    try {
                        if (check_transaction != null) {
                            check_transaction.dispose();
                            this.closeTransaction(check_transaction);
                        }
                        this.closeTransaction(transaction);
                    }
                    catch (Throwable e) {
                        this.Debug().writeException(e);
                    }
                    throw throwable;
                }
                try {
                    if (check_transaction != null) {
                        check_transaction.dispose();
                        this.closeTransaction(check_transaction);
                    }
                    this.closeTransaction(transaction);
                }
                catch (Throwable e) {
                    this.Debug().writeException(e);
                }
                break block57;
                catch (Throwable throwable) {
                    Object var43_80 = null;
                    try {
                        if (!entries_committed) {
                            for (int i7 = 0; i7 < changed_tables.length; ++i7) {
                                MasterTableJournal change_journal = changed_tables[i7];
                                int table_id = change_journal.getTableID();
                                MasterTableDataSource master = this.getMasterTable(table_id);
                                master.rollbackTransactionChange(change_journal);
                            }
                            if (this.Debug().isInterestedIn(10)) {
                                this.Debug().write(10, this, "Rolled back transaction changes in a commit.");
                            }
                        }
                        Object var49_91 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var49_92 = null;
                        try {
                            if (check_transaction != null) {
                                check_transaction.dispose();
                                this.closeTransaction(check_transaction);
                            }
                            this.closeTransaction(transaction);
                        }
                        catch (Throwable e) {
                            this.Debug().writeException(e);
                        }
                        throw throwable2;
                    }
                    try {
                        if (check_transaction != null) {
                            check_transaction.dispose();
                            this.closeTransaction(check_transaction);
                        }
                        this.closeTransaction(transaction);
                    }
                    catch (Throwable e) {
                        this.Debug().writeException(e);
                    }
                    throw throwable;
                }
            }
            long min_commit_id = this.open_transactions.minimumCommitID(null);
            int chsz = changed_tables_list.size();
            for (int i = 0; i < chsz; ++i) {
                MasterTableDataSource master = (MasterTableDataSource)changed_tables_list.get(i);
                master.mergeJournalChanges(min_commit_id);
            }
            int nsjsz = this.namespace_journal_list.size();
            for (int i = nsjsz - 1; i >= 0; --i) {
                NameSpaceJournal namespace_journal = (NameSpaceJournal)this.namespace_journal_list.get(i);
                if (namespace_journal.commit_id >= min_commit_id) continue;
                this.namespace_journal_list.remove(i);
            }
            this.store_system.setCheckPoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRollback(Transaction transaction, ArrayList touched_tables, TransactionJournal journal) {
        ArrayList<MasterTableJournal> journal_list = new ArrayList<MasterTableJournal>();
        for (int i = 0; i < touched_tables.size(); ++i) {
            MasterTableJournal table_journal = ((MutableTableDataSource)touched_tables.get(i)).getJournal();
            if (table_journal.entries() <= 0) continue;
            journal_list.add(table_journal);
        }
        MasterTableJournal[] changed_tables = journal_list.toArray(new MasterTableJournal[journal_list.size()]);
        IntegerVector created_tables = journal.getTablesCreated();
        Object object = this.commit_lock;
        synchronized (object) {
            try {
                for (int i = 0; i < changed_tables.length; ++i) {
                    MasterTableJournal change_journal = changed_tables[i];
                    int table_id = change_journal.getTableID();
                    MasterTableDataSource master = this.getMasterTable(table_id);
                    master.rollbackTransactionChange(change_journal);
                }
            }
            finally {
                this.closeTransaction(transaction);
            }
        }
    }

    private void commitToTables(IntegerVector created_tables, IntegerVector dropped_tables) {
        StateStore.StateResource resource;
        MasterTableDataSource t;
        int i;
        for (i = 0; i < created_tables.size(); ++i) {
            t = this.getMasterTable(created_tables.intAt(i));
            resource = new StateStore.StateResource(t.getTableID(), TableDataConglomerate.createEncodedTableFile(t));
            this.state_store.addVisibleResource(resource);
            this.state_store.removeDeleteResource(resource.name);
        }
        for (i = 0; i < dropped_tables.size(); ++i) {
            t = this.getMasterTable(dropped_tables.intAt(i));
            resource = new StateStore.StateResource(t.getTableID(), TableDataConglomerate.createEncodedTableFile(t));
            this.state_store.addDeleteResource(resource);
            this.state_store.removeVisibleResource(resource.name);
        }
        try {
            this.state_store.commit();
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new Error("IO Error: " + e.getMessage());
        }
    }

    MasterTableDataSource getMasterTable(int table_id) {
        Object object = this.commit_lock;
        synchronized (object) {
            for (int i = 0; i < this.table_list.size(); ++i) {
                MasterTableDataSource t = (MasterTableDataSource)this.table_list.get(i);
                if (t.getTableID() != table_id) continue;
                return t;
            }
            throw new Error("Unable to find an open table with id: " + table_id);
        }
    }

    MasterTableDataSource createMasterTable(DataTableDef table_def, int data_sector_size, int index_sector_size) {
        Object object = this.commit_lock;
        synchronized (object) {
            try {
                int table_id = this.nextUniqueTableID();
                V2MasterTableDataSource master_table = new V2MasterTableDataSource(this.getSystem(), this.storeSystem(), this.open_transactions, this.blob_store);
                master_table.create(table_id, table_def);
                this.table_list.add(master_table);
                this.markAsCommittedDropped(table_id);
                this.state_store.commit();
                return master_table;
            }
            catch (IOException e) {
                this.Debug().writeException(e);
                throw new Error("Unable to create master table '" + table_def.getName() + "' - " + e.getMessage());
            }
        }
    }

    MasterTableDataSource copyMasterTable(MasterTableDataSource src_master_table, IndexSet index_set) {
        Object object = this.commit_lock;
        synchronized (object) {
            try {
                int table_id = this.nextUniqueTableID();
                V2MasterTableDataSource master_table = new V2MasterTableDataSource(this.getSystem(), this.storeSystem(), this.open_transactions, this.blob_store);
                master_table.copy(table_id, src_master_table, index_set);
                this.table_list.add(master_table);
                this.markAsCommittedDropped(table_id);
                this.state_store.commit();
                return master_table;
            }
            catch (IOException e) {
                this.Debug().writeException(e);
                throw new RuntimeException("Unable to copy master table '" + src_master_table.getDataTableDef().getName() + "' - " + e.getMessage());
            }
        }
    }

    public void finalize() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NameSpaceJournal {
        long commit_id;
        ArrayList created_names;
        ArrayList dropped_names;

        NameSpaceJournal(long commit_id, ArrayList created_names, ArrayList dropped_names) {
            this.commit_id = commit_id;
            this.created_names = created_names;
            this.dropped_names = dropped_names;
        }
    }

    private static class CommitTableInfo {
        MasterTableDataSource master;
        IndexSet index_set;
        MasterTableJournal journal;
        MasterTableJournal[] changes_since_commit;
        int[] norm_added_rows;
        int[] norm_removed_rows;

        private CommitTableInfo() {
        }
    }

    private static class TableRowVariableResolver
    implements VariableResolver {
        private TableDataSource table;
        private int row_index = -1;

        public TableRowVariableResolver(TableDataSource table, int row) {
            this.table = table;
            this.row_index = row;
        }

        private int findColumnName(Variable variable) {
            int col_index = this.table.getDataTableDef().findColumnName(variable.getName());
            if (col_index == -1) {
                throw new Error("Can't find column: " + variable);
            }
            return col_index;
        }

        public int setID() {
            return this.row_index;
        }

        public TObject resolve(Variable variable) {
            int col_index = this.findColumnName(variable);
            return this.table.getCellContents(col_index, this.row_index);
        }

        public TType returnTType(Variable variable) {
            int col_index = this.findColumnName(variable);
            return this.table.getDataTableDef().columnAt(col_index).getTType();
        }
    }
}

