/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TableCommitModificationEvent;
import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TableModificationEvent;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionModificationListener;
import com.mckoi.util.IntegerVector;

abstract class TableBackedCache {
    private TableName backed_by_table;
    private IntegerVector added_list;
    private IntegerVector removed_list;
    private boolean transaction_active;
    private TransactionModificationListener listener;

    protected TableBackedCache(TableName table) {
        this.backed_by_table = table;
        this.added_list = new IntegerVector();
        this.removed_list = new IntegerVector();
    }

    private void addRowsToList(int[] from, IntegerVector list) {
        if (from != null) {
            for (int i = 0; i < from.length; ++i) {
                list.addInt(from[i]);
            }
        }
    }

    final void attachTo(TableDataConglomerate conglomerate) {
        TableName table_name = this.backed_by_table;
        this.listener = new TransactionModificationListener(){

            public void tableChange(TableModificationEvent evt) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableCommitChange(TableCommitModificationEvent evt) {
                TableName table_name = evt.getTableName();
                if (table_name.equals(TableBackedCache.this.backed_by_table)) {
                    IntegerVector integerVector = TableBackedCache.this.removed_list;
                    synchronized (integerVector) {
                        TableBackedCache.this.addRowsToList(evt.getAddedRows(), TableBackedCache.this.added_list);
                        TableBackedCache.this.addRowsToList(evt.getRemovedRows(), TableBackedCache.this.removed_list);
                    }
                }
            }
        };
        conglomerate.addTransactionModificationListener(table_name, this.listener);
    }

    final void detatchFrom(TableDataConglomerate conglomerate) {
        TableName table_name = this.backed_by_table;
        conglomerate.removeTransactionModificationListener(table_name, this.listener);
    }

    final void transactionStarted() {
        this.transaction_active = true;
        this.internalPurgeCache();
    }

    final void transactionFinished() {
        this.transaction_active = false;
        this.internalPurgeCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPurgeCache() {
        IntegerVector remove;
        IntegerVector add;
        IntegerVector integerVector = this.removed_list;
        synchronized (integerVector) {
            add = new IntegerVector(this.added_list);
            remove = new IntegerVector(this.removed_list);
            this.added_list.clear();
            this.removed_list.clear();
        }
        this.purgeCacheOfInvalidatedEntries(add, remove);
    }

    abstract void purgeCacheOfInvalidatedEntries(IntegerVector var1, IntegerVector var2);
}

