/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractDataTable;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DataTableListener;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.DumpHelper;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.INHelper;
import com.mckoi.database.JoinedTable;
import com.mckoi.database.NaturallyJoinedTable;
import com.mckoi.database.Operator;
import com.mckoi.database.PatternSearch;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableRange;
import com.mckoi.database.SelectableRangeSet;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.StatementException;
import com.mckoi.database.TArrayType;
import com.mckoi.database.TBooleanType;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.TableAccessState;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableFunctions;
import com.mckoi.database.TemporaryTable;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.Variable;
import com.mckoi.database.VariableResolver;
import com.mckoi.database.VirtualTable;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.IntegerVector;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public abstract class Table
implements TableDataSource {
    protected static boolean DEBUG_QUERY = true;
    private HashMap col_name_lookup;
    private Object COL_LOOKUP_LOCK = new Object();

    protected Table() {
    }

    public abstract Database getDatabase();

    public final TransactionSystem getSystem() {
        return this.getDatabase().getSystem();
    }

    public DebugLogger Debug() {
        return this.getSystem().Debug();
    }

    public abstract int getColumnCount();

    public abstract int getRowCount();

    public TType getTTypeForColumn(int column) {
        return this.getDataTableDef().columnAt(column).getTType();
    }

    public TType getTTypeForColumn(Variable v) {
        return this.getTTypeForColumn(this.findFieldName(v));
    }

    public abstract int findFieldName(Variable var1);

    public abstract Variable getResolvedVariable(int var1);

    abstract SelectableScheme getSelectableSchemeFor(int var1, int var2, Table var3);

    abstract void setToRowTableDomain(int var1, IntegerVector var2, TableDataSource var3);

    abstract RawTableInformation resolveToRawTable(RawTableInformation var1);

    public abstract TObject getCellContents(int var1, int var2);

    public abstract RowEnumeration rowEnumeration();

    public abstract DataTableDef getDataTableDef();

    abstract void addDataTableListener(DataTableListener var1);

    abstract void removeDataTableListener(DataTableListener var1);

    public abstract void lockRoot(int var1);

    public abstract void unlockRoot(int var1);

    public abstract boolean hasRootsLocked();

    public SelectableScheme getColumnScheme(int column) {
        return this.getSelectableSchemeFor(column, column, this);
    }

    public DataTableColumnDef getColumnDefAt(int col_index) {
        return this.getDataTableDef().columnAt(col_index);
    }

    public final void dumpTo(PrintStream out) throws IOException {
        DumpHelper.dump(this, out);
    }

    public final Table emptySelect() {
        if (this.getRowCount() == 0) {
            return this;
        }
        VirtualTable table = new VirtualTable(this);
        table.set(this, new IntegerVector(0));
        return table;
    }

    public final Table singleRowSelect(int row_index) {
        VirtualTable table = new VirtualTable(this);
        IntegerVector ivec = new IntegerVector(1);
        ivec.addInt(row_index);
        table.set(this, ivec);
        return table;
    }

    public final Table columnMerge(Table table) {
        if (this.getRowCount() != table.getRowCount()) {
            throw new Error("Tables have different row counts.");
        }
        IntegerVector all_row_set = new IntegerVector();
        int rcount = this.getRowCount();
        for (int i = 0; i < rcount; ++i) {
            all_row_set.addInt(i);
        }
        Table[] tabs = new Table[]{this, table};
        IntegerVector[] row_sets = new IntegerVector[]{all_row_set, all_row_set};
        VirtualTable out_table = new VirtualTable(tabs);
        out_table.set(tabs, row_sets);
        return out_table;
    }

    public final Table rangeSelect(Variable col_var, SelectableRange[] ranges) {
        if (this.getRowCount() == 0) {
            return this;
        }
        if (ranges == null || ranges.length == 0) {
            return this.emptySelect();
        }
        if (ranges.length == 1 && ranges[0].equals(SelectableRange.FULL_RANGE)) {
            return this;
        }
        int column = this.findFieldName(col_var);
        if (column == -1) {
            throw new RuntimeException("Unable to find the column given to select the range of: " + col_var.getName());
        }
        IntegerVector rows = this.selectRange(column, ranges);
        VirtualTable table = new VirtualTable(this);
        table.set(this, rows);
        table.optimisedPostSet(column);
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, table + " = " + this + ".rangeSelect(" + col_var + ", " + ranges + " )");
        }
        return table;
    }

    public final Table simpleSelect(QueryContext context, Variable lhs_var, Operator op, Expression rhs) {
        IntegerVector rows;
        String DEBUG_SELECT_WITH = null;
        int column = this.findFieldName(lhs_var);
        if (column == -1) {
            throw new RuntimeException("Unable to find the LHS column specified in the condition: " + lhs_var.getName());
        }
        boolean ordered_by_select_column = false;
        if (op.isSubQuery()) {
            Object ob = rhs.last();
            if (!(ob instanceof TObject)) {
                throw new RuntimeException("Sub-query not a TObject");
            }
            TObject tob = (TObject)ob;
            if (tob.getTType() instanceof TArrayType) {
                Expression[] list = (Expression[])tob.getObject();
                DataTableColumnDef col = this.getColumnDefAt(this.findFieldName(lhs_var));
                DatabaseQueryContext db_context = (DatabaseQueryContext)context;
                TemporaryTable table = new TemporaryTable(db_context.getDatabase(), "single", new DataTableColumnDef[]{col});
                for (int i = 0; i < list.length; ++i) {
                    table.newRow();
                    table.setRowObject(list[i].evaluate(null, null, context), 0);
                }
                table.setupAllSelectableSchemes();
                return TableFunctions.anyAllNonCorrelated(this, new Variable[]{lhs_var}, op, table);
            }
            throw new RuntimeException("Error with format or RHS expression.");
        }
        if (op.is("like") || op.is("not like") || op.is("regex")) {
            TObject rhs_const = rhs.evaluate(null, context);
            rows = op.is("regex") ? this.selectFromRegex(column, op, rhs_const) : this.selectFromPattern(column, op, rhs_const);
            ordered_by_select_column = true;
            if (DEBUG_QUERY) {
                DEBUG_SELECT_WITH = op.toString() + " " + rhs_const;
            }
        } else {
            DataTableColumnDef col_def = this.getColumnDefAt(column);
            if (!col_def.isIndexableType()) {
                throw new StatementException("Can not search on field type " + col_def.getSQLTypeString() + " in '" + col_def.getName() + "'");
            }
            TObject rhs_const = rhs.evaluate(null, context);
            rows = this.selectRows(column, op, rhs_const);
            ordered_by_select_column = true;
            if (DEBUG_QUERY) {
                DEBUG_SELECT_WITH = op.toString() + " " + rhs_const;
            }
        }
        VirtualTable table = new VirtualTable(this);
        table.set(this, rows);
        if (ordered_by_select_column) {
            table.optimisedPostSet(column);
        }
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, table + " = " + this + ".simpleSelect(" + lhs_var + " " + DEBUG_SELECT_WITH + " )");
        }
        return table;
    }

    public final Table simpleJoin(QueryContext context, Table table, Variable lhs_var, Operator op, Expression rhs) {
        int lhs_column = this.findFieldName(lhs_var);
        if (lhs_column == -1) {
            throw new RuntimeException("Unable to find the LHS column specified in the condition: " + lhs_var.toString());
        }
        TableVariableResolver resolver = table.getVariableResolver();
        IntegerVector this_row_set = new IntegerVector();
        IntegerVector table_row_set = new IntegerVector();
        RowEnumeration e = table.rowEnumeration();
        while (e.hasMoreRows()) {
            int row_index = e.nextRowIndex();
            resolver.setRow(row_index);
            TObject rhs_val = rhs.evaluate(resolver, context);
            IntegerVector selected_set = this.selectRows(lhs_column, op, rhs_val);
            int size = selected_set.size();
            for (int i = 0; i < size; ++i) {
                table_row_set.addInt(row_index);
            }
            this_row_set.append(selected_set);
        }
        Table[] tabs = new Table[]{this, table};
        IntegerVector[] row_sets = new IntegerVector[]{this_row_set, table_row_set};
        VirtualTable out_table = new VirtualTable(tabs);
        out_table.set(tabs, row_sets);
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, out_table + " = " + this + ".simpleJoin(" + table + ", " + lhs_var + ", " + op + ", " + rhs + " )");
        }
        return out_table;
    }

    public final Table exhaustiveSelect(QueryContext context, Expression exp) {
        Table result = this;
        int row_count = this.getRowCount();
        if (row_count > 0) {
            TableVariableResolver resolver = this.getVariableResolver();
            RowEnumeration e = this.rowEnumeration();
            IntegerVector selected_set = new IntegerVector(row_count);
            while (e.hasMoreRows()) {
                int row_index = e.nextRowIndex();
                resolver.setRow(row_index);
                TObject rhs_val = exp.evaluate(resolver, context);
                if (rhs_val.isNull() || !(rhs_val.getTType() instanceof TBooleanType) || !rhs_val.getObject().equals(Boolean.TRUE)) continue;
                selected_set.addInt(row_index);
            }
            VirtualTable table = new VirtualTable(this);
            table.set(this, selected_set);
            result = table;
        }
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, result + " = " + this + ".exhaustiveSelect(" + exp + " )");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table any(QueryContext context, Expression lhs, Operator op, Table right_table) {
        void var11_14;
        IntegerVector select_vec;
        int lhs_col_index;
        Table source_table;
        Table table = right_table;
        if (table.getColumnCount() != 1) {
            throw new Error("Input table <> 1 columns.");
        }
        if (this.getRowCount() == 0) {
            return this;
        }
        if (table.getRowCount() == 0) {
            return this.emptySelect();
        }
        if (lhs.isConstant()) {
            TObject lhs_const = lhs.evaluate(null, context);
            IntegerVector ivec = table.selectRows(0, op, lhs_const);
            if (ivec.size() <= 0) return this.emptySelect();
            return this;
        }
        Variable lhs_var = lhs.getVariable();
        if (lhs_var == null) {
            DatabaseQueryContext db_context = (DatabaseQueryContext)context;
            FunctionTable fun_table = new FunctionTable(this, new Expression[]{lhs}, new String[]{"1"}, db_context);
            source_table = fun_table;
            lhs_col_index = 0;
        } else {
            source_table = this;
            lhs_col_index = source_table.findFieldName(lhs_var);
            if (lhs_col_index == -1) {
                throw new Error("Can't find column '" + lhs_var + "'.");
            }
        }
        DataTableColumnDef source_col = source_table.getColumnDefAt(lhs_col_index);
        DataTableColumnDef dest_col = table.getColumnDefAt(0);
        if (!source_col.getTType().comparableTypes(dest_col.getTType())) {
            throw new Error("The type of the sub-query expression " + source_col.getSQLTypeString() + " is incompatible " + "with the sub-query " + dest_col.getSQLTypeString() + ".");
        }
        if (op.is(">") || op.is(">=")) {
            TObject lowest_cell = table.getFirstCellContent(0);
            select_vec = source_table.selectRows(lhs_col_index, op, lowest_cell);
        } else if (op.is("<") || op.is("<=")) {
            TObject highest_cell = table.getLastCellContent(0);
            select_vec = source_table.selectRows(lhs_col_index, op, highest_cell);
        } else if (op.is("=")) {
            select_vec = INHelper.in(source_table, table, lhs_col_index, 0);
        } else {
            if (!op.is("<>")) throw new Error("Don't understand operator '" + op + "' in ANY.");
            TObject cell = table.getSingleCellContent(0);
            if (cell == null) return this;
            select_vec = source_table.selectRows(lhs_col_index, op, cell);
        }
        VirtualTable rtable = new VirtualTable(this);
        rtable.set(this, (IntegerVector)var11_14);
        if (!this.Debug().isInterestedIn(10)) return rtable;
        this.Debug().write(10, this, rtable + " = " + this + ".any(" + lhs + ", " + op + ", " + right_table + ")");
        return rtable;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table all(QueryContext context, Expression lhs, Operator op, Table table) {
        void var10_16;
        IntegerVector select_vec;
        int lhs_col_index;
        Table source_table;
        if (table.getColumnCount() != 1) {
            throw new Error("Input table <> 1 columns.");
        }
        if (this.getRowCount() == 0) {
            return this;
        }
        if (table.getRowCount() == 0) {
            return this;
        }
        if (lhs.isConstant()) {
            boolean compared_to_true;
            TObject lhs_const = lhs.evaluate(null, context);
            if (op.is(">") || op.is(">=")) {
                TObject cell = table.getLastCellContent(0);
                compared_to_true = Table.compareCells(lhs_const, cell, op);
            } else if (op.is("<") || op.is("<=")) {
                TObject cell = table.getFirstCellContent(0);
                compared_to_true = Table.compareCells(lhs_const, cell, op);
            } else if (op.is("=")) {
                TObject cell = table.getSingleCellContent(0);
                compared_to_true = cell != null && Table.compareCells(lhs_const, cell, op);
            } else {
                if (!op.is("<>")) throw new Error("Don't understand operator '" + op + "' in ALL.");
                compared_to_true = !table.columnContainsCell(0, lhs_const);
            }
            if (!compared_to_true) return this.emptySelect();
            return this;
        }
        Variable lhs_var = lhs.getVariable();
        if (lhs_var == null) {
            DatabaseQueryContext db_context = (DatabaseQueryContext)context;
            FunctionTable fun_table = new FunctionTable(this, new Expression[]{lhs}, new String[]{"1"}, db_context);
            source_table = fun_table;
            lhs_col_index = 0;
        } else {
            source_table = this;
            lhs_col_index = source_table.findFieldName(lhs_var);
            if (lhs_col_index == -1) {
                throw new Error("Can't find column '" + lhs_var + "'.");
            }
        }
        DataTableColumnDef source_col = source_table.getColumnDefAt(lhs_col_index);
        DataTableColumnDef dest_col = table.getColumnDefAt(0);
        if (!source_col.getTType().comparableTypes(dest_col.getTType())) {
            throw new Error("The type of the sub-query expression " + source_col.getSQLTypeString() + " is incompatible " + "with the sub-query " + dest_col.getSQLTypeString() + ".");
        }
        if (op.is(">") || op.is(">=")) {
            TObject highest_cell = table.getLastCellContent(0);
            select_vec = source_table.selectRows(lhs_col_index, op, highest_cell);
        } else if (op.is("<") || op.is("<=")) {
            TObject lowest_cell = table.getFirstCellContent(0);
            select_vec = source_table.selectRows(lhs_col_index, op, lowest_cell);
        } else if (op.is("=")) {
            TObject single_cell = table.getSingleCellContent(0);
            if (single_cell == null) return this.emptySelect();
            select_vec = source_table.selectRows(lhs_col_index, op, single_cell);
        } else {
            if (!op.is("<>")) throw new Error("Don't understand operator '" + op + "' in ALL.");
            select_vec = INHelper.notIn(source_table, table, lhs_col_index, 0);
        }
        VirtualTable rtable = new VirtualTable(this);
        rtable.set(this, (IntegerVector)var10_16);
        if (!this.Debug().isInterestedIn(10)) return rtable;
        this.Debug().write(10, this, rtable + " = " + this + ".all(" + lhs + ", " + op + ", " + table + ")");
        return rtable;
    }

    public final Table join(Table table) {
        JoinedTable out_table;
        boolean QUICK_NAT_JOIN = true;
        if (QUICK_NAT_JOIN) {
            out_table = new NaturallyJoinedTable(this, table);
        } else {
            Table[] tabs = new Table[]{this, table};
            IntegerVector[] row_sets = new IntegerVector[2];
            if (this.getRowCount() == 0 || table.getRowCount() == 0) {
                row_sets[0] = new IntegerVector(0);
                row_sets[1] = new IntegerVector(0);
            } else {
                IntegerVector this_row_set = new IntegerVector();
                IntegerVector table_row_set = new IntegerVector();
                IntegerVector table_selected_set = new IntegerVector();
                RowEnumeration e = table.rowEnumeration();
                while (e.hasMoreRows()) {
                    int row_index = e.nextRowIndex();
                    table_selected_set.addInt(row_index);
                }
                int table_selected_set_size = table_selected_set.size();
                e = this.rowEnumeration();
                while (e.hasMoreRows()) {
                    int row_index = e.nextRowIndex();
                    for (int i = 0; i < table_selected_set_size; ++i) {
                        this_row_set.addInt(row_index);
                    }
                    table_row_set.append(table_selected_set);
                }
                row_sets[0] = this_row_set;
                row_sets[1] = table_row_set;
            }
            VirtualTable virt_table = new VirtualTable(tabs);
            virt_table.set(tabs, row_sets);
            out_table = virt_table;
        }
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, out_table + " = " + this + ".naturalJoin(" + table + " )");
        }
        return out_table;
    }

    public final VirtualTable outside(Table rtable) {
        IntegerVector row_list = new IntegerVector(rtable.getRowCount());
        RowEnumeration e = rtable.rowEnumeration();
        while (e.hasMoreRows()) {
            row_list.addInt(e.nextRowIndex());
        }
        int col_index = rtable.findFieldName(this.getResolvedVariable(0));
        rtable.setToRowTableDomain(col_index, row_list, this);
        IntegerVector this_table_set = new IntegerVector(this.getRowCount());
        e = this.rowEnumeration();
        while (e.hasMoreRows()) {
            this_table_set.addInt(e.nextRowIndex());
        }
        this_table_set.quickSort();
        row_list.quickSort();
        IntegerVector result_list = new IntegerVector(96);
        int size = this_table_set.size();
        int row_list_index = 0;
        int row_list_size = row_list.size();
        for (int i = 0; i < size; ++i) {
            int this_val = this_table_set.intAt(i);
            if (row_list_index < row_list_size) {
                int in_val = row_list.intAt(row_list_index);
                if (this_val < in_val) {
                    result_list.addInt(this_val);
                    continue;
                }
                if (this_val == in_val) {
                    while (row_list_index < row_list_size && row_list.intAt(row_list_index) == in_val) {
                        ++row_list_index;
                    }
                    continue;
                }
                throw new Error("'this_val' > 'in_val'");
            }
            result_list.addInt(this_val);
        }
        VirtualTable table = new VirtualTable(this);
        table.set(this, result_list);
        return table;
    }

    public final Table union(Table table) {
        if (this.getRowCount() == 0 && table.getRowCount() == 0 || table.getRowCount() == 0) {
            if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
                this.Debug().write(10, this, this + " = " + this + ".union(" + table + " )");
            }
            return this;
        }
        if (this.getRowCount() == 0) {
            if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
                this.Debug().write(10, this, table + " = " + this + ".union(" + table + " )");
            }
            return table;
        }
        RawTableInformation raw1 = this.resolveToRawTable(new RawTableInformation());
        RawTableInformation raw2 = table.resolveToRawTable(new RawTableInformation());
        raw1.union(raw2);
        Table[] table_list = raw1.getTables();
        VirtualTable table_out = new VirtualTable(table_list);
        table_out.set(table_list, raw1.getRows());
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, table_out + " = " + this + ".union(" + table + " )");
        }
        return table_out;
    }

    public final VirtualTable distinct() {
        RawTableInformation raw = this.resolveToRawTable(new RawTableInformation());
        raw.removeDuplicates();
        Table[] table_list = raw.getTables();
        VirtualTable table_out = new VirtualTable(table_list);
        table_out.set(table_list, raw.getRows());
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, table_out + " = " + this + ".distinct()");
        }
        return table_out;
    }

    public final Table distinct(int[] col_map) {
        IntegerVector result_list = new IntegerVector();
        IntegerVector row_list = this.orderedRowList(col_map);
        int r_count = row_list.size();
        int previous_row = -1;
        for (int i = 0; i < r_count; ++i) {
            int row_index = row_list.intAt(i);
            if (previous_row != -1) {
                boolean equal = true;
                for (int n = 0; n < col_map.length && equal; ++n) {
                    TObject c1 = this.getCellContents(col_map[n], row_index);
                    TObject c2 = this.getCellContents(col_map[n], previous_row);
                    equal = equal && c1.compareTo(c2) == 0;
                }
                if (!equal) {
                    result_list.addInt(row_index);
                }
            } else {
                result_list.addInt(row_index);
            }
            previous_row = row_index;
        }
        VirtualTable vt = new VirtualTable(this);
        vt.set(this, result_list);
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, vt + " = " + this + ".distinct(" + col_map + ")");
        }
        return vt;
    }

    private final int indexStringArray(String val, String[] array) {
        for (int n = 0; n < array.length; ++n) {
            if (!array[n].equals(val)) continue;
            return n;
        }
        return -1;
    }

    public final boolean columnContainsValue(int column, TObject ob) {
        return this.columnMatchesValue(column, Operator.get("="), ob);
    }

    public final boolean columnMatchesValue(int column, Operator op, TObject ob) {
        IntegerVector ivec = this.selectRows(column, op, ob);
        return ivec.size() > 0;
    }

    public final boolean allColumnMatchesValue(int column, Operator op, TObject ob) {
        IntegerVector ivec = this.selectRows(column, op, ob);
        return ivec.size() == this.getRowCount();
    }

    public final Table orderByColumns(int[] col_map) {
        Table work = this;
        for (int i = col_map.length - 1; i >= 0; --i) {
            work = work.orderByColumn(col_map[i], true);
        }
        if (this.getRowCount() != work.getRowCount()) {
            throw new Error("Internal Error, row count != sorted row count");
        }
        return work;
    }

    public final IntegerVector orderedRowList(int[] col_map) {
        Table work = this.orderByColumns(col_map);
        int r_count = this.getRowCount();
        IntegerVector row_list = new IntegerVector(r_count);
        RowEnumeration e = work.rowEnumeration();
        while (e.hasMoreRows()) {
            row_list.addInt(e.nextRowIndex());
        }
        work.setToRowTableDomain(0, row_list, this);
        return row_list;
    }

    public final VirtualTable orderByColumn(int col_index, boolean ascending) {
        DataTableColumnDef col_def = this.getColumnDefAt(col_index);
        IntegerVector rows = this.selectAll(col_index);
        if (!ascending) {
            rows.reverse();
        }
        VirtualTable table = new VirtualTable(this);
        table.set(this, rows);
        if (DEBUG_QUERY && this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, table + " = " + this + ".orderByColumn(" + col_index + ", " + ascending + ")");
        }
        return table;
    }

    public final VirtualTable orderByColumn(Variable column, boolean ascending) {
        int col_index = this.findFieldName(column);
        if (col_index == -1) {
            throw new Error("Unknown column in 'orderByColumn' ( " + column + " )");
        }
        return this.orderByColumn(col_index, ascending);
    }

    public final VirtualTable orderByColumn(Variable column) {
        return this.orderByColumn(column, true);
    }

    public final TableAccessState getTableAccessState() {
        return new TableAccessState(this);
    }

    final IntegerVector selectRows(int[] cols, Operator op, TObject[] cells) {
        if (cols.length > 1) {
            throw new Error("Multi-column select not supported.");
        }
        return this.selectRows(cols[0], op, cells[0]);
    }

    final IntegerVector selectRows(int column, Operator op, TObject cell) {
        TType col_type = this.getTTypeForColumn(column);
        if (!cell.getTType().comparableTypes(col_type)) {
            return new IntegerVector(0);
        }
        SelectableScheme ss = this.getSelectableSchemeFor(column, column, this);
        if (op.is("=")) {
            return ss.selectEqual(cell);
        }
        if (op.is("<>")) {
            return ss.selectNotEqual(cell);
        }
        if (op.is(">")) {
            return ss.selectGreater(cell);
        }
        if (op.is("<")) {
            return ss.selectLess(cell);
        }
        if (op.is(">=")) {
            return ss.selectGreaterOrEqual(cell);
        }
        if (op.is("<=")) {
            return ss.selectLessOrEqual(cell);
        }
        SelectableRangeSet range_set = new SelectableRangeSet();
        range_set.intersect(op, cell);
        return ss.selectRange(range_set.toSelectableRangeArray());
    }

    IntegerVector selectRows(int column, TObject min_cell, TObject max_cell) {
        TType col_type = this.getTTypeForColumn(column);
        if (!min_cell.getTType().comparableTypes(col_type) || !max_cell.getTType().comparableTypes(col_type)) {
            return new IntegerVector(0);
        }
        SelectableScheme ss = this.getSelectableSchemeFor(column, column, this);
        return ss.selectBetween(min_cell, max_cell);
    }

    final IntegerVector selectFromRegex(int column, Operator op, TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector(0);
        }
        return PatternSearch.regexSearch(this, column, ob.getObject().toString());
    }

    final IntegerVector selectFromPattern(int column, Operator op, TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector();
        }
        if (op.is("not like")) {
            IntegerVector like_set = PatternSearch.search(this, column, ob.toString());
            TObject null_cell = new TObject(ob.getTType(), null);
            IntegerVector original_set = this.selectRows(column, Operator.get("is not"), null_cell);
            int vec_size = Math.max(4, original_set.size() - like_set.size() + 4);
            IntegerVector result_set = new IntegerVector(vec_size);
            like_set.quickSort();
            int size = original_set.size();
            for (int i = 0; i < size; ++i) {
                int val = original_set.intAt(i);
                if (like_set.sortedIntCount(val) != 0) continue;
                result_set.addInt(val);
            }
            return result_set;
        }
        return PatternSearch.search(this, column, ob.toString());
    }

    final IntegerVector allRowsIn(int column, Table table) {
        IntegerVector iv = INHelper.in(this, table, column, 0);
        return iv;
    }

    final IntegerVector allRowsNotIn(int column, Table table) {
        return INHelper.notIn(this, table, column, 0);
    }

    public final IntegerVector selectAll(int column) {
        SelectableScheme ss = this.getSelectableSchemeFor(column, column, this);
        return ss.selectAll();
    }

    public final IntegerVector selectAll() {
        IntegerVector list = new IntegerVector(this.getRowCount());
        RowEnumeration rowEnumeration = this.rowEnumeration();
        while (rowEnumeration.hasMoreRows()) {
            list.addInt(rowEnumeration.nextRowIndex());
        }
        return list;
    }

    public final IntegerVector selectRange(int column, SelectableRange[] ranges) {
        SelectableScheme ss = this.getSelectableSchemeFor(column, column, this);
        return ss.selectRange(ranges);
    }

    public final IntegerVector selectLast(int column) {
        SelectableScheme ss = this.getSelectableSchemeFor(column, column, this);
        return ss.selectLast();
    }

    public final IntegerVector selectFirst(int column) {
        SelectableScheme ss = this.getSelectableSchemeFor(column, column, this);
        return ss.selectFirst();
    }

    public final IntegerVector selectRest(int column) {
        SelectableScheme ss = this.getSelectableSchemeFor(column, column, this);
        return ss.selectNotFirst();
    }

    private TObject[] singleArrayCellMap(TObject cell) {
        TObject[] tObjectArray;
        if (cell == null) {
            tObjectArray = null;
        } else {
            TObject[] tObjectArray2 = new TObject[1];
            tObjectArray = tObjectArray2;
            tObjectArray2[0] = cell;
        }
        return tObjectArray;
    }

    public final TObject getFirstCellContent(int column) {
        IntegerVector ivec = this.selectFirst(column);
        if (ivec.size() > 0) {
            return this.getCellContents(column, ivec.intAt(0));
        }
        return null;
    }

    public final TObject[] getFirstCellContent(int[] col_map) {
        if (col_map.length > 1) {
            throw new Error("Multi-column getLastCellContent not supported.");
        }
        return this.singleArrayCellMap(this.getFirstCellContent(col_map[0]));
    }

    public final TObject getLastCellContent(int column) {
        IntegerVector ivec = this.selectLast(column);
        if (ivec.size() > 0) {
            return this.getCellContents(column, ivec.intAt(0));
        }
        return null;
    }

    public final TObject[] getLastCellContent(int[] col_map) {
        if (col_map.length > 1) {
            throw new Error("Multi-column getLastCellContent not supported.");
        }
        return this.singleArrayCellMap(this.getLastCellContent(col_map[0]));
    }

    public final TObject getSingleCellContent(int column) {
        IntegerVector ivec = this.selectFirst(column);
        int sz = ivec.size();
        if (sz == this.getRowCount() && sz > 0) {
            return this.getCellContents(column, ivec.intAt(0));
        }
        return null;
    }

    public final TObject[] getSingleCellContent(int[] col_map) {
        if (col_map.length > 1) {
            throw new Error("Multi-column getSingleCellContent not supported.");
        }
        return this.singleArrayCellMap(this.getSingleCellContent(col_map[0]));
    }

    public final boolean columnContainsCell(int column, TObject cell) {
        IntegerVector ivec = this.selectRows(column, Operator.get("="), cell);
        return ivec.size() > 0;
    }

    public static boolean compareCells(TObject ob1, TObject ob2, Operator op) {
        TObject result = op.eval(ob1, ob2, null, null, null);
        return result.toBoolean();
    }

    public Map toMap() {
        if (this.getColumnCount() == 2) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            RowEnumeration rowEnumeration = this.rowEnumeration();
            while (rowEnumeration.hasMoreRows()) {
                int row_index = rowEnumeration.nextRowIndex();
                TObject key = this.getCellContents(0, row_index);
                TObject value = this.getCellContents(1, row_index);
                map.put(key.getObject().toString(), value.getObject());
            }
            return map;
        }
        throw new Error("Table must have two columns.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int fastFindFieldName(Variable col) {
        Object object = this.COL_LOOKUP_LOCK;
        synchronized (object) {
            Object ob;
            if (this.col_name_lookup == null) {
                this.col_name_lookup = new HashMap(30);
            }
            if ((ob = this.col_name_lookup.get(col)) == null) {
                int ci = this.findFieldName(col);
                this.col_name_lookup.put(col, new Integer(ci));
                return ci;
            }
            return (Integer)ob;
        }
    }

    final TableVariableResolver getVariableResolver() {
        return new TableVariableResolver();
    }

    public String toString() {
        String name = "VT" + this.hashCode();
        if (this instanceof AbstractDataTable) {
            name = ((AbstractDataTable)this).getTableName().toString();
        }
        return name + "[" + this.getRowCount() + "]";
    }

    public void printGraph(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.println("T[" + this.getClass() + "]");
    }

    final class TableVariableResolver
    implements VariableResolver {
        private int row_index = -1;

        TableVariableResolver() {
        }

        public void setRow(int row_index) {
            this.row_index = row_index;
        }

        private int findColumnName(Variable variable) {
            int col_index = Table.this.fastFindFieldName(variable);
            if (col_index == -1) {
                throw new Error("Can't find column: " + variable);
            }
            return col_index;
        }

        public int setID() {
            return this.row_index;
        }

        public TObject resolve(Variable variable) {
            return Table.this.getCellContents(this.findColumnName(variable), this.row_index);
        }

        public TType returnTType(Variable variable) {
            return Table.this.getTTypeForColumn(variable);
        }
    }
}

