/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TType;
import com.mckoi.database.global.StringAccessor;
import java.io.IOException;
import java.io.Reader;
import java.text.Collator;
import java.util.Locale;

public final class TStringType
extends TType {
    static final long serialVersionUID = -4189752898050725908L;
    private int max_size;
    private Locale locale;
    private int strength;
    private int decomposition;
    private transient Collator collator;
    static /* synthetic */ Class class$com$mckoi$database$global$StringAccessor;

    public TStringType(int sql_type, int max_size, Locale locale, int strength, int decomposition) {
        super(sql_type);
        this.max_size = max_size;
        this.strength = strength;
        this.decomposition = decomposition;
        this.locale = locale;
    }

    public TStringType(int sql_type, int max_size, String locale_str, int strength, int decomposition) {
        super(sql_type);
        this.max_size = max_size;
        this.strength = strength;
        this.decomposition = decomposition;
        if (locale_str != null && locale_str.length() >= 2) {
            String language = locale_str.substring(0, 2);
            String country = "";
            String variant = "";
            if (locale_str.length() > 2) {
                country = locale_str.substring(2, 4);
                if (locale_str.length() > 4) {
                    variant = locale_str.substring(4);
                }
            }
            this.locale = new Locale(language, country, variant);
        }
    }

    public TStringType(int sql_type, int max_size, String locale_str) {
        this(sql_type, max_size, locale_str, -1, -1);
    }

    public int getMaximumSize() {
        return this.max_size;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getDecomposition() {
        return this.decomposition;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocaleString() {
        if (this.locale == null) {
            return "";
        }
        StringBuffer locale_str = new StringBuffer();
        locale_str.append(this.locale.getLanguage());
        locale_str.append(this.locale.getCountry());
        locale_str.append(this.locale.getVariant());
        return new String(locale_str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int lexicographicalOrder(StringAccessor str1, StringAccessor str2) {
        long str1_size = str1.length();
        long str2_size = str2.length();
        if (str1_size < 32768L && str2_size < 32768L) {
            return ((Object)str1).toString().compareTo(((Object)str2).toString());
        }
        Reader r1 = str1.getReader();
        Reader r2 = str2.getReader();
        try {
            try {
                int c1;
                for (long size = Math.min(str1_size, str2_size); size > 0L; --size) {
                    int c2;
                    c1 = r1.read();
                    if (c1 == (c2 = r2.read())) continue;
                    int n = c1 - c2;
                    return n;
                }
                if (str1_size > str2_size) {
                    c1 = 1;
                    return c1;
                }
                if (str1_size < str2_size) {
                    c1 = -1;
                    return c1;
                }
                c1 = 0;
                return c1;
            }
            finally {
                r1.close();
                r2.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
    }

    private synchronized Collator getCollator() {
        if (this.collator != null) {
            return this.collator;
        }
        this.collator = Collator.getInstance(this.locale);
        int strength = this.getStrength();
        int decomposition = this.getStrength();
        if (strength >= 0) {
            this.collator.setStrength(strength);
        }
        if (decomposition >= 0) {
            this.collator.setDecomposition(decomposition);
        }
        return this.collator;
    }

    public boolean comparableTypes(TType type) {
        if (type instanceof TStringType) {
            TStringType s_type = (TStringType)type;
            if (this.getLocale() == null || s_type.getLocale() == null) {
                return true;
            }
            return this.getLocale().equals(s_type.getLocale());
        }
        return false;
    }

    public int compareObs(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return 0;
        }
        if (this.locale == null) {
            return this.lexicographicalOrder((StringAccessor)ob1, (StringAccessor)ob2);
        }
        return this.getCollator().compare(ob1.toString(), ob2.toString());
    }

    public int calculateApproximateMemoryUse(Object ob) {
        if (ob != null) {
            return ((StringAccessor)ob).length() * 2 + 24;
        }
        return 32;
    }

    public Class javaClass() {
        return class$com$mckoi$database$global$StringAccessor == null ? (class$com$mckoi$database$global$StringAccessor = TStringType.class$("com.mckoi.database.global.StringAccessor")) : class$com$mckoi$database$global$StringAccessor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

