/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.FixedSizeDataStore;
import com.mckoi.debug.DebugLogger;
import com.mckoi.store.AreaWriter;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.ByteArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class StateStore {
    private int MAGIC = 195854337;
    private Store store;
    private int table_id;
    private MutableArea header_area;
    private long vis_p;
    private long del_p;
    private ArrayList visible_list;
    private ArrayList delete_list;
    private boolean vis_list_change;
    private boolean del_list_change;

    public StateStore(Store store) {
        this.store = store;
        this.vis_list_change = false;
        this.del_list_change = false;
    }

    private void removeResource(ArrayList list, String name) {
        int sz = list.size();
        for (int i = 0; i < sz; ++i) {
            StateResource resource = (StateResource)list.get(i);
            if (!name.equals(resource.name)) continue;
            list.remove(i);
            return;
        }
        throw new RuntimeException("Couldn't find resource '" + name + "' in list.");
    }

    private void readStateResourceList(ArrayList list, long pointer) throws IOException {
        DataInputStream d_in = new DataInputStream(this.store.getAreaInputStream(pointer));
        int version = d_in.readInt();
        int count = (int)d_in.readLong();
        for (int i = 0; i < count; ++i) {
            long table_id = d_in.readLong();
            String name = d_in.readUTF();
            StateResource resource = new StateResource(table_id, name);
            list.add(resource);
        }
        d_in.close();
    }

    private void writeStateResourceList(ArrayList list, DataOutputStream d_out) throws IOException {
        d_out.writeInt(1);
        int sz = list.size();
        d_out.writeLong(sz);
        for (int i = 0; i < sz; ++i) {
            StateResource resource = (StateResource)list.get(i);
            d_out.writeLong(resource.table_id);
            d_out.writeUTF(resource.name);
        }
    }

    private long writeListToStore(ArrayList list) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream d_out = new DataOutputStream(bout);
        this.writeStateResourceList(list, d_out);
        d_out.flush();
        d_out.close();
        byte[] buf = bout.toByteArray();
        AreaWriter a = this.store.createArea(buf.length);
        long list_p = a.getID();
        a.put(buf);
        a.finish();
        return list_p;
    }

    public synchronized long create() throws IOException {
        AreaWriter vis_tables_area = this.store.createArea(12L);
        AreaWriter del_tables_area = this.store.createArea(12L);
        this.vis_p = vis_tables_area.getID();
        this.del_p = del_tables_area.getID();
        vis_tables_area.putInt(1);
        vis_tables_area.putLong(0L);
        vis_tables_area.finish();
        del_tables_area.putInt(1);
        del_tables_area.putLong(0L);
        del_tables_area.finish();
        AreaWriter header_writer = this.store.createArea(32L);
        long header_p = header_writer.getID();
        header_writer.putInt(this.MAGIC);
        header_writer.putInt(0);
        header_writer.putLong(0L);
        header_writer.putLong(this.vis_p);
        header_writer.putLong(this.del_p);
        header_writer.finish();
        this.header_area = this.store.getMutableArea(header_p);
        this.table_id = 0;
        this.visible_list = new ArrayList();
        this.delete_list = new ArrayList();
        return header_p;
    }

    public synchronized void init(long header_p) throws IOException {
        this.header_area = this.store.getMutableArea(header_p);
        int mag_value = this.header_area.getInt();
        if (mag_value != this.MAGIC) {
            throw new IOException("Magic value for state header area is incorrect.");
        }
        if (this.header_area.getInt() != 0) {
            throw new IOException("Unknown version for state header area.");
        }
        this.table_id = (int)this.header_area.getLong();
        this.vis_p = this.header_area.getLong();
        this.del_p = this.header_area.getLong();
        this.visible_list = new ArrayList();
        this.delete_list = new ArrayList();
        this.readStateResourceList(this.visible_list, this.vis_p);
        this.readStateResourceList(this.delete_list, this.del_p);
    }

    public synchronized long convert(File legacy_sf, DebugLogger debug) throws IOException {
        long header_p = this.create();
        FixedSizeDataStore state_file = new FixedSizeDataStore(legacy_sf, 507, debug);
        state_file.open(true);
        byte[] reserved_buffer = new byte[64];
        state_file.readReservedBuffer(reserved_buffer, 0, 64);
        int tables_sector = ByteArrayUtil.getInt(reserved_buffer, 4);
        InputStream sin = state_file.getSectorInputStream(tables_sector);
        DataInputStream din = new DataInputStream(sin);
        int vtver = din.readInt();
        int size = din.readInt();
        for (int i = 0; i < size; ++i) {
            int table_id = din.readInt();
            String resource_name = din.readUTF();
            if (!resource_name.startsWith(":")) {
                resource_name = ":1" + resource_name;
            }
            this.addVisibleResource(new StateResource(table_id, resource_name));
        }
        din.close();
        int dropped_sector = ByteArrayUtil.getInt(reserved_buffer, 12);
        if (dropped_sector > -1) {
            sin = state_file.getSectorInputStream(dropped_sector);
            din = new DataInputStream(sin);
            int dsver = din.readInt();
            size = din.readInt();
            for (int i = 0; i < size; ++i) {
                String resource_name = din.readUTF();
                if (!resource_name.startsWith(":")) {
                    resource_name = ":1" + resource_name;
                }
                this.addDeleteResource(new StateResource(-1L, resource_name));
            }
            din.close();
        }
        int state_sector = ByteArrayUtil.getInt(reserved_buffer, 8);
        sin = state_file.getSectorInputStream(state_sector);
        din = new DataInputStream(sin);
        din.readInt();
        int conv_table_id = din.readInt();
        din.close();
        state_file.close();
        this.header_area.position(8);
        this.header_area.putLong(conv_table_id);
        this.header_area.checkOut();
        this.commit();
        return header_p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int nextTableID() throws IOException {
        int cur_counter = this.table_id++;
        try {
            this.store.lockForWrite();
            this.header_area.position(8);
            this.header_area.putLong(this.table_id);
            this.header_area.checkOut();
        }
        finally {
            this.store.unlockForWrite();
        }
        return cur_counter;
    }

    public synchronized StateResource[] getVisibleList() {
        return this.visible_list.toArray(new StateResource[this.visible_list.size()]);
    }

    public synchronized StateResource[] getDeleteList() {
        return this.delete_list.toArray(new StateResource[this.delete_list.size()]);
    }

    public synchronized boolean containsVisibleResource(int table_id) {
        int sz = this.visible_list.size();
        for (int i = 0; i < sz; ++i) {
            if (((StateResource)this.visible_list.get((int)i)).table_id != (long)table_id) continue;
            return true;
        }
        return false;
    }

    public synchronized void addVisibleResource(StateResource resource) {
        this.visible_list.add(resource);
        this.vis_list_change = true;
    }

    public synchronized void addDeleteResource(StateResource resource) {
        this.delete_list.add(resource);
        this.del_list_change = true;
    }

    public synchronized void removeVisibleResource(String name) {
        this.removeResource(this.visible_list, name);
        this.vis_list_change = true;
    }

    public synchronized void removeDeleteResource(String name) {
        this.removeResource(this.delete_list, name);
        this.del_list_change = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean commit() throws IOException {
        boolean changes = false;
        long new_vis_p = this.vis_p;
        long new_del_p = this.del_p;
        try {
            this.store.lockForWrite();
            if (this.vis_list_change) {
                new_vis_p = this.writeListToStore(this.visible_list);
                this.vis_list_change = false;
                changes = true;
            }
            if (this.del_list_change) {
                new_del_p = this.writeListToStore(this.delete_list);
                this.del_list_change = false;
                changes = true;
            }
            if (changes) {
                this.header_area.position(16);
                this.header_area.putLong(new_vis_p);
                this.header_area.putLong(new_del_p);
                this.header_area.checkOut();
                if (this.vis_p != new_vis_p) {
                    this.store.deleteArea(this.vis_p);
                    this.vis_p = new_vis_p;
                }
                if (this.del_p != new_del_p) {
                    this.store.deleteArea(this.del_p);
                    this.del_p = new_del_p;
                }
            }
        }
        finally {
            this.store.unlockForWrite();
        }
        return changes;
    }

    static class StateResource {
        long table_id;
        String name;

        public StateResource(long table_id, String name) {
            this.table_id = table_id;
            this.name = name;
        }
    }
}

