/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.SimpleTableQuery;
import com.mckoi.database.SimpleTransaction;
import com.mckoi.database.StatementException;
import com.mckoi.database.TObject;
import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.TransactionException;
import com.mckoi.database.global.StringObject;
import com.mckoi.util.BigNumber;
import com.mckoi.util.IntegerVector;
import java.util.HashMap;

final class SequenceManager {
    private TableDataConglomerate conglomerate;
    private HashMap sequence_key_map;
    private static final TObject ONE_VAL = TObject.intVal(1);
    private static final TObject TRUE_VAL = TObject.booleanVal(true);

    SequenceManager(TableDataConglomerate conglomerate) {
        this.conglomerate = conglomerate;
        this.sequence_key_map = new HashMap();
    }

    private Transaction getTransaction() {
        return this.conglomerate.createTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SequenceGenerator getGenerator(TableName name) {
        SequenceGenerator generator = (SequenceGenerator)this.sequence_key_map.get(name);
        if (generator == null) {
            Transaction sequence_access_transaction = this.getTransaction();
            try {
                MutableTableDataSource seqi = sequence_access_transaction.getTable(TableDataConglomerate.SYS_SEQUENCE_INFO);
                SimpleTableQuery query = new SimpleTableQuery(seqi);
                StringObject schema_val = StringObject.fromString(name.getSchema());
                StringObject name_val = StringObject.fromString(name.getName());
                IntegerVector ivec = query.selectIndexesEqual(2, name_val, 1, schema_val);
                if (ivec.size() == 0) {
                    throw new StatementException("Sequence generator '" + name + "' not found.");
                }
                if (ivec.size() > 1) {
                    throw new RuntimeException("Assert failed: multiple sequence keys with same name.");
                }
                int row_i = ivec.intAt(0);
                TObject sid = seqi.getCellContents(0, row_i);
                TObject sschema = seqi.getCellContents(1, row_i);
                TObject sname = seqi.getCellContents(2, row_i);
                TObject stype = seqi.getCellContents(3, row_i);
                long id_val = sid.toBigNumber().longValue();
                query.dispose();
                if (stype.operatorEquals(ONE_VAL).valuesEqual(TRUE_VAL)) {
                    generator = new SequenceGenerator(id_val, name);
                } else {
                    MutableTableDataSource seq = sequence_access_transaction.getTable(TableDataConglomerate.SYS_SEQUENCE);
                    query = new SimpleTableQuery(seq);
                    ivec = query.selectIndexesEqual(0, sid);
                    if (ivec.size() == 0) {
                        throw new RuntimeException("Sequence table does not contain sequence information.");
                    }
                    if (ivec.size() > 1) {
                        throw new RuntimeException("Sequence table contains multiple generators for id.");
                    }
                    row_i = ivec.intAt(0);
                    BigNumber last_value = seq.getCellContents(1, row_i).toBigNumber();
                    BigNumber increment = seq.getCellContents(2, row_i).toBigNumber();
                    BigNumber minvalue = seq.getCellContents(3, row_i).toBigNumber();
                    BigNumber maxvalue = seq.getCellContents(4, row_i).toBigNumber();
                    BigNumber start = seq.getCellContents(5, row_i).toBigNumber();
                    BigNumber cache = seq.getCellContents(6, row_i).toBigNumber();
                    Boolean cycle = seq.getCellContents(7, row_i).toBoolean();
                    query.dispose();
                    generator = new SequenceGenerator(id_val, name, last_value.longValue(), increment.longValue(), minvalue.longValue(), maxvalue.longValue(), start.longValue(), cache.longValue(), cycle);
                    this.sequence_key_map.put(name, generator);
                }
                Object var25_23 = null;
            }
            catch (Throwable throwable) {
                Object var25_24 = null;
                try {
                    sequence_access_transaction.closeAndCommit();
                }
                catch (TransactionException e) {
                    this.conglomerate.Debug().writeException(e);
                    throw new RuntimeException("Transaction Error: " + e.getMessage());
                }
                throw throwable;
            }
            try {
                sequence_access_transaction.closeAndCommit();
            }
            catch (TransactionException e) {
                this.conglomerate.Debug().writeException(e);
                throw new RuntimeException("Transaction Error: " + e.getMessage());
            }
        }
        return generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGeneratorState(SequenceGenerator generator) {
        Transaction sequence_access_transaction = this.getTransaction();
        try {
            MutableTableDataSource seq = sequence_access_transaction.getTable(TableDataConglomerate.SYS_SEQUENCE);
            SimpleTableQuery query = new SimpleTableQuery(seq);
            IntegerVector ivec = query.selectIndexesEqual(0, BigNumber.fromLong(generator.id));
            if (ivec.size() == 0) {
                throw new StatementException("Sequence '" + generator.name + "' not found.");
            }
            if (ivec.size() > 1) {
                throw new RuntimeException("Assert failed: multiple id for sequence.");
            }
            int row_i = ivec.intAt(0);
            RowData row_data = new RowData(seq);
            row_data.setColumnDataFromTObject(0, TObject.longVal(generator.id));
            row_data.setColumnDataFromTObject(1, TObject.longVal(generator.last_value));
            row_data.setColumnDataFromTObject(2, TObject.longVal(generator.increment_by));
            row_data.setColumnDataFromTObject(3, TObject.longVal(generator.min_value));
            row_data.setColumnDataFromTObject(4, TObject.longVal(generator.max_value));
            row_data.setColumnDataFromTObject(5, TObject.longVal(generator.start));
            row_data.setColumnDataFromTObject(6, TObject.longVal(generator.cache));
            row_data.setColumnDataFromTObject(7, TObject.booleanVal(generator.cycle));
            seq.updateRow(row_i, row_data);
            query.dispose();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                sequence_access_transaction.closeAndCommit();
            }
            catch (TransactionException e) {
                this.conglomerate.Debug().writeException(e);
                throw new RuntimeException("Transaction Error: " + e.getMessage());
            }
            throw throwable;
        }
        try {
            sequence_access_transaction.closeAndCommit();
        }
        catch (TransactionException e) {
            this.conglomerate.Debug().writeException(e);
            throw new RuntimeException("Transaction Error: " + e.getMessage());
        }
    }

    synchronized void flushGenerator(TableName name) {
        this.sequence_key_map.remove(name);
    }

    static void addNativeTableGenerator(Transaction transaction, TableName table_name) {
        if (table_name.equals(TableDataConglomerate.SYS_SEQUENCE) || table_name.equals(TableDataConglomerate.SYS_SEQUENCE_INFO) || !transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE) || !transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE_INFO)) {
            return;
        }
        MutableTableDataSource table = transaction.getTable(TableDataConglomerate.SYS_SEQUENCE_INFO);
        long unique_id = transaction.nextUniqueID(TableDataConglomerate.SYS_SEQUENCE_INFO);
        RowData row_data = new RowData(table);
        row_data.setColumnDataFromObject(0, new Long(unique_id));
        row_data.setColumnDataFromObject(1, table_name.getSchema());
        row_data.setColumnDataFromObject(2, table_name.getName());
        row_data.setColumnDataFromObject(3, new Long(1L));
        table.addRow(row_data);
    }

    static void removeNativeTableGenerator(Transaction transaction, TableName table_name) {
        if (table_name.equals(TableDataConglomerate.SYS_SEQUENCE) || table_name.equals(TableDataConglomerate.SYS_SEQUENCE_INFO) || !transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE) || !transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE_INFO)) {
            return;
        }
        MutableTableDataSource seq = transaction.getTable(TableDataConglomerate.SYS_SEQUENCE);
        MutableTableDataSource seqi = transaction.getTable(TableDataConglomerate.SYS_SEQUENCE_INFO);
        SimpleTableQuery query = new SimpleTableQuery(seqi);
        IntegerVector ivec = query.selectIndexesEqual(2, TObject.stringVal(table_name.getName()), 1, TObject.stringVal(table_name.getSchema()));
        for (int i = 0; i < ivec.size(); ++i) {
            int row_i = ivec.intAt(i);
            TObject sid = seqi.getCellContents(0, row_i);
            SimpleTableQuery query2 = new SimpleTableQuery(seq);
            IntegerVector ivec2 = query2.selectIndexesEqual(0, sid);
            for (int n = 0; n < ivec2.size(); ++n) {
                seq.removeRow(ivec2.intAt(n));
            }
            seqi.removeRow(row_i);
            query2.dispose();
        }
        query.dispose();
    }

    static void createSequenceGenerator(Transaction transaction, TableName table_name, long start_value, long increment_by, long min_value, long max_value, long cache, boolean cycle) {
        if (!transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE) || !transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE_INFO)) {
            throw new RuntimeException("System sequence tables do not exist.");
        }
        MutableTableDataSource seq = transaction.getTable(TableDataConglomerate.SYS_SEQUENCE);
        MutableTableDataSource seqi = transaction.getTable(TableDataConglomerate.SYS_SEQUENCE_INFO);
        SimpleTableQuery query = new SimpleTableQuery(seqi);
        IntegerVector ivec = query.selectIndexesEqual(2, TObject.stringVal(table_name.getName()), 1, TObject.stringVal(table_name.getSchema()));
        if (ivec.size() > 0) {
            throw new RuntimeException("Sequence generator with name '" + table_name + "' already exists.");
        }
        query.dispose();
        long unique_id = transaction.nextUniqueID(TableDataConglomerate.SYS_SEQUENCE_INFO);
        RowData row_data = new RowData(seqi);
        row_data.setColumnDataFromObject(0, new Long(unique_id));
        row_data.setColumnDataFromObject(1, table_name.getSchema());
        row_data.setColumnDataFromObject(2, table_name.getName());
        row_data.setColumnDataFromObject(3, new Long(2L));
        seqi.addRow(row_data);
        row_data = new RowData(seq);
        row_data.setColumnDataFromObject(0, new Long(unique_id));
        row_data.setColumnDataFromObject(1, new Long(start_value));
        row_data.setColumnDataFromObject(2, new Long(increment_by));
        row_data.setColumnDataFromObject(3, new Long(min_value));
        row_data.setColumnDataFromObject(4, new Long(max_value));
        row_data.setColumnDataFromObject(5, new Long(start_value));
        row_data.setColumnDataFromObject(6, new Long(cache));
        row_data.setColumnDataFromObject(7, new Boolean(cycle));
        seq.addRow(row_data);
    }

    static void dropSequenceGenerator(Transaction transaction, TableName table_name) {
        if (!transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE) || !transaction.tableExists(TableDataConglomerate.SYS_SEQUENCE_INFO)) {
            throw new RuntimeException("System sequence tables do not exist.");
        }
        SequenceManager.removeNativeTableGenerator(transaction, table_name);
    }

    synchronized long nextValue(SimpleTransaction transaction, TableName name) {
        SequenceGenerator generator = this.getGenerator(name);
        if (generator.type == 1) {
            return transaction.nextUniqueID(new TableName(name.getSchema(), name.getName()));
        }
        long current_val = generator.current_val;
        generator.incrementCurrentValue();
        if (current_val == generator.last_value) {
            int i = 0;
            while ((long)i < generator.cache) {
                generator.incrementLastValue();
                ++i;
            }
            this.updateGeneratorState(generator);
        }
        return generator.current_val;
    }

    synchronized long curValue(SimpleTransaction transaction, TableName name) {
        SequenceGenerator generator = this.getGenerator(name);
        if (generator.type == 1) {
            return transaction.nextUniqueID(new TableName(name.getSchema(), name.getName()));
        }
        return generator.current_val;
    }

    synchronized void setValue(SimpleTransaction transaction, TableName name, long value) {
        SequenceGenerator generator = this.getGenerator(name);
        if (generator.type == 1) {
            transaction.setUniqueID(new TableName(name.getSchema(), name.getName()), value);
        } else {
            generator.current_val = value;
            generator.last_value = value;
            this.updateGeneratorState(generator);
        }
    }

    static InternalTableInfo createInternalTableInfo(Transaction transaction) {
        return new SequenceInternalTableInfo(transaction);
    }

    private static class SequenceInternalTableInfo
    implements InternalTableInfo {
        Transaction transaction;

        SequenceInternalTableInfo(Transaction transaction) {
            this.transaction = transaction;
        }

        private static DataTableDef createDataTableDef(String schema, String name) {
            DataTableDef def = new DataTableDef();
            def.setTableName(new TableName(schema, name));
            def.addColumn(DataTableColumnDef.createNumericColumn("last_value"));
            def.addColumn(DataTableColumnDef.createNumericColumn("current_value"));
            def.addColumn(DataTableColumnDef.createNumericColumn("top_value"));
            def.addColumn(DataTableColumnDef.createNumericColumn("increment_by"));
            def.addColumn(DataTableColumnDef.createNumericColumn("min_value"));
            def.addColumn(DataTableColumnDef.createNumericColumn("max_value"));
            def.addColumn(DataTableColumnDef.createNumericColumn("start"));
            def.addColumn(DataTableColumnDef.createNumericColumn("cache"));
            def.addColumn(DataTableColumnDef.createBooleanColumn("cycle"));
            def.setImmutable();
            return def;
        }

        public int getTableCount() {
            TableName SEQ = TableDataConglomerate.SYS_SEQUENCE;
            if (this.transaction.tableExists(SEQ)) {
                return this.transaction.getTable(SEQ).getRowCount();
            }
            return 0;
        }

        public int findTableName(TableName name) {
            TableName SEQ_INFO = TableDataConglomerate.SYS_SEQUENCE_INFO;
            if (this.transaction.realTableExists(SEQ_INFO)) {
                MutableTableDataSource table = this.transaction.getTable(SEQ_INFO);
                RowEnumeration row_e = table.rowEnumeration();
                int p = 0;
                while (row_e.hasMoreRows()) {
                    TObject ob_schema;
                    int row_index = row_e.nextRowIndex();
                    TObject seq_type = table.getCellContents(3, row_index);
                    if (seq_type.operatorEquals(ONE_VAL).valuesEqual(TRUE_VAL)) continue;
                    TObject ob_name = table.getCellContents(2, row_index);
                    if (ob_name.getObject().toString().equals(name.getName()) && (ob_schema = table.getCellContents(1, row_index)).getObject().toString().equals(name.getSchema())) {
                        return p;
                    }
                    ++p;
                }
            }
            return -1;
        }

        public TableName getTableName(int i) {
            TableName SEQ_INFO = TableDataConglomerate.SYS_SEQUENCE_INFO;
            if (this.transaction.realTableExists(SEQ_INFO)) {
                MutableTableDataSource table = this.transaction.getTable(SEQ_INFO);
                RowEnumeration row_e = table.rowEnumeration();
                int p = 0;
                while (row_e.hasMoreRows()) {
                    int row_index = row_e.nextRowIndex();
                    TObject seq_type = table.getCellContents(3, row_index);
                    if (seq_type.operatorEquals(ONE_VAL).valuesEqual(TRUE_VAL)) continue;
                    if (i == p) {
                        TObject ob_schema = table.getCellContents(1, row_index);
                        TObject ob_name = table.getCellContents(2, row_index);
                        return new TableName(ob_schema.getObject().toString(), ob_name.getObject().toString());
                    }
                    ++p;
                }
            }
            throw new RuntimeException("Out of bounds.");
        }

        public boolean containsTableName(TableName name) {
            TableName SEQ_INFO = TableDataConglomerate.SYS_SEQUENCE_INFO;
            if (name.equals(SEQ_INFO)) {
                return false;
            }
            return this.findTableName(name) != -1;
        }

        public String getTableType(int i) {
            return "SEQUENCE";
        }

        public DataTableDef getDataTableDef(int i) {
            TableName table_name = this.getTableName(i);
            return SequenceInternalTableInfo.createDataTableDef(table_name.getSchema(), table_name.getName());
        }

        public MutableTableDataSource createInternalTable(int index) {
            MutableTableDataSource table = this.transaction.getTable(TableDataConglomerate.SYS_SEQUENCE_INFO);
            RowEnumeration row_e = table.rowEnumeration();
            int p = 0;
            int row_i = -1;
            while (row_e.hasMoreRows() && row_i == -1) {
                int i = row_e.nextRowIndex();
                TObject seq_type = table.getCellContents(3, i);
                if (seq_type.operatorEquals(ONE_VAL).valuesEqual(TRUE_VAL)) continue;
                if (p == index) {
                    row_i = i;
                }
                ++p;
            }
            if (row_i != -1) {
                TObject seq_id = table.getCellContents(0, row_i);
                String schema = table.getCellContents(1, row_i).getObject().toString();
                String name = table.getCellContents(2, row_i).getObject().toString();
                TableName table_name = new TableName(schema, name);
                MutableTableDataSource seq_table = this.transaction.getTable(TableDataConglomerate.SYS_SEQUENCE);
                SelectableScheme scheme = seq_table.getColumnScheme(0);
                IntegerVector ivec = scheme.selectEqual(seq_id);
                if (ivec.size() > 0) {
                    TObject lv;
                    int seq_row_i = ivec.intAt(0);
                    DataTableDef table_def = SequenceInternalTableInfo.createDataTableDef(schema, name);
                    try {
                        lv = TObject.longVal(this.transaction.lastSequenceValue(table_name));
                    }
                    catch (StatementException e) {
                        lv = TObject.longVal(-1L);
                    }
                    TObject last_value = lv;
                    SequenceManager manager = this.transaction.getConglomerate().getSequenceManager();
                    TObject current_value = TObject.longVal(manager.curValue(this.transaction, table_name));
                    TObject top_value = seq_table.getCellContents(1, seq_row_i);
                    TObject increment_by = seq_table.getCellContents(2, seq_row_i);
                    TObject min_value = seq_table.getCellContents(3, seq_row_i);
                    TObject max_value = seq_table.getCellContents(4, seq_row_i);
                    TObject start = seq_table.getCellContents(5, seq_row_i);
                    TObject cache = seq_table.getCellContents(6, seq_row_i);
                    TObject cycle = seq_table.getCellContents(7, seq_row_i);
                    return new GTDataSource(this, this.transaction.getSystem(), table_def, last_value, current_value, top_value, increment_by, min_value, max_value, start, cache, cycle){
                        private final /* synthetic */ DataTableDef val$table_def;
                        private final /* synthetic */ TObject val$last_value;
                        private final /* synthetic */ TObject val$current_value;
                        private final /* synthetic */ TObject val$top_value;
                        private final /* synthetic */ TObject val$increment_by;
                        private final /* synthetic */ TObject val$min_value;
                        private final /* synthetic */ TObject val$max_value;
                        private final /* synthetic */ TObject val$start;
                        private final /* synthetic */ TObject val$cache;
                        private final /* synthetic */ TObject val$cycle;
                        private final /* synthetic */ SequenceInternalTableInfo this$0;
                        {
                            this.this$0 = this$0;
                            this.val$table_def = val$table_def;
                            this.val$last_value = val$last_value;
                            this.val$current_value = val$current_value;
                            this.val$top_value = val$top_value;
                            this.val$increment_by = val$increment_by;
                            this.val$min_value = val$min_value;
                            this.val$max_value = val$max_value;
                            this.val$start = val$start;
                            this.val$cache = val$cache;
                            this.val$cycle = val$cycle;
                        }

                        public DataTableDef getDataTableDef() {
                            return this.val$table_def;
                        }

                        public int getRowCount() {
                            return 1;
                        }

                        public TObject getCellContents(int col, int row) {
                            switch (col) {
                                case 0: {
                                    return this.val$last_value;
                                }
                                case 1: {
                                    return this.val$current_value;
                                }
                                case 2: {
                                    return this.val$top_value;
                                }
                                case 3: {
                                    return this.val$increment_by;
                                }
                                case 4: {
                                    return this.val$min_value;
                                }
                                case 5: {
                                    return this.val$max_value;
                                }
                                case 6: {
                                    return this.val$start;
                                }
                                case 7: {
                                    return this.val$cache;
                                }
                                case 8: {
                                    return this.val$cycle;
                                }
                            }
                            throw new RuntimeException("Column out of bounds.");
                        }
                    };
                }
                throw new RuntimeException("No SEQUENCE table entry for generator.");
            }
            throw new RuntimeException("Index out of bounds.");
        }
    }

    private static class SequenceGenerator {
        long current_val;
        long id;
        TableName name;
        int type;
        long last_value;
        long increment_by;
        long min_value;
        long max_value;
        long start;
        long cache;
        boolean cycle;

        SequenceGenerator(long id, TableName name) {
            this.type = 1;
            this.id = id;
            this.name = name;
        }

        SequenceGenerator(long id, TableName name, long last_value, long increment_by, long min_value, long max_value, long start, long cache, boolean cycle) {
            this.type = 2;
            this.id = id;
            this.name = name;
            this.last_value = last_value;
            this.current_val = last_value;
            this.increment_by = increment_by;
            this.min_value = min_value;
            this.max_value = max_value;
            this.start = start;
            this.cache = cache;
            this.cycle = cycle;
        }

        private long incrementValue(long val) {
            if ((val += this.increment_by) > this.max_value) {
                if (this.cycle) {
                    val = this.min_value;
                } else {
                    throw new StatementException("Sequence out of bounds.");
                }
            }
            if (val < this.min_value) {
                if (this.cycle) {
                    val = this.max_value;
                } else {
                    throw new StatementException("Sequence out of bounds.");
                }
            }
            return val;
        }

        void incrementCurrentValue() {
            this.current_val = this.incrementValue(this.current_val);
        }

        void incrementLastValue() {
            this.last_value = this.incrementValue(this.last_value);
        }
    }
}

