/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Operator;
import com.mckoi.database.SelectableRange;
import com.mckoi.database.TObject;
import com.mckoi.database.TStringType;
import com.mckoi.database.TType;
import java.util.ArrayList;
import java.util.ListIterator;

public final class SelectableRangeSet {
    private final ArrayList range_set = new ArrayList();

    public SelectableRangeSet() {
        this.range_set.add(SelectableRange.FULL_RANGE);
    }

    private static SelectableRange intersectRange(SelectableRange range, Operator op, TObject val, boolean null_check) {
        int c;
        boolean inclusive;
        TObject start = range.getStart();
        byte start_flag = range.getStartFlag();
        TObject end = range.getEnd();
        byte end_flag = range.getEndFlag();
        boolean bl = inclusive = op.is("is") || op.is("=") || op.is(">=") || op.is("<=");
        if (op.is("is") || op.is("=") || op.is(">") || op.is(">=")) {
            if (null_check && val.isNull()) {
                return null;
            }
            if (start == SelectableRange.FIRST_IN_SET) {
                start = val;
                start_flag = inclusive ? (byte)1 : 4;
            } else {
                c = val.compareTo(start);
                if (c == 0 && start_flag == 1 || c > 0) {
                    start = val;
                    byte by = start_flag = inclusive ? (byte)1 : 4;
                }
            }
        }
        if (op.is("is") || op.is("=") || op.is("<") || op.is("<=")) {
            if (null_check && val.isNull()) {
                return null;
            }
            if (null_check && start == SelectableRange.FIRST_IN_SET) {
                start = TObject.nullVal();
                start_flag = 4;
            }
            if (end == SelectableRange.LAST_IN_SET) {
                end = val;
                end_flag = inclusive ? (byte)2 : 3;
            } else {
                c = val.compareTo(end);
                if (c == 0 && end_flag == 2 || c < 0) {
                    end = val;
                    byte by = end_flag = inclusive ? (byte)2 : 3;
                }
            }
        }
        if (start != SelectableRange.FIRST_IN_SET && end != SelectableRange.LAST_IN_SET && ((c = start.compareTo(end)) == 0 && (start_flag == 4 || end_flag == 3) || c > 0)) {
            return null;
        }
        return new SelectableRange(start_flag, start, end_flag, end);
    }

    private static boolean rangeIntersectedBy(SelectableRange range1, SelectableRange range2) {
        byte start_flag_1 = range1.getStartFlag();
        TObject start_1 = range1.getStart();
        byte end_flag_1 = range1.getEndFlag();
        TObject end_1 = range1.getEnd();
        byte start_flag_2 = range2.getStartFlag();
        TObject start_2 = range2.getStart();
        byte end_flag_2 = range2.getEndFlag();
        TObject end_2 = range2.getEnd();
        TObject start_cell_1 = start_1 == SelectableRange.FIRST_IN_SET ? null : start_1;
        TObject end_cell_1 = end_1 == SelectableRange.LAST_IN_SET ? null : end_1;
        TObject start_cell_2 = start_2 == SelectableRange.FIRST_IN_SET ? null : start_2;
        TObject end_cell_2 = end_2 == SelectableRange.LAST_IN_SET ? null : end_2;
        boolean intersect_1 = false;
        if (start_cell_1 != null && end_cell_2 != null) {
            int c = start_cell_1.compareTo(end_cell_2);
            if (c < 0 || c == 0 && (start_flag_1 == 1 || end_flag_2 == 2)) {
                intersect_1 = true;
            }
        } else {
            intersect_1 = true;
        }
        boolean intersect_2 = false;
        if (start_cell_2 != null && end_cell_1 != null) {
            int c = start_cell_2.compareTo(end_cell_1);
            if (c < 0 || c == 0 && (start_flag_2 == 1 || end_flag_1 == 2)) {
                intersect_2 = true;
            }
        } else {
            intersect_2 = true;
        }
        return intersect_1 && intersect_2;
    }

    private static SelectableRange changeRangeSizeToEncompass(SelectableRange range1, SelectableRange range2) {
        int c;
        TObject cell;
        byte start_flag_1 = range1.getStartFlag();
        TObject start_1 = range1.getStart();
        byte end_flag_1 = range1.getEndFlag();
        TObject end_1 = range1.getEnd();
        byte start_flag_2 = range2.getStartFlag();
        TObject start_2 = range2.getStart();
        byte end_flag_2 = range2.getEndFlag();
        TObject end_2 = range2.getEnd();
        if (start_1 != SelectableRange.FIRST_IN_SET) {
            if (start_2 != SelectableRange.FIRST_IN_SET) {
                cell = start_1;
                c = cell.compareTo(start_2);
                if (c > 0 || c == 0 && start_flag_1 == 4 && start_flag_2 == 1) {
                    start_1 = start_2;
                    start_flag_1 = start_flag_2;
                }
            } else {
                start_1 = start_2;
                start_flag_1 = start_flag_2;
            }
        }
        if (end_1 != SelectableRange.LAST_IN_SET) {
            if (end_2 != SelectableRange.LAST_IN_SET) {
                cell = end_1;
                c = cell.compareTo(end_2);
                if (c < 0 || c == 0 && end_flag_1 == 3 && end_flag_2 == 2) {
                    end_1 = end_2;
                    end_flag_1 = end_flag_2;
                }
            } else {
                end_1 = end_2;
                end_flag_1 = end_flag_2;
            }
        }
        return new SelectableRange(start_flag_1, start_1, end_flag_1, end_1);
    }

    public void intersect(Operator op, TObject val) {
        int sz = this.range_set.size();
        ListIterator<SelectableRange> i = this.range_set.listIterator();
        if (op.is("<>") || op.is("is not")) {
            boolean null_check = op.is("<>");
            while (i.hasNext()) {
                SelectableRange range = (SelectableRange)i.next();
                SelectableRange left_range = SelectableRangeSet.intersectRange(range, Operator.get("<"), val, null_check);
                SelectableRange right_range = SelectableRangeSet.intersectRange(range, Operator.get(">"), val, null_check);
                i.remove();
                if (left_range != null) {
                    i.add(left_range);
                }
                if (right_range == null) continue;
                i.add(right_range);
            }
        } else {
            boolean null_check;
            boolean bl = null_check = !op.is("is");
            while (i.hasNext()) {
                SelectableRange range = (SelectableRange)i.next();
                if ((range = SelectableRangeSet.intersectRange(range, op, val, null_check)) == null) {
                    i.remove();
                    continue;
                }
                i.set(range);
            }
        }
    }

    public void union(Operator op, TObject val) {
        throw new Error("PENDING");
    }

    public void union(SelectableRangeSet union_to) {
        ArrayList input_set = union_to.range_set;
        int in_sz = input_set.size();
        for (int n = 0; n < in_sz; ++n) {
            SelectableRange in_range = (SelectableRange)input_set.get(n);
            int sz = this.range_set.size();
            ListIterator<SelectableRange> i = this.range_set.listIterator();
            while (i.hasNext()) {
                SelectableRange range = (SelectableRange)i.next();
                if (!SelectableRangeSet.rangeIntersectedBy(in_range, range)) continue;
                i.remove();
                in_range = SelectableRangeSet.changeRangeSizeToEncompass(in_range, range);
            }
            byte start_flag = in_range.getStartFlag();
            TObject start = in_range.getStart();
            byte end_flag = in_range.getEndFlag();
            TObject end = in_range.getEnd();
            if (start == SelectableRange.FIRST_IN_SET) {
                this.range_set.add(0, in_range);
                continue;
            }
            TObject start_cell = start;
            i = this.range_set.listIterator();
            while (i.hasNext()) {
                SelectableRange range = (SelectableRange)i.next();
                TObject cur_start = range.getStart();
                if (cur_start == SelectableRange.FIRST_IN_SET || cur_start.compareTo(start_cell) <= 0) continue;
                i.previous();
                break;
            }
            i.add(in_range);
        }
    }

    public SelectableRange[] toSelectableRangeArray() {
        int sz = this.range_set.size();
        SelectableRange[] ranges = new SelectableRange[sz];
        for (int i = 0; i < sz; ++i) {
            ranges[i] = (SelectableRange)this.range_set.get(i);
        }
        return ranges;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.range_set.size() == 0) {
            return "(NO RANGE)";
        }
        for (int i = 0; i < this.range_set.size(); ++i) {
            buf.append(this.range_set.get(i));
            buf.append(", ");
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        TStringType ttype = TType.STRING_TYPE;
        SelectableRangeSet range_set = new SelectableRangeSet();
        System.out.println(range_set);
        range_set.intersect(Operator.get(">="), new TObject(ttype, "2"));
        System.out.println(range_set);
        range_set.intersect(Operator.get("<>"), new TObject(ttype, "4"));
        System.out.println(range_set);
        range_set.intersect(Operator.get("<>"), new TObject(ttype, "2"));
        System.out.println(range_set);
        range_set.intersect(Operator.get("<>"), new TObject(ttype, "3"));
        System.out.println(range_set);
        range_set.intersect(Operator.get("<>"), new TObject(ttype, "2"));
        System.out.println(range_set);
        range_set.intersect(Operator.get("<>"), new TObject(ttype, "1"));
        System.out.println(range_set);
        range_set.intersect(Operator.get(">="), new TObject(ttype, "3"));
        System.out.println(range_set);
        range_set.intersect(Operator.get("<="), new TObject(ttype, "5"));
        System.out.println(range_set);
        range_set.intersect(Operator.get("<"), new TObject(ttype, "5"));
        System.out.println(range_set);
        range_set.intersect(Operator.get(">="), new TObject(ttype, "6"));
        System.out.println(range_set);
        System.out.println("---");
        SelectableRangeSet range1 = new SelectableRangeSet();
        range1.intersect(Operator.get("="), new TObject(ttype, "k"));
        SelectableRangeSet range2 = new SelectableRangeSet();
        range2.intersect(Operator.get("<>"), new TObject(ttype, "d"));
        range2.intersect(Operator.get("<"), new TObject(ttype, "g"));
        SelectableRangeSet range3 = new SelectableRangeSet();
        range3.intersect(Operator.get(">"), new TObject(ttype, "o"));
        range2.union(range3);
        range1.union(range2);
        System.out.println(range1);
    }
}

