/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TObject;
import com.mckoi.database.TType;

public final class SelectableRange {
    public static final TObject FIRST_IN_SET = new TObject(TType.NULL_TYPE, "[FIRST_IN_SET]");
    public static final TObject LAST_IN_SET = new TObject(TType.NULL_TYPE, "[LAST_IN_SET]");
    public static final byte FIRST_VALUE = 1;
    public static final byte LAST_VALUE = 2;
    public static final byte BEFORE_FIRST_VALUE = 3;
    public static final byte AFTER_LAST_VALUE = 4;
    private TObject start;
    private TObject end;
    private byte set_start_flag;
    private byte set_end_flag;
    public static final SelectableRange FULL_RANGE = new SelectableRange(1, FIRST_IN_SET, 2, LAST_IN_SET);
    public static final SelectableRange FULL_RANGE_NO_NULLS = new SelectableRange(4, TObject.nullVal(), 2, LAST_IN_SET);

    public SelectableRange(byte set_start_flag, TObject start, byte set_end_flag, TObject end) {
        this.start = start;
        this.end = end;
        this.set_start_flag = set_start_flag;
        this.set_end_flag = set_end_flag;
    }

    public TObject getStart() {
        return this.start;
    }

    public TObject getEnd() {
        return this.end;
    }

    public byte getStartFlag() {
        return this.set_start_flag;
    }

    public byte getEndFlag() {
        return this.set_end_flag;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getStartFlag() == 1) {
            buf.append("FIRST_VALUE ");
        } else if (this.getStartFlag() == 4) {
            buf.append("AFTER_LAST_VALUE ");
        }
        buf.append(this.getStart());
        buf.append(" -> ");
        if (this.getEndFlag() == 2) {
            buf.append("LAST_VALUE ");
        } else if (this.getEndFlag() == 3) {
            buf.append("BEFORE_FIRST_VALUE ");
        }
        buf.append(this.getEnd());
        return new String(buf);
    }

    public boolean equals(Object ob) {
        if (super.equals(ob)) {
            return true;
        }
        SelectableRange dest_range = (SelectableRange)ob;
        return this.getStart().valuesEqual(dest_range.getStart()) && this.getEnd().valuesEqual(dest_range.getEnd()) && this.getStartFlag() == dest_range.getStartFlag() && this.getEndFlag() == dest_range.getEndFlag();
    }
}

