/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.FilterTable;
import com.mckoi.database.RootTable;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;

public final class ReferenceTable
extends FilterTable
implements RootTable {
    private TableName table_name;
    private DataTableDef modified_table_def;

    ReferenceTable(Table table, TableName tname) {
        super(table);
        this.table_name = tname;
        this.modified_table_def = new DataTableDef(table.getDataTableDef());
        this.modified_table_def.setTableName(tname);
        this.modified_table_def.setImmutable();
    }

    ReferenceTable(Table table, DataTableDef def) {
        super(table);
        this.table_name = def.getTableName();
        this.modified_table_def = def;
    }

    public TableName getTableName() {
        return this.table_name;
    }

    public DataTableDef getDataTableDef() {
        return this.modified_table_def;
    }

    public int findFieldName(Variable v) {
        TableName table_name = v.getTableName();
        if (table_name != null && table_name.equals(this.getTableName())) {
            return this.getDataTableDef().fastFindColumnName(v.getName());
        }
        return -1;
    }

    public Variable getResolvedVariable(int column) {
        return new Variable(this.getTableName(), this.getDataTableDef().columnAt(column).getName());
    }

    public boolean typeEquals(RootTable table) {
        return this == table;
    }
}

