/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.RawRowElement;
import com.mckoi.database.RawTableElement;
import com.mckoi.database.RootTable;
import com.mckoi.database.Table;
import com.mckoi.util.IntegerVector;
import com.mckoi.util.SortUtil;
import java.util.Vector;

final class RawTableInformation {
    private Vector raw_info = new Vector();

    RawTableInformation() {
    }

    void add(RootTable table, IntegerVector row_set) {
        RawTableElement elem = new RawTableElement();
        elem.table = table;
        elem.row_set = row_set;
        this.raw_info.addElement(elem);
    }

    Table[] getTables() {
        int size = this.raw_info.size();
        Table[] list = new Table[size];
        for (int i = 0; i < size; ++i) {
            list[i] = (Table)((Object)((RawTableElement)this.raw_info.elementAt((int)i)).table);
        }
        return list;
    }

    IntegerVector[] getRows() {
        int size = this.raw_info.size();
        IntegerVector[] list = new IntegerVector[size];
        for (int i = 0; i < size; ++i) {
            list[i] = ((RawTableElement)this.raw_info.elementAt((int)i)).row_set;
        }
        return list;
    }

    protected RawTableElement[] getSortedElements() {
        Object[] list = new RawTableElement[this.raw_info.size()];
        this.raw_info.copyInto(list);
        SortUtil.quickSort((Comparable[])list);
        return list;
    }

    void union(RawTableInformation info) {
        int n;
        Comparable e;
        int i;
        int i2;
        int col_count = this.raw_info.size();
        RawTableElement[] merge1 = this.getSortedElements();
        RawTableElement[] merge2 = info.getSortedElements();
        int size1 = -1;
        int size2 = -1;
        if (merge1.length != merge2.length) {
            throw new Error("Incorrect format in table union");
        }
        for (i2 = 0; i2 < merge1.length; ++i2) {
            if (size1 == -1) {
                size1 = merge1[i2].row_set.size();
                continue;
            }
            if (size1 == merge1[i2].row_set.size()) continue;
            throw new Error("Incorrect format in table union");
        }
        for (i2 = 0; i2 < merge2.length; ++i2) {
            if (!merge2[i2].table.typeEquals(merge1[i2].table)) {
                throw new Error("Incorrect format in table union");
            }
            if (size2 == -1) {
                size2 = merge2[i2].row_set.size();
                continue;
            }
            if (size2 == merge2[i2].row_set.size()) continue;
            throw new Error("Incorrect format in table union");
        }
        if (size1 == -1 || size2 == -1) {
            throw new Error("Incorrect format in table union");
        }
        this.raw_info.removeAllElements();
        int merge_size = size1 + size2;
        Comparable[] elems = new RawRowElement[merge_size];
        int elems_index = 0;
        for (i = 0; i < size1; ++i) {
            e = new RawRowElement();
            e.row_vals = new int[col_count];
            for (n = 0; n < col_count; ++n) {
                e.row_vals[n] = merge1[n].row_set.intAt(i);
            }
            elems[elems_index] = e;
            ++elems_index;
        }
        for (i = 0; i < size2; ++i) {
            e = new RawRowElement();
            e.row_vals = new int[col_count];
            for (n = 0; n < col_count; ++n) {
                e.row_vals[n] = merge2[n].row_set.intAt(i);
            }
            elems[elems_index] = e;
            ++elems_index;
        }
        SortUtil.quickSort(elems);
        for (i = 0; i < col_count; ++i) {
            e = merge1[i];
            ((RawTableElement)e).row_set.clear();
        }
        Comparable previous = null;
        Comparable current = null;
        for (n = 0; n < merge_size; ++n) {
            current = elems[n];
            if (previous != null && previous.compareTo(current) == 0) continue;
            for (int i3 = 0; i3 < col_count; ++i3) {
                merge1[i3].row_set.addInt(((RawRowElement)current).row_vals[i3]);
            }
            previous = current;
        }
        for (int i4 = 0; i4 < col_count; ++i4) {
            this.raw_info.addElement(merge1[i4]);
        }
    }

    void removeDuplicates() {
        if (this.raw_info.size() == 0) {
            return;
        }
        RawTableElement elen = (RawTableElement)this.raw_info.elementAt(0);
        int len = elen.row_set.size();
        if (len == 0) {
            return;
        }
        Comparable[] elems = new RawRowElement[len];
        int width = this.raw_info.size();
        Object[] rdup = new RawTableElement[width];
        this.raw_info.copyInto(rdup);
        for (int i = 0; i < len; ++i) {
            RawRowElement e = new RawRowElement();
            e.row_vals = new int[width];
            for (int n = 0; n < width; ++n) {
                e.row_vals[n] = ((RawTableElement)rdup[n]).row_set.intAt(i);
            }
            elems[i] = e;
        }
        SortUtil.quickSort(elems);
        this.raw_info.removeAllElements();
        Object[] table_elements = rdup;
        for (int i = 0; i < width; ++i) {
            ((RawTableElement)table_elements[i]).row_set.clear();
        }
        Comparable previous = null;
        Comparable current = null;
        for (int n = 0; n < len; ++n) {
            current = elems[n];
            if (previous != null && previous.compareTo(current) == 0) continue;
            for (int i = 0; i < width; ++i) {
                ((RawTableElement)table_elements[i]).row_set.addInt(((RawRowElement)current).row_vals[i]);
            }
            previous = current;
        }
        for (int i = 0; i < width; ++i) {
            this.raw_info.addElement(table_elements[i]);
        }
    }
}

