/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.MasterTableDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionSystem;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.IndexComparator;
import com.mckoi.util.IntegerIterator;
import com.mckoi.util.IntegerVector;
import java.io.IOException;
import java.util.ArrayList;

final class RIDList {
    private TransactionSystem system;
    private MasterTableDataSource master_table;
    private TableName table_name;
    private String column_name;
    private int column;
    private BlockIntegerList set_list;
    private IntegerVector rid_list;
    private int hash_rid_difference;
    private IndexComparator set_comparator;
    private boolean is_built;
    private int build_state = 0;
    private IntegerVector concurrent_modification_info;
    private ArrayList concurrent_modification_data;
    private Object modification_lock = new Object();
    private boolean request_processing = false;

    RIDList(MasterTableDataSource master_table, int column) {
        this.master_table = master_table;
        this.system = master_table.getSystem();
        this.column = column;
        DataTableDef table_def = master_table.getDataTableDef();
        this.table_name = table_def.getTableName();
        this.column_name = table_def.columnAt(column).getName();
        this.is_built = false;
        this.setupComparator();
    }

    public final DebugLogger Debug() {
        return this.master_table.Debug();
    }

    private void setupComparator() {
        this.set_comparator = new IndexComparator(){

            private int internalCompare(int index, TObject cell2) {
                TObject cell1 = RIDList.this.getCellContents(index);
                return cell1.compareTo(cell2);
            }

            public int compare(int index, Object val) {
                return this.internalCompare(index, (TObject)val);
            }

            public int compare(int index1, int index2) {
                TObject cell = RIDList.this.getCellContents(index2);
                return this.internalCompare(index1, cell);
            }
        };
    }

    private TObject getCellContents(int row) {
        return this.master_table.getCellContents(this.column, row);
    }

    private void calcHashRIDDifference(int size) {
        if (size == 0) {
            this.hash_rid_difference = 32;
        } else {
            this.hash_rid_difference = 0x10000000 / size;
            if (this.hash_rid_difference > 16384) {
                this.hash_rid_difference = 16384;
            } else if (this.hash_rid_difference < 8) {
                this.hash_rid_difference = 8;
            }
        }
    }

    private int rehashRIDList(int old_rid_place) {
        this.calcHashRIDDifference(this.set_list.size());
        int new_rid_place = -1;
        int cur_rid = 0;
        int old_rid = 0;
        IntegerIterator iterator = this.set_list.iterator();
        while (iterator.hasNext()) {
            int new_value;
            int row_index = iterator.next();
            if (row_index < 0 || row_index >= this.rid_list.size()) continue;
            int old_value = this.rid_list.intAt(row_index);
            if (old_value == 0) {
                new_rid_place = cur_rid += this.hash_rid_difference;
                continue;
            }
            if (old_value != old_rid) {
                old_rid = old_value;
                new_value = cur_rid += this.hash_rid_difference;
            } else {
                new_value = cur_rid;
            }
            this.rid_list.placeIntAt(new_value, row_index);
        }
        if (new_rid_place == -1) {
            throw new Error("Post condition not correct - new_rid_place shouldn't be -1");
        }
        this.system.stats().increment("RIDList.rehash_rid_table");
        return new_rid_place;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertRID(TObject cell, int row) {
        TObject previous_cell;
        Object object = this.modification_lock;
        synchronized (object) {
            if (this.build_state > 0 && this.build_state < 4) {
                this.concurrent_modification_info.addInt(1);
                this.concurrent_modification_info.addInt(row);
                this.concurrent_modification_data.add(cell);
                return;
            }
            if (this.rid_list == null) {
                return;
            }
        }
        this.rid_list.placeIntAt(0, row);
        this.set_list.insertSort(cell, row, this.set_comparator);
        int given_rid = -1;
        int set_index = this.set_list.searchLast(cell, this.set_comparator);
        if (this.set_list.get(set_index) != row) {
            throw new Error("set_list.searchLast(cell) didn't turn up expected row.");
        }
        int next_set_index = set_index + 1;
        if (next_set_index >= this.set_list.size()) {
            next_set_index = -1;
        }
        int previous_set_index = set_index - 1;
        int next_rid = next_set_index > -1 ? this.rid_list.intAt(this.set_list.get(next_set_index)) : (previous_set_index > -1 ? this.rid_list.intAt(this.set_list.get(previous_set_index)) + this.hash_rid_difference * 2 : this.hash_rid_difference * 2);
        int previous_rid = previous_set_index > -1 ? this.rid_list.intAt(this.set_list.get(previous_set_index)) : 0;
        if (previous_set_index > -1 && (previous_cell = this.getCellContents(this.set_list.get(previous_set_index))).compareTo(cell) == 0) {
            given_rid = previous_rid;
        }
        if (given_rid == -1) {
            given_rid = previous_rid + 1 == next_rid ? this.rehashRIDList(next_rid) : (next_rid + 1 + (previous_rid - 1)) / 2;
        }
        this.rid_list.placeIntAt(given_rid, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRID(int row) {
        Object object = this.modification_lock;
        synchronized (object) {
            if (this.build_state > 0 && this.build_state < 4) {
                this.concurrent_modification_info.addInt(2);
                this.concurrent_modification_info.addInt(row);
                return;
            }
            if (this.rid_list == null) {
                return;
            }
        }
        try {
            TObject cell = this.getCellContents(row);
            int n = this.set_list.removeSort(cell, row, this.set_comparator);
        }
        catch (Error e) {
            System.err.println("RIDList: " + this.table_name + "." + this.column_name);
            throw e;
        }
    }

    void requestBuildRIDList() {
        if (!this.isBuilt() && !this.request_processing) {
            this.request_processing = true;
            this.system.postEvent(10000, this.system.createEvent(new Runnable(){

                public void run() {
                    RIDList.this.createRIDCache();
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRIDCache() {
        try {
            int rid_list_size;
            long time_took;
            int set_size;
            Object object;
            if (this.master_table.isClosed()) {
                return;
            }
            long time_start = System.currentTimeMillis();
            MasterTableDataSource masterTableDataSource = this.master_table;
            synchronized (masterTableDataSource) {
                object = this.modification_lock;
                synchronized (object) {
                    if (this.is_built) {
                        return;
                    }
                    this.build_state = 1;
                    this.concurrent_modification_info = new IntegerVector();
                    this.concurrent_modification_data = new ArrayList();
                    set_size = this.master_table.rawRowCount();
                    this.set_list = new BlockIntegerList();
                    for (int r = 0; r < set_size; ++r) {
                        if (this.master_table.recordDeleted(r)) continue;
                        TObject cell = this.getCellContents(r);
                        this.set_list.insertSort(cell, r, this.set_comparator);
                    }
                    this.master_table.addRootLock();
                }
            }
            try {
                this.calcHashRIDDifference(set_size);
                this.rid_list = new IntegerVector(set_size + 128);
                if (this.set_list.size() > 0) {
                    int cur_rid = this.hash_rid_difference;
                    IntegerIterator iterator = this.set_list.iterator();
                    int row_index = iterator.next();
                    TObject last_cell = this.getCellContents(row_index);
                    this.rid_list.placeIntAt(cur_rid, row_index);
                    while (iterator.hasNext()) {
                        row_index = iterator.next();
                        TObject cur_cell = this.getCellContents(row_index);
                        int cmp = cur_cell.compareTo(last_cell);
                        if (cmp > 0) {
                            cur_rid += this.hash_rid_difference;
                        } else if (cmp < 0) {
                            throw new Error("Internal Database Error: Index is corrupt  - InsertSearch list is not sorted.");
                        }
                        this.rid_list.placeIntAt(cur_rid, row_index);
                        last_cell = cur_cell;
                    }
                }
                MasterTableDataSource masterTableDataSource2 = this.master_table;
                synchronized (masterTableDataSource2) {
                    object = this.modification_lock;
                    synchronized (object) {
                        this.build_state = 4;
                        int mod_size = this.concurrent_modification_info.size();
                        int m_data = 0;
                        int insert_count = 0;
                        int remove_count = 0;
                        for (int i = 0; i < mod_size; i += 2) {
                            int type = this.concurrent_modification_info.intAt(i);
                            int row = this.concurrent_modification_info.intAt(i + 1);
                            if (type == 1) {
                                TObject cell = (TObject)this.concurrent_modification_data.get(m_data);
                                this.insertRID(cell, row);
                                ++m_data;
                                ++insert_count;
                                continue;
                            }
                            if (type == 2) {
                                this.removeRID(row);
                                ++remove_count;
                                continue;
                            }
                            throw new Error("Unknown modification type.");
                        }
                        if (remove_count > 0) {
                            this.Debug().write(40, this, "Assertion failed: It should not be possible to remove rows during a root lock when building a RID list.");
                        }
                        this.concurrent_modification_info = null;
                        this.concurrent_modification_data = null;
                        time_took = System.currentTimeMillis() - time_start;
                        rid_list_size = this.rid_list.size();
                        this.is_built = true;
                    }
                }
            }
            finally {
                this.master_table.removeRootLock();
            }
            this.Debug().write(10000, this, "RID List " + this.table_name.toString() + "." + this.column_name + " Initial Size = " + rid_list_size);
            this.Debug().write(10000, this, "RID list built in " + time_took + "ms.");
            this.system.stats().increment("{session} RIDList.rid_caches_created");
            this.system.stats().add(rid_list_size, "{session} RIDList.rid_indices");
        }
        catch (IOException e) {
            throw new Error("IO Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBuilt() {
        Object object = this.modification_lock;
        synchronized (object) {
            return this.is_built;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockIntegerList sortedSet(final IntegerVector row_set) {
        int row_set_length = row_set.size();
        BlockIntegerList new_set = new BlockIntegerList();
        IndexComparator comparator = new IndexComparator(){

            public int compare(int index, Object val) {
                int rid_val = RIDList.this.rid_list.intAt(row_set.intAt(index));
                int rid_val2 = (Integer)val;
                return rid_val - rid_val2;
            }

            public int compare(int index1, int index2) {
                throw new Error("Shouldn't be called!");
            }
        };
        MasterTableDataSource masterTableDataSource = this.master_table;
        synchronized (masterTableDataSource) {
            for (int i = 0; i < row_set_length; ++i) {
                Integer rid_val = new Integer(this.rid_list.intAt(row_set.intAt(i)));
                new_set.insertSort(rid_val, i, comparator);
            }
            return new_set;
        }
    }
}

