/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CompositeTable;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Operator;
import com.mckoi.database.OuterTable;
import com.mckoi.database.QueryContext;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.ReferenceTable;
import com.mckoi.database.SelectableRange;
import com.mckoi.database.SelectableRangeSet;
import com.mckoi.database.SubsetColumnTable;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TableFunctions;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.database.VirtualTable;
import java.util.ArrayList;
import java.util.List;

public class QueryPlan {
    private static void cloneArray(Variable[] array) throws CloneNotSupportedException {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Variable)array[i].clone();
            }
        }
    }

    private static void cloneArray(Expression[] array) throws CloneNotSupportedException {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Expression)array[i].clone();
            }
        }
    }

    private static void indentBuffer(int level, StringBuffer buf) {
        for (int i = 0; i < level; ++i) {
            buf.append(' ');
        }
    }

    public static class NonCorrelatedAnyAllNode
    extends BranchQueryPlanNode {
        static final long serialVersionUID = 7480579008259288291L;
        private Variable[] left_columns;
        private Operator sub_query_operator;

        public NonCorrelatedAnyAllNode(QueryPlanNode left, QueryPlanNode right, Variable[] left_vars, Operator subquery_op) {
            super(left, right);
            this.left_columns = left_vars;
            this.sub_query_operator = subquery_op;
        }

        public Table evaluate(QueryContext context) {
            Table left_result = this.left.evaluate(context);
            Table right_result = this.right.evaluate(context);
            return TableFunctions.anyAllNonCorrelated(left_result, this.left_columns, this.sub_query_operator, right_result);
        }

        public Object clone() throws CloneNotSupportedException {
            NonCorrelatedAnyAllNode node = (NonCorrelatedAnyAllNode)super.clone();
            QueryPlan.cloneArray(node.left_columns);
            return node;
        }

        public String titleString() {
            StringBuffer buf = new StringBuffer();
            buf.append("NON_CORRELATED: (");
            for (int i = 0; i < this.left_columns.length; ++i) {
                buf.append(this.left_columns[i].toString());
            }
            buf.append(") ");
            buf.append(this.sub_query_operator.toString());
            return new String(buf);
        }
    }

    public static class CompositeNode
    extends BranchQueryPlanNode {
        static final long serialVersionUID = -560587816928425857L;
        private int composite_op;
        private boolean all_op;

        public CompositeNode(QueryPlanNode left, QueryPlanNode right, int composite_op, boolean all_op) {
            super(left, right);
            this.composite_op = composite_op;
            this.all_op = all_op;
        }

        public Table evaluate(QueryContext context) {
            Table left_result = this.left.evaluate(context);
            Table right_result = this.right.evaluate(context);
            CompositeTable t = new CompositeTable(left_result, new Table[]{left_result, right_result});
            t.setupIndexesForCompositeFunction(this.composite_op, this.all_op);
            return t;
        }
    }

    public static class LogicalUnionNode
    extends BranchQueryPlanNode {
        static final long serialVersionUID = -7783166856668779902L;

        public LogicalUnionNode(QueryPlanNode left, QueryPlanNode right) {
            super(left, right);
        }

        public Table evaluate(QueryContext context) {
            Table left_result = this.left.evaluate(context);
            Table right_result = this.right.evaluate(context);
            return left_result.union(right_result);
        }

        public String titleString() {
            return "LOGICAL UNION";
        }
    }

    public static class LeftOuterJoinNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = 8908801499550863492L;
        private String complete_mark_name;

        public LeftOuterJoinNode(QueryPlanNode child, String complete_mark_name) {
            super(child);
            this.complete_mark_name = complete_mark_name;
        }

        public Table evaluate(QueryContext context) {
            Table result = this.child.evaluate(context);
            Table complete_left = context.getMarkedTable(this.complete_mark_name);
            VirtualTable outside = complete_left.outside(result);
            OuterTable outer_table = new OuterTable(result);
            outer_table.mergeIn(outside);
            return outer_table;
        }

        public String titleString() {
            return "LEFT OUTER JOIN";
        }
    }

    public static class JoinNode
    extends BranchQueryPlanNode {
        static final long serialVersionUID = 4133205808616807832L;
        private Variable left_var;
        private Operator join_op;
        private Expression right_expression;

        public JoinNode(QueryPlanNode left, QueryPlanNode right, Variable left_var, Operator join_op, Expression right_expression) {
            super(left, right);
            this.left_var = left_var;
            this.join_op = join_op;
            this.right_expression = right_expression;
        }

        public Table evaluate(QueryContext context) {
            Table left_result = this.left.evaluate(context);
            Table right_result = this.right.evaluate(context);
            Variable rhs_var = this.right_expression.getVariable();
            Variable lhs_var = this.left_var;
            Operator op = this.join_op;
            if (rhs_var != null && left_result.getRowCount() < right_result.getRowCount()) {
                this.right_expression = new Expression(lhs_var);
                lhs_var = rhs_var;
                op = op.reverse();
                Table t = right_result;
                right_result = left_result;
                left_result = t;
            }
            return left_result.simpleJoin(context, right_result, lhs_var, op, this.right_expression);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.right_expression.discoverTableNames(super.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.right_expression.discoverCorrelatedVariables(level, super.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            JoinNode node = (JoinNode)super.clone();
            node.left_var = (Variable)this.left_var.clone();
            node.right_expression = (Expression)this.right_expression.clone();
            return node;
        }

        public String titleString() {
            return "JOIN: " + this.left_var + this.join_op + this.right_expression;
        }
    }

    public static class EquiJoinNode
    extends BranchQueryPlanNode {
        static final long serialVersionUID = 113332589582049607L;
        private Variable[] left_columns;
        private Variable[] right_columns;

        public EquiJoinNode(QueryPlanNode left, QueryPlanNode right, Variable[] left_cols, Variable[] right_cols) {
            super(left, right);
            this.left_columns = left_cols;
            this.right_columns = right_cols;
        }

        public Table evaluate(QueryContext context) {
            Table left_result = this.left.evaluate(context);
            Table right_result = this.right.evaluate(context);
            Variable first_left = this.left_columns[0];
            Variable first_right = this.right_columns[0];
            Operator EQUALS_OP = Operator.get("=");
            Table result = left_result.simpleJoin(context, right_result, first_left, EQUALS_OP, new Expression(first_right));
            int sz = this.left_columns.length;
            if (sz > 1) {
                Expression rest_expression = new Expression();
                for (int i = 1; i < sz; ++i) {
                    Variable left_var = this.left_columns[i];
                    Variable right_var = this.right_columns[i];
                    rest_expression.addElement(left_var);
                    rest_expression.addElement(right_var);
                    rest_expression.addOperator(EQUALS_OP);
                }
                Operator AND_OP = Operator.get("and");
                for (int i = 2; i < sz; ++i) {
                    rest_expression.addOperator(AND_OP);
                }
                result = result.exhaustiveSelect(context, rest_expression);
            }
            return result;
        }

        public Object clone() throws CloneNotSupportedException {
            EquiJoinNode node = (EquiJoinNode)super.clone();
            QueryPlan.cloneArray(node.left_columns);
            QueryPlan.cloneArray(node.right_columns);
            return node;
        }
    }

    public static class NaturalJoinNode
    extends BranchQueryPlanNode {
        static final long serialVersionUID = 942526205653132810L;

        public NaturalJoinNode(QueryPlanNode left, QueryPlanNode right) {
            super(left, right);
        }

        public Table evaluate(QueryContext context) {
            Table left_result = this.left.evaluate(context);
            return left_result.join(this.right.evaluate(context));
        }

        public String titleString() {
            return "NATURAL JOIN";
        }
    }

    public static class CachePointNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = 7866310557831478639L;
        private long id;
        private static final Object GLOB_LOCK = new Object();
        private static int GLOB_ID = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CachePointNode(QueryPlanNode child) {
            super(child);
            Object object = GLOB_LOCK;
            synchronized (object) {
                this.id = System.currentTimeMillis() << 16 | (long)(GLOB_ID & 0xFFFF);
                ++GLOB_ID;
            }
        }

        public Table evaluate(QueryContext context) {
            Table child_table = context.getCachedNode(this.id);
            if (child_table == null) {
                child_table = this.child.evaluate(context);
                context.putCachedNode(this.id, child_table);
            }
            return child_table;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String titleString() {
            return "CACHE: " + this.id;
        }
    }

    public static class MarkerNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -8321710589608765270L;
        private String mark_name;

        public MarkerNode(QueryPlanNode child, String mark_name) {
            super(child);
            this.mark_name = mark_name;
        }

        public Table evaluate(QueryContext context) {
            Table child_table = this.child.evaluate(context);
            context.addMarkedTable(this.mark_name, child_table);
            return child_table;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static class CreateFunctionsNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -181012844247626327L;
        private Expression[] function_list;
        private String[] name_list;

        public CreateFunctionsNode(QueryPlanNode child, Expression[] function_list, String[] name_list) {
            super(child);
            this.function_list = function_list;
            this.name_list = name_list;
        }

        public Table evaluate(QueryContext context) {
            Table child_table = this.child.evaluate(context);
            DatabaseQueryContext db_context = (DatabaseQueryContext)context;
            FunctionTable fun_table = new FunctionTable(child_table, this.function_list, this.name_list, db_context);
            Table t = fun_table.mergeWithReference(null);
            return t;
        }

        public ArrayList discoverTableNames(ArrayList list) {
            list = super.discoverTableNames(list);
            for (int i = 0; i < this.function_list.length; ++i) {
                list = this.function_list[i].discoverTableNames(list);
            }
            return list;
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            list = super.discoverCorrelatedVariables(level, list);
            for (int i = 0; i < this.function_list.length; ++i) {
                list = this.function_list[i].discoverCorrelatedVariables(level, list);
            }
            return list;
        }

        public Object clone() throws CloneNotSupportedException {
            CreateFunctionsNode node = (CreateFunctionsNode)super.clone();
            QueryPlan.cloneArray(node.function_list);
            return node;
        }

        public String titleString() {
            StringBuffer buf = new StringBuffer();
            buf.append("FUNCTIONS: (");
            for (int i = 0; i < this.function_list.length; ++i) {
                buf.append(this.function_list[i]);
                buf.append(", ");
            }
            buf.append(")");
            return new String(buf);
        }
    }

    public static class GroupNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = 7140928678192396348L;
        private Variable[] columns;
        private Variable group_max_column;
        private Expression[] function_list;
        private String[] name_list;

        public GroupNode(QueryPlanNode child, Variable[] columns, Variable group_max_column, Expression[] function_list, String[] name_list) {
            super(child);
            this.columns = columns;
            this.group_max_column = group_max_column;
            this.function_list = function_list;
            this.name_list = name_list;
        }

        public GroupNode(QueryPlanNode child, Variable group_max_column, Expression[] function_list, String[] name_list) {
            this(child, null, group_max_column, function_list, name_list);
        }

        public Table evaluate(QueryContext context) {
            Table child_table = this.child.evaluate(context);
            DatabaseQueryContext db_context = (DatabaseQueryContext)context;
            FunctionTable fun_table = new FunctionTable(child_table, this.function_list, this.name_list, db_context);
            if (this.columns == null) {
                fun_table.setWholeTableAsGroup();
            } else {
                fun_table.createGroupMatrix(this.columns);
            }
            return fun_table.mergeWithReference(this.group_max_column);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            list = super.discoverTableNames(list);
            for (int i = 0; i < this.function_list.length; ++i) {
                list = this.function_list[i].discoverTableNames(list);
            }
            return list;
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            list = super.discoverCorrelatedVariables(level, list);
            for (int i = 0; i < this.function_list.length; ++i) {
                list = this.function_list[i].discoverCorrelatedVariables(level, list);
            }
            return list;
        }

        public Object clone() throws CloneNotSupportedException {
            GroupNode node = (GroupNode)super.clone();
            QueryPlan.cloneArray(node.columns);
            QueryPlan.cloneArray(node.function_list);
            node.group_max_column = this.group_max_column != null ? (Variable)this.group_max_column.clone() : null;
            return node;
        }

        public String titleString() {
            int i;
            StringBuffer buf = new StringBuffer();
            buf.append("GROUP: (");
            if (this.columns == null) {
                buf.append("WHOLE TABLE");
            } else {
                for (i = 0; i < this.columns.length; ++i) {
                    buf.append(this.columns[i]);
                    buf.append(", ");
                }
            }
            buf.append(")");
            if (this.function_list != null) {
                buf.append(" FUNS: [");
                for (i = 0; i < this.function_list.length; ++i) {
                    buf.append(this.function_list[i]);
                    buf.append(", ");
                }
                buf.append("]");
            }
            return new String(buf);
        }
    }

    public static class SortNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = 3644480534542996928L;
        private Variable[] columns;
        private boolean[] correct_ascending;

        public SortNode(QueryPlanNode child, Variable[] columns, boolean[] ascending) {
            super(child);
            this.columns = columns;
            this.correct_ascending = ascending;
            int sz = ascending.length;
            for (int n = 0; n < sz - 1; ++n) {
                if (ascending[n]) continue;
                for (int p = n + 1; p < sz; ++p) {
                    ascending[p] = !ascending[p];
                }
            }
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            int sz = this.correct_ascending.length;
            for (int n = sz - 1; n >= 0; --n) {
                t = t.orderByColumn(this.columns[n], this.correct_ascending[n]);
            }
            return t;
        }

        public Object clone() throws CloneNotSupportedException {
            SortNode node = (SortNode)super.clone();
            QueryPlan.cloneArray(node.columns);
            return node;
        }

        public String titleString() {
            StringBuffer buf = new StringBuffer();
            buf.append("SORT: (");
            for (int i = 0; i < this.columns.length; ++i) {
                buf.append(this.columns[i]);
                if (this.correct_ascending[i]) {
                    buf.append(" ASC");
                } else {
                    buf.append(" DESC");
                }
                buf.append(", ");
            }
            buf.append(")");
            return new String(buf);
        }
    }

    public static class DistinctNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -1538264313804102373L;
        private Variable[] columns;

        public DistinctNode(QueryPlanNode child, Variable[] columns) {
            super(child);
            this.columns = columns;
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            int sz = this.columns.length;
            int[] col_map = new int[sz];
            for (int i = 0; i < sz; ++i) {
                col_map[i] = t.findFieldName(this.columns[i]);
            }
            return t.distinct(col_map);
        }

        public Object clone() throws CloneNotSupportedException {
            DistinctNode node = (DistinctNode)super.clone();
            QueryPlan.cloneArray(node.columns);
            return node;
        }

        public String titleString() {
            StringBuffer buf = new StringBuffer();
            buf.append("DISTINCT: (");
            for (int i = 0; i < this.columns.length; ++i) {
                buf.append(this.columns[i]);
                buf.append(", ");
            }
            buf.append(")");
            return new String(buf);
        }
    }

    public static class SubsetNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = 3784462788248510832L;
        private Variable[] original_columns;
        private Variable[] new_column_names;

        public SubsetNode(QueryPlanNode child, Variable[] original_columns, Variable[] new_column_names) {
            super(child);
            this.original_columns = original_columns;
            this.new_column_names = new_column_names;
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            int sz = this.original_columns.length;
            int[] col_map = new int[sz];
            for (int i = 0; i < sz; ++i) {
                col_map[i] = t.findFieldName(this.original_columns[i]);
            }
            SubsetColumnTable col_table = new SubsetColumnTable(t);
            col_table.setColumnMap(col_map, this.new_column_names);
            return col_table;
        }

        public void setGivenName(TableName name) {
            if (name != null) {
                int sz = this.new_column_names.length;
                for (int i = 0; i < sz; ++i) {
                    this.new_column_names[i].setTableName(name);
                }
            }
        }

        public Variable[] getOriginalColumns() {
            return this.original_columns;
        }

        public Variable[] getNewColumnNames() {
            return this.new_column_names;
        }

        public Object clone() throws CloneNotSupportedException {
            SubsetNode node = (SubsetNode)super.clone();
            QueryPlan.cloneArray(node.original_columns);
            QueryPlan.cloneArray(node.new_column_names);
            return node;
        }

        public String titleString() {
            StringBuffer buf = new StringBuffer();
            buf.append("SUBSET: ");
            for (int i = 0; i < this.new_column_names.length; ++i) {
                buf.append(this.new_column_names[i]);
                buf.append("->");
                buf.append(this.original_columns[i]);
                buf.append(", ");
            }
            return new String(buf);
        }
    }

    public static class SimplePatternSelectNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -8247282157310682761L;
        private Expression expression;

        public SimplePatternSelectNode(QueryPlanNode child, Expression exp) {
            super(child);
            this.expression = exp;
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            Expression[] exps = this.expression.split();
            Variable lhs_var = exps[0].getVariable();
            if (lhs_var != null) {
                Operator op = (Operator)this.expression.last();
                return t.simpleSelect(context, lhs_var, op, exps[1]);
            }
            TObject v = this.expression.evaluate(null, context);
            if (v.isNull() || v.getObject().equals(Boolean.FALSE)) {
                return t.emptySelect();
            }
            return t;
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.expression.discoverTableNames(super.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.expression.discoverCorrelatedVariables(level, super.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            SimplePatternSelectNode node = (SimplePatternSelectNode)super.clone();
            node.expression = (Expression)this.expression.clone();
            return node;
        }

        public String titleString() {
            return "PATTERN: " + this.expression;
        }
    }

    public static class ConstantSelectNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -4435336817396073146L;
        private Expression expression;

        public ConstantSelectNode(QueryPlanNode child, Expression exp) {
            super(child);
            this.expression = exp;
        }

        public Table evaluate(QueryContext context) {
            TObject v = this.expression.evaluate(null, null, context);
            if (v.isNull() || v.getObject().equals(Boolean.FALSE)) {
                return this.child.evaluate(context).emptySelect();
            }
            return this.child.evaluate(context);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.expression.discoverTableNames(super.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.expression.discoverCorrelatedVariables(level, super.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            ConstantSelectNode node = (ConstantSelectNode)super.clone();
            node.expression = (Expression)this.expression.clone();
            return node;
        }

        public String titleString() {
            return "CONSTANT: " + this.expression;
        }
    }

    public static class ExhaustiveSelectNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -2005551680157574172L;
        private Expression expression;

        public ExhaustiveSelectNode(QueryPlanNode child, Expression exp) {
            super(child);
            this.expression = exp;
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            return t.exhaustiveSelect(context, this.expression);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.expression.discoverTableNames(super.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.expression.discoverCorrelatedVariables(level, super.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            ExhaustiveSelectNode node = (ExhaustiveSelectNode)super.clone();
            node.expression = (Expression)this.expression.clone();
            return node;
        }

        public String titleString() {
            return "EXHAUSTIVE: " + this.expression;
        }
    }

    public static class FunctionalSelectNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -1428022600352236457L;
        private Expression expression;

        public FunctionalSelectNode(QueryPlanNode child, Expression exp) {
            super(child);
            this.expression = exp;
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            return t.exhaustiveSelect(context, this.expression);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.expression.discoverTableNames(super.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.expression.discoverCorrelatedVariables(level, super.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            FunctionalSelectNode node = (FunctionalSelectNode)super.clone();
            node.expression = (Expression)this.expression.clone();
            return node;
        }
    }

    public static class MultiColumnEquiSelectNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -1407710412096857588L;
        private Variable[] columns;
        private Expression[] values;

        public MultiColumnEquiSelectNode(QueryPlanNode child, Variable[] columns, Expression[] values) {
            super(child);
            this.columns = columns;
            this.values = values;
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            Operator EQUALS_OP = Operator.get("=");
            for (int i = 0; i < this.columns.length; ++i) {
                t = t.simpleSelect(context, this.columns[i], EQUALS_OP, this.values[i]);
            }
            return t;
        }

        public ArrayList discoverTableNames(ArrayList list) {
            throw new Error("PENDING");
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            throw new Error("PENDING");
        }

        public Object clone() throws CloneNotSupportedException {
            MultiColumnEquiSelectNode node = (MultiColumnEquiSelectNode)super.clone();
            QueryPlan.cloneArray(node.columns);
            QueryPlan.cloneArray(node.values);
            return node;
        }
    }

    public static class SimpleSelectNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = 5502157970886270867L;
        private Variable left_var;
        private Operator op;
        private Expression right_expression;

        public SimpleSelectNode(QueryPlanNode child, Variable left_var, Operator op, Expression right_expression) {
            super(child);
            this.left_var = left_var;
            this.op = op;
            this.right_expression = right_expression;
        }

        public Table evaluate(QueryContext context) {
            Table table = this.child.evaluate(context);
            return table.simpleSelect(context, this.left_var, this.op, this.right_expression);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.right_expression.discoverTableNames(super.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.right_expression.discoverCorrelatedVariables(level, super.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            SimpleSelectNode node = (SimpleSelectNode)super.clone();
            node.left_var = (Variable)this.left_var.clone();
            node.right_expression = (Expression)this.right_expression.clone();
            return node;
        }

        public String titleString() {
            return "SIMPLE: " + this.left_var + this.op + this.right_expression;
        }
    }

    public static class RangeSelectNode
    extends SingleQueryPlanNode {
        static final long serialVersionUID = -108747827391465748L;
        private Expression expression;

        public RangeSelectNode(QueryPlanNode child, Expression exp) {
            super(child);
            this.expression = exp;
        }

        private ArrayList createAndList(ArrayList list, Expression exp) {
            return exp.breakByOperator(list, "and");
        }

        private void updateRange(QueryContext context, SelectableRangeSet range, DataTableColumnDef field, Expression e) {
            Operator op = (Operator)e.last();
            Expression[] exps = e.split();
            TObject cell = exps[1].evaluate(null, null, context);
            TType field_type = field.getTType();
            if (!cell.getTType().comparableTypes(field_type)) {
                cell = new TObject(field_type, null);
            }
            range.intersect(op, cell);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void calcRange(QueryContext context, DataTableColumnDef field, SelectableRangeSet range, Expression exp) {
            Operator op = (Operator)exp.last();
            if (op.isLogical()) {
                if (op.is("and")) {
                    ArrayList and_list = this.createAndList(new ArrayList(), exp);
                    int sz = and_list.size();
                    for (int i = 0; i < sz; ++i) {
                        this.updateRange(context, range, field, (Expression)and_list.get(i));
                    }
                    return;
                } else {
                    if (!op.is("or")) throw new Error("Unrecognised logical operator.");
                    Expression[] exps = exp.split();
                    SelectableRangeSet left = new SelectableRangeSet();
                    this.calcRange(context, field, left, exps[0]);
                    SelectableRangeSet right = new SelectableRangeSet();
                    this.calcRange(context, field, right, exps[1]);
                    range.union(left);
                    range.union(right);
                }
                return;
            } else {
                this.updateRange(context, range, field, exp);
            }
        }

        public Table evaluate(QueryContext context) {
            Table t = this.child.evaluate(context);
            Expression exp = this.expression;
            List all_vars = exp.allVariables();
            Variable v = null;
            int sz = all_vars.size();
            for (int i = 0; i < sz; ++i) {
                Variable cv = (Variable)all_vars.get(i);
                if (v != null && !cv.equals(v)) {
                    throw new Error("Assertion failed: Range plan does not contain common variable.");
                }
                v = cv;
            }
            int col = t.findFieldName(v);
            if (col == -1) {
                throw new Error("Couldn't find column reference in table: " + v);
            }
            DataTableColumnDef field = t.getColumnDefAt(col);
            SelectableRangeSet range = new SelectableRangeSet();
            this.calcRange(context, field, range, exp);
            SelectableRange[] ranges = range.toSelectableRangeArray();
            return t.rangeSelect(v, ranges);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.expression.discoverTableNames(super.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.expression.discoverCorrelatedVariables(level, super.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            RangeSelectNode node = (RangeSelectNode)super.clone();
            node.expression = (Expression)this.expression.clone();
            return node;
        }

        public String titleString() {
            return "RANGE: " + this.expression;
        }
    }

    public static class FetchViewNode
    implements QueryPlanNode {
        static final long serialVersionUID = -6557333346211179284L;
        private TableName table_name;
        private TableName alias_name;

        public FetchViewNode(TableName table_name, TableName aliased_as) {
            this.table_name = table_name;
            this.alias_name = aliased_as;
        }

        public QueryPlanNode createViewChildNode(QueryContext context) {
            DatabaseQueryContext db = (DatabaseQueryContext)context;
            return db.createViewQueryPlanNode(this.table_name);
        }

        public ArrayList discoverTableNames(ArrayList list) {
            if (!list.contains(this.table_name)) {
                list.add(this.table_name);
            }
            return list;
        }

        public Table evaluate(QueryContext context) {
            QueryPlanNode node = this.createViewChildNode(context);
            Table t = node.evaluate(context);
            if (this.alias_name != null) {
                return new ReferenceTable(t, this.alias_name);
            }
            return t;
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return list;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String titleString() {
            return "VIEW: " + this.table_name + " AS " + this.alias_name;
        }

        public void debugString(int level, StringBuffer buf) {
            QueryPlan.indentBuffer(level, buf);
            buf.append(this.titleString());
            buf.append('\n');
        }
    }

    public static class SingleRowTableNode
    implements QueryPlanNode {
        static final long serialVersionUID = -7180494964138911604L;

        public ArrayList discoverTableNames(ArrayList list) {
            return list;
        }

        public Table evaluate(QueryContext context) {
            DatabaseQueryContext db_context = (DatabaseQueryContext)context;
            return db_context.getDatabase().getSingleRowTable();
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return list;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String titleString() {
            return "SINGLE ROW";
        }

        public void debugString(int level, StringBuffer buf) {
            QueryPlan.indentBuffer(level, buf);
            buf.append(this.titleString());
            buf.append('\n');
        }
    }

    public static class FetchTableNode
    implements QueryPlanNode {
        static final long serialVersionUID = 7545493568015241717L;
        private TableName table_name;
        private TableName alias_name;

        public FetchTableNode(TableName table_name, TableName aliased_as) {
            this.table_name = table_name;
            this.alias_name = aliased_as;
        }

        public ArrayList discoverTableNames(ArrayList list) {
            if (!list.contains(this.table_name)) {
                list.add(this.table_name);
            }
            return list;
        }

        public Table evaluate(QueryContext context) {
            DatabaseQueryContext db_context = (DatabaseQueryContext)context;
            DataTable t = db_context.getTable(this.table_name);
            if (this.alias_name != null) {
                return new ReferenceTable((Table)t, this.alias_name);
            }
            return t;
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return list;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String titleString() {
            return "FETCH: " + this.table_name + " AS " + this.alias_name;
        }

        public void debugString(int level, StringBuffer buf) {
            QueryPlan.indentBuffer(level, buf);
            buf.append(this.titleString());
            buf.append('\n');
        }
    }

    public static abstract class BranchQueryPlanNode
    implements QueryPlanNode {
        static final long serialVersionUID = 2938130775577221138L;
        protected QueryPlanNode left;
        protected QueryPlanNode right;

        protected BranchQueryPlanNode(QueryPlanNode left, QueryPlanNode right) {
            this.left = left;
            this.right = right;
        }

        public QueryPlanNode left() {
            return this.left;
        }

        public QueryPlanNode right() {
            return this.right;
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.right.discoverTableNames(this.left.discoverTableNames(list));
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.right.discoverCorrelatedVariables(level, this.left.discoverCorrelatedVariables(level, list));
        }

        public Object clone() throws CloneNotSupportedException {
            BranchQueryPlanNode node = (BranchQueryPlanNode)super.clone();
            node.left = (QueryPlanNode)this.left.clone();
            node.right = (QueryPlanNode)this.right.clone();
            return node;
        }

        public String titleString() {
            return this.getClass().getName();
        }

        public void debugString(int level, StringBuffer buf) {
            QueryPlan.indentBuffer(level, buf);
            buf.append(this.titleString());
            buf.append('\n');
            this.left.debugString(level + 2, buf);
            this.right.debugString(level + 2, buf);
        }
    }

    public static abstract class SingleQueryPlanNode
    implements QueryPlanNode {
        static final long serialVersionUID = -6753991881140638658L;
        protected QueryPlanNode child;

        protected SingleQueryPlanNode(QueryPlanNode child) {
            this.child = child;
        }

        public QueryPlanNode child() {
            return this.child;
        }

        public ArrayList discoverTableNames(ArrayList list) {
            return this.child.discoverTableNames(list);
        }

        public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
            return this.child.discoverCorrelatedVariables(level, list);
        }

        public Object clone() throws CloneNotSupportedException {
            SingleQueryPlanNode node = (SingleQueryPlanNode)super.clone();
            node.child = (QueryPlanNode)this.child.clone();
            return node;
        }

        public String titleString() {
            return this.getClass().getName();
        }

        public void debugString(int level, StringBuffer buf) {
            QueryPlan.indentBuffer(level, buf);
            buf.append(this.titleString());
            buf.append('\n');
            this.child.debugString(level + 2, buf);
        }
    }
}

