/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.TableName;

public class ProcedureName {
    private final String schema;
    private final String name;

    public ProcedureName(String schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public ProcedureName(TableName table_name) {
        this(table_name.getSchema(), table_name.getName());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.schema + "." + this.name;
    }

    public static ProcedureName qualify(String current_schema, String proc_name) {
        int delim = proc_name.indexOf(".");
        if (delim == -1) {
            return new ProcedureName(current_schema, proc_name);
        }
        return new ProcedureName(proc_name.substring(0, delim), proc_name.substring(delim + 1, proc_name.length()));
    }

    public boolean equals(Object ob) {
        ProcedureName src_ob = (ProcedureName)ob;
        return this.schema.equals(src_ob.schema) && this.name.equals(src_ob.name);
    }

    public int hashCode() {
        return this.schema.hashCode() + this.name.hashCode();
    }
}

