/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

public class Privileges {
    static final int BIT_COUNT = 11;
    static final int BIT_MASK = 2047;
    public static final int ALL = 2047;
    public static final int SELECT = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 4;
    public static final int INSERT = 8;
    public static final int REFERENCES = 16;
    public static final int USAGE = 32;
    public static final int COMPACT = 64;
    public static final int CREATE = 128;
    public static final int ALTER = 256;
    public static final int DROP = 512;
    public static final int LIST = 1024;
    private int privs;
    public static final Privileges EMPTY_PRIVS;
    public static final Privileges TABLE_ALL_PRIVS;
    public static final Privileges TABLE_READ_PRIVS;
    public static final Privileges SCHEMA_ALL_PRIVS;
    public static final Privileges SCHEMA_READ_PRIVS;
    public static final Privileges PROCEDURE_ALL_PRIVS;
    public static final Privileges PROCEDURE_EXECUTE_PRIVS;

    private Privileges(int privs) {
        this.privs = privs & 0x7FF;
    }

    public Privileges() {
        this(0);
    }

    public Privileges add(int priv) {
        return new Privileges(this.privs | priv);
    }

    public Privileges remove(int priv) {
        int and_priv = this.privs & priv;
        return new Privileges(this.privs ^ and_priv);
    }

    public Privileges remove(Privileges privs) {
        return this.remove(privs.privs);
    }

    public boolean permits(int priv) {
        return (this.privs & priv) != 0;
    }

    public Privileges merge(Privileges in_privs) {
        return this.add(in_privs.privs);
    }

    public boolean isEmpty() {
        return this.privs == 0;
    }

    static String formatPriv(int priv) {
        if ((priv & 1) != 0) {
            return "SELECT";
        }
        if ((priv & 2) != 0) {
            return "DELETE";
        }
        if ((priv & 4) != 0) {
            return "UPDATE";
        }
        if ((priv & 8) != 0) {
            return "INSERT";
        }
        if ((priv & 0x10) != 0) {
            return "REFERENCES";
        }
        if ((priv & 0x20) != 0) {
            return "USAGE";
        }
        if ((priv & 0x40) != 0) {
            return "COMPACT";
        }
        if ((priv & 0x80) != 0) {
            return "CREATE";
        }
        if ((priv & 0x100) != 0) {
            return "ALTER";
        }
        if ((priv & 0x200) != 0) {
            return "DROP";
        }
        if ((priv & 0x400) != 0) {
            return "LIST";
        }
        throw new Error("Not priv bit set.");
    }

    public static int parseString(String priv) {
        if (priv.equals("SELECT")) {
            return 1;
        }
        if (priv.equals("DELETE")) {
            return 2;
        }
        if (priv.equals("UPDATE")) {
            return 4;
        }
        if (priv.equals("INSERT")) {
            return 8;
        }
        if (priv.equals("REFERENCES")) {
            return 16;
        }
        if (priv.equals("USAGE")) {
            return 32;
        }
        if (priv.equals("COMPACT")) {
            return 64;
        }
        if (priv.equals("CREATE")) {
            return 128;
        }
        if (priv.equals("ALTER")) {
            return 256;
        }
        if (priv.equals("DROP")) {
            return 512;
        }
        if (priv.equals("LIST")) {
            return 1024;
        }
        throw new Error("Priv not recognised.");
    }

    public int toInt() {
        return this.privs;
    }

    public String toEncodedString() {
        StringBuffer buf = new StringBuffer();
        buf.append("||");
        int priv_bit = 1;
        for (int i = 0; i < 11; ++i) {
            if ((this.privs & priv_bit) != 0) {
                buf.append(Privileges.formatPriv(priv_bit));
                buf.append("||");
            }
            priv_bit <<= 1;
        }
        return new String(buf);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int priv_bit = 1;
        for (int i = 0; i < 11; ++i) {
            if ((this.privs & priv_bit) != 0) {
                buf.append(Privileges.formatPriv(priv_bit));
                buf.append(' ');
            }
            priv_bit <<= 1;
        }
        return new String(buf);
    }

    public boolean equals(Object ob) {
        return this.privs == ((Privileges)ob).privs;
    }

    static {
        Privileges p = EMPTY_PRIVS = new Privileges();
        p = p.add(1);
        p = p.add(2);
        p = p.add(4);
        p = p.add(8);
        p = p.add(16);
        p = p.add(32);
        TABLE_ALL_PRIVS = p = p.add(64);
        p = EMPTY_PRIVS;
        p = p.add(1);
        TABLE_READ_PRIVS = p = p.add(32);
        p = EMPTY_PRIVS;
        p = p.add(128);
        p = p.add(256);
        p = p.add(512);
        SCHEMA_ALL_PRIVS = p = p.add(1024);
        p = EMPTY_PRIVS;
        SCHEMA_READ_PRIVS = p = p.add(1024);
        p = EMPTY_PRIVS;
        p = p.add(1);
        p = p.add(2);
        p = p.add(4);
        PROCEDURE_ALL_PRIVS = p = p.add(8);
        p = EMPTY_PRIVS;
        PROCEDURE_EXECUTE_PRIVS = p = p.add(1);
    }
}

