/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlindSearch;
import com.mckoi.database.RawTableInformation;
import com.mckoi.database.RootTable;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.VirtualTable;
import com.mckoi.util.IntegerVector;

class OuterTable
extends VirtualTable
implements RootTable {
    public IntegerVector[] outer_rows;
    private int outer_row_count;

    public OuterTable(Table input_table) {
        RawTableInformation base_table = input_table.resolveToRawTable(new RawTableInformation());
        Table[] tables = base_table.getTables();
        IntegerVector[] rows = base_table.getRows();
        this.outer_rows = new IntegerVector[rows.length];
        this.init(tables);
        this.set(tables, rows);
    }

    public void mergeIn(Table outside_table) {
        RawTableInformation raw_table_info = outside_table.resolveToRawTable(new RawTableInformation());
        Table[] base_tables = this.getReferenceTables();
        IntegerVector[] base_rows = this.getReferenceRows();
        Table[] tables = raw_table_info.getTables();
        IntegerVector[] rows = raw_table_info.getRows();
        this.outer_row_count = rows[0].size();
        for (int i = 0; i < base_tables.length; ++i) {
            IntegerVector list;
            Table btable = base_tables[i];
            int index = -1;
            for (int n = 0; n < tables.length && index == -1; ++n) {
                if (btable != tables[n]) continue;
                index = n;
            }
            if (index == -1) {
                this.outer_rows[i] = null;
                continue;
            }
            this.outer_rows[i] = list = new IntegerVector(this.outer_row_count);
            IntegerVector to_merge = rows[index];
            if (to_merge.size() != this.outer_row_count) {
                throw new Error("Wrong size for rows being merged in.");
            }
            list.append(to_merge);
        }
    }

    public int getRowCount() {
        return super.getRowCount() + this.outer_row_count;
    }

    SelectableScheme getSelectableSchemeFor(int column, int original_column, Table table) {
        if (this.column_scheme[column] == null) {
            BlindSearch scheme = new BlindSearch(this, column);
            this.column_scheme[column] = scheme.getSubsetScheme(this, column);
        }
        if (table == this) {
            return this.column_scheme[column];
        }
        return this.column_scheme[column].getSubsetScheme(table, original_column);
    }

    public TObject getCellContents(int column, int row) {
        int table_num = this.column_table[column];
        Table parent_table = this.reference_list[table_num];
        if (row >= this.outer_row_count) {
            row = this.row_list[table_num].intAt(row - this.outer_row_count);
            return parent_table.getCellContents(this.column_filter[column], row);
        }
        if (this.outer_rows[table_num] == null) {
            return new TObject(this.getColumnDefAt(column).getTType(), null);
        }
        row = this.outer_rows[table_num].intAt(row);
        return parent_table.getCellContents(this.column_filter[column], row);
    }

    public boolean typeEquals(RootTable table) {
        return this == table;
    }
}

