/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Transaction;
import com.mckoi.database.TransactionSystem;
import java.util.ArrayList;

final class OpenTransactionList {
    private static final boolean TRACKING = false;
    private TransactionSystem system;
    private ArrayList open_transactions;
    private ArrayList open_transaction_stacks;
    private long minimum_commit_id;
    private long maximum_commit_id;

    OpenTransactionList(TransactionSystem system) {
        this.system = system;
        this.open_transactions = new ArrayList();
        this.minimum_commit_id = Long.MAX_VALUE;
        this.maximum_commit_id = 0L;
    }

    synchronized void addTransaction(Transaction transaction) {
        long current_commit_id = transaction.getCommitID();
        if (current_commit_id < this.maximum_commit_id) {
            throw new Error("Added a transaction with a lower than maximum commit_id");
        }
        this.open_transactions.add(transaction);
        this.system.stats().increment("OpenTransactionList.count");
        this.maximum_commit_id = current_commit_id;
    }

    synchronized void removeTransaction(Transaction transaction) {
        int size = this.open_transactions.size();
        int i = this.open_transactions.indexOf(transaction);
        if (i == 0) {
            if (i == size - 1) {
                this.minimum_commit_id = Integer.MAX_VALUE;
                this.maximum_commit_id = 0L;
            } else {
                this.minimum_commit_id = ((Transaction)this.open_transactions.get(i + 1)).getCommitID();
            }
        } else if (i == this.open_transactions.size() - 1) {
            this.maximum_commit_id = ((Transaction)this.open_transactions.get(i - 1)).getCommitID();
        } else if (i == -1) {
            throw new Error("Unable to find transaction in the list.");
        }
        this.open_transactions.remove(i);
        this.system.stats().decrement("OpenTransactionList.count");
    }

    synchronized int count() {
        return this.open_transactions.size();
    }

    synchronized long minimumCommitID(Transaction transaction) {
        long minimum_commit_id = Long.MAX_VALUE;
        if (this.open_transactions.size() > 0) {
            Transaction test_transaction = (Transaction)this.open_transactions.get(0);
            if (test_transaction != transaction) {
                minimum_commit_id = test_transaction.getCommitID();
            } else if (this.open_transactions.size() > 1) {
                minimum_commit_id = ((Transaction)this.open_transactions.get(1)).getCommitID();
            }
        }
        return minimum_commit_id;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ OpenTransactionList: ");
        for (int i = 0; i < this.open_transactions.size(); ++i) {
            Transaction t = (Transaction)this.open_transactions.get(i);
            buf.append(t.getCommitID());
            buf.append(", ");
        }
        buf.append(" ]");
        return new String(buf);
    }
}

