/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.JoinedTable;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SimpleRowEnumeration;
import com.mckoi.database.Table;
import com.mckoi.util.IntegerVector;

public final class NaturallyJoinedTable
extends JoinedTable {
    private final int left_row_count;
    private final int right_row_count;
    private final IntegerVector left_set;
    private final IntegerVector right_set;
    private final boolean left_is_simple_enum;
    private final boolean right_is_simple_enum;

    public NaturallyJoinedTable(Table left, Table right) {
        super.init(new Table[]{left, right});
        this.left_row_count = left.getRowCount();
        this.right_row_count = right.getRowCount();
        this.left_is_simple_enum = left.rowEnumeration() instanceof SimpleRowEnumeration;
        this.right_is_simple_enum = right.rowEnumeration() instanceof SimpleRowEnumeration;
        this.left_set = !this.left_is_simple_enum ? NaturallyJoinedTable.createLookupRowList(left) : null;
        this.right_set = !this.right_is_simple_enum ? NaturallyJoinedTable.createLookupRowList(right) : null;
    }

    private static IntegerVector createLookupRowList(Table t) {
        IntegerVector ivec = new IntegerVector();
        RowEnumeration rowEnumeration = t.rowEnumeration();
        while (rowEnumeration.hasMoreRows()) {
            int row_index = rowEnumeration.nextRowIndex();
            ivec.addInt(row_index);
        }
        return ivec;
    }

    private int getLeftRowIndex(int row_index) {
        if (this.left_is_simple_enum) {
            return row_index;
        }
        return this.left_set.intAt(row_index);
    }

    private int getRightRowIndex(int row_index) {
        if (this.right_is_simple_enum) {
            return row_index;
        }
        return this.right_set.intAt(row_index);
    }

    public int getRowCount() {
        return this.left_row_count * this.right_row_count;
    }

    protected int resolveRowForTableAt(int row_number, int table_num) {
        if (table_num == 0) {
            return this.getLeftRowIndex(row_number / this.right_row_count);
        }
        return this.getRightRowIndex(row_number % this.right_row_count);
    }

    protected void resolveAllRowsForTableAt(IntegerVector row_set, int table_num) {
        boolean pick_right_table = table_num == 1;
        for (int n = row_set.size() - 1; n >= 0; --n) {
            int aa = row_set.intAt(n);
            int parent_row = pick_right_table ? this.getRightRowIndex(aa % this.right_row_count) : this.getLeftRowIndex(aa / this.right_row_count);
            row_set.setIntAt(parent_row, n);
        }
    }
}

