/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.MasterTableJournal;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionSystem;
import com.mckoi.debug.DebugLogger;
import java.util.ArrayList;

final class MultiVersionTableIndices {
    private final TableName table_name;
    private final int column_count;
    private final TransactionSystem system;
    private ArrayList transaction_mod_list;
    private String journal_count_stat_key;
    private long TS_merge_count = 0L;
    private long TS_merge_size = 0L;

    MultiVersionTableIndices(TransactionSystem system, TableName table_name, int column_count) {
        this.system = system;
        this.table_name = table_name;
        this.column_count = column_count;
        this.transaction_mod_list = new ArrayList();
        this.journal_count_stat_key = "MultiVersionTableIndices.journal_entries." + table_name;
    }

    public final DebugLogger Debug() {
        return this.system.Debug();
    }

    boolean mergeJournalChanges(long commit_id) {
        ++this.TS_merge_count;
        this.TS_merge_size += (long)this.transaction_mod_list.size();
        if (this.TS_merge_count % 32L == 0L) {
            this.system.stats().set((int)(this.TS_merge_size * 1000000L / this.TS_merge_count), "MultiVersionTableIndices.average_journal_merge_mul_1000000");
        }
        int merge_count = 0;
        int size = this.transaction_mod_list.size();
        while (this.transaction_mod_list.size() > 0) {
            MasterTableJournal journal = (MasterTableJournal)this.transaction_mod_list.get(0);
            if (commit_id > journal.getCommitID()) {
                ++merge_count;
                if (this.Debug().isInterestedIn(10)) {
                    this.Debug().write(10, this, "Merging '" + this.table_name + "' journal: " + journal);
                }
                this.transaction_mod_list.remove(0);
                this.system.stats().decrement(this.journal_count_stat_key);
                continue;
            }
            return false;
        }
        return true;
    }

    MasterTableJournal[] findAllJournalsSince(long commit_id) {
        ArrayList<MasterTableJournal> all_since = new ArrayList<MasterTableJournal>();
        int size = this.transaction_mod_list.size();
        for (int i = 0; i < size; ++i) {
            MasterTableJournal journal = (MasterTableJournal)this.transaction_mod_list.get(i);
            long journal_commit_id = journal.getCommitID();
            if (journal_commit_id < commit_id) continue;
            all_since.add(journal);
        }
        return all_since.toArray(new MasterTableJournal[all_since.size()]);
    }

    void addTransactionJournal(MasterTableJournal change) {
        this.transaction_mod_list.add(change);
        this.system.stats().increment(this.journal_count_stat_key);
    }

    boolean hasTransactionChangesPending() {
        return this.transaction_mod_list.size() > 0;
    }

    String transactionChangeString() {
        return this.transaction_mod_list.toString();
    }
}

