/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.TransactionException;
import com.mckoi.util.IntegerVector;
import java.io.DataInputStream;
import java.io.IOException;

final class MasterTableJournal {
    static final byte TABLE_ADD = 1;
    static final byte TABLE_REMOVE = 2;
    static final byte TABLE_UPDATE_ADD = 5;
    static final byte TABLE_UPDATE_REMOVE = 6;
    private long commit_id;
    private int table_id;
    private int journal_entries;
    private byte[] command_journal;
    private IntegerVector command_parameters;

    MasterTableJournal(int table_id) {
        this.table_id = table_id;
        this.command_journal = new byte[16];
        this.command_parameters = new IntegerVector(32);
    }

    MasterTableJournal() {
        this(-1);
    }

    void setCommitID(long commit_id) {
        this.commit_id = commit_id;
    }

    static boolean isAddCommand(byte command) {
        return (command & 3) == 1;
    }

    static boolean isRemoveCommand(byte command) {
        return (command & 3) == 2;
    }

    private void addCommand(byte command) {
        if (this.journal_entries >= this.command_journal.length) {
            int grow_size = Math.min(4000, this.journal_entries);
            grow_size = Math.max(4, grow_size);
            byte[] new_command_journal = new byte[this.journal_entries + grow_size];
            System.arraycopy(this.command_journal, 0, new_command_journal, 0, this.journal_entries);
            this.command_journal = new_command_journal;
        }
        this.command_journal[this.journal_entries] = command;
        ++this.journal_entries;
    }

    private void addParameter(int param) {
        this.command_parameters.addInt(param);
    }

    private void removeTopEntries(int n) {
        this.journal_entries -= n;
        this.command_parameters.crop(0, this.command_parameters.size() - n);
    }

    void addEntry(byte command, int row_index) {
        this.addCommand(command);
        this.addParameter(row_index);
    }

    long getCommitID() {
        return this.commit_id;
    }

    int getTableID() {
        return this.table_id;
    }

    int entries() {
        return this.journal_entries;
    }

    byte getCommand(int n) {
        return this.command_journal[n];
    }

    int getRowIndex(int n) {
        return this.command_parameters.intAt(n);
    }

    int[] normalizedAddedRows() {
        IntegerVector list = new IntegerVector();
        int size = this.entries();
        for (int i = 0; i < size; ++i) {
            int row_index;
            byte tc = this.getCommand(i);
            if (tc == 1 || tc == 5) {
                row_index = this.getRowIndex(i);
                list.addInt(row_index);
                continue;
            }
            if (tc == 2 || tc == 6) {
                row_index = this.getRowIndex(i);
                int found_at = list.indexOf(row_index);
                if (found_at == -1) continue;
                list.removeIntAt(found_at);
                continue;
            }
            throw new Error("Unknown command in journal.");
        }
        return list.toIntArray();
    }

    int[] normalizedRemovedRows() {
        IntegerVector list = new IntegerVector();
        int size = this.entries();
        for (int i = 0; i < size; ++i) {
            byte tc = this.getCommand(i);
            if (tc != 2 && tc != 6) continue;
            int row_index = this.getRowIndex(i);
            list.addInt(row_index);
        }
        return list.toIntArray();
    }

    IntegerVector[] allChangeInformation() {
        IntegerVector[] lists = new IntegerVector[3];
        for (int i = 0; i < 3; ++i) {
            lists[i] = new IntegerVector();
        }
        int size = this.entries();
        for (int i = 0; i < size; ++i) {
            byte tc = this.getCommand(i);
            int row_index = this.getRowIndex(i);
            if (tc == 1) {
                lists[0].addInt(row_index);
                continue;
            }
            if (tc == 2) {
                lists[1].addInt(row_index);
                continue;
            }
            if (tc == 5 || tc == 6) {
                lists[2].addInt(row_index);
                continue;
            }
            throw new RuntimeException("Don't understand journal command.");
        }
        return lists;
    }

    void rollbackEntries(int n) {
        int i;
        if (n > this.journal_entries) {
            throw new RuntimeException("Trying to roll back more journal entries than are in the journal.");
        }
        IntegerVector to_add = new IntegerVector();
        int size = this.entries();
        for (i = size - n; i < size; ++i) {
            byte tc = this.getCommand(i);
            if (tc != 1 && tc != 5) continue;
            to_add.addInt(this.getRowIndex(i));
        }
        this.removeTopEntries(n);
        for (i = 0; i < to_add.size(); ++i) {
            this.addEntry((byte)1, to_add.intAt(i));
            this.addEntry((byte)2, to_add.intAt(i));
        }
    }

    void testCommitClash(DataTableDef table_def, MasterTableJournal journal) throws TransactionException {
        for (int i = 0; i < this.entries(); ++i) {
            byte tc = this.getCommand(i);
            if (!MasterTableJournal.isRemoveCommand(tc)) continue;
            int row_index = this.getRowIndex(i);
            for (int n = 0; n < journal.entries(); ++n) {
                if (!MasterTableJournal.isRemoveCommand(journal.getCommand(n)) || journal.getRowIndex(n) != row_index) continue;
                throw new TransactionException(1, "Concurrent Serializable Transaction Conflict(1): Current row remove clash ( row: " + row_index + ", table: " + table_def.getTableName() + " )");
            }
        }
    }

    void readFrom(DataInputStream din) throws IOException {
        this.commit_id = din.readInt();
        this.table_id = din.readInt();
        this.journal_entries = din.readInt();
        this.command_journal = new byte[this.journal_entries];
        din.readFully(this.command_journal, 0, this.journal_entries);
        int size = din.readInt();
        for (int i = 0; i < size; ++i) {
            this.command_parameters.addInt(din.readInt());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[MasterTableJournal] [");
        buf.append(this.commit_id);
        buf.append("] (");
        for (int i = 0; i < this.entries(); ++i) {
            byte c = this.getCommand(i);
            int row_index = this.getRowIndex(i);
            buf.append("(");
            buf.append(c);
            buf.append(")");
            buf.append(row_index);
            buf.append(" ");
        }
        buf.append(")");
        return new String(buf);
    }
}

