/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.MasterTableDataSource;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.BlockIntegerList;
import java.io.IOException;

final class MasterTableGarbageCollector {
    private MasterTableDataSource data_source;
    private boolean full_sweep_due;
    private BlockIntegerList deleted_rows;
    private long last_garbage_success_event;
    private long last_garbage_try_event;

    MasterTableGarbageCollector(MasterTableDataSource data_source) {
        this.data_source = data_source;
        this.full_sweep_due = false;
        this.deleted_rows = new BlockIntegerList();
        this.last_garbage_success_event = System.currentTimeMillis();
        this.last_garbage_try_event = -1L;
    }

    public final DebugLogger Debug() {
        return this.data_source.Debug();
    }

    void markRowAsDeleted(int row_index) {
        boolean b;
        if (!this.full_sweep_due && !(b = this.deleted_rows.uniqueInsertSort(row_index))) {
            throw new Error("Row marked twice for deletion.");
        }
    }

    void markFullSweep() {
        this.full_sweep_due = true;
        if (this.deleted_rows.size() > 0) {
            this.deleted_rows = new BlockIntegerList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performCollectionEvent(boolean force) {
        try {
            int check_count = 0;
            int delete_count = 0;
            MasterTableDataSource masterTableDataSource = this.data_source;
            synchronized (masterTableDataSource) {
                if (this.data_source.isClosed()) {
                    return;
                }
                if (force || !this.data_source.isRootLocked() && !this.data_source.hasTransactionChangesPending()) {
                    this.last_garbage_success_event = System.currentTimeMillis();
                    this.last_garbage_try_event = -1L;
                    if (this.full_sweep_due) {
                        int raw_row_count = this.data_source.rawRowCount();
                        for (int i = 0; i < raw_row_count; ++i) {
                            boolean b = this.data_source.hardCheckAndReclaimRow(i);
                            if (b) {
                                ++delete_count;
                            }
                            ++check_count;
                        }
                        this.full_sweep_due = false;
                    } else {
                        int size = this.deleted_rows.size();
                        if (size > 0) {
                            for (int i = 0; i < size; ++i) {
                                int row_index = this.deleted_rows.get(i);
                                this.data_source.hardRemoveRow(row_index);
                                ++delete_count;
                                ++check_count;
                            }
                        }
                        this.deleted_rows = new BlockIntegerList();
                    }
                    if (check_count > 0 && this.Debug().isInterestedIn(10)) {
                        this.Debug().write(10, this, "Row GC: [" + this.data_source.getName() + "] check_count=" + check_count + " delete count=" + delete_count);
                        this.Debug().write(10, this, "GC row sweep deleted " + delete_count + " rows.");
                    }
                }
            }
        }
        catch (IOException e) {
            this.Debug().writeException(e);
        }
    }

    private class CollectionEvent
    implements Runnable {
        private CollectionEvent() {
        }

        public void run() {
            MasterTableGarbageCollector.this.performCollectionEvent(false);
        }
    }
}

