/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlindSearch;
import com.mckoi.database.BlobStoreInterface;
import com.mckoi.database.DataCellCache;
import com.mckoi.database.DataIndexDef;
import com.mckoi.database.DataIndexSetDef;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConstraintViolationException;
import com.mckoi.database.IndexSet;
import com.mckoi.database.InsertSearch;
import com.mckoi.database.MasterTableGarbageCollector;
import com.mckoi.database.MasterTableJournal;
import com.mckoi.database.MultiVersionTableIndices;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.OpenTransactionList;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RIDList;
import com.mckoi.database.RawDiagnosticTable;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.SimpleTransaction;
import com.mckoi.database.StoreSystem;
import com.mckoi.database.SystemQueryContext;
import com.mckoi.database.TObject;
import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.TransactionSystem;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.IntegerIterator;
import com.mckoi.util.IntegerListInterface;
import com.mckoi.util.IntegerVector;
import java.io.IOException;

abstract class MasterTableDataSource {
    private TransactionSystem system;
    private StoreSystem store_system;
    protected int table_id;
    protected boolean is_closed;
    private int root_lock;
    protected DataTableDef table_def;
    protected DataIndexSetDef index_def;
    private TableName cached_table_name;
    protected MultiVersionTableIndices table_indices;
    protected RIDList[] column_rid_list;
    protected boolean DATA_CELL_CACHING = true;
    protected final DataCellCache cache;
    protected int column_count;
    private OpenTransactionList open_transactions;
    protected MasterTableGarbageCollector garbage_collector;
    protected BlobStoreInterface blob_store_interface;
    protected String root_lock_key;
    protected String total_hits_key;
    protected String file_hits_key;
    protected String delete_hits_key;
    protected String insert_hits_key;

    MasterTableDataSource(TransactionSystem system, StoreSystem store_system, OpenTransactionList open_transactions, BlobStoreInterface blob_store_interface) {
        this.system = system;
        this.store_system = store_system;
        this.open_transactions = open_transactions;
        this.blob_store_interface = blob_store_interface;
        this.garbage_collector = new MasterTableGarbageCollector(this);
        this.cache = system.getDataCellCache();
        this.is_closed = true;
        if (this.DATA_CELL_CACHING) {
            this.DATA_CELL_CACHING = this.cache != null;
        }
    }

    public final TransactionSystem getSystem() {
        return this.system;
    }

    public final DebugLogger Debug() {
        return this.getSystem().Debug();
    }

    public TableName getTableName() {
        return this.getDataTableDef().getTableName();
    }

    public String getName() {
        return this.getDataTableDef().getName();
    }

    public String getSchema() {
        return this.getDataTableDef().getSchema();
    }

    synchronized TableName cachedTableName() {
        if (this.cached_table_name != null) {
            return this.cached_table_name;
        }
        this.cached_table_name = this.getTableName();
        return this.cached_table_name;
    }

    synchronized void mergeJournalChanges(long commit_id) {
        boolean all_merged = this.table_indices.mergeJournalChanges(commit_id);
        if (all_merged && !this.isReadOnly()) {
            this.checkForCleanup();
        }
    }

    synchronized MasterTableJournal[] findAllJournalsSince(long commit_id) {
        return this.table_indices.findAllJournalsSince(commit_id);
    }

    int getTableID() {
        return this.table_id;
    }

    DataTableDef getDataTableDef() {
        return this.table_def;
    }

    DataIndexSetDef getDataIndexSetDef() {
        return this.index_def;
    }

    protected static String makeTableFileName(TransactionSystem system, int table_id, TableName table_name) {
        String tid = Integer.toString(table_id);
        int pad = 3 - tid.length();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pad; ++i) {
            buf.append('0');
        }
        String str = table_name.toString().replace('.', '_');
        StringBuffer osified_name = new StringBuffer();
        int count = 0;
        for (int i = 0; i < str.length() || count > 64; ++i) {
            char c = str.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && c != '_') continue;
            osified_name.append(c);
            ++count;
        }
        return new String(buf) + tid + new String(osified_name);
    }

    abstract String getSourceIdent();

    abstract int writeRecordType(int var1, int var2) throws IOException;

    abstract int readRecordType(int var1) throws IOException;

    abstract boolean recordDeleted(int var1) throws IOException;

    abstract int rawRowCount() throws IOException;

    abstract void internalDeleteRow(int var1) throws IOException;

    abstract IndexSet createIndexSet();

    abstract void commitIndexSet(IndexSet var1);

    abstract int internalAddRow(RowData var1) throws IOException;

    abstract TObject internalGetCellContents(int var1, int var2);

    abstract long currentUniqueID();

    abstract long nextUniqueID();

    abstract void setUniqueID(long var1);

    abstract void dispose(boolean var1) throws IOException;

    abstract boolean drop() throws IOException;

    abstract void shutdownHookCleanup();

    boolean isWorthCompacting() {
        return true;
    }

    synchronized SelectableScheme createSelectableSchemeForColumn(IndexSet index_set, TableDataSource table, int column) {
        DataTableColumnDef column_def = this.getDataTableDef().columnAt(column);
        if (!column_def.isIndexableType()) {
            return new BlindSearch(table, column);
        }
        String scheme_type = column_def.getIndexScheme();
        if (scheme_type.equals("InsertSearch")) {
            DataIndexSetDef index_set_def = this.getDataIndexSetDef();
            int index_i = index_set_def.findIndexForColumns(new String[]{column_def.getName()});
            return this.createSelectableSchemeForIndex(index_set, table, index_i);
        }
        if (scheme_type.equals("BlindSearch")) {
            return new BlindSearch(table, column);
        }
        throw new Error("Unknown scheme type");
    }

    synchronized SelectableScheme createSelectableSchemeForIndex(IndexSet index_set, TableDataSource table, int index_i) {
        DataIndexDef index_def = this.getDataIndexSetDef().indexAt(index_i);
        if (index_def.getType().equals("BLIST")) {
            String[] cols = index_def.getColumnNames();
            DataTableDef table_def = this.getDataTableDef();
            if (cols.length == 1) {
                int col_index = table_def.findColumnName(cols[0]);
                IntegerListInterface index_list = index_set.getIndex(index_def.getPointer());
                InsertSearch iis = new InsertSearch(table, col_index, index_list);
                return iis;
            }
            throw new RuntimeException("Multi-column indexes not supported at this time.");
        }
        throw new RuntimeException("Unrecognised type.");
    }

    protected TableDataSource minimalTableDataSource(final IntegerListInterface master_index) {
        return new TableDataSource(){

            public TransactionSystem getSystem() {
                return MasterTableDataSource.this.system;
            }

            public DataTableDef getDataTableDef() {
                return MasterTableDataSource.this.getDataTableDef();
            }

            public int getRowCount() {
                return master_index.size();
            }

            public RowEnumeration rowEnumeration() {
                IntegerIterator iterator = master_index.iterator();
                return new RowEnumeration(this, iterator){
                    private final /* synthetic */ IntegerIterator val$iterator;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$iterator = val$iterator;
                    }

                    public boolean hasMoreRows() {
                        return this.val$iterator.hasNext();
                    }

                    public int nextRowIndex() {
                        return this.val$iterator.next();
                    }
                };
            }

            public SelectableScheme getColumnScheme(int column) {
                throw new Error("Not implemented.");
            }

            public TObject getCellContents(int column, int row) {
                return MasterTableDataSource.this.getCellContents(column, row);
            }
        };
    }

    synchronized void buildIndexes() throws IOException {
        IndexSet index_set = this.createIndexSet();
        DataIndexSetDef index_set_def = this.getDataIndexSetDef();
        int row_count = this.rawRowCount();
        IntegerListInterface master_index = index_set.getIndex(0);
        for (int row_index = 0; row_index < row_count; ++row_index) {
            boolean inserted;
            if (this.recordDeleted(row_index) || (inserted = master_index.uniqueInsertSort(row_index))) continue;
            throw new RuntimeException("Assertion failed: Master index entry was duplicated.");
        }
        this.commitIndexSet(index_set);
        int index_count = index_set_def.indexCount();
        for (int i = 0; i < index_count; ++i) {
            this.buildIndex(i);
        }
    }

    synchronized void buildIndex(int index_number) throws IOException {
        DataIndexSetDef index_set_def = this.getDataIndexSetDef();
        IndexSet index_set = this.createIndexSet();
        IntegerListInterface master_index = index_set.getIndex(0);
        TableDataSource min_table_source = this.minimalTableDataSource(master_index);
        SelectableScheme scheme = this.createSelectableSchemeForIndex(index_set, min_table_source, index_number);
        int row_count = this.rawRowCount();
        for (int row_index = 0; row_index < row_count; ++row_index) {
            if (this.recordDeleted(row_index)) continue;
            scheme.insert(row_index);
        }
        this.commitIndexSet(index_set);
    }

    synchronized void commitTransactionChange(long commit_id, MasterTableJournal change, IndexSet index_set) {
        if (this.isReadOnly()) {
            throw new Error("Can't commit transaction journal, table is read only.");
        }
        change.setCommitID(commit_id);
        try {
            this.table_indices.addTransactionJournal(change);
            this.commitIndexSet(index_set);
            int size = change.entries();
            for (int i = 0; i < size; ++i) {
                int old_type;
                byte b = change.getCommand(i);
                int row_index = change.getRowIndex(i);
                if (MasterTableJournal.isAddCommand(b)) {
                    old_type = this.writeRecordType(row_index, 16);
                    if ((old_type & 0xF0) == 0) continue;
                    this.writeRecordType(row_index, old_type & 0xF0);
                    throw new Error("Record " + row_index + " of table " + this + " was not in an uncommitted state!");
                }
                if (!MasterTableJournal.isRemoveCommand(b)) continue;
                old_type = this.writeRecordType(row_index, 32);
                if ((old_type & 0xF0) != 16) {
                    this.writeRecordType(row_index, old_type & 0xF0);
                    throw new Error("Record " + row_index + " of table " + this + " was not in an added state!");
                }
                this.garbage_collector.markRowAsDeleted(row_index);
            }
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new Error("IO Error: " + e.getMessage());
        }
    }

    synchronized void rollbackTransactionChange(MasterTableJournal change) {
        if (this.isReadOnly()) {
            throw new Error("Can't rollback transaction journal, table is read only.");
        }
        try {
            int size = change.entries();
            for (int i = 0; i < size; ++i) {
                byte b = change.getCommand(i);
                int row_index = change.getRowIndex(i);
                if (MasterTableJournal.isAddCommand(b)) {
                    int old_type = this.writeRecordType(row_index, 32);
                    if ((old_type & 0xF0) != 0) {
                        this.writeRecordType(row_index, old_type & 0xF0);
                        throw new Error("Record " + row_index + " was not in an " + "uncommitted state!");
                    }
                    this.garbage_collector.markRowAsDeleted(row_index);
                    continue;
                }
                if (!MasterTableJournal.isRemoveCommand(b)) continue;
            }
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new Error("IO Error: " + e.getMessage());
        }
    }

    MutableTableDataSource createTableDataSourceAtCommit(SimpleTransaction transaction) {
        return this.createTableDataSourceAtCommit(transaction, new MasterTableJournal(this.getTableID()));
    }

    MutableTableDataSource createTableDataSourceAtCommit(SimpleTransaction transaction, MasterTableJournal journal) {
        return new MMutableTableDataSource(transaction, journal);
    }

    protected synchronized void setupDataIndexSetDef() {
        this.index_def = new DataIndexSetDef(this.table_def.getTableName());
        for (int i = 0; i < this.table_def.columnCount(); ++i) {
            DataTableColumnDef col_def = this.table_def.columnAt(i);
            if (!col_def.isIndexableType() || !col_def.getIndexScheme().equals("InsertSearch")) continue;
            this.index_def.addDataIndexDef(new DataIndexDef("ANON-COLUMN:" + i, new String[]{col_def.getName()}, i + 1, "BLIST", false));
        }
    }

    protected synchronized void setupDataTableDef(DataTableDef table_def) {
        if ((this.table_id & 0xF0000000) != 0) {
            throw new Error("'table_id' exceeds maximum possible keys.");
        }
        this.table_def = table_def;
        TableName table_name = table_def.getTableName();
        this.table_indices = new MultiVersionTableIndices(this.getSystem(), table_name, table_def.columnCount());
        this.column_rid_list = new RIDList[table_def.columnCount()];
        this.setupDataIndexSetDef();
    }

    protected synchronized void loadInternal() {
        String table_name = this.table_def.getName();
        String schema_name = this.table_def.getSchema();
        String n = table_name;
        if (schema_name.length() > 0) {
            n = schema_name + "." + table_name;
        }
        this.root_lock_key = "MasterTableDataSource.RootLocks." + n;
        this.total_hits_key = "MasterTableDataSource.Hits.Total." + n;
        this.file_hits_key = "MasterTableDataSource.Hits.File." + n;
        this.delete_hits_key = "MasterTableDataSource.Hits.Delete." + n;
        this.insert_hits_key = "MasterTableDataSource.Hits.Insert." + n;
        this.column_count = this.table_def.columnCount();
        this.is_closed = false;
    }

    synchronized boolean isClosed() {
        return this.is_closed;
    }

    boolean isReadOnly() {
        return this.system.readOnlyAccess();
    }

    protected StoreSystem storeSystem() {
        return this.store_system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addRow(RowData data) throws IOException {
        int row_number;
        MasterTableDataSource masterTableDataSource = this;
        synchronized (masterTableDataSource) {
            row_number = this.internalAddRow(data);
        }
        this.getSystem().stats().increment(this.insert_hits_key);
        return row_number;
    }

    private synchronized void doHardRowRemove(int row_index) throws IOException {
        for (int i = 0; i < this.column_count; ++i) {
            RIDList rid_list = this.column_rid_list[i];
            if (rid_list == null) continue;
            rid_list.removeRID(row_index);
        }
        this.internalDeleteRow(row_index);
        this.system.stats().increment(this.delete_hits_key);
    }

    synchronized void hardRemoveRow(int record_index) throws IOException {
        if (!this.isRootLocked()) {
            int type_key = this.readRecordType(record_index);
            if ((type_key & 0xF0) != 32) {
                throw new Error("Row isn't marked as committed removed: " + record_index);
            }
        } else {
            throw new Error("Assertion failed: Can't remove row, table is under a root lock.");
        }
        this.doHardRowRemove(record_index);
    }

    synchronized boolean hardCheckAndReclaimRow(int record_index) throws IOException {
        if (!this.isRootLocked()) {
            int type_key;
            if (!this.recordDeleted(record_index) && ((type_key = this.readRecordType(record_index)) & 0xF0) == 32) {
                this.doHardRowRemove(record_index);
                return true;
            }
            return false;
        }
        throw new Error("Assertion failed: Can't remove row, table is under a root lock.");
    }

    synchronized int recordTypeInfo(int record_index) throws IOException {
        if (this.recordDeleted(record_index)) {
            return 4;
        }
        int type_key = this.readRecordType(record_index) & 0xF0;
        if (type_key == 0) {
            return 1;
        }
        if (type_key == 16) {
            return 2;
        }
        if (type_key == 32) {
            return 3;
        }
        return 0;
    }

    protected synchronized void doOpeningScan() throws IOException {
        long in_time = System.currentTimeMillis();
        if (this.isRootLocked() || this.hasTransactionChangesPending()) {
            throw new RuntimeException("Odd, we are root locked or have pending journal changes.");
        }
        if (!this.isReadOnly()) {
            MasterTableJournal journal = new MasterTableJournal();
            IndexSet index_set = this.createIndexSet();
            IntegerListInterface master_index = index_set.getIndex(0);
            int row_count = this.rawRowCount();
            for (int i = 0; i < row_count; ++i) {
                if (!this.recordDeleted(i)) {
                    int type = this.recordTypeInfo(i);
                    if (type == 3 || type == 1) {
                        if (!master_index.contains(i)) {
                            this.doHardRowRemove(i);
                            continue;
                        }
                        this.Debug().write(40, this, "Inconsistant: Row is indexed but marked as removed or uncommitted.");
                        this.Debug().write(40, this, "Row: " + i + " Type: " + type + " Table: " + this.getTableName());
                        this.writeRecordType(i, 16);
                        continue;
                    }
                    if (master_index.contains(i)) continue;
                    this.Debug().write(40, this, "Inconsistant: Row committed added but not in master index.");
                    this.Debug().write(40, this, "Row: " + i + " Type: " + type + " Table: " + this.getTableName());
                    this.writeRecordType(i, 32);
                    continue;
                }
                if (!master_index.contains(i)) continue;
                this.Debug().write(40, this, "Inconsistant: Row is removed but in index.");
                this.Debug().write(40, this, "Row: " + i + " Table: " + this.getTableName());
                this.writeRecordType(i, 16);
            }
            index_set.dispose();
        }
        long bench_time = System.currentTimeMillis() - in_time;
        if (this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, "Opening scan for " + this.toString() + " (" + this.getTableName() + ") took " + bench_time + "ms.");
        }
    }

    RawDiagnosticTable getRawDiagnosticTable() {
        return new MRawDiagnosticTable();
    }

    TObject getCellContents(int column, int row) {
        if (row < 0) {
            throw new Error("'row' is < 0");
        }
        return this.internalGetCellContents(column, row);
    }

    synchronized void addRootLock() {
        this.system.stats().increment(this.root_lock_key);
        ++this.root_lock;
    }

    synchronized void removeRootLock() {
        if (!this.is_closed) {
            this.system.stats().decrement(this.root_lock_key);
            if (this.root_lock == 0) {
                throw new Error("Too many root locks removed!");
            }
            --this.root_lock;
            if (this.root_lock == 0) {
                this.checkForCleanup();
            }
        }
    }

    synchronized boolean isRootLocked() {
        return this.root_lock > 0;
    }

    protected synchronized void clearAllRootLocks() {
        this.root_lock = 0;
    }

    abstract void checkForCleanup();

    synchronized String transactionChangeString() {
        return this.table_indices.transactionChangeString();
    }

    synchronized boolean hasTransactionChangesPending() {
        return this.table_indices.hasTransactionChangesPending();
    }

    private final class MMutableTableDataSource
    implements MutableTableDataSource {
        private SimpleTransaction transaction;
        private boolean tran_read_only;
        private TableName table_name;
        private int row_list_rebuild;
        private IntegerListInterface row_list;
        private int[] scheme_rebuilds;
        private IndexSet index_set;
        private SelectableScheme[] column_schemes;
        private MasterTableJournal table_journal;
        private int last_entry_ri_check;

        public MMutableTableDataSource(SimpleTransaction transaction, MasterTableJournal journal) {
            this.transaction = transaction;
            this.index_set = transaction.getIndexSetForTable(MasterTableDataSource.this);
            int col_count = this.getDataTableDef().columnCount();
            this.table_name = this.getDataTableDef().getTableName();
            this.tran_read_only = transaction.isReadOnly();
            this.row_list_rebuild = 0;
            this.scheme_rebuilds = new int[col_count];
            this.column_schemes = new SelectableScheme[col_count];
            this.table_journal = journal;
            this.last_entry_ri_check = this.table_journal.entries();
        }

        private void executeUpdateReferentialAction(Transaction.ColumnGroupReference constraint, TObject[] original_key, TObject[] new_key, QueryContext context) {
            DataTableDef table_def;
            int[] key_cols;
            String update_rule = constraint.update_rule;
            if (update_rule.equals("NO ACTION") && constraint.deferred != 6) {
                return;
            }
            MutableTableDataSource key_table = this.transaction.getTable(constraint.key_table_name);
            IntegerVector key_entries = TableDataConglomerate.findKeys(key_table, key_cols = TableDataConglomerate.findColumnIndices(table_def = key_table.getDataTableDef(), constraint.key_columns), original_key);
            if (key_entries.size() > 0) {
                if (update_rule.equals("NO ACTION")) {
                    throw new DatabaseConstraintViolationException(23, TableDataConglomerate.deferredString(constraint.deferred) + " foreign key constraint violation on update (" + constraint.name + ") Columns = " + constraint.key_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(constraint.key_columns) + " ) -> " + constraint.ref_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(constraint.ref_columns) + " )");
                }
                int sz = key_entries.size();
                for (int i = 0; i < sz; ++i) {
                    int n;
                    int row_index = key_entries.intAt(i);
                    RowData row_data = new RowData(key_table);
                    row_data.setFromRow(row_index);
                    if (update_rule.equals("CASCADE")) {
                        for (n = 0; n < key_cols.length; ++n) {
                            row_data.setColumnData(key_cols[n], new_key[n]);
                        }
                        key_table.updateRow(row_index, row_data);
                        continue;
                    }
                    if (update_rule.equals("SET NULL")) {
                        for (n = 0; n < key_cols.length; ++n) {
                            row_data.setColumnToNull(key_cols[n]);
                        }
                        key_table.updateRow(row_index, row_data);
                        continue;
                    }
                    if (update_rule.equals("SET DEFAULT")) {
                        for (n = 0; n < key_cols.length; ++n) {
                            row_data.setColumnToDefault(key_cols[n], context);
                        }
                        key_table.updateRow(row_index, row_data);
                        continue;
                    }
                    throw new RuntimeException("Do not understand referential action: " + update_rule);
                }
                key_table.constraintIntegrityCheck();
            }
        }

        private void executeDeleteReferentialAction(Transaction.ColumnGroupReference constraint, TObject[] original_key, QueryContext context) {
            DataTableDef table_def;
            int[] key_cols;
            String delete_rule = constraint.delete_rule;
            if (delete_rule.equals("NO ACTION") && constraint.deferred != 6) {
                return;
            }
            MutableTableDataSource key_table = this.transaction.getTable(constraint.key_table_name);
            IntegerVector key_entries = TableDataConglomerate.findKeys(key_table, key_cols = TableDataConglomerate.findColumnIndices(table_def = key_table.getDataTableDef(), constraint.key_columns), original_key);
            if (key_entries.size() > 0) {
                if (delete_rule.equals("NO ACTION")) {
                    throw new DatabaseConstraintViolationException(23, TableDataConglomerate.deferredString(constraint.deferred) + " foreign key constraint violation on delete (" + constraint.name + ") Columns = " + constraint.key_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(constraint.key_columns) + " ) -> " + constraint.ref_table_name.toString() + "( " + TableDataConglomerate.stringColumnList(constraint.ref_columns) + " )");
                }
                int sz = key_entries.size();
                for (int i = 0; i < sz; ++i) {
                    int n;
                    int row_index = key_entries.intAt(i);
                    RowData row_data = new RowData(key_table);
                    row_data.setFromRow(row_index);
                    if (delete_rule.equals("CASCADE")) {
                        key_table.removeRow(row_index);
                        continue;
                    }
                    if (delete_rule.equals("SET NULL")) {
                        for (n = 0; n < key_cols.length; ++n) {
                            row_data.setColumnToNull(key_cols[n]);
                        }
                        key_table.updateRow(row_index, row_data);
                        continue;
                    }
                    if (delete_rule.equals("SET DEFAULT")) {
                        for (n = 0; n < key_cols.length; ++n) {
                            row_data.setColumnToDefault(key_cols[n], context);
                        }
                        key_table.updateRow(row_index, row_data);
                        continue;
                    }
                    throw new RuntimeException("Do not understand referential action: " + delete_rule);
                }
                key_table.constraintIntegrityCheck();
            }
        }

        private IntegerListInterface getRowIndexList() {
            if (this.row_list == null) {
                this.row_list = this.index_set.getIndex(0);
            }
            return this.row_list;
        }

        private void ensureRowIndexListCurrent() {
            int rebuild_index;
            int journal_count = this.table_journal.entries();
            for (rebuild_index = this.row_list_rebuild; rebuild_index < journal_count; ++rebuild_index) {
                boolean b;
                byte command = this.table_journal.getCommand(rebuild_index);
                int row_index = this.table_journal.getRowIndex(rebuild_index);
                if (MasterTableJournal.isAddCommand(command)) {
                    b = this.getRowIndexList().uniqueInsertSort(row_index);
                    if (b) continue;
                    throw new Error("Row index already used in this table (" + row_index + ")");
                }
                if (MasterTableJournal.isRemoveCommand(command)) {
                    b = this.getRowIndexList().removeSort(row_index);
                    if (b) continue;
                    throw new Error("Row index removed that wasn't in this table!");
                }
                throw new Error("Unrecognised journal command.");
            }
            this.row_list_rebuild = rebuild_index;
        }

        private void ensureColumnSchemeCurrent(int column) {
            int rebuild_index;
            SelectableScheme scheme = this.column_schemes[column];
            int journal_count = this.table_journal.entries();
            for (rebuild_index = this.scheme_rebuilds[column]; rebuild_index < journal_count; ++rebuild_index) {
                byte command = this.table_journal.getCommand(rebuild_index);
                int row_index = this.table_journal.getRowIndex(rebuild_index);
                if (MasterTableJournal.isAddCommand(command)) {
                    scheme.insert(row_index);
                    continue;
                }
                if (MasterTableJournal.isRemoveCommand(command)) {
                    scheme.remove(row_index);
                    continue;
                }
                throw new Error("Unrecognised journal command.");
            }
            this.scheme_rebuilds[column] = rebuild_index;
        }

        public TransactionSystem getSystem() {
            return MasterTableDataSource.this.getSystem();
        }

        public DataTableDef getDataTableDef() {
            return MasterTableDataSource.this.getDataTableDef();
        }

        public int getRowCount() {
            this.ensureRowIndexListCurrent();
            return this.getRowIndexList().size();
        }

        public RowEnumeration rowEnumeration() {
            this.ensureRowIndexListCurrent();
            IntegerIterator iterator = this.getRowIndexList().iterator();
            return new RowEnumeration(this, iterator){
                private final /* synthetic */ IntegerIterator val$iterator;
                private final /* synthetic */ MMutableTableDataSource this$1;
                {
                    this.this$1 = this$1;
                    this.val$iterator = val$iterator;
                }

                public boolean hasMoreRows() {
                    return this.val$iterator.hasNext();
                }

                public int nextRowIndex() {
                    return this.val$iterator.next();
                }
            };
        }

        public TObject getCellContents(int column, int row) {
            return MasterTableDataSource.this.getCellContents(column, row);
        }

        public SelectableScheme getColumnScheme(int column) {
            SelectableScheme scheme = this.column_schemes[column];
            if (scheme == null) {
                this.column_schemes[column] = scheme = MasterTableDataSource.this.createSelectableSchemeForColumn(this.index_set, this, column);
            }
            this.ensureColumnSchemeCurrent(column);
            return scheme;
        }

        public int addRow(RowData row_data) {
            int row_index;
            if (this.tran_read_only) {
                throw new RuntimeException("Transaction is read only.");
            }
            if (MasterTableDataSource.this.isReadOnly()) {
                throw new Error("Can not add row - table is read only.");
            }
            try {
                row_index = MasterTableDataSource.this.addRow(row_data);
            }
            catch (IOException e) {
                MasterTableDataSource.this.Debug().writeException(e);
                throw new Error("IO Error: " + e.getMessage());
            }
            this.table_journal.addEntry((byte)1, row_index);
            return row_index;
        }

        public void removeRow(int row_index) {
            if (this.tran_read_only) {
                throw new RuntimeException("Transaction is read only.");
            }
            if (MasterTableDataSource.this.isReadOnly()) {
                throw new Error("Can not remove row - table is read only.");
            }
            this.table_journal.addEntry((byte)2, row_index);
        }

        public int updateRow(int row_index, RowData row_data) {
            int new_row_index;
            if (this.tran_read_only) {
                throw new RuntimeException("Transaction is read only.");
            }
            if (MasterTableDataSource.this.isReadOnly()) {
                throw new Error("Can not update row - table is read only.");
            }
            this.table_journal.addEntry((byte)6, row_index);
            try {
                new_row_index = MasterTableDataSource.this.addRow(row_data);
            }
            catch (IOException e) {
                MasterTableDataSource.this.Debug().writeException(e);
                throw new Error("IO Error: " + e.getMessage());
            }
            this.table_journal.addEntry((byte)5, new_row_index);
            return new_row_index;
        }

        public void flushIndexChanges() {
            this.ensureRowIndexListCurrent();
            for (int i = 0; i < this.column_schemes.length; ++i) {
                this.getColumnScheme(i);
            }
        }

        public void constraintIntegrityCheck() {
            try {
                if (this.last_entry_ri_check == this.table_journal.entries()) {
                    return;
                }
                DataTableDef table_def = this.getDataTableDef();
                TableName table_name = table_def.getTableName();
                SystemQueryContext context = new SystemQueryContext(this.transaction, table_name.getSchema());
                IntegerVector rows_updated = new IntegerVector();
                IntegerVector rows_deleted = new IntegerVector();
                IntegerVector rows_added = new IntegerVector();
                int size = this.table_journal.entries();
                for (int i = this.last_entry_ri_check; i < size; ++i) {
                    byte tc = this.table_journal.getCommand(i);
                    int row_index = this.table_journal.getRowIndex(i);
                    if (tc == 2 || tc == 6) {
                        rows_deleted.addInt(row_index);
                        int ra_i = rows_added.indexOf(row_index);
                        if (ra_i != -1) {
                            rows_added.removeIntAt(ra_i);
                        }
                    } else if (tc == 1 || tc == 5) {
                        rows_added.addInt(row_index);
                    }
                    if (tc == 6) {
                        rows_updated.addInt(row_index);
                        continue;
                    }
                    if (tc != 5) continue;
                    rows_updated.addInt(row_index);
                }
                if (rows_deleted.size() > 0) {
                    Transaction.ColumnGroupReference[] foreign_constraints = Transaction.queryTableImportedForeignKeyReferences(this.transaction, table_name);
                    for (int n = 0; n < foreign_constraints.length; ++n) {
                        Transaction.ColumnGroupReference constraint = foreign_constraints[n];
                        for (int i = 0; i < rows_deleted.size(); ++i) {
                            int row_index = rows_deleted.intAt(i);
                            int[] cols = TableDataConglomerate.findColumnIndices(table_def, constraint.ref_columns);
                            TObject[] original_key = new TObject[cols.length];
                            int null_count = 0;
                            for (int p = 0; p < cols.length; ++p) {
                                original_key[p] = this.getCellContents(cols[p], row_index);
                                if (!original_key[p].isNull()) continue;
                                ++null_count;
                            }
                            if (null_count == cols.length) continue;
                            int update_index = rows_updated.indexOf(row_index);
                            if (update_index != -1) {
                                int row_index_add = rows_updated.intAt(update_index + 1);
                                boolean key_changed = false;
                                TObject[] key_updated_to = new TObject[cols.length];
                                for (int p = 0; p < cols.length; ++p) {
                                    key_updated_to[p] = this.getCellContents(cols[p], row_index_add);
                                    if (original_key[p].compareTo(key_updated_to[p]) == 0) continue;
                                    key_changed = true;
                                }
                                if (!key_changed) continue;
                                this.executeUpdateReferentialAction(constraint, original_key, key_updated_to, context);
                                continue;
                            }
                            this.executeDeleteReferentialAction(constraint, original_key, context);
                        }
                    }
                }
                if (rows_added.size() > 0) {
                    int[] row_indices = rows_added.toIntArray();
                    TableDataConglomerate.checkFieldConstraintViolations(this.transaction, this, row_indices);
                    TableDataConglomerate.checkAddConstraintViolations(this.transaction, (TableDataSource)this, row_indices, (short)6);
                }
            }
            catch (DatabaseConstraintViolationException e) {
                int rollback_point = this.table_journal.entries() - this.last_entry_ri_check;
                if (this.row_list_rebuild <= rollback_point) {
                    this.table_journal.rollbackEntries(rollback_point);
                } else {
                    System.out.println("WARNING: rebuild_pointer is after rollback point so we can't rollback to the point before the constraint violation.");
                }
                throw e;
            }
            finally {
                this.last_entry_ri_check = this.table_journal.entries();
            }
        }

        public MasterTableJournal getJournal() {
            return this.table_journal;
        }

        public void dispose() {
            for (int i = 0; i < this.column_schemes.length; ++i) {
                SelectableScheme scheme = this.column_schemes[i];
                if (scheme == null) continue;
                scheme.dispose();
                this.column_schemes[i] = null;
            }
            this.row_list = null;
            this.table_journal = null;
            this.scheme_rebuilds = null;
            this.index_set = null;
            this.transaction = null;
        }

        public void addRootLock() {
            MasterTableDataSource.this.addRootLock();
        }

        public void removeRootLock() {
            MasterTableDataSource.this.removeRootLock();
        }
    }

    private final class MRawDiagnosticTable
    implements RawDiagnosticTable {
        private MRawDiagnosticTable() {
        }

        public int physicalRecordCount() {
            try {
                return MasterTableDataSource.this.rawRowCount();
            }
            catch (IOException e) {
                throw new Error(e.getMessage());
            }
        }

        public DataTableDef getDataTableDef() {
            return MasterTableDataSource.this.getDataTableDef();
        }

        public int recordState(int record_index) {
            try {
                return MasterTableDataSource.this.recordTypeInfo(record_index);
            }
            catch (IOException e) {
                throw new Error(e.getMessage());
            }
        }

        public int recordSize(int record_index) {
            return -1;
        }

        public TObject getCellContents(int column, int record_index) {
            return MasterTableDataSource.this.getCellContents(column, record_index);
        }

        public String recordMiscInformation(int record_index) {
            return null;
        }
    }
}

