/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.User;
import com.mckoi.database.jdbc.DatabaseCallBack;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbcserver.AbstractJDBCDatabaseInterface;
import java.sql.Connection;
import java.sql.SQLException;

class InternalJDBCHelper {
    InternalJDBCHelper() {
    }

    static Connection createJDBCConnection(User user, DatabaseConnection connection) {
        InternalDatabaseInterface db_interface = new InternalDatabaseInterface(user, connection);
        return new InternalConnection(connection, db_interface, 11, 4092000);
    }

    static void disposeJDBCConnection(Connection jdbc_connection) throws SQLException {
        InternalConnection connection = (InternalConnection)jdbc_connection;
        connection.internalClose();
    }

    private static class InternalDatabaseInterface
    extends AbstractJDBCDatabaseInterface {
        private DatabaseConnection database;

        public InternalDatabaseInterface(User user, DatabaseConnection db) {
            super(db.getDatabase());
            this.database = db;
            this.init(user, db);
        }

        public boolean login(String default_schema, String username, String password, DatabaseCallBack call_back) throws SQLException {
            throw new SQLException("'login' is not supported for InterfaceDatabaseInterface");
        }

        public void dispose() throws SQLException {
            this.internalDispose();
        }
    }

    private static class InternalConnection
    extends MConnection {
        private InternalDatabaseInterface internal_db_interface;

        public InternalConnection(DatabaseConnection db, InternalDatabaseInterface jdbc_interface, int cache_size, int max_size) {
            super("", jdbc_interface, cache_size, max_size);
            this.internal_db_interface = jdbc_interface;
            this.setCaseInsensitiveIdentifiers(db.isInCaseInsensitiveMode());
        }

        InternalDatabaseInterface getDBInterface() {
            return this.internal_db_interface;
        }

        public void setAutoCommit(boolean status) throws SQLException {
            if (status) {
                throw new SQLException("Auto-commit can not be enabled for an internal connection.");
            }
        }

        public boolean getAutoCommit() throws SQLException {
            return false;
        }

        public void close() {
        }
    }
}

