/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CollatedBaseSearch;
import com.mckoi.database.SelectableScheme;
import com.mckoi.database.TObject;
import com.mckoi.database.TableDataSource;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.IndexComparator;
import com.mckoi.util.IntegerIterator;
import com.mckoi.util.IntegerListInterface;
import com.mckoi.util.IntegerVector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class InsertSearch
extends CollatedBaseSearch {
    private IntegerListInterface set_list;
    boolean RECORD_UID;
    private IndexComparator set_comparator;
    private int DEBUG_immutable_set_size;

    public InsertSearch(TableDataSource table, int column) {
        super(table, column);
        this.set_list = new BlockIntegerList();
        this.setupComparator();
    }

    public InsertSearch(TableDataSource table, int column, IntegerVector vec) {
        this(table, column);
        for (int i = 0; i < vec.size(); ++i) {
            this.set_list.add(vec.intAt(i));
        }
        this.checkSchemeSorted();
    }

    InsertSearch(TableDataSource table, int column, IntegerListInterface list) {
        this(table, column);
        this.set_list = list;
        this.checkSchemeSorted();
    }

    private InsertSearch(TableDataSource table, InsertSearch from, boolean immutable) {
        super(table, from.getColumn());
        if (immutable) {
            this.setImmutable();
        }
        if (immutable) {
            this.set_list = from.set_list;
            this.DEBUG_immutable_set_size = this.set_list.size();
        } else {
            this.set_list = new BlockIntegerList(from.set_list);
        }
        this.RECORD_UID = from.RECORD_UID;
        this.setupComparator();
    }

    private void setupComparator() {
        this.set_comparator = new IndexComparator(){

            private int internalCompare(int index, TObject cell2) {
                TObject cell1 = InsertSearch.this.getCellContents(index);
                return cell1.compareTo(cell2);
            }

            public int compare(int index, Object val) {
                return this.internalCompare(index, (TObject)val);
            }

            public int compare(int index1, int index2) {
                TObject cell = InsertSearch.this.getCellContents(index2);
                return this.internalCompare(index1, cell);
            }
        };
    }

    public void insert(int row) {
        if (this.isImmutable()) {
            throw new Error("Tried to change an immutable scheme.");
        }
        TObject cell = this.getCellContents(row);
        this.set_list.insertSort(cell, row, this.set_comparator);
    }

    public void remove(int row) {
        if (this.isImmutable()) {
            throw new Error("Tried to change an immutable scheme.");
        }
        TObject cell = this.getCellContents(row);
        int removed = this.set_list.removeSort(cell, row, this.set_comparator);
        if (removed != row) {
            throw new Error("Removed value different than row asked to remove.  To remove: " + row + "  Removed: " + removed);
        }
    }

    private final IndexComparator safeSetComparator() {
        return this.set_comparator;
    }

    public void readFrom(InputStream in) throws IOException {
        if (this.set_list.size() != 0) {
            throw new RuntimeException("Error reading scheme, already a set in the Scheme");
        }
        DataInputStream din = new DataInputStream(in);
        int vec_size = din.readInt();
        int row_count = this.getTable().getRowCount();
        if (row_count != vec_size) {
            throw new IOException("Different table row count to indices in scheme. table=" + row_count + ", vec_size=" + vec_size);
        }
        for (int i = 0; i < vec_size; ++i) {
            int row = din.readInt();
            if (row < 0) {
                this.set_list = new BlockIntegerList();
                throw new IOException("Scheme contains out of table bounds index.");
            }
            this.set_list.add(row);
        }
        this.getSystem().stats().add(vec_size, "{session} InsertSearch.read_indices");
        this.checkSchemeSorted();
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        int list_size = this.set_list.size();
        dout.writeInt(list_size);
        IntegerIterator i = this.set_list.iterator(0, list_size - 1);
        while (i.hasNext()) {
            dout.writeInt(i.next());
        }
    }

    public SelectableScheme copy(TableDataSource table, boolean immutable) {
        if (this.isImmutable() && this.DEBUG_immutable_set_size != this.set_list.size()) {
            throw new Error("Assert failed: Immutable set size is different from when created.");
        }
        return new InsertSearch(table, this, immutable);
    }

    public void dispose() {
        this.set_list = null;
        this.set_comparator = null;
    }

    private void checkSchemeSorted() {
    }

    protected int searchFirst(TObject val) {
        return this.set_list.searchFirst(val, this.safeSetComparator());
    }

    protected int searchLast(TObject val) {
        return this.set_list.searchLast(val, this.safeSetComparator());
    }

    protected int setSize() {
        return this.set_list.size();
    }

    protected TObject firstInCollationOrder() {
        return this.getCellContents(this.set_list.get(0));
    }

    protected TObject lastInCollationOrder() {
        return this.getCellContents(this.set_list.get(this.setSize() - 1));
    }

    protected IntegerVector addRangeToSet(int start, int end, IntegerVector ivec) {
        if (ivec == null) {
            ivec = new IntegerVector(end - start + 2);
        }
        IntegerIterator i = this.set_list.iterator(start, end);
        while (i.hasNext()) {
            ivec.addInt(i.next());
        }
        return ivec;
    }

    public IntegerVector selectAll() {
        IntegerVector ivec = new IntegerVector(this.set_list);
        return ivec;
    }
}

