/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.IndexSet;
import com.mckoi.database.TransactionSystem;
import com.mckoi.debug.DebugLogger;
import com.mckoi.store.Area;
import com.mckoi.store.AreaWriter;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.AbstractBlockIntegerList;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.IntegerListBlockInterface;
import com.mckoi.util.IntegerListInterface;
import java.io.IOException;
import java.util.ArrayList;

final class IndexSetStore {
    private static final int MAGIC = 212402833;
    private final DebugLogger debug;
    private final TransactionSystem system;
    private Store store;
    private MutableArea start_area;
    private long index_header_p;
    private Area index_header_area;
    private IndexBlock[] index_blocks;
    private static IndexIntegerList[] EMPTY_INTEGER_LISTS = new IndexIntegerList[0];

    public IndexSetStore(Store store, TransactionSystem system) {
        this.store = store;
        this.system = system;
        this.debug = system.Debug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deleteAllAreas(ArrayList list) {
        if (this.store != null) {
            try {
                this.store.lockForWrite();
                int sz = list.size();
                for (int i = 0; i < sz; ++i) {
                    long id = (Long)list.get(i);
                    this.store.deleteArea(id);
                }
            }
            catch (IOException e) {
                this.debug.write(40, this, "Error when freeing old index block.");
                this.debug.writeException(e);
            }
            finally {
                this.store.unlockForWrite();
            }
        }
    }

    private long createBlankIndexBlock() throws IOException {
        AreaWriter a = this.store.createArea(16L);
        long index_block_p = a.getID();
        a.putInt(1);
        a.putInt(0);
        a.putLong(0L);
        a.finish();
        return index_block_p;
    }

    public synchronized long create() throws IOException {
        AreaWriter a = this.store.createArea(16L);
        this.index_header_p = a.getID();
        a.putInt(1);
        a.putInt(0);
        a.putLong(0L);
        a.finish();
        this.index_header_area = this.store.getArea(this.index_header_p);
        this.index_blocks = new IndexBlock[0];
        AreaWriter start_a = this.store.createArea(32L);
        long start_p = start_a.getID();
        start_a.putInt(212402833);
        start_a.putInt(1);
        start_a.putLong(this.index_header_p);
        start_a.finish();
        this.start_area = this.store.getMutableArea(start_p);
        return start_p;
    }

    public synchronized void init(long start_p) throws IOException {
        this.start_area = this.store.getMutableArea(start_p);
        int magic = this.start_area.getInt();
        if (magic != 212402833) {
            throw new IOException("Magic value for index set does not match.");
        }
        int version = this.start_area.getInt();
        if (version != 1) {
            throw new IOException("Unknown version for index set.");
        }
        this.index_header_p = this.start_area.getLong();
        this.index_header_area = this.store.getArea(this.index_header_p);
        version = this.index_header_area.getInt();
        if (version != 1) {
            throw new IOException("Incorrect version");
        }
        int reserved = this.index_header_area.getInt();
        int index_count = (int)this.index_header_area.getLong();
        this.index_blocks = new IndexBlock[index_count];
        for (int i = 0; i < index_count; ++i) {
            int type = this.index_header_area.getInt();
            int block_size = this.index_header_area.getInt();
            long index_block_p = this.index_header_area.getLong();
            if (type != 1) {
                throw new IOException("Do not understand index type: " + type);
            }
            this.index_blocks[i] = new IndexBlock(i, block_size, index_block_p);
            this.index_blocks[i].addReference();
        }
    }

    public synchronized void close() {
        if (this.store != null) {
            for (int i = 0; i < this.index_blocks.length; ++i) {
                this.index_blocks[i].removeReference();
            }
            this.store = null;
            this.index_blocks = null;
        }
    }

    public synchronized void copyAllFrom(IndexSet index_set) throws IOException {
        AreaWriter a;
        long old_index_header_p;
        if (this.index_blocks == null) {
            throw new RuntimeException("Can't copy because this IndexSetStore is not initialized.");
        }
        for (int i = 0; i < this.index_blocks.length; ++i) {
            this.commitDropIndex(i);
        }
        if (index_set instanceof SnapshotIndexSet) {
            SnapshotIndexSet s_index_set = (SnapshotIndexSet)index_set;
            int index_count = s_index_set.snapshot_index_blocks.length;
            old_index_header_p = this.index_header_p;
            a = this.store.createArea(16 + 16 * index_count);
            this.index_header_p = a.getID();
            a.putInt(1);
            a.putInt(0);
            a.putLong(index_count);
            for (int i = 0; i < index_count; ++i) {
                IndexBlock source_block = s_index_set.snapshot_index_blocks[i];
                long index_block_p = source_block.copyTo(this.store);
                a.putInt(1);
                a.putInt(source_block.getBlockSize());
                a.putLong(index_block_p);
            }
        } else {
            throw new RuntimeException("Can not copy non-IndexSetStore IndexSet");
        }
        a.finish();
        this.start_area.position(8);
        this.start_area.putLong(this.index_header_p);
        this.start_area.checkOut();
        this.store.deleteArea(old_index_header_p);
        this.init(this.start_area.getID());
    }

    public void addAllAreasUsed(ArrayList list) throws IOException {
        list.add(new Long(this.start_area.getID()));
        list.add(new Long(this.index_header_p));
        for (int i = 0; i < this.index_blocks.length; ++i) {
            IndexBlock block = this.index_blocks[i];
            list.add(new Long(block.getPointer()));
            long[] block_pointers = block.getAllBlockPointers();
            for (int n = 0; n < block_pointers.length; ++n) {
                list.add(new Long(block_pointers[n]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addIndexLists(int count, int type, int block_size) throws IOException {
        try {
            int i;
            this.store.lockForWrite();
            int new_size = 16 + (this.index_blocks.length + count) * 16;
            AreaWriter new_index_area = this.store.createArea(new_size);
            long new_index_p = new_index_area.getID();
            IndexBlock[] new_index_blocks = new IndexBlock[this.index_blocks.length + count];
            this.index_header_area.position(0);
            int version = this.index_header_area.getInt();
            int reserved = this.index_header_area.getInt();
            long icount = this.index_header_area.getLong();
            new_index_area.putInt(version);
            new_index_area.putInt(reserved);
            new_index_area.putLong(icount + (long)count);
            for (i = 0; i < this.index_blocks.length; ++i) {
                int itype = this.index_header_area.getInt();
                int iblock_size = this.index_header_area.getInt();
                long index_block_p = this.index_header_area.getLong();
                new_index_area.putInt(itype);
                new_index_area.putInt(iblock_size);
                new_index_area.putLong(index_block_p);
                new_index_blocks[i] = this.index_blocks[i];
            }
            for (i = 0; i < count; ++i) {
                long new_blank_block_p = this.createBlankIndexBlock();
                new_index_area.putInt(type);
                new_index_area.putInt(block_size);
                new_index_area.putLong(new_blank_block_p);
                IndexBlock i_block = new IndexBlock(this.index_blocks.length + i, block_size, new_blank_block_p);
                i_block.addReference();
                new_index_blocks[this.index_blocks.length + i] = i_block;
            }
            new_index_area.finish();
            long old_index_header_p = this.index_header_p;
            this.index_header_p = new_index_p;
            this.index_header_area = this.store.getArea(new_index_p);
            this.index_blocks = new_index_blocks;
            this.start_area.position(8);
            this.start_area.putLong(new_index_p);
            this.start_area.checkOut();
            this.store.deleteArea(old_index_header_p);
        }
        finally {
            this.store.unlockForWrite();
        }
    }

    public synchronized IndexSet getSnapshotIndexSet() {
        IndexBlock[] snapshot_index_blocks = (IndexBlock[])this.index_blocks.clone();
        for (int i = 0; i < snapshot_index_blocks.length; ++i) {
            snapshot_index_blocks[i].addReference();
        }
        return new SnapshotIndexSet(snapshot_index_blocks);
    }

    private synchronized void commitIndexHeader() throws IOException {
        AreaWriter a = this.store.createArea(16 + this.index_blocks.length * 16);
        long a_p = a.getID();
        a.putInt(1);
        a.putInt(0);
        a.putLong(this.index_blocks.length);
        for (int i = 0; i < this.index_blocks.length; ++i) {
            IndexBlock ind_block = this.index_blocks[i];
            a.putInt(1);
            a.putInt(ind_block.getBlockSize());
            a.putLong(ind_block.getPointer());
        }
        a.finish();
        long old_index_header_p = this.index_header_p;
        this.index_header_p = a_p;
        this.index_header_area = this.store.getArea(this.index_header_p);
        this.start_area.position(8);
        this.start_area.putLong(this.index_header_p);
        this.start_area.checkOut();
        this.store.deleteArea(old_index_header_p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitIndexSet(IndexSet index_set) {
        ArrayList<IndexBlock> removed_blocks = new ArrayList<IndexBlock>();
        IndexSetStore indexSetStore = this;
        synchronized (indexSetStore) {
            SnapshotIndexSet s_index_set = (SnapshotIndexSet)index_set;
            IndexIntegerList[] lists = s_index_set.getAllLists();
            try {
                try {
                    this.store.lockForWrite();
                    for (int n = 0; n < lists.length; ++n) {
                        IndexIntegerList list = lists[n];
                        int index_num = list.getIndexNumber();
                        IndexBlock cur_index_block = this.index_blocks[index_num];
                        MappedListBlock[] blocks = list.getAllBlocks();
                        AreaWriter a = this.store.createArea(16 + blocks.length * 28);
                        long block_p = a.getID();
                        a.putInt(1);
                        a.putInt(0);
                        a.putLong(blocks.length);
                        for (int i = 0; i < blocks.length; ++i) {
                            long b_p;
                            MappedListBlock b = blocks[i];
                            long bottom_int = 0L;
                            long top_int = 0L;
                            int block_size = b.size();
                            if (block_size > 0) {
                                bottom_int = b.bottomInt();
                                top_int = b.topInt();
                            }
                            if ((b_p = b.getBlockPointer()) == -1L || b.hasChanged()) {
                                if (b_p != -1L) {
                                    cur_index_block.addDeletedArea(b_p);
                                }
                                b_p = b.writeToStore();
                            }
                            a.putLong(bottom_int);
                            a.putLong(top_int);
                            a.putLong(b_p);
                            a.putInt(block_size | b.getCompactType() << 24);
                        }
                        a.finish();
                        MappedListBlock[] deleted_blocks = list.getDeletedBlocks();
                        for (int i = 0; i < deleted_blocks.length; ++i) {
                            long del_block_p = deleted_blocks[i].getBlockPointer();
                            if (del_block_p == -1L) continue;
                            cur_index_block.addDeletedArea(del_block_p);
                        }
                        cur_index_block.markAsDeleted();
                        IndexBlock new_index_block = new IndexBlock(index_num, cur_index_block.getBlockSize(), block_p);
                        new_index_block.setParentIndexBlock(cur_index_block);
                        new_index_block.addReference();
                        this.index_blocks[index_num] = new_index_block;
                        removed_blocks.add(cur_index_block);
                    }
                    this.commitIndexHeader();
                }
                finally {
                    this.store.unlockForWrite();
                }
            }
            catch (IOException e) {
                this.debug.writeException(e);
                throw new Error("IO Error: " + e.getMessage());
            }
        }
        int sz = removed_blocks.size();
        for (int i = 0; i < sz; ++i) {
            IndexBlock block = (IndexBlock)removed_blocks.get(i);
            block.removeReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commitDropIndex(int index_num) throws IOException {
        IndexBlock cur_index_block = this.index_blocks[index_num];
        int block_size = cur_index_block.getBlockSize();
        try {
            this.store.lockForWrite();
            long[] all_block_pointers = cur_index_block.getAllBlockPointers();
            for (int i = 0; i < all_block_pointers.length; ++i) {
                cur_index_block.addDeletedArea(all_block_pointers[i]);
            }
            cur_index_block.markAsDeleted();
            long block_p = this.createBlankIndexBlock();
            IndexBlock new_index_block = new IndexBlock(index_num, block_size, block_p);
            new_index_block.addReference();
            cur_index_block.removeReference();
            this.index_blocks[index_num] = new_index_block;
            this.commitIndexHeader();
        }
        finally {
            this.store.unlockForWrite();
        }
    }

    private class IndexBlock {
        private int reference_count;
        private int index_num;
        private final long index_block_p;
        private long block_entries;
        private final int block_size;
        private ArrayList deleted_areas;
        private boolean deleted = false;
        private boolean freed = false;
        private IndexBlock parent_block;

        IndexBlock(int index_num, int block_size, long index_block_p) throws IOException {
            this.index_num = index_num;
            this.block_size = block_size;
            this.index_block_p = index_block_p;
            Area index_block_area = IndexSetStore.this.store.getArea(index_block_p);
            index_block_area.position(8);
            this.block_entries = index_block_area.getLong();
            this.reference_count = 0;
        }

        void setParentIndexBlock(IndexBlock parent) {
            this.parent_block = parent;
        }

        long[] getAllBlockPointers() throws IOException {
            Area index_block_area = IndexSetStore.this.store.getArea(this.index_block_p);
            long[] blocks = new long[(int)this.block_entries];
            if (this.block_entries != 0L) {
                index_block_area.position(16);
                int i = 0;
                while ((long)i < this.block_entries) {
                    index_block_area.getLong();
                    index_block_area.getLong();
                    long element_p = index_block_area.getLong();
                    index_block_area.getInt();
                    blocks[i] = element_p;
                    ++i;
                }
            }
            return blocks;
        }

        private MappedListBlock[] createMappedListBlocks() throws IOException {
            Area index_block_area = IndexSetStore.this.store.getArea(this.index_block_p);
            MappedListBlock[] blocks = new MappedListBlock[(int)this.block_entries];
            if (this.block_entries != 0L) {
                index_block_area.position(16);
                int i = 0;
                while ((long)i < this.block_entries) {
                    long first_entry = index_block_area.getLong();
                    long last_entry = index_block_area.getLong();
                    long element_p = index_block_area.getLong();
                    int type_size = index_block_area.getInt();
                    int element_count = type_size & 0xFFF;
                    byte type = (byte)(type_size >>> 24 & 0xF);
                    blocks[i] = new MappedListBlock(first_entry, last_entry, element_p, element_count, type, this.block_size);
                    ++i;
                }
            }
            return blocks;
        }

        IndexIntegerList createIndexIntegerList() throws IOException {
            MappedListBlock[] blocks = this.createMappedListBlocks();
            return new IndexIntegerList(this.index_num, this.block_size, blocks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long copyTo(Store dest_store) throws IOException {
            MappedListBlock[] blocks = this.createMappedListBlocks();
            try {
                dest_store.lockForWrite();
                AreaWriter a = dest_store.createArea(16 + blocks.length * 28);
                long block_p = a.getID();
                a.putInt(1);
                a.putInt(0);
                a.putLong(blocks.length);
                for (int i = 0; i < blocks.length; ++i) {
                    MappedListBlock entry = blocks[i];
                    long b_p = entry.copyTo(dest_store);
                    int block_size = entry.size();
                    a.putLong(entry.first_entry);
                    a.putLong(entry.last_entry);
                    a.putLong(b_p);
                    a.putInt(block_size | entry.getCompactType() << 24);
                }
                a.finish();
                long l = block_p;
                return l;
            }
            finally {
                dest_store.unlockForWrite();
            }
        }

        private boolean deleteBlockChain() {
            boolean parent_deleted = true;
            if (this.parent_block != null && (parent_deleted = this.parent_block.deleteBlockChain())) {
                this.parent_block = null;
            }
            if (parent_deleted) {
                if (this.reference_count <= 0) {
                    if (this.deleted && this.deleted_areas != null) {
                        IndexSetStore.this.deleteAllAreas(this.deleted_areas);
                    }
                    this.deleted_areas = null;
                } else {
                    return false;
                }
            }
            return parent_deleted;
        }

        public synchronized void addReference() {
            if (this.freed) {
                throw new RuntimeException("Assertion failed: Block was freed.");
            }
            ++this.reference_count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeReference() {
            boolean pending_delete = false;
            Object object = this;
            synchronized (object) {
                --this.reference_count;
                if (this.reference_count <= 0) {
                    if (this.freed) {
                        throw new RuntimeException("Assertion failed: remove reference called too many times.");
                    }
                    if (!this.deleted && this.deleted_areas != null) {
                        throw new RuntimeException("Assertion failed: !deleted and deleted_areas != null");
                    }
                    this.freed = true;
                    if (this.deleted) {
                        this.addDeletedArea(this.index_block_p);
                        pending_delete = true;
                    }
                }
            }
            if (pending_delete) {
                object = IndexSetStore.this;
                synchronized (object) {
                    this.deleteBlockChain();
                }
            }
        }

        public synchronized int getReferenceCount() {
            return this.reference_count;
        }

        public int getBlockSize() {
            return this.block_size;
        }

        public long getPointer() {
            return this.index_block_p;
        }

        public synchronized void markAsDeleted() {
            this.deleted = true;
        }

        public synchronized void addDeletedArea(long pointer) {
            if (this.deleted_areas == null) {
                this.deleted_areas = new ArrayList();
            }
            this.deleted_areas.add(new Long(pointer));
        }
    }

    private final class IndexIntegerList
    extends AbstractBlockIntegerList {
        private int index_num;
        private int max_block_size;
        private boolean disposed = false;
        private ArrayList deleted_blocks = new ArrayList();

        public IndexIntegerList(int index_num, int max_block_size, MappedListBlock[] blocks) {
            super(blocks);
            this.index_num = index_num;
            this.max_block_size = max_block_size;
        }

        protected IntegerListBlockInterface newListBlock() {
            if (!this.disposed) {
                return new MappedListBlock(this.max_block_size);
            }
            throw new Error("Integer list has been disposed.");
        }

        protected void deleteListBlock(IntegerListBlockInterface list_block) {
            this.deleted_blocks.add(list_block);
        }

        public int getIndexNumber() {
            return this.index_num;
        }

        public MappedListBlock[] getAllBlocks() {
            return this.block_list.toArray(new MappedListBlock[this.block_list.size()]);
        }

        public MappedListBlock[] getDeletedBlocks() {
            return this.deleted_blocks.toArray(new MappedListBlock[this.deleted_blocks.size()]);
        }

        public void dispose() {
            this.disposed = true;
            this.block_list = null;
        }
    }

    private final class MappedListBlock
    extends BlockIntegerList.IntArrayListBlock {
        private long first_entry;
        private long last_entry;
        private long block_p;
        private Object lock = new Object();
        private boolean mutable_block;
        private byte compact_type;
        private final int max_block_size;

        public MappedListBlock(long first_e, long last_e, long mapped_p, int size, byte compact_type, int max_block_size) {
            this.first_entry = first_e;
            this.last_entry = last_e;
            this.block_p = mapped_p;
            this.compact_type = compact_type;
            this.max_block_size = max_block_size;
            this.count = size;
            this.array = null;
        }

        public MappedListBlock(int block_size_in) {
            super(block_size_in);
            this.block_p = -1L;
            this.max_block_size = block_size_in;
        }

        public long getBlockPointer() {
            return this.block_p;
        }

        public byte getCompactType() {
            return this.compact_type;
        }

        public long copyTo(Store dest_store) throws IOException {
            byte entry_size = this.compact_type;
            int area_size = this.count * entry_size;
            AreaWriter dest = dest_store.createArea(area_size);
            long dest_block_p = dest.getID();
            IndexSetStore.this.store.getArea(this.block_p).copyTo(dest, area_size);
            dest.finish();
            return dest_block_p;
        }

        public long writeToStore() throws IOException {
            long largest_val = 0L;
            for (int i = 0; i < this.count; ++i) {
                long v = this.array[i];
                if (Math.abs(v) <= Math.abs(largest_val)) continue;
                largest_val = v;
            }
            long lv = largest_val;
            this.compact_type = lv >> 7 == 0L || lv >> 7 == -1L ? (byte)1 : (lv >> 15 == 0L || lv >> 15 == -1L ? (byte)2 : (lv >> 23 == 0L || lv >> 23 == -1L ? (byte)3 : (byte)4));
            byte entry_size = this.compact_type;
            int area_size = this.count * entry_size;
            byte[] arr = new byte[area_size];
            int p = 0;
            for (int i = 0; i < this.count; ++i) {
                int v = this.array[i];
                for (int n = entry_size - 1; n >= 0; --n) {
                    arr[p] = (byte)(v >>> n * 8 & 0xFF);
                    ++p;
                }
            }
            AreaWriter a = IndexSetStore.this.store.createArea(area_size);
            this.block_p = a.getID();
            a.put(arr, 0, area_size);
            a.finish();
            this.lock = null;
            return this.block_p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getArray(boolean immutable) {
            Object object = this.lock;
            synchronized (object) {
                if (this.array != null) {
                    this.prepareMutate(immutable);
                    return this.array;
                }
                this.array = new int[this.max_block_size];
                byte entry_size = this.compact_type;
                int area_size = this.count * entry_size;
                byte[] buf = new byte[area_size];
                try {
                    IndexSetStore.this.store.getArea(this.block_p).get(buf, 0, area_size);
                }
                catch (IOException e) {
                    IndexSetStore.this.debug.write(40, this, "block_p = " + this.block_p);
                    IndexSetStore.this.debug.writeException(e);
                    throw new Error("IO Error: " + e.getMessage());
                }
                int p = 0;
                for (int i = 0; i < this.count; ++i) {
                    int v = buf[p] << (entry_size - 1) * 8;
                    ++p;
                    for (int n = entry_size - 2; n >= 0; --n) {
                        v |= (buf[p] & 0xFF) << n * 8;
                        ++p;
                    }
                    this.array[i] = v;
                }
                this.mutable_block = false;
                this.prepareMutate(immutable);
                return this.array;
            }
        }

        public int getArrayLength() {
            return this.max_block_size;
        }

        private void prepareMutate(boolean immutable) {
            if (!immutable && !this.mutable_block) {
                this.array = (int[])this.array.clone();
                this.mutable_block = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int topInt() {
            if (this.count == 0) {
                throw new Error("No first int in block.");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.array == null) {
                    return (int)this.last_entry;
                }
                return this.array[this.count - 1];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int bottomInt() {
            if (this.count == 0) {
                throw new Error("No first int in block.");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.array == null) {
                    return (int)this.first_entry;
                }
                return this.array[0];
            }
        }
    }

    private class SnapshotIndexSet
    implements IndexSet {
        private IndexBlock[] snapshot_index_blocks;
        private ArrayList integer_lists;
        private boolean disposed;

        public SnapshotIndexSet(IndexBlock[] blocks) {
            this.snapshot_index_blocks = blocks;
            this.disposed = false;
        }

        public IndexIntegerList[] getAllLists() {
            if (this.integer_lists == null) {
                return EMPTY_INTEGER_LISTS;
            }
            return this.integer_lists.toArray(new IndexIntegerList[this.integer_lists.size()]);
        }

        public IntegerListInterface getIndex(int n) {
            if (this.integer_lists == null) {
                this.integer_lists = new ArrayList();
            } else {
                for (int o = 0; o < this.integer_lists.size(); ++o) {
                    IndexIntegerList i_list = (IndexIntegerList)this.integer_lists.get(o);
                    if (i_list.getIndexNumber() != n) continue;
                    return i_list;
                }
            }
            try {
                IndexIntegerList ilist = this.snapshot_index_blocks[n].createIndexIntegerList();
                this.integer_lists.add(ilist);
                return ilist;
            }
            catch (IOException e) {
                IndexSetStore.this.debug.writeException(e);
                throw new RuntimeException("IO Error: " + e.getMessage());
            }
        }

        public void dispose() {
            if (!this.disposed) {
                int i;
                if (this.integer_lists != null) {
                    for (i = 0; i < this.integer_lists.size(); ++i) {
                        IndexIntegerList ilist = (IndexIntegerList)this.integer_lists.get(i);
                        ilist.dispose();
                    }
                    this.integer_lists = null;
                }
                for (i = 0; i < this.snapshot_index_blocks.length; ++i) {
                    IndexBlock iblock = this.snapshot_index_blocks[i];
                    iblock.removeReference();
                }
                this.snapshot_index_blocks = null;
                this.disposed = true;
            }
        }

        public void finalize() {
            try {
                if (!this.disposed) {
                    this.dispose();
                }
            }
            catch (Throwable e) {
                IndexSetStore.this.debug.write(40, this, "Finalize error: " + e.getMessage());
                IndexSetStore.this.debug.writeException(e);
            }
        }
    }
}

