/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Operator;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.IntegerVector;

final class INHelper {
    INHelper() {
    }

    static final IntegerVector origIn(Table table1, Table table2, int column1, int column2) {
        int large_column;
        int small_column;
        Table large_table;
        Table small_table;
        if (table1.getRowCount() < table2.getRowCount()) {
            small_table = table1;
            large_table = table2;
            small_column = column1;
            large_column = column2;
        } else {
            small_table = table2;
            large_table = table1;
            small_column = column2;
            large_column = column1;
        }
        IntegerVector result_rows = new IntegerVector();
        RowEnumeration e = small_table.rowEnumeration();
        Operator EQUALSOP = Operator.get("=");
        while (e.hasMoreRows()) {
            int small_row_index = e.nextRowIndex();
            TObject cell = small_table.getCellContents(small_column, small_row_index);
            IntegerVector selected_set = large_table.selectRows(large_column, EQUALSOP, cell);
            if (selected_set.size() <= 0) continue;
            if (large_table == table1) {
                result_rows.append(selected_set);
                continue;
            }
            result_rows.addInt(small_row_index);
        }
        return result_rows;
    }

    static final IntegerVector in(Table table1, Table table2, int column1, int column2) {
        int large_column;
        int small_column;
        Table large_table;
        Table small_table;
        if (table1.getRowCount() < table2.getRowCount()) {
            small_table = table1;
            large_table = table2;
            small_column = column1;
            large_column = column2;
        } else {
            small_table = table2;
            large_table = table1;
            small_column = column2;
            large_column = column1;
        }
        BlockIntegerList result_rows = new BlockIntegerList();
        RowEnumeration e = small_table.rowEnumeration();
        Operator EQUALSOP = Operator.get("=");
        while (e.hasMoreRows()) {
            int small_row_index = e.nextRowIndex();
            TObject cell = small_table.getCellContents(small_column, small_row_index);
            IntegerVector selected_set = large_table.selectRows(large_column, EQUALSOP, cell);
            if (selected_set.size() <= 0) continue;
            if (large_table == table1) {
                int sz = selected_set.size();
                boolean rs = true;
                for (int i = 0; rs && i < sz; ++i) {
                    rs = result_rows.uniqueInsertSort(selected_set.intAt(i));
                }
                continue;
            }
            result_rows.add(small_row_index);
        }
        return new IntegerVector(result_rows);
    }

    static final IntegerVector in(Table table1, Table table2, int[] t1_cols, int[] t2_cols) {
        if (t1_cols.length > 1) {
            throw new Error("Multi-column 'in' not supported.");
        }
        return INHelper.in(table1, table2, t1_cols[0], t2_cols[0]);
    }

    static final IntegerVector notIn(Table table1, Table table2, int col1, int col2) {
        int t2_row_count = table2.getRowCount();
        if (t2_row_count == 0) {
            return table1.selectAll(col1);
        }
        if (t2_row_count == 1) {
            RowEnumeration e = table2.rowEnumeration();
            TObject cell = table2.getCellContents(col2, e.nextRowIndex());
            return table1.selectRows(col1, Operator.get("<>"), cell);
        }
        IntegerVector result_rows = new IntegerVector();
        RowEnumeration e = table1.rowEnumeration();
        Operator EQUALSOP = Operator.get("=");
        while (e.hasMoreRows()) {
            int row_index = e.nextRowIndex();
            TObject cell = table1.getCellContents(col1, row_index);
            IntegerVector selected_set = table2.selectRows(col2, Operator.get("="), cell);
            if (selected_set.size() > 0) continue;
            result_rows.addInt(row_index);
        }
        return result_rows;
    }

    static final IntegerVector notIn(Table table1, Table table2, int[] t1_cols, int[] t2_cols) {
        if (t1_cols.length > 1) {
            throw new Error("Multi-column 'not in' not supported.");
        }
        return INHelper.notIn(table1, table2, t1_cols[0], t2_cols[0]);
    }
}

