/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTable;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.Operator;
import com.mckoi.database.Privileges;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableBackedCache;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.util.BigNumber;
import com.mckoi.util.Cache;
import com.mckoi.util.IntegerVector;

public class GrantManager {
    public static final int TABLE = 1;
    public static final int DOMAIN = 2;
    public static final int SCHEMA = 65;
    public static final int CATALOG = 66;
    public static final String PUBLIC_USERNAME_STR = "@PUBLIC";
    public static final TObject PUBLIC_USERNAME = TObject.stringVal("@PUBLIC");
    private DatabaseConnection connection;
    private QueryContext context;
    private Cache priv_cache;
    private boolean grant_table_changed;

    GrantManager(DatabaseConnection connection) {
        this.connection = connection;
        this.context = new DatabaseQueryContext(connection);
        this.priv_cache = new Cache(129, 129, 20);
        this.grant_table_changed = false;
        connection.attachTableBackedCache(new TableBackedCache(Database.SYS_GRANTS){

            public void purgeCacheOfInvalidatedEntries(IntegerVector added_rows, IntegerVector removed_rows) {
                if (GrantManager.this.grant_table_changed) {
                    GrantManager.this.invalidateGrantCache();
                    GrantManager.this.grant_table_changed = false;
                } else if (added_rows != null && added_rows.size() > 0 || removed_rows != null && removed_rows.size() > 0) {
                    GrantManager.this.invalidateGrantCache();
                }
            }
        });
    }

    private void invalidateGrantCache() {
        this.priv_cache.removeAll();
    }

    private Privileges getPrivs(int object, String param, String username, boolean only_grant_options, String granter, boolean include_public_privs) throws DatabaseException {
        GrantQuery key = new GrantQuery(object, param, username, only_grant_options, include_public_privs);
        Privileges privs = (Privileges)this.priv_cache.get(key);
        if (privs == null) {
            DataTable grant_table = this.connection.getTable(Database.SYS_GRANTS);
            Variable object_col = grant_table.getResolvedVariable(1);
            Variable param_col = grant_table.getResolvedVariable(2);
            Variable grantee_col = grant_table.getResolvedVariable(3);
            Variable grant_option_col = grant_table.getResolvedVariable(4);
            Variable granter_col = grant_table.getResolvedVariable(5);
            Operator EQUALS = Operator.get("=");
            Table t1 = grant_table;
            t1 = t1.simpleSelect(this.context, param_col, EQUALS, new Expression(TObject.stringVal(param)));
            Expression user_check = Expression.simple(grantee_col, EQUALS, TObject.stringVal(username));
            if (include_public_privs) {
                user_check = new Expression(user_check, Operator.get("or"), Expression.simple(grantee_col, EQUALS, PUBLIC_USERNAME));
            }
            Expression expr = new Expression(Expression.simple(object_col, EQUALS, TObject.intVal(object)), Operator.get("and"), user_check);
            if (only_grant_options) {
                Expression grant_option_check = Expression.simple(grant_option_col, EQUALS, TObject.stringVal("true"));
                expr = new Expression(expr, Operator.get("and"), grant_option_check);
            }
            if (granter != null) {
                Expression granter_check = Expression.simple(granter_col, EQUALS, TObject.stringVal(granter));
                expr = new Expression(expr, Operator.get("and"), granter_check);
            }
            t1 = t1.exhaustiveSelect(this.context, expr);
            privs = Privileges.EMPTY_PRIVS;
            RowEnumeration e = t1.rowEnumeration();
            while (e.hasMoreRows()) {
                int row_index = e.nextRowIndex();
                BigNumber priv_bit = (BigNumber)t1.getCellContents(0, row_index).getObject();
                privs = privs.add(priv_bit.intValue());
            }
            this.priv_cache.put(key, privs);
        }
        return privs;
    }

    private void internalSetPrivs(Privileges new_privs, int object, String param, String grantee, boolean grant_option, String granter) throws DatabaseException {
        this.revokeAllGrantsOnObject(object, param, grantee, grant_option, granter);
        if (!new_privs.isEmpty()) {
            DataTable grant_table = this.connection.getTable(Database.SYS_GRANTS);
            RowData rdat = new RowData(grant_table);
            rdat.setColumnDataFromObject(0, BigNumber.fromInt(new_privs.toInt()));
            rdat.setColumnDataFromObject(1, BigNumber.fromInt(object));
            rdat.setColumnDataFromObject(2, param);
            rdat.setColumnDataFromObject(3, grantee);
            rdat.setColumnDataFromObject(4, grant_option ? "true" : "false");
            rdat.setColumnDataFromObject(5, granter);
            grant_table.add(rdat);
            this.invalidateGrantCache();
            this.grant_table_changed = true;
        }
    }

    public void addGrant(Privileges privs, int object, String param, String grantee, boolean grant_option, String granter) throws DatabaseException {
        Privileges existing_privs;
        Privileges new_privs;
        if (object == 1) {
            if (!this.connection.tableExists(TableName.resolve(param))) {
                throw new DatabaseException("Table: " + param + " does not exist.");
            }
        } else if (object == 65 && !this.connection.schemaExists(param)) {
            throw new DatabaseException("Schema: " + param + " does not exist.");
        }
        if (!(new_privs = privs.merge(existing_privs = this.getPrivs(object, param, grantee, grant_option, granter, false))).equals(existing_privs)) {
            this.internalSetPrivs(new_privs, object, param, grantee, grant_option, granter);
        }
    }

    public void addGrantToAllTablesInSchema(String schema, Privileges privs, String grantee, boolean grant_option, String granter) throws DatabaseException {
        TableName[] list = this.connection.getTableList();
        for (int i = 0; i < list.length; ++i) {
            TableName tname = list[i];
            if (!tname.getSchema().equals(schema)) continue;
            this.addGrant(privs, 1, tname.toString(), grantee, grant_option, granter);
        }
    }

    public void removeGrant(Privileges privs, int object, String param, String grantee, boolean grant_option, String granter) throws DatabaseException {
        Privileges existing_privs = this.getPrivs(object, param, grantee, grant_option, granter, false);
        Privileges new_privs = existing_privs.remove(privs);
        if (!new_privs.equals(existing_privs)) {
            this.internalSetPrivs(new_privs, object, param, grantee, grant_option, granter);
        }
    }

    public void revokeAllGrantsOnObject(int object, String param, String grantee, boolean grant_option, String granter) throws DatabaseException {
        DataTable grant_table = this.connection.getTable(Database.SYS_GRANTS);
        Variable object_col = grant_table.getResolvedVariable(1);
        Variable param_col = grant_table.getResolvedVariable(2);
        Variable grantee_col = grant_table.getResolvedVariable(3);
        Variable grant_option_col = grant_table.getResolvedVariable(4);
        Variable granter_col = grant_table.getResolvedVariable(5);
        Operator EQUALS = Operator.get("=");
        Table t1 = grant_table;
        t1 = t1.simpleSelect(this.context, param_col, EQUALS, new Expression(TObject.stringVal(param)));
        Expression user_check = Expression.simple(grantee_col, EQUALS, TObject.stringVal(grantee));
        Expression expr = new Expression(Expression.simple(object_col, EQUALS, TObject.intVal(object)), Operator.get("and"), user_check);
        Expression grant_option_check = Expression.simple(grant_option_col, EQUALS, TObject.stringVal(grant_option ? "true" : "false"));
        expr = new Expression(expr, Operator.get("and"), grant_option_check);
        Expression granter_check = Expression.simple(granter_col, EQUALS, TObject.stringVal(granter));
        expr = new Expression(expr, Operator.get("and"), granter_check);
        t1 = t1.exhaustiveSelect(this.context, expr);
        grant_table.delete(t1);
        this.invalidateGrantCache();
        this.grant_table_changed = true;
    }

    public void revokeAllGrantsOnObject(int object, String param) throws DatabaseException {
        DataTable grant_table = this.connection.getTable(Database.SYS_GRANTS);
        Variable object_col = grant_table.getResolvedVariable(1);
        Variable param_col = grant_table.getResolvedVariable(2);
        Table t1 = grant_table.simpleSelect(this.context, object_col, Operator.get("="), new Expression(TObject.intVal(object)));
        t1 = t1.simpleSelect(this.context, param_col, Operator.get("="), new Expression(TObject.stringVal(param)));
        grant_table.delete(t1);
        this.invalidateGrantCache();
        this.grant_table_changed = true;
    }

    public Privileges userGrants(int object, String param, String username) throws DatabaseException {
        return this.getPrivs(object, param, username, false, null, true);
    }

    public Privileges userGrantOptions(int object, String param, String username) throws DatabaseException {
        return this.getPrivs(object, param, username, true, null, true);
    }

    private static class GrantQuery {
        private int object;
        private String param;
        private String username;
        private int flags;

        GrantQuery(int object, String param, String username, boolean flag1, boolean flag2) {
            this.object = object;
            this.param = param;
            this.username = username;
            this.flags = flag1 ? 1 : 0;
            this.flags |= flag2 ? 2 : 0;
        }

        public boolean equals(Object ob) {
            GrantQuery dest = (GrantQuery)ob;
            return this.object == dest.object && this.param.equals(dest.param) && this.username.equals(dest.username) && this.flags == dest.flags;
        }

        public int hashCode() {
            return this.object + this.param.hashCode() + this.username.hashCode() + this.flags;
        }
    }
}

