/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import java.util.Arrays;

final class GTTableInfoDataSource
extends GTDataSource {
    private Transaction transaction;
    private TableName[] table_list;
    private String[] table_types;
    private int row_count;
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTTableInfoDataSource(Transaction transaction) {
        super(transaction.getSystem());
        this.transaction = transaction;
    }

    public GTTableInfoDataSource init() {
        this.table_list = this.transaction.getTableList();
        Arrays.sort(this.table_list);
        this.table_types = new String[this.table_list.length];
        this.row_count = this.table_list.length;
        for (int i = 0; i < this.table_list.length; ++i) {
            String cur_type = this.transaction.getTableType(this.table_list[i]);
            if (cur_type.equals("TABLE") && this.table_list[i].getSchema().equals("SYS_INFO")) {
                cur_type = "SYSTEM TABLE";
            }
            this.table_types[i] = cur_type;
        }
        return this;
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return this.row_count;
    }

    public TObject getCellContents(int column, int row) {
        TableName tname = this.table_list[row];
        switch (column) {
            case 0: {
                return this.columnValue(column, tname.getSchema());
            }
            case 1: {
                return this.columnValue(column, tname.getName());
            }
            case 2: {
                return this.columnValue(column, this.table_types[row]);
            }
            case 3: {
                return this.columnValue(column, "");
            }
        }
        throw new Error("Column out of bounds.");
    }

    public void dispose() {
        super.dispose();
        this.table_list = null;
        this.transaction = null;
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRTableInfo"));
        def.addColumn(GTTableInfoDataSource.stringColumn("schema"));
        def.addColumn(GTTableInfoDataSource.stringColumn("name"));
        def.addColumn(GTTableInfoDataSource.stringColumn("type"));
        def.addColumn(GTTableInfoDataSource.stringColumn("other"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }
}

