/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.util.BigNumber;

final class GTTableColumnsDataSource
extends GTDataSource {
    private Transaction transaction;
    private DataTableDef[] visible_tables;
    private int row_count;
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTTableColumnsDataSource(Transaction transaction) {
        super(transaction.getSystem());
        this.transaction = transaction;
    }

    public GTTableColumnsDataSource init() {
        TableName[] list = this.transaction.getTableList();
        this.visible_tables = new DataTableDef[list.length];
        this.row_count = 0;
        for (int i = 0; i < list.length; ++i) {
            DataTableDef def = this.transaction.getDataTableDef(list[i]);
            this.row_count += def.columnCount();
            this.visible_tables[i] = def;
        }
        return this;
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return this.row_count;
    }

    public TObject getCellContents(int column, int row) {
        int sz = this.visible_tables.length;
        int rs = 0;
        for (int n = 0; n < sz; ++n) {
            DataTableDef def = this.visible_tables[n];
            int b = rs;
            if (row < b || row >= (rs += def.columnCount())) continue;
            int seq_no = row - b;
            DataTableColumnDef col_def = def.columnAt(seq_no);
            switch (column) {
                case 0: {
                    return this.columnValue(column, def.getSchema());
                }
                case 1: {
                    return this.columnValue(column, def.getName());
                }
                case 2: {
                    return this.columnValue(column, col_def.getName());
                }
                case 3: {
                    return this.columnValue(column, BigNumber.fromLong(col_def.getSQLType()));
                }
                case 4: {
                    return this.columnValue(column, col_def.getSQLTypeString());
                }
                case 5: {
                    return this.columnValue(column, BigNumber.fromLong(col_def.getSize()));
                }
                case 6: {
                    return this.columnValue(column, BigNumber.fromLong(col_def.getScale()));
                }
                case 7: {
                    return this.columnValue(column, new Boolean(col_def.isNotNull()));
                }
                case 8: {
                    return this.columnValue(column, col_def.getDefaultExpressionString());
                }
                case 9: {
                    return this.columnValue(column, col_def.getIndexScheme());
                }
                case 10: {
                    return this.columnValue(column, BigNumber.fromLong(seq_no));
                }
            }
            throw new Error("Column out of bounds.");
        }
        throw new Error("Row out of bounds.");
    }

    public void dispose() {
        super.dispose();
        this.visible_tables = null;
        this.transaction = null;
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRTableColumns"));
        def.addColumn(GTTableColumnsDataSource.stringColumn("schema"));
        def.addColumn(GTTableColumnsDataSource.stringColumn("table"));
        def.addColumn(GTTableColumnsDataSource.stringColumn("column"));
        def.addColumn(GTTableColumnsDataSource.numericColumn("sql_type"));
        def.addColumn(GTTableColumnsDataSource.stringColumn("type_desc"));
        def.addColumn(GTTableColumnsDataSource.numericColumn("size"));
        def.addColumn(GTTableColumnsDataSource.numericColumn("scale"));
        def.addColumn(GTTableColumnsDataSource.booleanColumn("not_null"));
        def.addColumn(GTTableColumnsDataSource.stringColumn("default"));
        def.addColumn(GTTableColumnsDataSource.stringColumn("index_str"));
        def.addColumn(GTTableColumnsDataSource.numericColumn("seq_no"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }
}

